/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.strings;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.TString;

@OpMetadata(opType="StringToHashBucketStrong", inputsClass=Inputs.class)
public final class ToHashBucketStrong
extends RawOp
implements Operand<TInt64> {
    public static final String OP_NAME = "StringToHashBucketStrong";
    private Output<TInt64> output;

    public ToHashBucketStrong(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static ToHashBucketStrong create(Scope scope, Operand<TString> input, Long numBuckets, List<Long> key) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "ToHashBucketStrong");
        opBuilder.addInput(input.asOutput());
        opBuilder.setAttr("num_buckets", numBuckets);
        long[] keyArray = new long[key.size()];
        for (int i = 0; i < keyArray.length; ++i) {
            keyArray[i] = key.get(i);
        }
        opBuilder.setAttr("key", keyArray);
        return new ToHashBucketStrong(opBuilder.build());
    }

    public Output<TInt64> output() {
        return this.output;
    }

    @Override
    public Output<TInt64> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=ToHashBucketStrong.class)
    public static class Inputs
    extends RawOpInputs<ToHashBucketStrong> {
        public final Operand<TString> input;
        public final long numBuckets;
        public final long[] key;

        public Inputs(GraphOperation op) {
            super(new ToHashBucketStrong(op), op, Arrays.asList("num_buckets", "key"));
            int inputIndex = 0;
            this.input = op.input(inputIndex++);
            this.numBuckets = op.attributes().getAttrInt("num_buckets");
            this.key = op.attributes().getAttrIntList("key");
        }
    }
}

