/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.tensorflow.engine;

import ai.djl.Device;
import ai.djl.Model;
import ai.djl.engine.Engine;
import ai.djl.engine.EngineException;
import ai.djl.ndarray.NDManager;
import ai.djl.nn.SymbolBlock;
import ai.djl.tensorflow.engine.TfModel;
import ai.djl.tensorflow.engine.TfNDManager;
import ai.djl.tensorflow.engine.javacpp.JavacppUtils;
import ai.djl.tensorflow.engine.javacpp.LibUtils;
import ai.djl.training.GradientCollector;
import ai.djl.util.RandomUtils;
import java.util.concurrent.atomic.AtomicReference;
import org.tensorflow.TensorFlow;
import org.tensorflow.internal.c_api.TFE_Context;

public final class TfEngine
extends Engine
implements AutoCloseable {
    public static final String ENGINE_NAME = "TensorFlow";
    static final int RANK = 3;
    private static AtomicReference<TFE_Context> eagerSessionHandle;

    private TfEngine() {
    }

    static TfEngine newInstance() {
        try {
            LibUtils.loadLibrary();
            eagerSessionHandle = new AtomicReference<TFE_Context>(JavacppUtils.createEagerSession(true, 2, JavacppUtils.getSessionConfig()));
            TensorFlow.version();
            return new TfEngine();
        }
        catch (Throwable t) {
            throw new EngineException("Failed to load TensorFlow native library", t);
        }
    }

    public Model newModel(String name, Device device) {
        return new TfModel(name, device);
    }

    public SymbolBlock newSymbolBlock(NDManager manager) {
        throw new UnsupportedOperationException("TensorFlow does not support empty SymbolBlock");
    }

    public String getEngineName() {
        return ENGINE_NAME;
    }

    public int getRank() {
        return 3;
    }

    public String getVersion() {
        return TensorFlow.version();
    }

    /*
     * Exception decompiling
     */
    public boolean hasCapability(String capability) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 23[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public NDManager newBaseManager() {
        return TfNDManager.getSystemManager().newSubManager();
    }

    public NDManager newBaseManager(Device device) {
        return TfNDManager.getSystemManager().newSubManager(device);
    }

    public GradientCollector newGradientCollector() {
        throw new UnsupportedOperationException("TensorFlow does not support training yet");
    }

    public void setRandomSeed(int seed) {
        super.setRandomSeed(seed);
        RandomUtils.RANDOM.setSeed(seed);
    }

    TFE_Context getEagerSession() {
        return eagerSessionHandle.get();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(200);
        sb.append(this.getEngineName()).append(':').append(this.getVersion()).append(", capabilities: [\n\tMKL,\n");
        if (this.hasCapability("CUDA")) {
            sb.append("\t").append("CUDA").append(",\n");
        }
        sb.append("]\nTensorFlow Library: ").append(LibUtils.getLibName());
        return sb.toString();
    }

    @Override
    public void close() {
        TFE_Context handle = eagerSessionHandle.getAndSet(null);
        if (handle != null && !handle.isNull()) {
            handle.close();
        }
    }
}

