/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.tensorflow.engine;

import java.util.concurrent.atomic.AtomicBoolean;
import org.tensorflow.internal.c_api.TF_Graph;
import org.tensorflow.internal.c_api.TF_Session;
import org.tensorflow.proto.framework.MetaGraphDef;

public class SavedModelBundle
implements AutoCloseable {
    private TF_Graph graphHandle;
    private TF_Session sessionHandle;
    private MetaGraphDef metaGraphDef;
    private AtomicBoolean closed;

    public SavedModelBundle(TF_Graph graphHandle, TF_Session sessionHandle, MetaGraphDef metaGraphDef) {
        this.graphHandle = graphHandle;
        this.sessionHandle = sessionHandle;
        this.metaGraphDef = metaGraphDef;
        this.closed = new AtomicBoolean(false);
    }

    public TF_Graph getGraph() {
        return this.graphHandle;
    }

    public TF_Session getSession() {
        return this.sessionHandle;
    }

    public MetaGraphDef getMetaGraphDef() {
        return this.metaGraphDef;
    }

    @Override
    public void close() {
        if (this.closed.getAndSet(true)) {
            return;
        }
        if (this.graphHandle != null && !this.graphHandle.isNull()) {
            this.graphHandle.close();
        }
        if (this.sessionHandle != null && !this.sessionHandle.isNull()) {
            this.sessionHandle.close();
        }
        this.metaGraphDef = null;
    }
}

