/*
 * Decompiled with CFR 0.152.
 */
package ai.docling.core;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import tools.jackson.databind.annotation.JsonDeserialize;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder=Builder.class)
public class DoclingDocument {
    @JsonProperty(value="schema_name")
    private final @Nullable String schemaName;
    @JsonProperty(value="version")
    private final @Nullable String version;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="origin")
    private final @Nullable DocumentOrigin origin;
    @JsonProperty(value="body")
    private final GroupItem body;
    @JsonProperty(value="groups")
    @JsonSetter(nulls=Nulls.AS_EMPTY)
    private final List<GroupItem> groups;
    @JsonProperty(value="texts")
    @JsonSetter(nulls=Nulls.AS_EMPTY)
    private final List<BaseTextItem> texts;
    @JsonProperty(value="pictures")
    @JsonSetter(nulls=Nulls.AS_EMPTY)
    private final List<PictureItem> pictures;
    @JsonProperty(value="tables")
    private final List<TableItem> tables;
    @JsonProperty(value="key_value_items")
    private final List<KeyValueItem> keyValueItems;
    @JsonProperty(value="form_items")
    private final List<FormItem> formItems;
    @JsonProperty(value="pages")
    private final Map<String, PageItem> pages;

    DoclingDocument(@Nullable String schemaName, @Nullable String version, String name, @Nullable DocumentOrigin origin, GroupItem body, List<GroupItem> groups, List<BaseTextItem> texts, List<PictureItem> pictures, List<TableItem> tables, List<KeyValueItem> keyValueItems, List<FormItem> formItems, Map<String, PageItem> pages) {
        this.schemaName = schemaName;
        this.version = version;
        this.name = name;
        this.origin = origin;
        this.body = body;
        this.groups = groups;
        this.texts = texts;
        this.pictures = pictures;
        this.tables = tables;
        this.keyValueItems = keyValueItems;
        this.formItems = formItems;
        this.pages = pages;
    }

    public static @NonNull Builder builder() {
        return new Builder();
    }

    public @NonNull Builder toBuilder() {
        Builder builder = new Builder().schemaName(this.schemaName).version(this.version).name(this.name).origin(this.origin).body(this.body);
        if (this.groups != null) {
            builder.groups(this.groups);
        }
        if (this.texts != null) {
            builder.texts(this.texts);
        }
        if (this.pictures != null) {
            builder.pictures(this.pictures);
        }
        if (this.tables != null) {
            builder.tables(this.tables);
        }
        if (this.keyValueItems != null) {
            builder.keyValueItems(this.keyValueItems);
        }
        if (this.formItems != null) {
            builder.formItems(this.formItems);
        }
        if (this.pages != null) {
            builder.pages(this.pages);
        }
        return builder;
    }

    public @Nullable String getSchemaName() {
        return this.schemaName;
    }

    public @Nullable String getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public @Nullable DocumentOrigin getOrigin() {
        return this.origin;
    }

    public GroupItem getBody() {
        return this.body;
    }

    public List<GroupItem> getGroups() {
        return this.groups;
    }

    public List<BaseTextItem> getTexts() {
        return this.texts;
    }

    public List<PictureItem> getPictures() {
        return this.pictures;
    }

    public List<TableItem> getTables() {
        return this.tables;
    }

    public List<KeyValueItem> getKeyValueItems() {
        return this.keyValueItems;
    }

    public List<FormItem> getFormItems() {
        return this.formItems;
    }

    public Map<String, PageItem> getPages() {
        return this.pages;
    }

    public @NonNull String toString() {
        return "DoclingDocument(schemaName=" + this.getSchemaName() + ", version=" + this.getVersion() + ", name=" + this.getName() + ", origin=" + String.valueOf(this.getOrigin()) + ", body=" + String.valueOf(this.getBody()) + ", groups=" + String.valueOf(this.getGroups()) + ", texts=" + String.valueOf(this.getTexts()) + ", pictures=" + String.valueOf(this.getPictures()) + ", tables=" + String.valueOf(this.getTables()) + ", keyValueItems=" + String.valueOf(this.getKeyValueItems()) + ", formItems=" + String.valueOf(this.getFormItems()) + ", pages=" + String.valueOf(this.getPages()) + ")";
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonDeserialize(builder=Builder.class)
    @com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder=Builder.class)
    public static class DocumentOrigin {
        @JsonProperty(value="mimetype")
        private final String mimetype;
        @JsonProperty(value="binary_hash")
        private final BigInteger binaryHash;
        @JsonProperty(value="filename")
        private final String filename;
        @JsonProperty(value="uri")
        private final @Nullable String uri;

        DocumentOrigin(String mimetype, BigInteger binaryHash, String filename, @Nullable String uri) {
            this.mimetype = mimetype;
            this.binaryHash = binaryHash;
            this.filename = filename;
            this.uri = uri;
        }

        public static @NonNull Builder builder() {
            return new Builder();
        }

        public @NonNull Builder toBuilder() {
            return new Builder().mimetype(this.mimetype).binaryHash(this.binaryHash).filename(this.filename).uri(this.uri);
        }

        public String getMimetype() {
            return this.mimetype;
        }

        public BigInteger getBinaryHash() {
            return this.binaryHash;
        }

        public String getFilename() {
            return this.filename;
        }

        public @Nullable String getUri() {
            return this.uri;
        }

        public @NonNull String toString() {
            return "DoclingDocument.DocumentOrigin(mimetype=" + this.getMimetype() + ", binaryHash=" + String.valueOf(this.getBinaryHash()) + ", filename=" + this.getFilename() + ", uri=" + this.getUri() + ")";
        }

        @tools.jackson.databind.annotation.JsonPOJOBuilder(withPrefix="")
        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        public static class Builder {
            private String mimetype;
            private BigInteger binaryHash;
            private String filename;
            private String uri;

            Builder() {
            }

            @JsonProperty(value="mimetype")
            public @NonNull Builder mimetype(String mimetype) {
                this.mimetype = mimetype;
                return this;
            }

            @JsonProperty(value="binary_hash")
            public @NonNull Builder binaryHash(BigInteger binaryHash) {
                this.binaryHash = binaryHash;
                return this;
            }

            @JsonProperty(value="filename")
            public @NonNull Builder filename(String filename) {
                this.filename = filename;
                return this;
            }

            @JsonProperty(value="uri")
            public @NonNull Builder uri(@Nullable String uri) {
                this.uri = uri;
                return this;
            }

            public @NonNull DocumentOrigin build() {
                return new DocumentOrigin(this.mimetype, this.binaryHash, this.filename, this.uri);
            }

            public @NonNull String toString() {
                return "DoclingDocument.DocumentOrigin.Builder(mimetype=" + this.mimetype + ", binaryHash=" + String.valueOf(this.binaryHash) + ", filename=" + this.filename + ", uri=" + this.uri + ")";
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonDeserialize(builder=Builder.class)
    @com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder=Builder.class)
    public static class GroupItem {
        @JsonProperty(value="self_ref")
        private final String selfRef;
        @JsonProperty(value="parent")
        private final @Nullable RefItem parent;
        @JsonProperty(value="children")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        private final List<RefItem> children;
        @JsonProperty(value="content_layer")
        private final ContentLayer contentLayer;
        @JsonProperty(value="meta")
        private final @Nullable BaseMeta meta;
        @JsonProperty(value="name")
        private final @Nullable String name;
        @JsonProperty(value="label")
        private final GroupLabel label;

        GroupItem(String selfRef, @Nullable RefItem parent, List<RefItem> children, ContentLayer contentLayer, @Nullable BaseMeta meta, @Nullable String name, GroupLabel label) {
            this.selfRef = selfRef;
            this.parent = parent;
            this.children = children;
            this.contentLayer = contentLayer;
            this.meta = meta;
            this.name = name;
            this.label = label;
        }

        public static @NonNull Builder builder() {
            return new Builder();
        }

        public @NonNull Builder toBuilder() {
            Builder builder = new Builder().selfRef(this.selfRef).parent(this.parent).contentLayer(this.contentLayer).meta(this.meta).name(this.name).label(this.label);
            if (this.children != null) {
                builder.children(this.children);
            }
            return builder;
        }

        public String getSelfRef() {
            return this.selfRef;
        }

        public @Nullable RefItem getParent() {
            return this.parent;
        }

        public List<RefItem> getChildren() {
            return this.children;
        }

        public ContentLayer getContentLayer() {
            return this.contentLayer;
        }

        public @Nullable BaseMeta getMeta() {
            return this.meta;
        }

        public @Nullable String getName() {
            return this.name;
        }

        public GroupLabel getLabel() {
            return this.label;
        }

        public @NonNull String toString() {
            return "DoclingDocument.GroupItem(selfRef=" + this.getSelfRef() + ", parent=" + String.valueOf(this.getParent()) + ", children=" + String.valueOf(this.getChildren()) + ", contentLayer=" + String.valueOf((Object)this.getContentLayer()) + ", meta=" + String.valueOf(this.getMeta()) + ", name=" + this.getName() + ", label=" + String.valueOf((Object)this.getLabel()) + ")";
        }

        @tools.jackson.databind.annotation.JsonPOJOBuilder(withPrefix="")
        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        public static class Builder {
            private String selfRef;
            private RefItem parent;
            private ArrayList<RefItem> children;
            private ContentLayer contentLayer;
            private BaseMeta meta;
            private String name;
            private GroupLabel label;

            Builder() {
            }

            @JsonProperty(value="self_ref")
            public @NonNull Builder selfRef(String selfRef) {
                this.selfRef = selfRef;
                return this;
            }

            @JsonProperty(value="parent")
            public @NonNull Builder parent(@Nullable RefItem parent) {
                this.parent = parent;
                return this;
            }

            public @NonNull Builder child(RefItem child) {
                if (this.children == null) {
                    this.children = new ArrayList();
                }
                this.children.add(child);
                return this;
            }

            @JsonProperty(value="children")
            @JsonSetter(nulls=Nulls.AS_EMPTY)
            public @NonNull Builder children(@NonNull Collection<? extends RefItem> children) {
                if (children == null) {
                    throw new IllegalArgumentException("children cannot be null");
                }
                if (this.children == null) {
                    this.children = new ArrayList();
                }
                this.children.addAll(children);
                return this;
            }

            public @NonNull Builder clearChildren() {
                if (this.children != null) {
                    this.children.clear();
                }
                return this;
            }

            @JsonProperty(value="content_layer")
            public @NonNull Builder contentLayer(ContentLayer contentLayer) {
                this.contentLayer = contentLayer;
                return this;
            }

            @JsonProperty(value="meta")
            public @NonNull Builder meta(@Nullable BaseMeta meta) {
                this.meta = meta;
                return this;
            }

            @JsonProperty(value="name")
            public @NonNull Builder name(@Nullable String name) {
                this.name = name;
                return this;
            }

            @JsonProperty(value="label")
            public @NonNull Builder label(GroupLabel label) {
                this.label = label;
                return this;
            }

            public @NonNull GroupItem build() {
                return new GroupItem(this.selfRef, this.parent, switch (this.children == null ? 0 : this.children.size()) {
                    case 0 -> Collections.emptyList();
                    case 1 -> Collections.singletonList(this.children.get(0));
                    default -> Collections.unmodifiableList(new ArrayList<RefItem>(this.children));
                }, this.contentLayer, this.meta, this.name, this.label);
            }

            public @NonNull String toString() {
                return "DoclingDocument.GroupItem.Builder(selfRef=" + this.selfRef + ", parent=" + String.valueOf(this.parent) + ", children=" + String.valueOf(this.children) + ", contentLayer=" + String.valueOf((Object)this.contentLayer) + ", meta=" + String.valueOf(this.meta) + ", name=" + this.name + ", label=" + String.valueOf((Object)this.label) + ")";
            }
        }
    }

    @tools.jackson.databind.annotation.JsonPOJOBuilder(withPrefix="")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class Builder {
        private String schemaName;
        private String version;
        private String name;
        private DocumentOrigin origin;
        private GroupItem body;
        private ArrayList<GroupItem> groups;
        private ArrayList<BaseTextItem> texts;
        private ArrayList<PictureItem> pictures;
        private ArrayList<TableItem> tables;
        private ArrayList<KeyValueItem> keyValueItems;
        private ArrayList<FormItem> formItems;
        private ArrayList<String> pages$key;
        private ArrayList<PageItem> pages$value;

        Builder() {
        }

        @JsonProperty(value="schema_name")
        public @NonNull Builder schemaName(@Nullable String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        @JsonProperty(value="version")
        public @NonNull Builder version(@Nullable String version) {
            this.version = version;
            return this;
        }

        @JsonProperty(value="name")
        public @NonNull Builder name(String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="origin")
        public @NonNull Builder origin(@Nullable DocumentOrigin origin) {
            this.origin = origin;
            return this;
        }

        @JsonProperty(value="body")
        public @NonNull Builder body(GroupItem body) {
            this.body = body;
            return this;
        }

        public @NonNull Builder group(GroupItem group) {
            if (this.groups == null) {
                this.groups = new ArrayList();
            }
            this.groups.add(group);
            return this;
        }

        @JsonProperty(value="groups")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        public @NonNull Builder groups(@NonNull Collection<? extends GroupItem> groups) {
            if (groups == null) {
                throw new IllegalArgumentException("groups cannot be null");
            }
            if (this.groups == null) {
                this.groups = new ArrayList();
            }
            this.groups.addAll(groups);
            return this;
        }

        public @NonNull Builder clearGroups() {
            if (this.groups != null) {
                this.groups.clear();
            }
            return this;
        }

        public @NonNull Builder text(BaseTextItem text) {
            if (this.texts == null) {
                this.texts = new ArrayList();
            }
            this.texts.add(text);
            return this;
        }

        @JsonProperty(value="texts")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        public @NonNull Builder texts(@NonNull Collection<? extends BaseTextItem> texts) {
            if (texts == null) {
                throw new IllegalArgumentException("texts cannot be null");
            }
            if (this.texts == null) {
                this.texts = new ArrayList();
            }
            this.texts.addAll(texts);
            return this;
        }

        public @NonNull Builder clearTexts() {
            if (this.texts != null) {
                this.texts.clear();
            }
            return this;
        }

        public @NonNull Builder picture(PictureItem picture) {
            if (this.pictures == null) {
                this.pictures = new ArrayList();
            }
            this.pictures.add(picture);
            return this;
        }

        @JsonProperty(value="pictures")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        public @NonNull Builder pictures(@NonNull Collection<? extends PictureItem> pictures) {
            if (pictures == null) {
                throw new IllegalArgumentException("pictures cannot be null");
            }
            if (this.pictures == null) {
                this.pictures = new ArrayList();
            }
            this.pictures.addAll(pictures);
            return this;
        }

        public @NonNull Builder clearPictures() {
            if (this.pictures != null) {
                this.pictures.clear();
            }
            return this;
        }

        public @NonNull Builder table(TableItem table) {
            if (this.tables == null) {
                this.tables = new ArrayList();
            }
            this.tables.add(table);
            return this;
        }

        @JsonProperty(value="tables")
        public @NonNull Builder tables(@NonNull Collection<? extends TableItem> tables) {
            if (tables == null) {
                throw new IllegalArgumentException("tables cannot be null");
            }
            if (this.tables == null) {
                this.tables = new ArrayList();
            }
            this.tables.addAll(tables);
            return this;
        }

        public @NonNull Builder clearTables() {
            if (this.tables != null) {
                this.tables.clear();
            }
            return this;
        }

        public @NonNull Builder keyValueItem(KeyValueItem keyValueItem) {
            if (this.keyValueItems == null) {
                this.keyValueItems = new ArrayList();
            }
            this.keyValueItems.add(keyValueItem);
            return this;
        }

        @JsonProperty(value="key_value_items")
        public @NonNull Builder keyValueItems(@NonNull Collection<? extends KeyValueItem> keyValueItems) {
            if (keyValueItems == null) {
                throw new IllegalArgumentException("keyValueItems cannot be null");
            }
            if (this.keyValueItems == null) {
                this.keyValueItems = new ArrayList();
            }
            this.keyValueItems.addAll(keyValueItems);
            return this;
        }

        public @NonNull Builder clearKeyValueItems() {
            if (this.keyValueItems != null) {
                this.keyValueItems.clear();
            }
            return this;
        }

        public @NonNull Builder formItem(FormItem formItem) {
            if (this.formItems == null) {
                this.formItems = new ArrayList();
            }
            this.formItems.add(formItem);
            return this;
        }

        @JsonProperty(value="form_items")
        public @NonNull Builder formItems(@NonNull Collection<? extends FormItem> formItems) {
            if (formItems == null) {
                throw new IllegalArgumentException("formItems cannot be null");
            }
            if (this.formItems == null) {
                this.formItems = new ArrayList();
            }
            this.formItems.addAll(formItems);
            return this;
        }

        public @NonNull Builder clearFormItems() {
            if (this.formItems != null) {
                this.formItems.clear();
            }
            return this;
        }

        public @NonNull Builder page(String pageKey, PageItem pageValue) {
            if (this.pages$key == null) {
                this.pages$key = new ArrayList();
                this.pages$value = new ArrayList();
            }
            this.pages$key.add(pageKey);
            this.pages$value.add(pageValue);
            return this;
        }

        @JsonProperty(value="pages")
        public @NonNull Builder pages(@NonNull Map<? extends String, ? extends PageItem> pages) {
            if (pages == null) {
                throw new IllegalArgumentException("pages cannot be null");
            }
            if (this.pages$key == null) {
                this.pages$key = new ArrayList();
                this.pages$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends PageItem> $lombokEntry : pages.entrySet()) {
                this.pages$key.add($lombokEntry.getKey());
                this.pages$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public @NonNull Builder clearPages() {
            if (this.pages$key != null) {
                this.pages$key.clear();
                this.pages$value.clear();
            }
            return this;
        }

        public @NonNull DoclingDocument build() {
            Map<String, PageItem> pages;
            List<GroupItem> groups = switch (this.groups == null ? 0 : this.groups.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.groups.get(0));
                default -> Collections.unmodifiableList(new ArrayList<GroupItem>(this.groups));
            };
            List<BaseTextItem> texts = switch (this.texts == null ? 0 : this.texts.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.texts.get(0));
                default -> Collections.unmodifiableList(new ArrayList<BaseTextItem>(this.texts));
            };
            List<PictureItem> pictures = switch (this.pictures == null ? 0 : this.pictures.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.pictures.get(0));
                default -> Collections.unmodifiableList(new ArrayList<PictureItem>(this.pictures));
            };
            List<TableItem> tables = switch (this.tables == null ? 0 : this.tables.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.tables.get(0));
                default -> Collections.unmodifiableList(new ArrayList<TableItem>(this.tables));
            };
            List<KeyValueItem> keyValueItems = switch (this.keyValueItems == null ? 0 : this.keyValueItems.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.keyValueItems.get(0));
                default -> Collections.unmodifiableList(new ArrayList<KeyValueItem>(this.keyValueItems));
            };
            List<FormItem> formItems = switch (this.formItems == null ? 0 : this.formItems.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.formItems.get(0));
                default -> Collections.unmodifiableList(new ArrayList<FormItem>(this.formItems));
            };
            switch (this.pages$key == null ? 0 : this.pages$key.size()) {
                case 0: {
                    pages = Collections.emptyMap();
                    break;
                }
                case 1: {
                    pages = Collections.singletonMap(this.pages$key.get(0), this.pages$value.get(0));
                    break;
                }
                default: {
                    pages = new LinkedHashMap(this.pages$key.size() < 0x40000000 ? 1 + this.pages$key.size() + (this.pages$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.pages$key.size(); ++$i) {
                        pages.put(this.pages$key.get($i), this.pages$value.get($i));
                    }
                    pages = Collections.unmodifiableMap(pages);
                }
            }
            return new DoclingDocument(this.schemaName, this.version, this.name, this.origin, this.body, groups, texts, pictures, tables, keyValueItems, formItems, pages);
        }

        public @NonNull String toString() {
            return "DoclingDocument.Builder(schemaName=" + this.schemaName + ", version=" + this.version + ", name=" + this.name + ", origin=" + String.valueOf(this.origin) + ", body=" + String.valueOf(this.body) + ", groups=" + String.valueOf(this.groups) + ", texts=" + String.valueOf(this.texts) + ", pictures=" + String.valueOf(this.pictures) + ", tables=" + String.valueOf(this.tables) + ", keyValueItems=" + String.valueOf(this.keyValueItems) + ", formItems=" + String.valueOf(this.formItems) + ", pages$key=" + String.valueOf(this.pages$key) + ", pages$value=" + String.valueOf(this.pages$value) + ")";
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonDeserialize(builder=Builder.class)
    @com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder=Builder.class)
    public static class PageItem {
        @JsonProperty(value="size")
        private final Size size;
        @JsonProperty(value="image")
        private final @Nullable ImageRef image;
        @JsonProperty(value="page_no")
        private final Integer pageNo;

        PageItem(Size size, @Nullable ImageRef image, Integer pageNo) {
            this.size = size;
            this.image = image;
            this.pageNo = pageNo;
        }

        public static @NonNull Builder builder() {
            return new Builder();
        }

        public @NonNull Builder toBuilder() {
            return new Builder().size(this.size).image(this.image).pageNo(this.pageNo);
        }

        public Size getSize() {
            return this.size;
        }

        public @Nullable ImageRef getImage() {
            return this.image;
        }

        public Integer getPageNo() {
            return this.pageNo;
        }

        public @NonNull String toString() {
            return "DoclingDocument.PageItem(size=" + String.valueOf(this.getSize()) + ", image=" + String.valueOf(this.getImage()) + ", pageNo=" + this.getPageNo() + ")";
        }

        @tools.jackson.databind.annotation.JsonPOJOBuilder(withPrefix="")
        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        public static class Builder {
            private Size size;
            private ImageRef image;
            private Integer pageNo;

            Builder() {
            }

            @JsonProperty(value="size")
            public @NonNull Builder size(Size size) {
                this.size = size;
                return this;
            }

            @JsonProperty(value="image")
            public @NonNull Builder image(@Nullable ImageRef image) {
                this.image = image;
                return this;
            }

            @JsonProperty(value="page_no")
            public @NonNull Builder pageNo(Integer pageNo) {
                this.pageNo = pageNo;
                return this;
            }

            public @NonNull PageItem build() {
                return new PageItem(this.size, this.image, this.pageNo);
            }

            public @NonNull String toString() {
                return "DoclingDocument.PageItem.Builder(size=" + String.valueOf(this.size) + ", image=" + String.valueOf(this.image) + ", pageNo=" + this.pageNo + ")";
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonDeserialize(builder=Builder.class)
    @com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder=Builder.class)
    public static class FormItem {
        @JsonProperty(value="self_ref")
        private final String selfRef;
        @JsonProperty(value="parent")
        private final @Nullable RefItem parent;
        @JsonProperty(value="children")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        private final List<RefItem> children;
        @JsonProperty(value="content_layer")
        private final ContentLayer contentLayer;
        @JsonProperty(value="meta")
        private final @Nullable FloatingMeta meta;
        @JsonProperty(value="label")
        private final String label;
        @JsonProperty(value="prov")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        private final List<ProvenanceItem> prov;
        @JsonProperty(value="captions")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        private final List<RefItem> captions;
        @JsonProperty(value="references")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        private final List<RefItem> references;
        @JsonProperty(value="footnotes")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        private final List<RefItem> footnotes;
        @JsonProperty(value="image")
        private final @Nullable ImageRef image;
        @JsonProperty(value="graph")
        private final GraphData graph;

        FormItem(String selfRef, @Nullable RefItem parent, List<RefItem> children, ContentLayer contentLayer, @Nullable FloatingMeta meta, String label, List<ProvenanceItem> prov, List<RefItem> captions, List<RefItem> references, List<RefItem> footnotes, @Nullable ImageRef image, GraphData graph) {
            this.selfRef = selfRef;
            this.parent = parent;
            this.children = children;
            this.contentLayer = contentLayer;
            this.meta = meta;
            this.label = label;
            this.prov = prov;
            this.captions = captions;
            this.references = references;
            this.footnotes = footnotes;
            this.image = image;
            this.graph = graph;
        }

        public static @NonNull Builder builder() {
            return new Builder();
        }

        public @NonNull Builder toBuilder() {
            Builder builder = new Builder().selfRef(this.selfRef).parent(this.parent).contentLayer(this.contentLayer).meta(this.meta).label(this.label).image(this.image).graph(this.graph);
            if (this.children != null) {
                builder.children(this.children);
            }
            if (this.prov != null) {
                builder.prov(this.prov);
            }
            if (this.captions != null) {
                builder.captions(this.captions);
            }
            if (this.references != null) {
                builder.references(this.references);
            }
            if (this.footnotes != null) {
                builder.footnotes(this.footnotes);
            }
            return builder;
        }

        public String getSelfRef() {
            return this.selfRef;
        }

        public @Nullable RefItem getParent() {
            return this.parent;
        }

        public List<RefItem> getChildren() {
            return this.children;
        }

        public ContentLayer getContentLayer() {
            return this.contentLayer;
        }

        public @Nullable FloatingMeta getMeta() {
            return this.meta;
        }

        public String getLabel() {
            return this.label;
        }

        public List<ProvenanceItem> getProv() {
            return this.prov;
        }

        public List<RefItem> getCaptions() {
            return this.captions;
        }

        public List<RefItem> getReferences() {
            return this.references;
        }

        public List<RefItem> getFootnotes() {
            return this.footnotes;
        }

        public @Nullable ImageRef getImage() {
            return this.image;
        }

        public GraphData getGraph() {
            return this.graph;
        }

        public @NonNull String toString() {
            return "DoclingDocument.FormItem(selfRef=" + this.getSelfRef() + ", parent=" + String.valueOf(this.getParent()) + ", children=" + String.valueOf(this.getChildren()) + ", contentLayer=" + String.valueOf((Object)this.getContentLayer()) + ", meta=" + String.valueOf(this.getMeta()) + ", label=" + this.getLabel() + ", prov=" + String.valueOf(this.getProv()) + ", captions=" + String.valueOf(this.getCaptions()) + ", references=" + String.valueOf(this.getReferences()) + ", footnotes=" + String.valueOf(this.getFootnotes()) + ", image=" + String.valueOf(this.getImage()) + ", graph=" + String.valueOf(this.getGraph()) + ")";
        }

        @tools.jackson.databind.annotation.JsonPOJOBuilder(withPrefix="")
        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        public static class Builder {
            private String selfRef;
            private RefItem parent;
            private ArrayList<RefItem> children;
            private ContentLayer contentLayer;
            private FloatingMeta meta;
            private String label;
            private ArrayList<ProvenanceItem> prov;
            private ArrayList<RefItem> captions;
            private ArrayList<RefItem> references;
            private ArrayList<RefItem> footnotes;
            private ImageRef image;
            private GraphData graph;

            Builder() {
            }

            @JsonProperty(value="self_ref")
            public @NonNull Builder selfRef(String selfRef) {
                this.selfRef = selfRef;
                return this;
            }

            @JsonProperty(value="parent")
            public @NonNull Builder parent(@Nullable RefItem parent) {
                this.parent = parent;
                return this;
            }

            public @NonNull Builder child(RefItem child) {
                if (this.children == null) {
                    this.children = new ArrayList();
                }
                this.children.add(child);
                return this;
            }

            @JsonProperty(value="children")
            @JsonSetter(nulls=Nulls.AS_EMPTY)
            public @NonNull Builder children(@NonNull Collection<? extends RefItem> children) {
                if (children == null) {
                    throw new IllegalArgumentException("children cannot be null");
                }
                if (this.children == null) {
                    this.children = new ArrayList();
                }
                this.children.addAll(children);
                return this;
            }

            public @NonNull Builder clearChildren() {
                if (this.children != null) {
                    this.children.clear();
                }
                return this;
            }

            @JsonProperty(value="content_layer")
            public @NonNull Builder contentLayer(ContentLayer contentLayer) {
                this.contentLayer = contentLayer;
                return this;
            }

            @JsonProperty(value="meta")
            public @NonNull Builder meta(@Nullable FloatingMeta meta) {
                this.meta = meta;
                return this;
            }

            @JsonProperty(value="label")
            public @NonNull Builder label(String label) {
                this.label = label;
                return this;
            }

            public @NonNull Builder prov(ProvenanceItem prov) {
                if (this.prov == null) {
                    this.prov = new ArrayList();
                }
                this.prov.add(prov);
                return this;
            }

            @JsonProperty(value="prov")
            @JsonSetter(nulls=Nulls.AS_EMPTY)
            public @NonNull Builder prov(@NonNull Collection<? extends ProvenanceItem> prov) {
                if (prov == null) {
                    throw new IllegalArgumentException("prov cannot be null");
                }
                if (this.prov == null) {
                    this.prov = new ArrayList();
                }
                this.prov.addAll(prov);
                return this;
            }

            public @NonNull Builder clearProv() {
                if (this.prov != null) {
                    this.prov.clear();
                }
                return this;
            }

            public @NonNull Builder caption(RefItem caption) {
                if (this.captions == null) {
                    this.captions = new ArrayList();
                }
                this.captions.add(caption);
                return this;
            }

            @JsonProperty(value="captions")
            @JsonSetter(nulls=Nulls.AS_EMPTY)
            public @NonNull Builder captions(@NonNull Collection<? extends RefItem> captions) {
                if (captions == null) {
                    throw new IllegalArgumentException("captions cannot be null");
                }
                if (this.captions == null) {
                    this.captions = new ArrayList();
                }
                this.captions.addAll(captions);
                return this;
            }

            public @NonNull Builder clearCaptions() {
                if (this.captions != null) {
                    this.captions.clear();
                }
                return this;
            }

            public @NonNull Builder reference(RefItem reference) {
                if (this.references == null) {
                    this.references = new ArrayList();
                }
                this.references.add(reference);
                return this;
            }

            @JsonProperty(value="references")
            @JsonSetter(nulls=Nulls.AS_EMPTY)
            public @NonNull Builder references(@NonNull Collection<? extends RefItem> references) {
                if (references == null) {
                    throw new IllegalArgumentException("references cannot be null");
                }
                if (this.references == null) {
                    this.references = new ArrayList();
                }
                this.references.addAll(references);
                return this;
            }

            public @NonNull Builder clearReferences() {
                if (this.references != null) {
                    this.references.clear();
                }
                return this;
            }

            public @NonNull Builder footnote(RefItem footnote) {
                if (this.footnotes == null) {
                    this.footnotes = new ArrayList();
                }
                this.footnotes.add(footnote);
                return this;
            }

            @JsonProperty(value="footnotes")
            @JsonSetter(nulls=Nulls.AS_EMPTY)
            public @NonNull Builder footnotes(@NonNull Collection<? extends RefItem> footnotes) {
                if (footnotes == null) {
                    throw new IllegalArgumentException("footnotes cannot be null");
                }
                if (this.footnotes == null) {
                    this.footnotes = new ArrayList();
                }
                this.footnotes.addAll(footnotes);
                return this;
            }

            public @NonNull Builder clearFootnotes() {
                if (this.footnotes != null) {
                    this.footnotes.clear();
                }
                return this;
            }

            @JsonProperty(value="image")
            public @NonNull Builder image(@Nullable ImageRef image) {
                this.image = image;
                return this;
            }

            @JsonProperty(value="graph")
            public @NonNull Builder graph(GraphData graph) {
                this.graph = graph;
                return this;
            }

            public @NonNull FormItem build() {
                return new FormItem(this.selfRef, this.parent, switch (this.children == null ? 0 : this.children.size()) {
                    case 0 -> Collections.emptyList();
                    case 1 -> Collections.singletonList(this.children.get(0));
                    default -> Collections.unmodifiableList(new ArrayList<RefItem>(this.children));
                }, this.contentLayer, this.meta, this.label, switch (this.prov == null ? 0 : this.prov.size()) {
                    case 0 -> Collections.emptyList();
                    case 1 -> Collections.singletonList(this.prov.get(0));
                    default -> Collections.unmodifiableList(new ArrayList<ProvenanceItem>(this.prov));
                }, switch (this.captions == null ? 0 : this.captions.size()) {
                    case 0 -> Collections.emptyList();
                    case 1 -> Collections.singletonList(this.captions.get(0));
                    default -> Collections.unmodifiableList(new ArrayList<RefItem>(this.captions));
                }, switch (this.references == null ? 0 : this.references.size()) {
                    case 0 -> Collections.emptyList();
                    case 1 -> Collections.singletonList(this.references.get(0));
                    default -> Collections.unmodifiableList(new ArrayList<RefItem>(this.references));
                }, switch (this.footnotes == null ? 0 : this.footnotes.size()) {
                    case 0 -> Collections.emptyList();
                    case 1 -> Collections.singletonList(this.footnotes.get(0));
                    default -> Collections.unmodifiableList(new ArrayList<RefItem>(this.footnotes));
                }, this.image, this.graph);
            }

            public @NonNull String toString() {
                return "DoclingDocument.FormItem.Builder(selfRef=" + this.selfRef + ", parent=" + String.valueOf(this.parent) + ", children=" + String.valueOf(this.children) + ", contentLayer=" + String.valueOf((Object)this.contentLayer) + ", meta=" + String.valueOf(this.meta) + ", label=" + this.label + ", prov=" + String.valueOf(this.prov) + ", captions=" + String.valueOf(this.captions) + ", references=" + String.valueOf(this.references) + ", footnotes=" + String.valueOf(this.footnotes) + ", image=" + String.valueOf(this.image) + ", graph=" + String.valueOf(this.graph) + ")";
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonDeserialize(builder=Builder.class)
    @com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder=Builder.class)
    public static class GraphLink {
        @JsonProperty(value="label")
        private final GraphLinkLabel label;
        @JsonProperty(value="source_cell_id")
        private final Integer sourceCellId;
        @JsonProperty(value="target_cell_id")
        private final Integer targetCellId;

        GraphLink(GraphLinkLabel label, Integer sourceCellId, Integer targetCellId) {
            this.label = label;
            this.sourceCellId = sourceCellId;
            this.targetCellId = targetCellId;
        }

        public static @NonNull Builder builder() {
            return new Builder();
        }

        public @NonNull Builder toBuilder() {
            return new Builder().label(this.label).sourceCellId(this.sourceCellId).targetCellId(this.targetCellId);
        }

        public GraphLinkLabel getLabel() {
            return this.label;
        }

        public Integer getSourceCellId() {
            return this.sourceCellId;
        }

        public Integer getTargetCellId() {
            return this.targetCellId;
        }

        public @NonNull String toString() {
            return "DoclingDocument.GraphLink(label=" + String.valueOf((Object)this.getLabel()) + ", sourceCellId=" + this.getSourceCellId() + ", targetCellId=" + this.getTargetCellId() + ")";
        }

        @tools.jackson.databind.annotation.JsonPOJOBuilder(withPrefix="")
        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        public static class Builder {
            private GraphLinkLabel label;
            private Integer sourceCellId;
            private Integer targetCellId;

            Builder() {
            }

            @JsonProperty(value="label")
            public @NonNull Builder label(GraphLinkLabel label) {
                this.label = label;
                return this;
            }

            @JsonProperty(value="source_cell_id")
            public @NonNull Builder sourceCellId(Integer sourceCellId) {
                this.sourceCellId = sourceCellId;
                return this;
            }

            @JsonProperty(value="target_cell_id")
            public @NonNull Builder targetCellId(Integer targetCellId) {
                this.targetCellId = targetCellId;
                return this;
            }

            public @NonNull GraphLink build() {
                return new GraphLink(this.label, this.sourceCellId, this.targetCellId);
            }

            public @NonNull String toString() {
                return "DoclingDocument.GraphLink.Builder(label=" + String.valueOf((Object)this.label) + ", sourceCellId=" + this.sourceCellId + ", targetCellId=" + this.targetCellId + ")";
            }
        }
    }

    public static enum GraphLinkLabel {
        UNSPECIFIED,
        TO_VALUE,
        TO_KEY,
        TO_PARENT,
        TO_CHILD;

    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonDeserialize(builder=Builder.class)
    @com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder=Builder.class)
    public static class GraphCell {
        @JsonProperty(value="label")
        private final GraphCellLabel label;
        @JsonProperty(value="cell_id")
        private final Integer cellId;
        @JsonProperty(value="text")
        private final String text;
        @JsonProperty(value="orig")
        private final String orig;
        @JsonProperty(value="prov")
        private final @Nullable ProvenanceItem prov;
        @JsonProperty(value="item_ref")
        private final @Nullable RefItem itemRef;

        GraphCell(GraphCellLabel label, Integer cellId, String text, String orig, @Nullable ProvenanceItem prov, @Nullable RefItem itemRef) {
            this.label = label;
            this.cellId = cellId;
            this.text = text;
            this.orig = orig;
            this.prov = prov;
            this.itemRef = itemRef;
        }

        public static @NonNull Builder builder() {
            return new Builder();
        }

        public @NonNull Builder toBuilder() {
            return new Builder().label(this.label).cellId(this.cellId).text(this.text).orig(this.orig).prov(this.prov).itemRef(this.itemRef);
        }

        public GraphCellLabel getLabel() {
            return this.label;
        }

        public Integer getCellId() {
            return this.cellId;
        }

        public String getText() {
            return this.text;
        }

        public String getOrig() {
            return this.orig;
        }

        public @Nullable ProvenanceItem getProv() {
            return this.prov;
        }

        public @Nullable RefItem getItemRef() {
            return this.itemRef;
        }

        public @NonNull String toString() {
            return "DoclingDocument.GraphCell(label=" + String.valueOf((Object)this.getLabel()) + ", cellId=" + this.getCellId() + ", text=" + this.getText() + ", orig=" + this.getOrig() + ", prov=" + String.valueOf(this.getProv()) + ", itemRef=" + String.valueOf(this.getItemRef()) + ")";
        }

        @tools.jackson.databind.annotation.JsonPOJOBuilder(withPrefix="")
        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        public static class Builder {
            private GraphCellLabel label;
            private Integer cellId;
            private String text;
            private String orig;
            private ProvenanceItem prov;
            private RefItem itemRef;

            Builder() {
            }

            @JsonProperty(value="label")
            public @NonNull Builder label(GraphCellLabel label) {
                this.label = label;
                return this;
            }

            @JsonProperty(value="cell_id")
            public @NonNull Builder cellId(Integer cellId) {
                this.cellId = cellId;
                return this;
            }

            @JsonProperty(value="text")
            public @NonNull Builder text(String text) {
                this.text = text;
                return this;
            }

            @JsonProperty(value="orig")
            public @NonNull Builder orig(String orig) {
                this.orig = orig;
                return this;
            }

            @JsonProperty(value="prov")
            public @NonNull Builder prov(@Nullable ProvenanceItem prov) {
                this.prov = prov;
                return this;
            }

            @JsonProperty(value="item_ref")
            public @NonNull Builder itemRef(@Nullable RefItem itemRef) {
                this.itemRef = itemRef;
                return this;
            }

            public @NonNull GraphCell build() {
                return new GraphCell(this.label, this.cellId, this.text, this.orig, this.prov, this.itemRef);
            }

            public @NonNull String toString() {
                return "DoclingDocument.GraphCell.Builder(label=" + String.valueOf((Object)this.label) + ", cellId=" + this.cellId + ", text=" + this.text + ", orig=" + this.orig + ", prov=" + String.valueOf(this.prov) + ", itemRef=" + String.valueOf(this.itemRef) + ")";
            }
        }
    }

    public static enum GraphCellLabel {
        UNSPECIFIED,
        KEY,
        VALUE,
        CHECKBOX;

    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonDeserialize(builder=Builder.class)
    @com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder=Builder.class)
    public static class GraphData {
        @JsonProperty(value="cells")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        private final List<GraphCell> cells;
        @JsonProperty(value="links")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        private final List<GraphLink> links;

        GraphData(List<GraphCell> cells, List<GraphLink> links) {
            this.cells = cells;
            this.links = links;
        }

        public static @NonNull Builder builder() {
            return new Builder();
        }

        public @NonNull Builder toBuilder() {
            Builder builder = new Builder();
            if (this.cells != null) {
                builder.cells(this.cells);
            }
            if (this.links != null) {
                builder.links(this.links);
            }
            return builder;
        }

        public List<GraphCell> getCells() {
            return this.cells;
        }

        public List<GraphLink> getLinks() {
            return this.links;
        }

        public @NonNull String toString() {
            return "DoclingDocument.GraphData(cells=" + String.valueOf(this.getCells()) + ", links=" + String.valueOf(this.getLinks()) + ")";
        }

        @tools.jackson.databind.annotation.JsonPOJOBuilder(withPrefix="")
        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        public static class Builder {
            private ArrayList<GraphCell> cells;
            private ArrayList<GraphLink> links;

            Builder() {
            }

            public @NonNull Builder cell(GraphCell cell) {
                if (this.cells == null) {
                    this.cells = new ArrayList();
                }
                this.cells.add(cell);
                return this;
            }

            @JsonProperty(value="cells")
            @JsonSetter(nulls=Nulls.AS_EMPTY)
            public @NonNull Builder cells(@NonNull Collection<? extends GraphCell> cells) {
                if (cells == null) {
                    throw new IllegalArgumentException("cells cannot be null");
                }
                if (this.cells == null) {
                    this.cells = new ArrayList();
                }
                this.cells.addAll(cells);
                return this;
            }

            public @NonNull Builder clearCells() {
                if (this.cells != null) {
                    this.cells.clear();
                }
                return this;
            }

            public @NonNull Builder link(GraphLink link) {
                if (this.links == null) {
                    this.links = new ArrayList();
                }
                this.links.add(link);
                return this;
            }

            @JsonProperty(value="links")
            @JsonSetter(nulls=Nulls.AS_EMPTY)
            public @NonNull Builder links(@NonNull Collection<? extends GraphLink> links) {
                if (links == null) {
                    throw new IllegalArgumentException("links cannot be null");
                }
                if (this.links == null) {
                    this.links = new ArrayList();
                }
                this.links.addAll(links);
                return this;
            }

            public @NonNull Builder clearLinks() {
                if (this.links != null) {
                    this.links.clear();
                }
                return this;
            }

            public @NonNull GraphData build() {
                return new GraphData(switch (this.cells == null ? 0 : this.cells.size()) {
                    case 0 -> Collections.emptyList();
                    case 1 -> Collections.singletonList(this.cells.get(0));
                    default -> Collections.unmodifiableList(new ArrayList<GraphCell>(this.cells));
                }, switch (this.links == null ? 0 : this.links.size()) {
                    case 0 -> Collections.emptyList();
                    case 1 -> Collections.singletonList(this.links.get(0));
                    default -> Collections.unmodifiableList(new ArrayList<GraphLink>(this.links));
                });
            }

            public @NonNull String toString() {
                return "DoclingDocument.GraphData.Builder(cells=" + String.valueOf(this.cells) + ", links=" + String.valueOf(this.links) + ")";
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonDeserialize(builder=Builder.class)
    @com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder=Builder.class)
    public static class KeyValueItem {
        @JsonProperty(value="self_ref")
        private final String selfRef;
        @JsonProperty(value="parent")
        private final @Nullable RefItem parent;
        @JsonProperty(value="children")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        private final List<RefItem> children;
        @JsonProperty(value="content_layer")
        private final ContentLayer contentLayer;
        @JsonProperty(value="meta")
        private final @Nullable FloatingMeta meta;
        @JsonProperty(value="label")
        private final String label;
        @JsonProperty(value="prov")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        private final List<ProvenanceItem> prov;
        @JsonProperty(value="captions")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        private final List<RefItem> captions;
        @JsonProperty(value="references")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        private final List<RefItem> references;
        @JsonProperty(value="footnotes")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        private final List<RefItem> footnotes;
        @JsonProperty(value="image")
        private final @Nullable ImageRef image;
        @JsonProperty(value="graph")
        private final GraphData graph;

        KeyValueItem(String selfRef, @Nullable RefItem parent, List<RefItem> children, ContentLayer contentLayer, @Nullable FloatingMeta meta, String label, List<ProvenanceItem> prov, List<RefItem> captions, List<RefItem> references, List<RefItem> footnotes, @Nullable ImageRef image, GraphData graph) {
            this.selfRef = selfRef;
            this.parent = parent;
            this.children = children;
            this.contentLayer = contentLayer;
            this.meta = meta;
            this.label = label;
            this.prov = prov;
            this.captions = captions;
            this.references = references;
            this.footnotes = footnotes;
            this.image = image;
            this.graph = graph;
        }

        public static @NonNull Builder builder() {
            return new Builder();
        }

        public @NonNull Builder toBuilder() {
            Builder builder = new Builder().selfRef(this.selfRef).parent(this.parent).contentLayer(this.contentLayer).meta(this.meta).label(this.label).image(this.image).graph(this.graph);
            if (this.children != null) {
                builder.children(this.children);
            }
            if (this.prov != null) {
                builder.prov(this.prov);
            }
            if (this.captions != null) {
                builder.captions(this.captions);
            }
            if (this.references != null) {
                builder.references(this.references);
            }
            if (this.footnotes != null) {
                builder.footnotes(this.footnotes);
            }
            return builder;
        }

        public String getSelfRef() {
            return this.selfRef;
        }

        public @Nullable RefItem getParent() {
            return this.parent;
        }

        public List<RefItem> getChildren() {
            return this.children;
        }

        public ContentLayer getContentLayer() {
            return this.contentLayer;
        }

        public @Nullable FloatingMeta getMeta() {
            return this.meta;
        }

        public String getLabel() {
            return this.label;
        }

        public List<ProvenanceItem> getProv() {
            return this.prov;
        }

        public List<RefItem> getCaptions() {
            return this.captions;
        }

        public List<RefItem> getReferences() {
            return this.references;
        }

        public List<RefItem> getFootnotes() {
            return this.footnotes;
        }

        public @Nullable ImageRef getImage() {
            return this.image;
        }

        public GraphData getGraph() {
            return this.graph;
        }

        public @NonNull String toString() {
            return "DoclingDocument.KeyValueItem(selfRef=" + this.getSelfRef() + ", parent=" + String.valueOf(this.getParent()) + ", children=" + String.valueOf(this.getChildren()) + ", contentLayer=" + String.valueOf((Object)this.getContentLayer()) + ", meta=" + String.valueOf(this.getMeta()) + ", label=" + this.getLabel() + ", prov=" + String.valueOf(this.getProv()) + ", captions=" + String.valueOf(this.getCaptions()) + ", references=" + String.valueOf(this.getReferences()) + ", footnotes=" + String.valueOf(this.getFootnotes()) + ", image=" + String.valueOf(this.getImage()) + ", graph=" + String.valueOf(this.getGraph()) + ")";
        }

        @tools.jackson.databind.annotation.JsonPOJOBuilder(withPrefix="")
        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        public static class Builder {
            private String selfRef;
            private RefItem parent;
            private ArrayList<RefItem> children;
            private ContentLayer contentLayer;
            private FloatingMeta meta;
            private String label;
            private ArrayList<ProvenanceItem> prov;
            private ArrayList<RefItem> captions;
            private ArrayList<RefItem> references;
            private ArrayList<RefItem> footnotes;
            private ImageRef image;
            private GraphData graph;

            Builder() {
            }

            @JsonProperty(value="self_ref")
            public @NonNull Builder selfRef(String selfRef) {
                this.selfRef = selfRef;
                return this;
            }

            @JsonProperty(value="parent")
            public @NonNull Builder parent(@Nullable RefItem parent) {
                this.parent = parent;
                return this;
            }

            public @NonNull Builder child(RefItem child) {
                if (this.children == null) {
                    this.children = new ArrayList();
                }
                this.children.add(child);
                return this;
            }

            @JsonProperty(value="children")
            @JsonSetter(nulls=Nulls.AS_EMPTY)
            public @NonNull Builder children(@NonNull Collection<? extends RefItem> children) {
                if (children == null) {
                    throw new IllegalArgumentException("children cannot be null");
                }
                if (this.children == null) {
                    this.children = new ArrayList();
                }
                this.children.addAll(children);
                return this;
            }

            public @NonNull Builder clearChildren() {
                if (this.children != null) {
                    this.children.clear();
                }
                return this;
            }

            @JsonProperty(value="content_layer")
            public @NonNull Builder contentLayer(ContentLayer contentLayer) {
                this.contentLayer = contentLayer;
                return this;
            }

            @JsonProperty(value="meta")
            public @NonNull Builder meta(@Nullable FloatingMeta meta) {
                this.meta = meta;
                return this;
            }

            @JsonProperty(value="label")
            public @NonNull Builder label(String label) {
                this.label = label;
                return this;
            }

            public @NonNull Builder prov(ProvenanceItem prov) {
                if (this.prov == null) {
                    this.prov = new ArrayList();
                }
                this.prov.add(prov);
                return this;
            }

            @JsonProperty(value="prov")
            @JsonSetter(nulls=Nulls.AS_EMPTY)
            public @NonNull Builder prov(@NonNull Collection<? extends ProvenanceItem> prov) {
                if (prov == null) {
                    throw new IllegalArgumentException("prov cannot be null");
                }
                if (this.prov == null) {
                    this.prov = new ArrayList();
                }
                this.prov.addAll(prov);
                return this;
            }

            public @NonNull Builder clearProv() {
                if (this.prov != null) {
                    this.prov.clear();
                }
                return this;
            }

            public @NonNull Builder caption(RefItem caption) {
                if (this.captions == null) {
                    this.captions = new ArrayList();
                }
                this.captions.add(caption);
                return this;
            }

            @JsonProperty(value="captions")
            @JsonSetter(nulls=Nulls.AS_EMPTY)
            public @NonNull Builder captions(@NonNull Collection<? extends RefItem> captions) {
                if (captions == null) {
                    throw new IllegalArgumentException("captions cannot be null");
                }
                if (this.captions == null) {
                    this.captions = new ArrayList();
                }
                this.captions.addAll(captions);
                return this;
            }

            public @NonNull Builder clearCaptions() {
                if (this.captions != null) {
                    this.captions.clear();
                }
                return this;
            }

            public @NonNull Builder reference(RefItem reference) {
                if (this.references == null) {
                    this.references = new ArrayList();
                }
                this.references.add(reference);
                return this;
            }

            @JsonProperty(value="references")
            @JsonSetter(nulls=Nulls.AS_EMPTY)
            public @NonNull Builder references(@NonNull Collection<? extends RefItem> references) {
                if (references == null) {
                    throw new IllegalArgumentException("references cannot be null");
                }
                if (this.references == null) {
                    this.references = new ArrayList();
                }
                this.references.addAll(references);
                return this;
            }

            public @NonNull Builder clearReferences() {
                if (this.references != null) {
                    this.references.clear();
                }
                return this;
            }

            public @NonNull Builder footnote(RefItem footnote) {
                if (this.footnotes == null) {
                    this.footnotes = new ArrayList();
                }
                this.footnotes.add(footnote);
                return this;
            }

            @JsonProperty(value="footnotes")
            @JsonSetter(nulls=Nulls.AS_EMPTY)
            public @NonNull Builder footnotes(@NonNull Collection<? extends RefItem> footnotes) {
                if (footnotes == null) {
                    throw new IllegalArgumentException("footnotes cannot be null");
                }
                if (this.footnotes == null) {
                    this.footnotes = new ArrayList();
                }
                this.footnotes.addAll(footnotes);
                return this;
            }

            public @NonNull Builder clearFootnotes() {
                if (this.footnotes != null) {
                    this.footnotes.clear();
                }
                return this;
            }

            @JsonProperty(value="image")
            public @NonNull Builder image(@Nullable ImageRef image) {
                this.image = image;
                return this;
            }

            @JsonProperty(value="graph")
            public @NonNull Builder graph(GraphData graph) {
                this.graph = graph;
                return this;
            }

            public @NonNull KeyValueItem build() {
                return new KeyValueItem(this.selfRef, this.parent, switch (this.children == null ? 0 : this.children.size()) {
                    case 0 -> Collections.emptyList();
                    case 1 -> Collections.singletonList(this.children.get(0));
                    default -> Collections.unmodifiableList(new ArrayList<RefItem>(this.children));
                }, this.contentLayer, this.meta, this.label, switch (this.prov == null ? 0 : this.prov.size()) {
                    case 0 -> Collections.emptyList();
                    case 1 -> Collections.singletonList(this.prov.get(0));
                    default -> Collections.unmodifiableList(new ArrayList<ProvenanceItem>(this.prov));
                }, switch (this.captions == null ? 0 : this.captions.size()) {
                    case 0 -> Collections.emptyList();
                    case 1 -> Collections.singletonList(this.captions.get(0));
                    default -> Collections.unmodifiableList(new ArrayList<RefItem>(this.captions));
                }, switch (this.references == null ? 0 : this.references.size()) {
                    case 0 -> Collections.emptyList();
                    case 1 -> Collections.singletonList(this.references.get(0));
                    default -> Collections.unmodifiableList(new ArrayList<RefItem>(this.references));
                }, switch (this.footnotes == null ? 0 : this.footnotes.size()) {
                    case 0 -> Collections.emptyList();
                    case 1 -> Collections.singletonList(this.footnotes.get(0));
                    default -> Collections.unmodifiableList(new ArrayList<RefItem>(this.footnotes));
                }, this.image, this.graph);
            }

            public @NonNull String toString() {
                return "DoclingDocument.KeyValueItem.Builder(selfRef=" + this.selfRef + ", parent=" + String.valueOf(this.parent) + ", children=" + String.valueOf(this.children) + ", contentLayer=" + String.valueOf((Object)this.contentLayer) + ", meta=" + String.valueOf(this.meta) + ", label=" + this.label + ", prov=" + String.valueOf(this.prov) + ", captions=" + String.valueOf(this.captions) + ", references=" + String.valueOf(this.references) + ", footnotes=" + String.valueOf(this.footnotes) + ", image=" + String.valueOf(this.image) + ", graph=" + String.valueOf(this.graph) + ")";
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonDeserialize(builder=Builder.class)
    @com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder=Builder.class)
    public static class TableCell {
        @JsonProperty(value="bbox")
        private final BoundingBox bbox;
        @JsonProperty(value="row_span")
        private final Integer rowSpan;
        @JsonProperty(value="col_span")
        private final Integer colSpan;
        @JsonProperty(value="start_row_offset_idx")
        private final Integer startRowOffsetIdx;
        @JsonProperty(value="end_row_offset_idx")
        private final Integer endRowOffsetIdx;
        @JsonProperty(value="start_col_offset_idx")
        private final Integer startColOffsetIdx;
        @JsonProperty(value="end_col_offset_idx")
        private final Integer endColOffsetIdx;
        @JsonProperty(value="text")
        private final String text;
        @JsonProperty(value="column_header")
        private final boolean columnHeader;
        @JsonProperty(value="row_header")
        private final boolean rowHeader;
        @JsonProperty(value="row_section")
        private final boolean rowSection;
        @JsonProperty(value="fillable")
        private final boolean fillable;

        TableCell(BoundingBox bbox, Integer rowSpan, Integer colSpan, Integer startRowOffsetIdx, Integer endRowOffsetIdx, Integer startColOffsetIdx, Integer endColOffsetIdx, String text, boolean columnHeader, boolean rowHeader, boolean rowSection, boolean fillable) {
            this.bbox = bbox;
            this.rowSpan = rowSpan;
            this.colSpan = colSpan;
            this.startRowOffsetIdx = startRowOffsetIdx;
            this.endRowOffsetIdx = endRowOffsetIdx;
            this.startColOffsetIdx = startColOffsetIdx;
            this.endColOffsetIdx = endColOffsetIdx;
            this.text = text;
            this.columnHeader = columnHeader;
            this.rowHeader = rowHeader;
            this.rowSection = rowSection;
            this.fillable = fillable;
        }

        public static @NonNull Builder builder() {
            return new Builder();
        }

        public @NonNull Builder toBuilder() {
            return new Builder().bbox(this.bbox).rowSpan(this.rowSpan).colSpan(this.colSpan).startRowOffsetIdx(this.startRowOffsetIdx).endRowOffsetIdx(this.endRowOffsetIdx).startColOffsetIdx(this.startColOffsetIdx).endColOffsetIdx(this.endColOffsetIdx).text(this.text).columnHeader(this.columnHeader).rowHeader(this.rowHeader).rowSection(this.rowSection).fillable(this.fillable);
        }

        public BoundingBox getBbox() {
            return this.bbox;
        }

        public Integer getRowSpan() {
            return this.rowSpan;
        }

        public Integer getColSpan() {
            return this.colSpan;
        }

        public Integer getStartRowOffsetIdx() {
            return this.startRowOffsetIdx;
        }

        public Integer getEndRowOffsetIdx() {
            return this.endRowOffsetIdx;
        }

        public Integer getStartColOffsetIdx() {
            return this.startColOffsetIdx;
        }

        public Integer getEndColOffsetIdx() {
            return this.endColOffsetIdx;
        }

        public String getText() {
            return this.text;
        }

        public boolean isColumnHeader() {
            return this.columnHeader;
        }

        public boolean isRowHeader() {
            return this.rowHeader;
        }

        public boolean isRowSection() {
            return this.rowSection;
        }

        public boolean isFillable() {
            return this.fillable;
        }

        public @NonNull String toString() {
            return "DoclingDocument.TableCell(bbox=" + String.valueOf(this.getBbox()) + ", rowSpan=" + this.getRowSpan() + ", colSpan=" + this.getColSpan() + ", startRowOffsetIdx=" + this.getStartRowOffsetIdx() + ", endRowOffsetIdx=" + this.getEndRowOffsetIdx() + ", startColOffsetIdx=" + this.getStartColOffsetIdx() + ", endColOffsetIdx=" + this.getEndColOffsetIdx() + ", text=" + this.getText() + ", columnHeader=" + this.isColumnHeader() + ", rowHeader=" + this.isRowHeader() + ", rowSection=" + this.isRowSection() + ", fillable=" + this.isFillable() + ")";
        }

        @tools.jackson.databind.annotation.JsonPOJOBuilder(withPrefix="")
        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        public static class Builder {
            private BoundingBox bbox;
            private Integer rowSpan;
            private Integer colSpan;
            private Integer startRowOffsetIdx;
            private Integer endRowOffsetIdx;
            private Integer startColOffsetIdx;
            private Integer endColOffsetIdx;
            private String text;
            private boolean columnHeader;
            private boolean rowHeader;
            private boolean rowSection;
            private boolean fillable;

            Builder() {
            }

            @JsonProperty(value="bbox")
            public @NonNull Builder bbox(BoundingBox bbox) {
                this.bbox = bbox;
                return this;
            }

            @JsonProperty(value="row_span")
            public @NonNull Builder rowSpan(Integer rowSpan) {
                this.rowSpan = rowSpan;
                return this;
            }

            @JsonProperty(value="col_span")
            public @NonNull Builder colSpan(Integer colSpan) {
                this.colSpan = colSpan;
                return this;
            }

            @JsonProperty(value="start_row_offset_idx")
            public @NonNull Builder startRowOffsetIdx(Integer startRowOffsetIdx) {
                this.startRowOffsetIdx = startRowOffsetIdx;
                return this;
            }

            @JsonProperty(value="end_row_offset_idx")
            public @NonNull Builder endRowOffsetIdx(Integer endRowOffsetIdx) {
                this.endRowOffsetIdx = endRowOffsetIdx;
                return this;
            }

            @JsonProperty(value="start_col_offset_idx")
            public @NonNull Builder startColOffsetIdx(Integer startColOffsetIdx) {
                this.startColOffsetIdx = startColOffsetIdx;
                return this;
            }

            @JsonProperty(value="end_col_offset_idx")
            public @NonNull Builder endColOffsetIdx(Integer endColOffsetIdx) {
                this.endColOffsetIdx = endColOffsetIdx;
                return this;
            }

            @JsonProperty(value="text")
            public @NonNull Builder text(String text) {
                this.text = text;
                return this;
            }

            @JsonProperty(value="column_header")
            public @NonNull Builder columnHeader(boolean columnHeader) {
                this.columnHeader = columnHeader;
                return this;
            }

            @JsonProperty(value="row_header")
            public @NonNull Builder rowHeader(boolean rowHeader) {
                this.rowHeader = rowHeader;
                return this;
            }

            @JsonProperty(value="row_section")
            public @NonNull Builder rowSection(boolean rowSection) {
                this.rowSection = rowSection;
                return this;
            }

            @JsonProperty(value="fillable")
            public @NonNull Builder fillable(boolean fillable) {
                this.fillable = fillable;
                return this;
            }

            public @NonNull TableCell build() {
                return new TableCell(this.bbox, this.rowSpan, this.colSpan, this.startRowOffsetIdx, this.endRowOffsetIdx, this.startColOffsetIdx, this.endColOffsetIdx, this.text, this.columnHeader, this.rowHeader, this.rowSection, this.fillable);
            }

            public @NonNull String toString() {
                return "DoclingDocument.TableCell.Builder(bbox=" + String.valueOf(this.bbox) + ", rowSpan=" + this.rowSpan + ", colSpan=" + this.colSpan + ", startRowOffsetIdx=" + this.startRowOffsetIdx + ", endRowOffsetIdx=" + this.endRowOffsetIdx + ", startColOffsetIdx=" + this.startColOffsetIdx + ", endColOffsetIdx=" + this.endColOffsetIdx + ", text=" + this.text + ", columnHeader=" + this.columnHeader + ", rowHeader=" + this.rowHeader + ", rowSection=" + this.rowSection + ", fillable=" + this.fillable + ")";
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonDeserialize(builder=Builder.class)
    @com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder=Builder.class)
    public static class TableData {
        @JsonProperty(value="table_cells")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        private final List<Object> tableCells;
        @JsonProperty(value="num_rows")
        private final Integer numRows;
        @JsonProperty(value="num_cols")
        private final Integer numCols;
        @JsonProperty(value="grid")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        private final List<List<TableCell>> grid;

        TableData(List<Object> tableCells, Integer numRows, Integer numCols, List<List<TableCell>> grid) {
            this.tableCells = tableCells;
            this.numRows = numRows;
            this.numCols = numCols;
            this.grid = grid;
        }

        public static @NonNull Builder builder() {
            return new Builder();
        }

        public @NonNull Builder toBuilder() {
            Builder builder = new Builder().numRows(this.numRows).numCols(this.numCols);
            if (this.tableCells != null) {
                builder.tableCells(this.tableCells);
            }
            if (this.grid != null) {
                builder.grid((Collection<? extends List<TableCell>>)this.grid);
            }
            return builder;
        }

        public List<Object> getTableCells() {
            return this.tableCells;
        }

        public Integer getNumRows() {
            return this.numRows;
        }

        public Integer getNumCols() {
            return this.numCols;
        }

        public List<List<TableCell>> getGrid() {
            return this.grid;
        }

        public @NonNull String toString() {
            return "DoclingDocument.TableData(tableCells=" + String.valueOf(this.getTableCells()) + ", numRows=" + this.getNumRows() + ", numCols=" + this.getNumCols() + ", grid=" + String.valueOf(this.getGrid()) + ")";
        }

        @tools.jackson.databind.annotation.JsonPOJOBuilder(withPrefix="")
        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        public static class Builder {
            private ArrayList<Object> tableCells;
            private Integer numRows;
            private Integer numCols;
            private ArrayList<List<TableCell>> grid;

            Builder() {
            }

            public @NonNull Builder tableCell(Object tableCell) {
                if (this.tableCells == null) {
                    this.tableCells = new ArrayList();
                }
                this.tableCells.add(tableCell);
                return this;
            }

            @JsonProperty(value="table_cells")
            @JsonSetter(nulls=Nulls.AS_EMPTY)
            public @NonNull Builder tableCells(@NonNull Collection<? extends Object> tableCells) {
                if (tableCells == null) {
                    throw new IllegalArgumentException("tableCells cannot be null");
                }
                if (this.tableCells == null) {
                    this.tableCells = new ArrayList();
                }
                this.tableCells.addAll(tableCells);
                return this;
            }

            public @NonNull Builder clearTableCells() {
                if (this.tableCells != null) {
                    this.tableCells.clear();
                }
                return this;
            }

            @JsonProperty(value="num_rows")
            public @NonNull Builder numRows(Integer numRows) {
                this.numRows = numRows;
                return this;
            }

            @JsonProperty(value="num_cols")
            public @NonNull Builder numCols(Integer numCols) {
                this.numCols = numCols;
                return this;
            }

            public @NonNull Builder grid(List<TableCell> grid) {
                if (this.grid == null) {
                    this.grid = new ArrayList();
                }
                this.grid.add(grid);
                return this;
            }

            @JsonProperty(value="grid")
            @JsonSetter(nulls=Nulls.AS_EMPTY)
            public @NonNull Builder grid(@NonNull Collection<? extends List<TableCell>> grid) {
                if (grid == null) {
                    throw new IllegalArgumentException("grid cannot be null");
                }
                if (this.grid == null) {
                    this.grid = new ArrayList();
                }
                this.grid.addAll(grid);
                return this;
            }

            public @NonNull Builder clearGrid() {
                if (this.grid != null) {
                    this.grid.clear();
                }
                return this;
            }

            public @NonNull TableData build() {
                return new TableData(switch (this.tableCells == null ? 0 : this.tableCells.size()) {
                    case 0 -> Collections.emptyList();
                    case 1 -> Collections.singletonList(this.tableCells.get(0));
                    default -> Collections.unmodifiableList(new ArrayList<Object>(this.tableCells));
                }, this.numRows, this.numCols, switch (this.grid == null ? 0 : this.grid.size()) {
                    case 0 -> Collections.emptyList();
                    case 1 -> Collections.singletonList(this.grid.get(0));
                    default -> Collections.unmodifiableList(new ArrayList<List<TableCell>>(this.grid));
                });
            }

            public @NonNull String toString() {
                return "DoclingDocument.TableData.Builder(tableCells=" + String.valueOf(this.tableCells) + ", numRows=" + this.numRows + ", numCols=" + this.numCols + ", grid=" + String.valueOf(this.grid) + ")";
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonDeserialize(builder=Builder.class)
    @com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder=Builder.class)
    public static class FloatingMeta {
        @JsonProperty(value="summary")
        private final @Nullable SummaryMetaField summary;
        @JsonProperty(value="description")
        private final @Nullable DescriptionMetaField description;

        FloatingMeta(@Nullable SummaryMetaField summary, @Nullable DescriptionMetaField description) {
            this.summary = summary;
            this.description = description;
        }

        public static @NonNull Builder builder() {
            return new Builder();
        }

        public @NonNull Builder toBuilder() {
            return new Builder().summary(this.summary).description(this.description);
        }

        public @Nullable SummaryMetaField getSummary() {
            return this.summary;
        }

        public @Nullable DescriptionMetaField getDescription() {
            return this.description;
        }

        public @NonNull String toString() {
            return "DoclingDocument.FloatingMeta(summary=" + String.valueOf(this.getSummary()) + ", description=" + String.valueOf(this.getDescription()) + ")";
        }

        @tools.jackson.databind.annotation.JsonPOJOBuilder(withPrefix="")
        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        public static class Builder {
            private SummaryMetaField summary;
            private DescriptionMetaField description;

            Builder() {
            }

            @JsonProperty(value="summary")
            public @NonNull Builder summary(@Nullable SummaryMetaField summary) {
                this.summary = summary;
                return this;
            }

            @JsonProperty(value="description")
            public @NonNull Builder description(@Nullable DescriptionMetaField description) {
                this.description = description;
                return this;
            }

            public @NonNull FloatingMeta build() {
                return new FloatingMeta(this.summary, this.description);
            }

            public @NonNull String toString() {
                return "DoclingDocument.FloatingMeta.Builder(summary=" + String.valueOf(this.summary) + ", description=" + String.valueOf(this.description) + ")";
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonDeserialize(builder=Builder.class)
    @com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder=Builder.class)
    public static class TableItem {
        @JsonProperty(value="self_ref")
        private final String selfRef;
        @JsonProperty(value="parent")
        private final @Nullable RefItem parent;
        @JsonProperty(value="children")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        private final List<RefItem> children;
        @JsonProperty(value="content_layer")
        private final ContentLayer contentLayer;
        @JsonProperty(value="meta")
        private final @Nullable FloatingMeta meta;
        @JsonProperty(value="label")
        private final String label;
        @JsonProperty(value="prov")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        private final List<ProvenanceItem> prov;
        @JsonProperty(value="captions")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        private final List<RefItem> captions;
        @JsonProperty(value="references")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        private final List<RefItem> references;
        @JsonProperty(value="footnotes")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        private final List<RefItem> footnotes;
        @JsonProperty(value="image")
        private final @Nullable ImageRef image;
        @JsonProperty(value="data")
        private final TableData data;

        TableItem(String selfRef, @Nullable RefItem parent, List<RefItem> children, ContentLayer contentLayer, @Nullable FloatingMeta meta, String label, List<ProvenanceItem> prov, List<RefItem> captions, List<RefItem> references, List<RefItem> footnotes, @Nullable ImageRef image, TableData data) {
            this.selfRef = selfRef;
            this.parent = parent;
            this.children = children;
            this.contentLayer = contentLayer;
            this.meta = meta;
            this.label = label;
            this.prov = prov;
            this.captions = captions;
            this.references = references;
            this.footnotes = footnotes;
            this.image = image;
            this.data = data;
        }

        public static @NonNull Builder builder() {
            return new Builder();
        }

        public @NonNull Builder toBuilder() {
            Builder builder = new Builder().selfRef(this.selfRef).parent(this.parent).contentLayer(this.contentLayer).meta(this.meta).label(this.label).image(this.image).data(this.data);
            if (this.children != null) {
                builder.children(this.children);
            }
            if (this.prov != null) {
                builder.prov(this.prov);
            }
            if (this.captions != null) {
                builder.captions(this.captions);
            }
            if (this.references != null) {
                builder.references(this.references);
            }
            if (this.footnotes != null) {
                builder.footnotes(this.footnotes);
            }
            return builder;
        }

        public String getSelfRef() {
            return this.selfRef;
        }

        public @Nullable RefItem getParent() {
            return this.parent;
        }

        public List<RefItem> getChildren() {
            return this.children;
        }

        public ContentLayer getContentLayer() {
            return this.contentLayer;
        }

        public @Nullable FloatingMeta getMeta() {
            return this.meta;
        }

        public String getLabel() {
            return this.label;
        }

        public List<ProvenanceItem> getProv() {
            return this.prov;
        }

        public List<RefItem> getCaptions() {
            return this.captions;
        }

        public List<RefItem> getReferences() {
            return this.references;
        }

        public List<RefItem> getFootnotes() {
            return this.footnotes;
        }

        public @Nullable ImageRef getImage() {
            return this.image;
        }

        public TableData getData() {
            return this.data;
        }

        public @NonNull String toString() {
            return "DoclingDocument.TableItem(selfRef=" + this.getSelfRef() + ", parent=" + String.valueOf(this.getParent()) + ", children=" + String.valueOf(this.getChildren()) + ", contentLayer=" + String.valueOf((Object)this.getContentLayer()) + ", meta=" + String.valueOf(this.getMeta()) + ", label=" + this.getLabel() + ", prov=" + String.valueOf(this.getProv()) + ", captions=" + String.valueOf(this.getCaptions()) + ", references=" + String.valueOf(this.getReferences()) + ", footnotes=" + String.valueOf(this.getFootnotes()) + ", image=" + String.valueOf(this.getImage()) + ", data=" + String.valueOf(this.getData()) + ")";
        }

        @tools.jackson.databind.annotation.JsonPOJOBuilder(withPrefix="")
        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        public static class Builder {
            private String selfRef;
            private RefItem parent;
            private ArrayList<RefItem> children;
            private ContentLayer contentLayer;
            private FloatingMeta meta;
            private String label;
            private ArrayList<ProvenanceItem> prov;
            private ArrayList<RefItem> captions;
            private ArrayList<RefItem> references;
            private ArrayList<RefItem> footnotes;
            private ImageRef image;
            private TableData data;

            Builder() {
            }

            @JsonProperty(value="self_ref")
            public @NonNull Builder selfRef(String selfRef) {
                this.selfRef = selfRef;
                return this;
            }

            @JsonProperty(value="parent")
            public @NonNull Builder parent(@Nullable RefItem parent) {
                this.parent = parent;
                return this;
            }

            public @NonNull Builder child(RefItem child) {
                if (this.children == null) {
                    this.children = new ArrayList();
                }
                this.children.add(child);
                return this;
            }

            @JsonProperty(value="children")
            @JsonSetter(nulls=Nulls.AS_EMPTY)
            public @NonNull Builder children(@NonNull Collection<? extends RefItem> children) {
                if (children == null) {
                    throw new IllegalArgumentException("children cannot be null");
                }
                if (this.children == null) {
                    this.children = new ArrayList();
                }
                this.children.addAll(children);
                return this;
            }

            public @NonNull Builder clearChildren() {
                if (this.children != null) {
                    this.children.clear();
                }
                return this;
            }

            @JsonProperty(value="content_layer")
            public @NonNull Builder contentLayer(ContentLayer contentLayer) {
                this.contentLayer = contentLayer;
                return this;
            }

            @JsonProperty(value="meta")
            public @NonNull Builder meta(@Nullable FloatingMeta meta) {
                this.meta = meta;
                return this;
            }

            @JsonProperty(value="label")
            public @NonNull Builder label(String label) {
                this.label = label;
                return this;
            }

            public @NonNull Builder prov(ProvenanceItem prov) {
                if (this.prov == null) {
                    this.prov = new ArrayList();
                }
                this.prov.add(prov);
                return this;
            }

            @JsonProperty(value="prov")
            @JsonSetter(nulls=Nulls.AS_EMPTY)
            public @NonNull Builder prov(@NonNull Collection<? extends ProvenanceItem> prov) {
                if (prov == null) {
                    throw new IllegalArgumentException("prov cannot be null");
                }
                if (this.prov == null) {
                    this.prov = new ArrayList();
                }
                this.prov.addAll(prov);
                return this;
            }

            public @NonNull Builder clearProv() {
                if (this.prov != null) {
                    this.prov.clear();
                }
                return this;
            }

            public @NonNull Builder caption(RefItem caption) {
                if (this.captions == null) {
                    this.captions = new ArrayList();
                }
                this.captions.add(caption);
                return this;
            }

            @JsonProperty(value="captions")
            @JsonSetter(nulls=Nulls.AS_EMPTY)
            public @NonNull Builder captions(@NonNull Collection<? extends RefItem> captions) {
                if (captions == null) {
                    throw new IllegalArgumentException("captions cannot be null");
                }
                if (this.captions == null) {
                    this.captions = new ArrayList();
                }
                this.captions.addAll(captions);
                return this;
            }

            public @NonNull Builder clearCaptions() {
                if (this.captions != null) {
                    this.captions.clear();
                }
                return this;
            }

            public @NonNull Builder reference(RefItem reference) {
                if (this.references == null) {
                    this.references = new ArrayList();
                }
                this.references.add(reference);
                return this;
            }

            @JsonProperty(value="references")
            @JsonSetter(nulls=Nulls.AS_EMPTY)
            public @NonNull Builder references(@NonNull Collection<? extends RefItem> references) {
                if (references == null) {
                    throw new IllegalArgumentException("references cannot be null");
                }
                if (this.references == null) {
                    this.references = new ArrayList();
                }
                this.references.addAll(references);
                return this;
            }

            public @NonNull Builder clearReferences() {
                if (this.references != null) {
                    this.references.clear();
                }
                return this;
            }

            public @NonNull Builder footnote(RefItem footnote) {
                if (this.footnotes == null) {
                    this.footnotes = new ArrayList();
                }
                this.footnotes.add(footnote);
                return this;
            }

            @JsonProperty(value="footnotes")
            @JsonSetter(nulls=Nulls.AS_EMPTY)
            public @NonNull Builder footnotes(@NonNull Collection<? extends RefItem> footnotes) {
                if (footnotes == null) {
                    throw new IllegalArgumentException("footnotes cannot be null");
                }
                if (this.footnotes == null) {
                    this.footnotes = new ArrayList();
                }
                this.footnotes.addAll(footnotes);
                return this;
            }

            public @NonNull Builder clearFootnotes() {
                if (this.footnotes != null) {
                    this.footnotes.clear();
                }
                return this;
            }

            @JsonProperty(value="image")
            public @NonNull Builder image(@Nullable ImageRef image) {
                this.image = image;
                return this;
            }

            @JsonProperty(value="data")
            public @NonNull Builder data(TableData data) {
                this.data = data;
                return this;
            }

            public @NonNull TableItem build() {
                return new TableItem(this.selfRef, this.parent, switch (this.children == null ? 0 : this.children.size()) {
                    case 0 -> Collections.emptyList();
                    case 1 -> Collections.singletonList(this.children.get(0));
                    default -> Collections.unmodifiableList(new ArrayList<RefItem>(this.children));
                }, this.contentLayer, this.meta, this.label, switch (this.prov == null ? 0 : this.prov.size()) {
                    case 0 -> Collections.emptyList();
                    case 1 -> Collections.singletonList(this.prov.get(0));
                    default -> Collections.unmodifiableList(new ArrayList<ProvenanceItem>(this.prov));
                }, switch (this.captions == null ? 0 : this.captions.size()) {
                    case 0 -> Collections.emptyList();
                    case 1 -> Collections.singletonList(this.captions.get(0));
                    default -> Collections.unmodifiableList(new ArrayList<RefItem>(this.captions));
                }, switch (this.references == null ? 0 : this.references.size()) {
                    case 0 -> Collections.emptyList();
                    case 1 -> Collections.singletonList(this.references.get(0));
                    default -> Collections.unmodifiableList(new ArrayList<RefItem>(this.references));
                }, switch (this.footnotes == null ? 0 : this.footnotes.size()) {
                    case 0 -> Collections.emptyList();
                    case 1 -> Collections.singletonList(this.footnotes.get(0));
                    default -> Collections.unmodifiableList(new ArrayList<RefItem>(this.footnotes));
                }, this.image, this.data);
            }

            public @NonNull String toString() {
                return "DoclingDocument.TableItem.Builder(selfRef=" + this.selfRef + ", parent=" + String.valueOf(this.parent) + ", children=" + String.valueOf(this.children) + ", contentLayer=" + String.valueOf((Object)this.contentLayer) + ", meta=" + String.valueOf(this.meta) + ", label=" + this.label + ", prov=" + String.valueOf(this.prov) + ", captions=" + String.valueOf(this.captions) + ", references=" + String.valueOf(this.references) + ", footnotes=" + String.valueOf(this.footnotes) + ", image=" + String.valueOf(this.image) + ", data=" + String.valueOf(this.data) + ")";
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonDeserialize(builder=Builder.class)
    @com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder=Builder.class)
    public static class Size {
        @JsonProperty(value="width")
        private final Double width;
        @JsonProperty(value="height")
        private final Double height;

        Size(Double width, Double height) {
            this.width = width;
            this.height = height;
        }

        public static @NonNull Builder builder() {
            return new Builder();
        }

        public @NonNull Builder toBuilder() {
            return new Builder().width(this.width).height(this.height);
        }

        public Double getWidth() {
            return this.width;
        }

        public Double getHeight() {
            return this.height;
        }

        public @NonNull String toString() {
            return "DoclingDocument.Size(width=" + this.getWidth() + ", height=" + this.getHeight() + ")";
        }

        @tools.jackson.databind.annotation.JsonPOJOBuilder(withPrefix="")
        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        public static class Builder {
            private Double width;
            private Double height;

            Builder() {
            }

            @JsonProperty(value="width")
            public @NonNull Builder width(Double width) {
                this.width = width;
                return this;
            }

            @JsonProperty(value="height")
            public @NonNull Builder height(Double height) {
                this.height = height;
                return this;
            }

            public @NonNull Size build() {
                return new Size(this.width, this.height);
            }

            public @NonNull String toString() {
                return "DoclingDocument.Size.Builder(width=" + this.width + ", height=" + this.height + ")";
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonDeserialize(builder=Builder.class)
    @com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder=Builder.class)
    public static class ImageRef {
        @JsonProperty(value="mimetype")
        private final String mimetype;
        @JsonProperty(value="dpi")
        private final Integer dpi;
        @JsonProperty(value="size")
        private final Size size;
        @JsonProperty(value="uri")
        private final String uri;

        ImageRef(String mimetype, Integer dpi, Size size, String uri) {
            this.mimetype = mimetype;
            this.dpi = dpi;
            this.size = size;
            this.uri = uri;
        }

        public static @NonNull Builder builder() {
            return new Builder();
        }

        public @NonNull Builder toBuilder() {
            return new Builder().mimetype(this.mimetype).dpi(this.dpi).size(this.size).uri(this.uri);
        }

        public String getMimetype() {
            return this.mimetype;
        }

        public Integer getDpi() {
            return this.dpi;
        }

        public Size getSize() {
            return this.size;
        }

        public String getUri() {
            return this.uri;
        }

        public @NonNull String toString() {
            return "DoclingDocument.ImageRef(mimetype=" + this.getMimetype() + ", dpi=" + this.getDpi() + ", size=" + String.valueOf(this.getSize()) + ", uri=" + this.getUri() + ")";
        }

        @tools.jackson.databind.annotation.JsonPOJOBuilder(withPrefix="")
        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        public static class Builder {
            private String mimetype;
            private Integer dpi;
            private Size size;
            private String uri;

            Builder() {
            }

            @JsonProperty(value="mimetype")
            public @NonNull Builder mimetype(String mimetype) {
                this.mimetype = mimetype;
                return this;
            }

            @JsonProperty(value="dpi")
            public @NonNull Builder dpi(Integer dpi) {
                this.dpi = dpi;
                return this;
            }

            @JsonProperty(value="size")
            public @NonNull Builder size(Size size) {
                this.size = size;
                return this;
            }

            @JsonProperty(value="uri")
            public @NonNull Builder uri(String uri) {
                this.uri = uri;
                return this;
            }

            public @NonNull ImageRef build() {
                return new ImageRef(this.mimetype, this.dpi, this.size, this.uri);
            }

            public @NonNull String toString() {
                return "DoclingDocument.ImageRef.Builder(mimetype=" + this.mimetype + ", dpi=" + this.dpi + ", size=" + String.valueOf(this.size) + ", uri=" + this.uri + ")";
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonDeserialize(builder=Builder.class)
    @com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder=Builder.class)
    public static class BoundingBox {
        @JsonProperty(value="l")
        private final Double l;
        @JsonProperty(value="t")
        private final Double t;
        @JsonProperty(value="r")
        private final Double r;
        @JsonProperty(value="b")
        private final Double b;
        @JsonProperty(value="coord_origin")
        private final @Nullable String coordOrigin;

        BoundingBox(Double l, Double t, Double r, Double b, @Nullable String coordOrigin) {
            this.l = l;
            this.t = t;
            this.r = r;
            this.b = b;
            this.coordOrigin = coordOrigin;
        }

        public static @NonNull Builder builder() {
            return new Builder();
        }

        public @NonNull Builder toBuilder() {
            return new Builder().l(this.l).t(this.t).r(this.r).b(this.b).coordOrigin(this.coordOrigin);
        }

        public Double getL() {
            return this.l;
        }

        public Double getT() {
            return this.t;
        }

        public Double getR() {
            return this.r;
        }

        public Double getB() {
            return this.b;
        }

        public @Nullable String getCoordOrigin() {
            return this.coordOrigin;
        }

        public @NonNull String toString() {
            return "DoclingDocument.BoundingBox(l=" + this.getL() + ", t=" + this.getT() + ", r=" + this.getR() + ", b=" + this.getB() + ", coordOrigin=" + this.getCoordOrigin() + ")";
        }

        @tools.jackson.databind.annotation.JsonPOJOBuilder(withPrefix="")
        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        public static class Builder {
            private Double l;
            private Double t;
            private Double r;
            private Double b;
            private String coordOrigin;

            Builder() {
            }

            @JsonProperty(value="l")
            public @NonNull Builder l(Double l) {
                this.l = l;
                return this;
            }

            @JsonProperty(value="t")
            public @NonNull Builder t(Double t) {
                this.t = t;
                return this;
            }

            @JsonProperty(value="r")
            public @NonNull Builder r(Double r) {
                this.r = r;
                return this;
            }

            @JsonProperty(value="b")
            public @NonNull Builder b(Double b) {
                this.b = b;
                return this;
            }

            @JsonProperty(value="coord_origin")
            public @NonNull Builder coordOrigin(@Nullable String coordOrigin) {
                this.coordOrigin = coordOrigin;
                return this;
            }

            public @NonNull BoundingBox build() {
                return new BoundingBox(this.l, this.t, this.r, this.b, this.coordOrigin);
            }

            public @NonNull String toString() {
                return "DoclingDocument.BoundingBox.Builder(l=" + this.l + ", t=" + this.t + ", r=" + this.r + ", b=" + this.b + ", coordOrigin=" + this.coordOrigin + ")";
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonDeserialize(builder=Builder.class)
    @com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder=Builder.class)
    public static class ProvenanceItem {
        @JsonProperty(value="page_no")
        private final Integer pageNo;
        @JsonProperty(value="bbox")
        private final BoundingBox bbox;
        @JsonProperty(value="charspan")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        private final List<Integer> charspan;

        ProvenanceItem(Integer pageNo, BoundingBox bbox, List<Integer> charspan) {
            this.pageNo = pageNo;
            this.bbox = bbox;
            this.charspan = charspan;
        }

        public static @NonNull Builder builder() {
            return new Builder();
        }

        public @NonNull Builder toBuilder() {
            Builder builder = new Builder().pageNo(this.pageNo).bbox(this.bbox);
            if (this.charspan != null) {
                builder.charspan(this.charspan);
            }
            return builder;
        }

        public Integer getPageNo() {
            return this.pageNo;
        }

        public BoundingBox getBbox() {
            return this.bbox;
        }

        public List<Integer> getCharspan() {
            return this.charspan;
        }

        public @NonNull String toString() {
            return "DoclingDocument.ProvenanceItem(pageNo=" + this.getPageNo() + ", bbox=" + String.valueOf(this.getBbox()) + ", charspan=" + String.valueOf(this.getCharspan()) + ")";
        }

        @tools.jackson.databind.annotation.JsonPOJOBuilder(withPrefix="")
        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        public static class Builder {
            private Integer pageNo;
            private BoundingBox bbox;
            private ArrayList<Integer> charspan;

            Builder() {
            }

            @JsonProperty(value="page_no")
            public @NonNull Builder pageNo(Integer pageNo) {
                this.pageNo = pageNo;
                return this;
            }

            @JsonProperty(value="bbox")
            public @NonNull Builder bbox(BoundingBox bbox) {
                this.bbox = bbox;
                return this;
            }

            public @NonNull Builder charspan(Integer charspan) {
                if (this.charspan == null) {
                    this.charspan = new ArrayList();
                }
                this.charspan.add(charspan);
                return this;
            }

            @JsonProperty(value="charspan")
            @JsonSetter(nulls=Nulls.AS_EMPTY)
            public @NonNull Builder charspan(@NonNull Collection<? extends Integer> charspan) {
                if (charspan == null) {
                    throw new IllegalArgumentException("charspan cannot be null");
                }
                if (this.charspan == null) {
                    this.charspan = new ArrayList();
                }
                this.charspan.addAll(charspan);
                return this;
            }

            public @NonNull Builder clearCharspan() {
                if (this.charspan != null) {
                    this.charspan.clear();
                }
                return this;
            }

            public @NonNull ProvenanceItem build() {
                return new ProvenanceItem(this.pageNo, this.bbox, switch (this.charspan == null ? 0 : this.charspan.size()) {
                    case 0 -> Collections.emptyList();
                    case 1 -> Collections.singletonList(this.charspan.get(0));
                    default -> Collections.unmodifiableList(new ArrayList<Integer>(this.charspan));
                });
            }

            public @NonNull String toString() {
                return "DoclingDocument.ProvenanceItem.Builder(pageNo=" + this.pageNo + ", bbox=" + String.valueOf(this.bbox) + ", charspan=" + String.valueOf(this.charspan) + ")";
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonDeserialize(builder=Builder.class)
    @com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder=Builder.class)
    public static class TabularChartMetaField {
        @JsonProperty(value="confidence")
        private final @Nullable Double confidence;
        @JsonProperty(value="created_by")
        private final @Nullable String createdBy;
        @JsonProperty(value="title")
        private final @Nullable String title;
        @JsonProperty(value="chart_data")
        private final TableData chartData;

        TabularChartMetaField(@Nullable Double confidence, @Nullable String createdBy, @Nullable String title, TableData chartData) {
            this.confidence = confidence;
            this.createdBy = createdBy;
            this.title = title;
            this.chartData = chartData;
        }

        public static @NonNull Builder builder() {
            return new Builder();
        }

        public @NonNull Builder toBuilder() {
            return new Builder().confidence(this.confidence).createdBy(this.createdBy).title(this.title).chartData(this.chartData);
        }

        public @Nullable Double getConfidence() {
            return this.confidence;
        }

        public @Nullable String getCreatedBy() {
            return this.createdBy;
        }

        public @Nullable String getTitle() {
            return this.title;
        }

        public TableData getChartData() {
            return this.chartData;
        }

        public @NonNull String toString() {
            return "DoclingDocument.TabularChartMetaField(confidence=" + this.getConfidence() + ", createdBy=" + this.getCreatedBy() + ", title=" + this.getTitle() + ", chartData=" + String.valueOf(this.getChartData()) + ")";
        }

        @tools.jackson.databind.annotation.JsonPOJOBuilder(withPrefix="")
        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        public static class Builder {
            private Double confidence;
            private String createdBy;
            private String title;
            private TableData chartData;

            Builder() {
            }

            @JsonProperty(value="confidence")
            public @NonNull Builder confidence(@Nullable Double confidence) {
                this.confidence = confidence;
                return this;
            }

            @JsonProperty(value="created_by")
            public @NonNull Builder createdBy(@Nullable String createdBy) {
                this.createdBy = createdBy;
                return this;
            }

            @JsonProperty(value="title")
            public @NonNull Builder title(@Nullable String title) {
                this.title = title;
                return this;
            }

            @JsonProperty(value="chart_data")
            public @NonNull Builder chartData(TableData chartData) {
                this.chartData = chartData;
                return this;
            }

            public @NonNull TabularChartMetaField build() {
                return new TabularChartMetaField(this.confidence, this.createdBy, this.title, this.chartData);
            }

            public @NonNull String toString() {
                return "DoclingDocument.TabularChartMetaField.Builder(confidence=" + this.confidence + ", createdBy=" + this.createdBy + ", title=" + this.title + ", chartData=" + String.valueOf(this.chartData) + ")";
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonDeserialize(builder=Builder.class)
    @com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder=Builder.class)
    public static class MoleculeMetaField {
        @JsonProperty(value="confidence")
        private final @Nullable Double confidence;
        @JsonProperty(value="created_by")
        private final @Nullable String createdBy;
        @JsonProperty(value="smi")
        private final String smi;

        MoleculeMetaField(@Nullable Double confidence, @Nullable String createdBy, String smi) {
            this.confidence = confidence;
            this.createdBy = createdBy;
            this.smi = smi;
        }

        public static @NonNull Builder builder() {
            return new Builder();
        }

        public @NonNull Builder toBuilder() {
            return new Builder().confidence(this.confidence).createdBy(this.createdBy).smi(this.smi);
        }

        public @Nullable Double getConfidence() {
            return this.confidence;
        }

        public @Nullable String getCreatedBy() {
            return this.createdBy;
        }

        public String getSmi() {
            return this.smi;
        }

        public @NonNull String toString() {
            return "DoclingDocument.MoleculeMetaField(confidence=" + this.getConfidence() + ", createdBy=" + this.getCreatedBy() + ", smi=" + this.getSmi() + ")";
        }

        @tools.jackson.databind.annotation.JsonPOJOBuilder(withPrefix="")
        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        public static class Builder {
            private Double confidence;
            private String createdBy;
            private String smi;

            Builder() {
            }

            @JsonProperty(value="confidence")
            public @NonNull Builder confidence(@Nullable Double confidence) {
                this.confidence = confidence;
                return this;
            }

            @JsonProperty(value="created_by")
            public @NonNull Builder createdBy(@Nullable String createdBy) {
                this.createdBy = createdBy;
                return this;
            }

            @JsonProperty(value="smi")
            public @NonNull Builder smi(String smi) {
                this.smi = smi;
                return this;
            }

            public @NonNull MoleculeMetaField build() {
                return new MoleculeMetaField(this.confidence, this.createdBy, this.smi);
            }

            public @NonNull String toString() {
                return "DoclingDocument.MoleculeMetaField.Builder(confidence=" + this.confidence + ", createdBy=" + this.createdBy + ", smi=" + this.smi + ")";
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonDeserialize(builder=Builder.class)
    @com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder=Builder.class)
    public static class PictureClassificationPrediction {
        @JsonProperty(value="confidence")
        private final @Nullable Double confidence;
        @JsonProperty(value="created_by")
        private final @Nullable String createdBy;
        @JsonProperty(value="class_name")
        private final String className;

        PictureClassificationPrediction(@Nullable Double confidence, @Nullable String createdBy, String className) {
            this.confidence = confidence;
            this.createdBy = createdBy;
            this.className = className;
        }

        public static @NonNull Builder builder() {
            return new Builder();
        }

        public @NonNull Builder toBuilder() {
            return new Builder().confidence(this.confidence).createdBy(this.createdBy).className(this.className);
        }

        public @Nullable Double getConfidence() {
            return this.confidence;
        }

        public @Nullable String getCreatedBy() {
            return this.createdBy;
        }

        public String getClassName() {
            return this.className;
        }

        public @NonNull String toString() {
            return "DoclingDocument.PictureClassificationPrediction(confidence=" + this.getConfidence() + ", createdBy=" + this.getCreatedBy() + ", className=" + this.getClassName() + ")";
        }

        @tools.jackson.databind.annotation.JsonPOJOBuilder(withPrefix="")
        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        public static class Builder {
            private Double confidence;
            private String createdBy;
            private String className;

            Builder() {
            }

            @JsonProperty(value="confidence")
            public @NonNull Builder confidence(@Nullable Double confidence) {
                this.confidence = confidence;
                return this;
            }

            @JsonProperty(value="created_by")
            public @NonNull Builder createdBy(@Nullable String createdBy) {
                this.createdBy = createdBy;
                return this;
            }

            @JsonProperty(value="class_name")
            public @NonNull Builder className(String className) {
                this.className = className;
                return this;
            }

            public @NonNull PictureClassificationPrediction build() {
                return new PictureClassificationPrediction(this.confidence, this.createdBy, this.className);
            }

            public @NonNull String toString() {
                return "DoclingDocument.PictureClassificationPrediction.Builder(confidence=" + this.confidence + ", createdBy=" + this.createdBy + ", className=" + this.className + ")";
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonDeserialize(builder=Builder.class)
    @com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder=Builder.class)
    public static class PictureClassificationMetaField {
        @JsonProperty(value="predictions")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        private final List<PictureClassificationPrediction> predictions;

        PictureClassificationMetaField(List<PictureClassificationPrediction> predictions) {
            this.predictions = predictions;
        }

        public static @NonNull Builder builder() {
            return new Builder();
        }

        public @NonNull Builder toBuilder() {
            Builder builder = new Builder();
            if (this.predictions != null) {
                builder.predictions(this.predictions);
            }
            return builder;
        }

        public List<PictureClassificationPrediction> getPredictions() {
            return this.predictions;
        }

        public @NonNull String toString() {
            return "DoclingDocument.PictureClassificationMetaField(predictions=" + String.valueOf(this.getPredictions()) + ")";
        }

        @tools.jackson.databind.annotation.JsonPOJOBuilder(withPrefix="")
        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        public static class Builder {
            private ArrayList<PictureClassificationPrediction> predictions;

            Builder() {
            }

            public @NonNull Builder prediction(PictureClassificationPrediction prediction) {
                if (this.predictions == null) {
                    this.predictions = new ArrayList();
                }
                this.predictions.add(prediction);
                return this;
            }

            @JsonProperty(value="predictions")
            @JsonSetter(nulls=Nulls.AS_EMPTY)
            public @NonNull Builder predictions(@NonNull Collection<? extends PictureClassificationPrediction> predictions) {
                if (predictions == null) {
                    throw new IllegalArgumentException("predictions cannot be null");
                }
                if (this.predictions == null) {
                    this.predictions = new ArrayList();
                }
                this.predictions.addAll(predictions);
                return this;
            }

            public @NonNull Builder clearPredictions() {
                if (this.predictions != null) {
                    this.predictions.clear();
                }
                return this;
            }

            public @NonNull PictureClassificationMetaField build() {
                return new PictureClassificationMetaField(switch (this.predictions == null ? 0 : this.predictions.size()) {
                    case 0 -> Collections.emptyList();
                    case 1 -> Collections.singletonList(this.predictions.get(0));
                    default -> Collections.unmodifiableList(new ArrayList<PictureClassificationPrediction>(this.predictions));
                });
            }

            public @NonNull String toString() {
                return "DoclingDocument.PictureClassificationMetaField.Builder(predictions=" + String.valueOf(this.predictions) + ")";
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonDeserialize(builder=Builder.class)
    @com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder=Builder.class)
    public static class DescriptionMetaField {
        @JsonProperty(value="confidence")
        private final @Nullable Double confidence;
        @JsonProperty(value="created_by")
        private final @Nullable String createdBy;
        @JsonProperty(value="text")
        private final String text;

        DescriptionMetaField(@Nullable Double confidence, @Nullable String createdBy, String text) {
            this.confidence = confidence;
            this.createdBy = createdBy;
            this.text = text;
        }

        public static @NonNull Builder builder() {
            return new Builder();
        }

        public @NonNull Builder toBuilder() {
            return new Builder().confidence(this.confidence).createdBy(this.createdBy).text(this.text);
        }

        public @Nullable Double getConfidence() {
            return this.confidence;
        }

        public @Nullable String getCreatedBy() {
            return this.createdBy;
        }

        public String getText() {
            return this.text;
        }

        public @NonNull String toString() {
            return "DoclingDocument.DescriptionMetaField(confidence=" + this.getConfidence() + ", createdBy=" + this.getCreatedBy() + ", text=" + this.getText() + ")";
        }

        @tools.jackson.databind.annotation.JsonPOJOBuilder(withPrefix="")
        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        public static class Builder {
            private Double confidence;
            private String createdBy;
            private String text;

            Builder() {
            }

            @JsonProperty(value="confidence")
            public @NonNull Builder confidence(@Nullable Double confidence) {
                this.confidence = confidence;
                return this;
            }

            @JsonProperty(value="created_by")
            public @NonNull Builder createdBy(@Nullable String createdBy) {
                this.createdBy = createdBy;
                return this;
            }

            @JsonProperty(value="text")
            public @NonNull Builder text(String text) {
                this.text = text;
                return this;
            }

            public @NonNull DescriptionMetaField build() {
                return new DescriptionMetaField(this.confidence, this.createdBy, this.text);
            }

            public @NonNull String toString() {
                return "DoclingDocument.DescriptionMetaField.Builder(confidence=" + this.confidence + ", createdBy=" + this.createdBy + ", text=" + this.text + ")";
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonDeserialize(builder=Builder.class)
    @com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder=Builder.class)
    public static class PictureMeta {
        @JsonProperty(value="summary")
        private final @Nullable SummaryMetaField summary;
        @JsonProperty(value="description")
        private final @Nullable DescriptionMetaField description;
        @JsonProperty(value="classification")
        private final @Nullable PictureClassificationMetaField classification;
        @JsonProperty(value="molecule")
        private final @Nullable MoleculeMetaField molecule;
        @JsonProperty(value="tabular_chart")
        private final @Nullable TabularChartMetaField tabularChart;

        PictureMeta(@Nullable SummaryMetaField summary, @Nullable DescriptionMetaField description, @Nullable PictureClassificationMetaField classification, @Nullable MoleculeMetaField molecule, @Nullable TabularChartMetaField tabularChart) {
            this.summary = summary;
            this.description = description;
            this.classification = classification;
            this.molecule = molecule;
            this.tabularChart = tabularChart;
        }

        public static @NonNull Builder builder() {
            return new Builder();
        }

        public @NonNull Builder toBuilder() {
            return new Builder().summary(this.summary).description(this.description).classification(this.classification).molecule(this.molecule).tabularChart(this.tabularChart);
        }

        public @Nullable SummaryMetaField getSummary() {
            return this.summary;
        }

        public @Nullable DescriptionMetaField getDescription() {
            return this.description;
        }

        public @Nullable PictureClassificationMetaField getClassification() {
            return this.classification;
        }

        public @Nullable MoleculeMetaField getMolecule() {
            return this.molecule;
        }

        public @Nullable TabularChartMetaField getTabularChart() {
            return this.tabularChart;
        }

        public @NonNull String toString() {
            return "DoclingDocument.PictureMeta(summary=" + String.valueOf(this.getSummary()) + ", description=" + String.valueOf(this.getDescription()) + ", classification=" + String.valueOf(this.getClassification()) + ", molecule=" + String.valueOf(this.getMolecule()) + ", tabularChart=" + String.valueOf(this.getTabularChart()) + ")";
        }

        @tools.jackson.databind.annotation.JsonPOJOBuilder(withPrefix="")
        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        public static class Builder {
            private SummaryMetaField summary;
            private DescriptionMetaField description;
            private PictureClassificationMetaField classification;
            private MoleculeMetaField molecule;
            private TabularChartMetaField tabularChart;

            Builder() {
            }

            @JsonProperty(value="summary")
            public @NonNull Builder summary(@Nullable SummaryMetaField summary) {
                this.summary = summary;
                return this;
            }

            @JsonProperty(value="description")
            public @NonNull Builder description(@Nullable DescriptionMetaField description) {
                this.description = description;
                return this;
            }

            @JsonProperty(value="classification")
            public @NonNull Builder classification(@Nullable PictureClassificationMetaField classification) {
                this.classification = classification;
                return this;
            }

            @JsonProperty(value="molecule")
            public @NonNull Builder molecule(@Nullable MoleculeMetaField molecule) {
                this.molecule = molecule;
                return this;
            }

            @JsonProperty(value="tabular_chart")
            public @NonNull Builder tabularChart(@Nullable TabularChartMetaField tabularChart) {
                this.tabularChart = tabularChart;
                return this;
            }

            public @NonNull PictureMeta build() {
                return new PictureMeta(this.summary, this.description, this.classification, this.molecule, this.tabularChart);
            }

            public @NonNull String toString() {
                return "DoclingDocument.PictureMeta.Builder(summary=" + String.valueOf(this.summary) + ", description=" + String.valueOf(this.description) + ", classification=" + String.valueOf(this.classification) + ", molecule=" + String.valueOf(this.molecule) + ", tabularChart=" + String.valueOf(this.tabularChart) + ")";
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonDeserialize(builder=Builder.class)
    @com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder=Builder.class)
    public static class PictureItem {
        @JsonProperty(value="self_ref")
        private final @Nullable String selfRef;
        @JsonProperty(value="parent")
        private final RefItem parent;
        @JsonProperty(value="children")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        private final List<RefItem> children;
        @JsonProperty(value="content_layer")
        private final ContentLayer contentLayer;
        @JsonProperty(value="meta")
        private final @Nullable PictureMeta meta;
        @JsonProperty(value="label")
        private final String label;
        @JsonProperty(value="prov")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        private final List<ProvenanceItem> prov;
        @JsonProperty(value="captions")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        private final List<RefItem> captions;
        @JsonProperty(value="references")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        private final List<RefItem> references;
        @JsonProperty(value="footnotes")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        private final List<RefItem> footnotes;
        @JsonProperty(value="image")
        private final @Nullable ImageRef image;

        PictureItem(@Nullable String selfRef, RefItem parent, List<RefItem> children, ContentLayer contentLayer, @Nullable PictureMeta meta, String label, List<ProvenanceItem> prov, List<RefItem> captions, List<RefItem> references, List<RefItem> footnotes, @Nullable ImageRef image) {
            this.selfRef = selfRef;
            this.parent = parent;
            this.children = children;
            this.contentLayer = contentLayer;
            this.meta = meta;
            this.label = label;
            this.prov = prov;
            this.captions = captions;
            this.references = references;
            this.footnotes = footnotes;
            this.image = image;
        }

        public static @NonNull Builder builder() {
            return new Builder();
        }

        public @NonNull Builder toBuilder() {
            Builder builder = new Builder().selfRef(this.selfRef).parent(this.parent).contentLayer(this.contentLayer).meta(this.meta).label(this.label).captions(this.captions).references(this.references).footnotes(this.footnotes).image(this.image);
            if (this.children != null) {
                builder.children(this.children);
            }
            if (this.prov != null) {
                builder.prov(this.prov);
            }
            return builder;
        }

        public @Nullable String getSelfRef() {
            return this.selfRef;
        }

        public RefItem getParent() {
            return this.parent;
        }

        public List<RefItem> getChildren() {
            return this.children;
        }

        public ContentLayer getContentLayer() {
            return this.contentLayer;
        }

        public @Nullable PictureMeta getMeta() {
            return this.meta;
        }

        public String getLabel() {
            return this.label;
        }

        public List<ProvenanceItem> getProv() {
            return this.prov;
        }

        public List<RefItem> getCaptions() {
            return this.captions;
        }

        public List<RefItem> getReferences() {
            return this.references;
        }

        public List<RefItem> getFootnotes() {
            return this.footnotes;
        }

        public @Nullable ImageRef getImage() {
            return this.image;
        }

        public @NonNull String toString() {
            return "DoclingDocument.PictureItem(selfRef=" + this.getSelfRef() + ", parent=" + String.valueOf(this.getParent()) + ", children=" + String.valueOf(this.getChildren()) + ", contentLayer=" + String.valueOf((Object)this.getContentLayer()) + ", meta=" + String.valueOf(this.getMeta()) + ", label=" + this.getLabel() + ", prov=" + String.valueOf(this.getProv()) + ", captions=" + String.valueOf(this.getCaptions()) + ", references=" + String.valueOf(this.getReferences()) + ", footnotes=" + String.valueOf(this.getFootnotes()) + ", image=" + String.valueOf(this.getImage()) + ")";
        }

        @tools.jackson.databind.annotation.JsonPOJOBuilder(withPrefix="")
        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        public static class Builder {
            private String selfRef;
            private RefItem parent;
            private ArrayList<RefItem> children;
            private ContentLayer contentLayer;
            private PictureMeta meta;
            private String label;
            private ArrayList<ProvenanceItem> prov;
            private List<RefItem> captions;
            private List<RefItem> references;
            private List<RefItem> footnotes;
            private ImageRef image;

            Builder() {
            }

            @JsonProperty(value="self_ref")
            public @NonNull Builder selfRef(@Nullable String selfRef) {
                this.selfRef = selfRef;
                return this;
            }

            @JsonProperty(value="parent")
            public @NonNull Builder parent(RefItem parent) {
                this.parent = parent;
                return this;
            }

            public @NonNull Builder child(RefItem child) {
                if (this.children == null) {
                    this.children = new ArrayList();
                }
                this.children.add(child);
                return this;
            }

            @JsonProperty(value="children")
            @JsonSetter(nulls=Nulls.AS_EMPTY)
            public @NonNull Builder children(@NonNull Collection<? extends RefItem> children) {
                if (children == null) {
                    throw new IllegalArgumentException("children cannot be null");
                }
                if (this.children == null) {
                    this.children = new ArrayList();
                }
                this.children.addAll(children);
                return this;
            }

            public @NonNull Builder clearChildren() {
                if (this.children != null) {
                    this.children.clear();
                }
                return this;
            }

            @JsonProperty(value="content_layer")
            public @NonNull Builder contentLayer(ContentLayer contentLayer) {
                this.contentLayer = contentLayer;
                return this;
            }

            @JsonProperty(value="meta")
            public @NonNull Builder meta(@Nullable PictureMeta meta) {
                this.meta = meta;
                return this;
            }

            @JsonProperty(value="label")
            public @NonNull Builder label(String label) {
                this.label = label;
                return this;
            }

            public @NonNull Builder prov(ProvenanceItem prov) {
                if (this.prov == null) {
                    this.prov = new ArrayList();
                }
                this.prov.add(prov);
                return this;
            }

            @JsonProperty(value="prov")
            @JsonSetter(nulls=Nulls.AS_EMPTY)
            public @NonNull Builder prov(@NonNull Collection<? extends ProvenanceItem> prov) {
                if (prov == null) {
                    throw new IllegalArgumentException("prov cannot be null");
                }
                if (this.prov == null) {
                    this.prov = new ArrayList();
                }
                this.prov.addAll(prov);
                return this;
            }

            public @NonNull Builder clearProv() {
                if (this.prov != null) {
                    this.prov.clear();
                }
                return this;
            }

            @JsonProperty(value="captions")
            @JsonSetter(nulls=Nulls.AS_EMPTY)
            public @NonNull Builder captions(List<RefItem> captions) {
                this.captions = captions;
                return this;
            }

            @JsonProperty(value="references")
            @JsonSetter(nulls=Nulls.AS_EMPTY)
            public @NonNull Builder references(List<RefItem> references) {
                this.references = references;
                return this;
            }

            @JsonProperty(value="footnotes")
            @JsonSetter(nulls=Nulls.AS_EMPTY)
            public @NonNull Builder footnotes(List<RefItem> footnotes) {
                this.footnotes = footnotes;
                return this;
            }

            @JsonProperty(value="image")
            public @NonNull Builder image(@Nullable ImageRef image) {
                this.image = image;
                return this;
            }

            public @NonNull PictureItem build() {
                return new PictureItem(this.selfRef, this.parent, switch (this.children == null ? 0 : this.children.size()) {
                    case 0 -> Collections.emptyList();
                    case 1 -> Collections.singletonList(this.children.get(0));
                    default -> Collections.unmodifiableList(new ArrayList<RefItem>(this.children));
                }, this.contentLayer, this.meta, this.label, switch (this.prov == null ? 0 : this.prov.size()) {
                    case 0 -> Collections.emptyList();
                    case 1 -> Collections.singletonList(this.prov.get(0));
                    default -> Collections.unmodifiableList(new ArrayList<ProvenanceItem>(this.prov));
                }, this.captions, this.references, this.footnotes, this.image);
            }

            public @NonNull String toString() {
                return "DoclingDocument.PictureItem.Builder(selfRef=" + this.selfRef + ", parent=" + String.valueOf(this.parent) + ", children=" + String.valueOf(this.children) + ", contentLayer=" + String.valueOf((Object)this.contentLayer) + ", meta=" + String.valueOf(this.meta) + ", label=" + this.label + ", prov=" + String.valueOf(this.prov) + ", captions=" + String.valueOf(this.captions) + ", references=" + String.valueOf(this.references) + ", footnotes=" + String.valueOf(this.footnotes) + ", image=" + String.valueOf(this.image) + ")";
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonDeserialize(builder=Builder.class)
    @com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder=Builder.class)
    public static final class TextItem
    implements BaseTextItem {
        @JsonProperty(value="self_ref")
        private final String selfRef;
        @JsonProperty(value="parent")
        private final @Nullable RefItem parent;
        @JsonProperty(value="children")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        private final List<RefItem> children;
        @JsonProperty(value="content_layer")
        private final ContentLayer contentLayer;
        @JsonProperty(value="meta")
        private final @Nullable BaseMeta meta;
        @JsonProperty(value="label")
        private final DocItemLabel label;
        @JsonProperty(value="prov")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        private final List<ProvenanceItem> prov;
        @JsonProperty(value="orig")
        private final String orig;
        @JsonProperty(value="text")
        private final String text;
        @JsonProperty(value="formatting")
        private final @Nullable Formatting formatting;
        @JsonProperty(value="hyperlink")
        private final @Nullable String hyperlink;

        TextItem(String selfRef, @Nullable RefItem parent, List<RefItem> children, ContentLayer contentLayer, @Nullable BaseMeta meta, DocItemLabel label, List<ProvenanceItem> prov, String orig, String text, @Nullable Formatting formatting, @Nullable String hyperlink) {
            this.selfRef = selfRef;
            this.parent = parent;
            this.children = children;
            this.contentLayer = contentLayer;
            this.meta = meta;
            this.label = label;
            this.prov = prov;
            this.orig = orig;
            this.text = text;
            this.formatting = formatting;
            this.hyperlink = hyperlink;
        }

        public static @NonNull Builder builder() {
            return new Builder();
        }

        public @NonNull Builder toBuilder() {
            Builder builder = new Builder().selfRef(this.selfRef).parent(this.parent).contentLayer(this.contentLayer).meta(this.meta).label(this.label).orig(this.orig).text(this.text).formatting(this.formatting).hyperlink(this.hyperlink);
            if (this.children != null) {
                builder.children(this.children);
            }
            if (this.prov != null) {
                builder.prov(this.prov);
            }
            return builder;
        }

        @Override
        public String getSelfRef() {
            return this.selfRef;
        }

        @Override
        public @Nullable RefItem getParent() {
            return this.parent;
        }

        @Override
        public List<RefItem> getChildren() {
            return this.children;
        }

        @Override
        public ContentLayer getContentLayer() {
            return this.contentLayer;
        }

        public @Nullable BaseMeta getMeta() {
            return this.meta;
        }

        @Override
        public DocItemLabel getLabel() {
            return this.label;
        }

        @Override
        public List<ProvenanceItem> getProv() {
            return this.prov;
        }

        @Override
        public String getOrig() {
            return this.orig;
        }

        @Override
        public String getText() {
            return this.text;
        }

        @Override
        public @Nullable Formatting getFormatting() {
            return this.formatting;
        }

        @Override
        public @Nullable String getHyperlink() {
            return this.hyperlink;
        }

        public @NonNull String toString() {
            return "DoclingDocument.TextItem(selfRef=" + this.getSelfRef() + ", parent=" + String.valueOf(this.getParent()) + ", children=" + String.valueOf(this.getChildren()) + ", contentLayer=" + String.valueOf((Object)this.getContentLayer()) + ", meta=" + String.valueOf(this.getMeta()) + ", label=" + String.valueOf((Object)this.getLabel()) + ", prov=" + String.valueOf(this.getProv()) + ", orig=" + this.getOrig() + ", text=" + this.getText() + ", formatting=" + String.valueOf(this.getFormatting()) + ", hyperlink=" + this.getHyperlink() + ")";
        }

        @tools.jackson.databind.annotation.JsonPOJOBuilder(withPrefix="")
        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        public static class Builder {
            private String selfRef;
            private RefItem parent;
            private ArrayList<RefItem> children;
            private ContentLayer contentLayer;
            private BaseMeta meta;
            private DocItemLabel label;
            private ArrayList<ProvenanceItem> prov;
            private String orig;
            private String text;
            private Formatting formatting;
            private String hyperlink;

            Builder() {
            }

            @JsonProperty(value="self_ref")
            public @NonNull Builder selfRef(String selfRef) {
                this.selfRef = selfRef;
                return this;
            }

            @JsonProperty(value="parent")
            public @NonNull Builder parent(@Nullable RefItem parent) {
                this.parent = parent;
                return this;
            }

            public @NonNull Builder child(RefItem child) {
                if (this.children == null) {
                    this.children = new ArrayList();
                }
                this.children.add(child);
                return this;
            }

            @JsonProperty(value="children")
            @JsonSetter(nulls=Nulls.AS_EMPTY)
            public @NonNull Builder children(@NonNull Collection<? extends RefItem> children) {
                if (children == null) {
                    throw new IllegalArgumentException("children cannot be null");
                }
                if (this.children == null) {
                    this.children = new ArrayList();
                }
                this.children.addAll(children);
                return this;
            }

            public @NonNull Builder clearChildren() {
                if (this.children != null) {
                    this.children.clear();
                }
                return this;
            }

            @JsonProperty(value="content_layer")
            public @NonNull Builder contentLayer(ContentLayer contentLayer) {
                this.contentLayer = contentLayer;
                return this;
            }

            @JsonProperty(value="meta")
            public @NonNull Builder meta(@Nullable BaseMeta meta) {
                this.meta = meta;
                return this;
            }

            @JsonProperty(value="label")
            public @NonNull Builder label(DocItemLabel label) {
                this.label = label;
                return this;
            }

            public @NonNull Builder prov(ProvenanceItem prov) {
                if (this.prov == null) {
                    this.prov = new ArrayList();
                }
                this.prov.add(prov);
                return this;
            }

            @JsonProperty(value="prov")
            @JsonSetter(nulls=Nulls.AS_EMPTY)
            public @NonNull Builder prov(@NonNull Collection<? extends ProvenanceItem> prov) {
                if (prov == null) {
                    throw new IllegalArgumentException("prov cannot be null");
                }
                if (this.prov == null) {
                    this.prov = new ArrayList();
                }
                this.prov.addAll(prov);
                return this;
            }

            public @NonNull Builder clearProv() {
                if (this.prov != null) {
                    this.prov.clear();
                }
                return this;
            }

            @JsonProperty(value="orig")
            public @NonNull Builder orig(String orig) {
                this.orig = orig;
                return this;
            }

            @JsonProperty(value="text")
            public @NonNull Builder text(String text) {
                this.text = text;
                return this;
            }

            @JsonProperty(value="formatting")
            public @NonNull Builder formatting(@Nullable Formatting formatting) {
                this.formatting = formatting;
                return this;
            }

            @JsonProperty(value="hyperlink")
            public @NonNull Builder hyperlink(@Nullable String hyperlink) {
                this.hyperlink = hyperlink;
                return this;
            }

            public @NonNull TextItem build() {
                return new TextItem(this.selfRef, this.parent, switch (this.children == null ? 0 : this.children.size()) {
                    case 0 -> Collections.emptyList();
                    case 1 -> Collections.singletonList(this.children.get(0));
                    default -> Collections.unmodifiableList(new ArrayList<RefItem>(this.children));
                }, this.contentLayer, this.meta, this.label, switch (this.prov == null ? 0 : this.prov.size()) {
                    case 0 -> Collections.emptyList();
                    case 1 -> Collections.singletonList(this.prov.get(0));
                    default -> Collections.unmodifiableList(new ArrayList<ProvenanceItem>(this.prov));
                }, this.orig, this.text, this.formatting, this.hyperlink);
            }

            public @NonNull String toString() {
                return "DoclingDocument.TextItem.Builder(selfRef=" + this.selfRef + ", parent=" + String.valueOf(this.parent) + ", children=" + String.valueOf(this.children) + ", contentLayer=" + String.valueOf((Object)this.contentLayer) + ", meta=" + String.valueOf(this.meta) + ", label=" + String.valueOf((Object)this.label) + ", prov=" + String.valueOf(this.prov) + ", orig=" + this.orig + ", text=" + this.text + ", formatting=" + String.valueOf(this.formatting) + ", hyperlink=" + this.hyperlink + ")";
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonDeserialize(builder=Builder.class)
    @com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder=Builder.class)
    public static final class FormulaItem
    implements BaseTextItem {
        @JsonProperty(value="self_ref")
        private final String selfRef;
        @JsonProperty(value="parent")
        private final @Nullable RefItem parent;
        @JsonProperty(value="children")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        private final List<RefItem> children;
        @JsonProperty(value="content_layer")
        private final ContentLayer contentLayer;
        @JsonProperty(value="meta")
        private final @Nullable BaseMeta meta;
        @JsonProperty(value="label")
        private final DocItemLabel label;
        @JsonProperty(value="prov")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        private final List<ProvenanceItem> prov;
        @JsonProperty(value="orig")
        private final String orig;
        @JsonProperty(value="text")
        private final String text;
        @JsonProperty(value="formatting")
        private final @Nullable Formatting formatting;
        @JsonProperty(value="hyperlink")
        private final @Nullable String hyperlink;

        FormulaItem(String selfRef, @Nullable RefItem parent, List<RefItem> children, ContentLayer contentLayer, @Nullable BaseMeta meta, DocItemLabel label, List<ProvenanceItem> prov, String orig, String text, @Nullable Formatting formatting, @Nullable String hyperlink) {
            this.selfRef = selfRef;
            this.parent = parent;
            this.children = children;
            this.contentLayer = contentLayer;
            this.meta = meta;
            this.label = label;
            this.prov = prov;
            this.orig = orig;
            this.text = text;
            this.formatting = formatting;
            this.hyperlink = hyperlink;
        }

        public static @NonNull Builder builder() {
            return new Builder();
        }

        public @NonNull Builder toBuilder() {
            Builder builder = new Builder().selfRef(this.selfRef).parent(this.parent).contentLayer(this.contentLayer).meta(this.meta).label(this.label).orig(this.orig).text(this.text).formatting(this.formatting).hyperlink(this.hyperlink);
            if (this.children != null) {
                builder.children(this.children);
            }
            if (this.prov != null) {
                builder.prov(this.prov);
            }
            return builder;
        }

        @Override
        public String getSelfRef() {
            return this.selfRef;
        }

        @Override
        public @Nullable RefItem getParent() {
            return this.parent;
        }

        @Override
        public List<RefItem> getChildren() {
            return this.children;
        }

        @Override
        public ContentLayer getContentLayer() {
            return this.contentLayer;
        }

        public @Nullable BaseMeta getMeta() {
            return this.meta;
        }

        @Override
        public DocItemLabel getLabel() {
            return this.label;
        }

        @Override
        public List<ProvenanceItem> getProv() {
            return this.prov;
        }

        @Override
        public String getOrig() {
            return this.orig;
        }

        @Override
        public String getText() {
            return this.text;
        }

        @Override
        public @Nullable Formatting getFormatting() {
            return this.formatting;
        }

        @Override
        public @Nullable String getHyperlink() {
            return this.hyperlink;
        }

        public @NonNull String toString() {
            return "DoclingDocument.FormulaItem(selfRef=" + this.getSelfRef() + ", parent=" + String.valueOf(this.getParent()) + ", children=" + String.valueOf(this.getChildren()) + ", contentLayer=" + String.valueOf((Object)this.getContentLayer()) + ", meta=" + String.valueOf(this.getMeta()) + ", label=" + String.valueOf((Object)this.getLabel()) + ", prov=" + String.valueOf(this.getProv()) + ", orig=" + this.getOrig() + ", text=" + this.getText() + ", formatting=" + String.valueOf(this.getFormatting()) + ", hyperlink=" + this.getHyperlink() + ")";
        }

        @tools.jackson.databind.annotation.JsonPOJOBuilder(withPrefix="")
        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        public static class Builder {
            private String selfRef;
            private RefItem parent;
            private ArrayList<RefItem> children;
            private ContentLayer contentLayer;
            private BaseMeta meta;
            private DocItemLabel label;
            private ArrayList<ProvenanceItem> prov;
            private String orig;
            private String text;
            private Formatting formatting;
            private String hyperlink;

            Builder() {
            }

            @JsonProperty(value="self_ref")
            public @NonNull Builder selfRef(String selfRef) {
                this.selfRef = selfRef;
                return this;
            }

            @JsonProperty(value="parent")
            public @NonNull Builder parent(@Nullable RefItem parent) {
                this.parent = parent;
                return this;
            }

            public @NonNull Builder child(RefItem child) {
                if (this.children == null) {
                    this.children = new ArrayList();
                }
                this.children.add(child);
                return this;
            }

            @JsonProperty(value="children")
            @JsonSetter(nulls=Nulls.AS_EMPTY)
            public @NonNull Builder children(@NonNull Collection<? extends RefItem> children) {
                if (children == null) {
                    throw new IllegalArgumentException("children cannot be null");
                }
                if (this.children == null) {
                    this.children = new ArrayList();
                }
                this.children.addAll(children);
                return this;
            }

            public @NonNull Builder clearChildren() {
                if (this.children != null) {
                    this.children.clear();
                }
                return this;
            }

            @JsonProperty(value="content_layer")
            public @NonNull Builder contentLayer(ContentLayer contentLayer) {
                this.contentLayer = contentLayer;
                return this;
            }

            @JsonProperty(value="meta")
            public @NonNull Builder meta(@Nullable BaseMeta meta) {
                this.meta = meta;
                return this;
            }

            @JsonProperty(value="label")
            public @NonNull Builder label(DocItemLabel label) {
                this.label = label;
                return this;
            }

            public @NonNull Builder prov(ProvenanceItem prov) {
                if (this.prov == null) {
                    this.prov = new ArrayList();
                }
                this.prov.add(prov);
                return this;
            }

            @JsonProperty(value="prov")
            @JsonSetter(nulls=Nulls.AS_EMPTY)
            public @NonNull Builder prov(@NonNull Collection<? extends ProvenanceItem> prov) {
                if (prov == null) {
                    throw new IllegalArgumentException("prov cannot be null");
                }
                if (this.prov == null) {
                    this.prov = new ArrayList();
                }
                this.prov.addAll(prov);
                return this;
            }

            public @NonNull Builder clearProv() {
                if (this.prov != null) {
                    this.prov.clear();
                }
                return this;
            }

            @JsonProperty(value="orig")
            public @NonNull Builder orig(String orig) {
                this.orig = orig;
                return this;
            }

            @JsonProperty(value="text")
            public @NonNull Builder text(String text) {
                this.text = text;
                return this;
            }

            @JsonProperty(value="formatting")
            public @NonNull Builder formatting(@Nullable Formatting formatting) {
                this.formatting = formatting;
                return this;
            }

            @JsonProperty(value="hyperlink")
            public @NonNull Builder hyperlink(@Nullable String hyperlink) {
                this.hyperlink = hyperlink;
                return this;
            }

            public @NonNull FormulaItem build() {
                return new FormulaItem(this.selfRef, this.parent, switch (this.children == null ? 0 : this.children.size()) {
                    case 0 -> Collections.emptyList();
                    case 1 -> Collections.singletonList(this.children.get(0));
                    default -> Collections.unmodifiableList(new ArrayList<RefItem>(this.children));
                }, this.contentLayer, this.meta, this.label, switch (this.prov == null ? 0 : this.prov.size()) {
                    case 0 -> Collections.emptyList();
                    case 1 -> Collections.singletonList(this.prov.get(0));
                    default -> Collections.unmodifiableList(new ArrayList<ProvenanceItem>(this.prov));
                }, this.orig, this.text, this.formatting, this.hyperlink);
            }

            public @NonNull String toString() {
                return "DoclingDocument.FormulaItem.Builder(selfRef=" + this.selfRef + ", parent=" + String.valueOf(this.parent) + ", children=" + String.valueOf(this.children) + ", contentLayer=" + String.valueOf((Object)this.contentLayer) + ", meta=" + String.valueOf(this.meta) + ", label=" + String.valueOf((Object)this.label) + ", prov=" + String.valueOf(this.prov) + ", orig=" + this.orig + ", text=" + this.text + ", formatting=" + String.valueOf(this.formatting) + ", hyperlink=" + this.hyperlink + ")";
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonDeserialize(builder=Builder.class)
    @com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder=Builder.class)
    public static final class CodeItem
    implements BaseTextItem {
        @JsonProperty(value="self_ref")
        private final String selfRef;
        @JsonProperty(value="parent")
        private final @Nullable RefItem parent;
        @JsonProperty(value="children")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        private final List<RefItem> children;
        @JsonProperty(value="content_layer")
        private final ContentLayer contentLayer;
        @JsonProperty(value="meta")
        private final @Nullable FloatingMeta meta;
        @JsonProperty(value="label")
        private final DocItemLabel label;
        @JsonProperty(value="prov")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        private final List<ProvenanceItem> prov;
        @JsonProperty(value="orig")
        private final String orig;
        @JsonProperty(value="text")
        private final String text;
        @JsonProperty(value="formatting")
        private final @Nullable Formatting formatting;
        @JsonProperty(value="hyperlink")
        private final @Nullable String hyperlink;
        @JsonProperty(value="captions")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        private final List<RefItem> captions;
        @JsonProperty(value="references")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        private final List<RefItem> references;
        @JsonProperty(value="footnotes")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        private final List<RefItem> footnotes;
        @JsonProperty(value="image")
        private final @Nullable ImageRef image;
        @JsonProperty(value="code_language")
        private final @Nullable String codeLanguage;

        CodeItem(String selfRef, @Nullable RefItem parent, List<RefItem> children, ContentLayer contentLayer, @Nullable FloatingMeta meta, DocItemLabel label, List<ProvenanceItem> prov, String orig, String text, @Nullable Formatting formatting, @Nullable String hyperlink, List<RefItem> captions, List<RefItem> references, List<RefItem> footnotes, @Nullable ImageRef image, @Nullable String codeLanguage) {
            this.selfRef = selfRef;
            this.parent = parent;
            this.children = children;
            this.contentLayer = contentLayer;
            this.meta = meta;
            this.label = label;
            this.prov = prov;
            this.orig = orig;
            this.text = text;
            this.formatting = formatting;
            this.hyperlink = hyperlink;
            this.captions = captions;
            this.references = references;
            this.footnotes = footnotes;
            this.image = image;
            this.codeLanguage = codeLanguage;
        }

        public static @NonNull Builder builder() {
            return new Builder();
        }

        public @NonNull Builder toBuilder() {
            Builder builder = new Builder().selfRef(this.selfRef).parent(this.parent).contentLayer(this.contentLayer).meta(this.meta).label(this.label).orig(this.orig).text(this.text).formatting(this.formatting).hyperlink(this.hyperlink).image(this.image).codeLanguage(this.codeLanguage);
            if (this.children != null) {
                builder.children(this.children);
            }
            if (this.prov != null) {
                builder.prov(this.prov);
            }
            if (this.captions != null) {
                builder.captions(this.captions);
            }
            if (this.references != null) {
                builder.references(this.references);
            }
            if (this.footnotes != null) {
                builder.footnotes(this.footnotes);
            }
            return builder;
        }

        @Override
        public String getSelfRef() {
            return this.selfRef;
        }

        @Override
        public @Nullable RefItem getParent() {
            return this.parent;
        }

        @Override
        public List<RefItem> getChildren() {
            return this.children;
        }

        @Override
        public ContentLayer getContentLayer() {
            return this.contentLayer;
        }

        public @Nullable FloatingMeta getMeta() {
            return this.meta;
        }

        @Override
        public DocItemLabel getLabel() {
            return this.label;
        }

        @Override
        public List<ProvenanceItem> getProv() {
            return this.prov;
        }

        @Override
        public String getOrig() {
            return this.orig;
        }

        @Override
        public String getText() {
            return this.text;
        }

        @Override
        public @Nullable Formatting getFormatting() {
            return this.formatting;
        }

        @Override
        public @Nullable String getHyperlink() {
            return this.hyperlink;
        }

        public List<RefItem> getCaptions() {
            return this.captions;
        }

        public List<RefItem> getReferences() {
            return this.references;
        }

        public List<RefItem> getFootnotes() {
            return this.footnotes;
        }

        public @Nullable ImageRef getImage() {
            return this.image;
        }

        public @Nullable String getCodeLanguage() {
            return this.codeLanguage;
        }

        public @NonNull String toString() {
            return "DoclingDocument.CodeItem(selfRef=" + this.getSelfRef() + ", parent=" + String.valueOf(this.getParent()) + ", children=" + String.valueOf(this.getChildren()) + ", contentLayer=" + String.valueOf((Object)this.getContentLayer()) + ", meta=" + String.valueOf(this.getMeta()) + ", label=" + String.valueOf((Object)this.getLabel()) + ", prov=" + String.valueOf(this.getProv()) + ", orig=" + this.getOrig() + ", text=" + this.getText() + ", formatting=" + String.valueOf(this.getFormatting()) + ", hyperlink=" + this.getHyperlink() + ", captions=" + String.valueOf(this.getCaptions()) + ", references=" + String.valueOf(this.getReferences()) + ", footnotes=" + String.valueOf(this.getFootnotes()) + ", image=" + String.valueOf(this.getImage()) + ", codeLanguage=" + this.getCodeLanguage() + ")";
        }

        @tools.jackson.databind.annotation.JsonPOJOBuilder(withPrefix="")
        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        public static class Builder {
            private String selfRef;
            private RefItem parent;
            private ArrayList<RefItem> children;
            private ContentLayer contentLayer;
            private FloatingMeta meta;
            private DocItemLabel label;
            private ArrayList<ProvenanceItem> prov;
            private String orig;
            private String text;
            private Formatting formatting;
            private String hyperlink;
            private ArrayList<RefItem> captions;
            private ArrayList<RefItem> references;
            private ArrayList<RefItem> footnotes;
            private ImageRef image;
            private String codeLanguage;

            Builder() {
            }

            @JsonProperty(value="self_ref")
            public @NonNull Builder selfRef(String selfRef) {
                this.selfRef = selfRef;
                return this;
            }

            @JsonProperty(value="parent")
            public @NonNull Builder parent(@Nullable RefItem parent) {
                this.parent = parent;
                return this;
            }

            public @NonNull Builder child(RefItem child) {
                if (this.children == null) {
                    this.children = new ArrayList();
                }
                this.children.add(child);
                return this;
            }

            @JsonProperty(value="children")
            @JsonSetter(nulls=Nulls.AS_EMPTY)
            public @NonNull Builder children(@NonNull Collection<? extends RefItem> children) {
                if (children == null) {
                    throw new IllegalArgumentException("children cannot be null");
                }
                if (this.children == null) {
                    this.children = new ArrayList();
                }
                this.children.addAll(children);
                return this;
            }

            public @NonNull Builder clearChildren() {
                if (this.children != null) {
                    this.children.clear();
                }
                return this;
            }

            @JsonProperty(value="content_layer")
            public @NonNull Builder contentLayer(ContentLayer contentLayer) {
                this.contentLayer = contentLayer;
                return this;
            }

            @JsonProperty(value="meta")
            public @NonNull Builder meta(@Nullable FloatingMeta meta) {
                this.meta = meta;
                return this;
            }

            @JsonProperty(value="label")
            public @NonNull Builder label(DocItemLabel label) {
                this.label = label;
                return this;
            }

            public @NonNull Builder prov(ProvenanceItem prov) {
                if (this.prov == null) {
                    this.prov = new ArrayList();
                }
                this.prov.add(prov);
                return this;
            }

            @JsonProperty(value="prov")
            @JsonSetter(nulls=Nulls.AS_EMPTY)
            public @NonNull Builder prov(@NonNull Collection<? extends ProvenanceItem> prov) {
                if (prov == null) {
                    throw new IllegalArgumentException("prov cannot be null");
                }
                if (this.prov == null) {
                    this.prov = new ArrayList();
                }
                this.prov.addAll(prov);
                return this;
            }

            public @NonNull Builder clearProv() {
                if (this.prov != null) {
                    this.prov.clear();
                }
                return this;
            }

            @JsonProperty(value="orig")
            public @NonNull Builder orig(String orig) {
                this.orig = orig;
                return this;
            }

            @JsonProperty(value="text")
            public @NonNull Builder text(String text) {
                this.text = text;
                return this;
            }

            @JsonProperty(value="formatting")
            public @NonNull Builder formatting(@Nullable Formatting formatting) {
                this.formatting = formatting;
                return this;
            }

            @JsonProperty(value="hyperlink")
            public @NonNull Builder hyperlink(@Nullable String hyperlink) {
                this.hyperlink = hyperlink;
                return this;
            }

            public @NonNull Builder caption(RefItem caption) {
                if (this.captions == null) {
                    this.captions = new ArrayList();
                }
                this.captions.add(caption);
                return this;
            }

            @JsonProperty(value="captions")
            @JsonSetter(nulls=Nulls.AS_EMPTY)
            public @NonNull Builder captions(@NonNull Collection<? extends RefItem> captions) {
                if (captions == null) {
                    throw new IllegalArgumentException("captions cannot be null");
                }
                if (this.captions == null) {
                    this.captions = new ArrayList();
                }
                this.captions.addAll(captions);
                return this;
            }

            public @NonNull Builder clearCaptions() {
                if (this.captions != null) {
                    this.captions.clear();
                }
                return this;
            }

            public @NonNull Builder reference(RefItem reference) {
                if (this.references == null) {
                    this.references = new ArrayList();
                }
                this.references.add(reference);
                return this;
            }

            @JsonProperty(value="references")
            @JsonSetter(nulls=Nulls.AS_EMPTY)
            public @NonNull Builder references(@NonNull Collection<? extends RefItem> references) {
                if (references == null) {
                    throw new IllegalArgumentException("references cannot be null");
                }
                if (this.references == null) {
                    this.references = new ArrayList();
                }
                this.references.addAll(references);
                return this;
            }

            public @NonNull Builder clearReferences() {
                if (this.references != null) {
                    this.references.clear();
                }
                return this;
            }

            public @NonNull Builder footnote(RefItem footnote) {
                if (this.footnotes == null) {
                    this.footnotes = new ArrayList();
                }
                this.footnotes.add(footnote);
                return this;
            }

            @JsonProperty(value="footnotes")
            @JsonSetter(nulls=Nulls.AS_EMPTY)
            public @NonNull Builder footnotes(@NonNull Collection<? extends RefItem> footnotes) {
                if (footnotes == null) {
                    throw new IllegalArgumentException("footnotes cannot be null");
                }
                if (this.footnotes == null) {
                    this.footnotes = new ArrayList();
                }
                this.footnotes.addAll(footnotes);
                return this;
            }

            public @NonNull Builder clearFootnotes() {
                if (this.footnotes != null) {
                    this.footnotes.clear();
                }
                return this;
            }

            @JsonProperty(value="image")
            public @NonNull Builder image(@Nullable ImageRef image) {
                this.image = image;
                return this;
            }

            @JsonProperty(value="code_language")
            public @NonNull Builder codeLanguage(@Nullable String codeLanguage) {
                this.codeLanguage = codeLanguage;
                return this;
            }

            public @NonNull CodeItem build() {
                return new CodeItem(this.selfRef, this.parent, switch (this.children == null ? 0 : this.children.size()) {
                    case 0 -> Collections.emptyList();
                    case 1 -> Collections.singletonList(this.children.get(0));
                    default -> Collections.unmodifiableList(new ArrayList<RefItem>(this.children));
                }, this.contentLayer, this.meta, this.label, switch (this.prov == null ? 0 : this.prov.size()) {
                    case 0 -> Collections.emptyList();
                    case 1 -> Collections.singletonList(this.prov.get(0));
                    default -> Collections.unmodifiableList(new ArrayList<ProvenanceItem>(this.prov));
                }, this.orig, this.text, this.formatting, this.hyperlink, switch (this.captions == null ? 0 : this.captions.size()) {
                    case 0 -> Collections.emptyList();
                    case 1 -> Collections.singletonList(this.captions.get(0));
                    default -> Collections.unmodifiableList(new ArrayList<RefItem>(this.captions));
                }, switch (this.references == null ? 0 : this.references.size()) {
                    case 0 -> Collections.emptyList();
                    case 1 -> Collections.singletonList(this.references.get(0));
                    default -> Collections.unmodifiableList(new ArrayList<RefItem>(this.references));
                }, switch (this.footnotes == null ? 0 : this.footnotes.size()) {
                    case 0 -> Collections.emptyList();
                    case 1 -> Collections.singletonList(this.footnotes.get(0));
                    default -> Collections.unmodifiableList(new ArrayList<RefItem>(this.footnotes));
                }, this.image, this.codeLanguage);
            }

            public @NonNull String toString() {
                return "DoclingDocument.CodeItem.Builder(selfRef=" + this.selfRef + ", parent=" + String.valueOf(this.parent) + ", children=" + String.valueOf(this.children) + ", contentLayer=" + String.valueOf((Object)this.contentLayer) + ", meta=" + String.valueOf(this.meta) + ", label=" + String.valueOf((Object)this.label) + ", prov=" + String.valueOf(this.prov) + ", orig=" + this.orig + ", text=" + this.text + ", formatting=" + String.valueOf(this.formatting) + ", hyperlink=" + this.hyperlink + ", captions=" + String.valueOf(this.captions) + ", references=" + String.valueOf(this.references) + ", footnotes=" + String.valueOf(this.footnotes) + ", image=" + String.valueOf(this.image) + ", codeLanguage=" + this.codeLanguage + ")";
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonDeserialize(builder=Builder.class)
    @com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder=Builder.class)
    public static final class ListItem
    implements BaseTextItem {
        @JsonProperty(value="self_ref")
        private final String selfRef;
        @JsonProperty(value="parent")
        private final @Nullable RefItem parent;
        @JsonProperty(value="children")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        private final List<RefItem> children;
        @JsonProperty(value="content_layer")
        private final ContentLayer contentLayer;
        @JsonProperty(value="meta")
        private final @Nullable BaseMeta meta;
        @JsonProperty(value="label")
        private final DocItemLabel label;
        @JsonProperty(value="prov")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        private final List<ProvenanceItem> prov;
        @JsonProperty(value="orig")
        private final String orig;
        @JsonProperty(value="text")
        private final String text;
        @JsonProperty(value="formatting")
        private final @Nullable Formatting formatting;
        @JsonProperty(value="hyperlink")
        private final @Nullable String hyperlink;
        @JsonProperty(value="enumerated")
        private final boolean enumerated;
        @JsonProperty(value="marker")
        private final @Nullable String marker;

        ListItem(String selfRef, @Nullable RefItem parent, List<RefItem> children, ContentLayer contentLayer, @Nullable BaseMeta meta, DocItemLabel label, List<ProvenanceItem> prov, String orig, String text, @Nullable Formatting formatting, @Nullable String hyperlink, boolean enumerated, @Nullable String marker) {
            this.selfRef = selfRef;
            this.parent = parent;
            this.children = children;
            this.contentLayer = contentLayer;
            this.meta = meta;
            this.label = label;
            this.prov = prov;
            this.orig = orig;
            this.text = text;
            this.formatting = formatting;
            this.hyperlink = hyperlink;
            this.enumerated = enumerated;
            this.marker = marker;
        }

        public static @NonNull Builder builder() {
            return new Builder();
        }

        public @NonNull Builder toBuilder() {
            Builder builder = new Builder().selfRef(this.selfRef).parent(this.parent).contentLayer(this.contentLayer).meta(this.meta).label(this.label).orig(this.orig).text(this.text).formatting(this.formatting).hyperlink(this.hyperlink).enumerated(this.enumerated).marker(this.marker);
            if (this.children != null) {
                builder.children(this.children);
            }
            if (this.prov != null) {
                builder.prov(this.prov);
            }
            return builder;
        }

        @Override
        public String getSelfRef() {
            return this.selfRef;
        }

        @Override
        public @Nullable RefItem getParent() {
            return this.parent;
        }

        @Override
        public List<RefItem> getChildren() {
            return this.children;
        }

        @Override
        public ContentLayer getContentLayer() {
            return this.contentLayer;
        }

        public @Nullable BaseMeta getMeta() {
            return this.meta;
        }

        @Override
        public DocItemLabel getLabel() {
            return this.label;
        }

        @Override
        public List<ProvenanceItem> getProv() {
            return this.prov;
        }

        @Override
        public String getOrig() {
            return this.orig;
        }

        @Override
        public String getText() {
            return this.text;
        }

        @Override
        public @Nullable Formatting getFormatting() {
            return this.formatting;
        }

        @Override
        public @Nullable String getHyperlink() {
            return this.hyperlink;
        }

        public boolean isEnumerated() {
            return this.enumerated;
        }

        public @Nullable String getMarker() {
            return this.marker;
        }

        public @NonNull String toString() {
            return "DoclingDocument.ListItem(selfRef=" + this.getSelfRef() + ", parent=" + String.valueOf(this.getParent()) + ", children=" + String.valueOf(this.getChildren()) + ", contentLayer=" + String.valueOf((Object)this.getContentLayer()) + ", meta=" + String.valueOf(this.getMeta()) + ", label=" + String.valueOf((Object)this.getLabel()) + ", prov=" + String.valueOf(this.getProv()) + ", orig=" + this.getOrig() + ", text=" + this.getText() + ", formatting=" + String.valueOf(this.getFormatting()) + ", hyperlink=" + this.getHyperlink() + ", enumerated=" + this.isEnumerated() + ", marker=" + this.getMarker() + ")";
        }

        @tools.jackson.databind.annotation.JsonPOJOBuilder(withPrefix="")
        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        public static class Builder {
            private String selfRef;
            private RefItem parent;
            private ArrayList<RefItem> children;
            private ContentLayer contentLayer;
            private BaseMeta meta;
            private DocItemLabel label;
            private ArrayList<ProvenanceItem> prov;
            private String orig;
            private String text;
            private Formatting formatting;
            private String hyperlink;
            private boolean enumerated;
            private String marker;

            Builder() {
            }

            @JsonProperty(value="self_ref")
            public @NonNull Builder selfRef(String selfRef) {
                this.selfRef = selfRef;
                return this;
            }

            @JsonProperty(value="parent")
            public @NonNull Builder parent(@Nullable RefItem parent) {
                this.parent = parent;
                return this;
            }

            public @NonNull Builder child(RefItem child) {
                if (this.children == null) {
                    this.children = new ArrayList();
                }
                this.children.add(child);
                return this;
            }

            @JsonProperty(value="children")
            @JsonSetter(nulls=Nulls.AS_EMPTY)
            public @NonNull Builder children(@NonNull Collection<? extends RefItem> children) {
                if (children == null) {
                    throw new IllegalArgumentException("children cannot be null");
                }
                if (this.children == null) {
                    this.children = new ArrayList();
                }
                this.children.addAll(children);
                return this;
            }

            public @NonNull Builder clearChildren() {
                if (this.children != null) {
                    this.children.clear();
                }
                return this;
            }

            @JsonProperty(value="content_layer")
            public @NonNull Builder contentLayer(ContentLayer contentLayer) {
                this.contentLayer = contentLayer;
                return this;
            }

            @JsonProperty(value="meta")
            public @NonNull Builder meta(@Nullable BaseMeta meta) {
                this.meta = meta;
                return this;
            }

            @JsonProperty(value="label")
            public @NonNull Builder label(DocItemLabel label) {
                this.label = label;
                return this;
            }

            public @NonNull Builder prov(ProvenanceItem prov) {
                if (this.prov == null) {
                    this.prov = new ArrayList();
                }
                this.prov.add(prov);
                return this;
            }

            @JsonProperty(value="prov")
            @JsonSetter(nulls=Nulls.AS_EMPTY)
            public @NonNull Builder prov(@NonNull Collection<? extends ProvenanceItem> prov) {
                if (prov == null) {
                    throw new IllegalArgumentException("prov cannot be null");
                }
                if (this.prov == null) {
                    this.prov = new ArrayList();
                }
                this.prov.addAll(prov);
                return this;
            }

            public @NonNull Builder clearProv() {
                if (this.prov != null) {
                    this.prov.clear();
                }
                return this;
            }

            @JsonProperty(value="orig")
            public @NonNull Builder orig(String orig) {
                this.orig = orig;
                return this;
            }

            @JsonProperty(value="text")
            public @NonNull Builder text(String text) {
                this.text = text;
                return this;
            }

            @JsonProperty(value="formatting")
            public @NonNull Builder formatting(@Nullable Formatting formatting) {
                this.formatting = formatting;
                return this;
            }

            @JsonProperty(value="hyperlink")
            public @NonNull Builder hyperlink(@Nullable String hyperlink) {
                this.hyperlink = hyperlink;
                return this;
            }

            @JsonProperty(value="enumerated")
            public @NonNull Builder enumerated(boolean enumerated) {
                this.enumerated = enumerated;
                return this;
            }

            @JsonProperty(value="marker")
            public @NonNull Builder marker(@Nullable String marker) {
                this.marker = marker;
                return this;
            }

            public @NonNull ListItem build() {
                return new ListItem(this.selfRef, this.parent, switch (this.children == null ? 0 : this.children.size()) {
                    case 0 -> Collections.emptyList();
                    case 1 -> Collections.singletonList(this.children.get(0));
                    default -> Collections.unmodifiableList(new ArrayList<RefItem>(this.children));
                }, this.contentLayer, this.meta, this.label, switch (this.prov == null ? 0 : this.prov.size()) {
                    case 0 -> Collections.emptyList();
                    case 1 -> Collections.singletonList(this.prov.get(0));
                    default -> Collections.unmodifiableList(new ArrayList<ProvenanceItem>(this.prov));
                }, this.orig, this.text, this.formatting, this.hyperlink, this.enumerated, this.marker);
            }

            public @NonNull String toString() {
                return "DoclingDocument.ListItem.Builder(selfRef=" + this.selfRef + ", parent=" + String.valueOf(this.parent) + ", children=" + String.valueOf(this.children) + ", contentLayer=" + String.valueOf((Object)this.contentLayer) + ", meta=" + String.valueOf(this.meta) + ", label=" + String.valueOf((Object)this.label) + ", prov=" + String.valueOf(this.prov) + ", orig=" + this.orig + ", text=" + this.text + ", formatting=" + String.valueOf(this.formatting) + ", hyperlink=" + this.hyperlink + ", enumerated=" + this.enumerated + ", marker=" + this.marker + ")";
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonDeserialize(builder=Builder.class)
    @com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder=Builder.class)
    public static final class SectionHeaderItem
    implements BaseTextItem {
        @JsonProperty(value="self_ref")
        private final String selfRef;
        @JsonProperty(value="parent")
        private final @Nullable RefItem parent;
        @JsonProperty(value="children")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        private final List<RefItem> children;
        @JsonProperty(value="content_layer")
        private final ContentLayer contentLayer;
        @JsonProperty(value="meta")
        private final @Nullable BaseMeta meta;
        @JsonProperty(value="label")
        private final DocItemLabel label;
        @JsonProperty(value="prov")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        private final List<ProvenanceItem> prov;
        @JsonProperty(value="orig")
        private final String orig;
        @JsonProperty(value="text")
        private final String text;
        @JsonProperty(value="formatting")
        private final @Nullable Formatting formatting;
        @JsonProperty(value="hyperlink")
        private final @Nullable String hyperlink;
        @JsonProperty(value="level")
        private final Integer level;

        SectionHeaderItem(String selfRef, @Nullable RefItem parent, List<RefItem> children, ContentLayer contentLayer, @Nullable BaseMeta meta, DocItemLabel label, List<ProvenanceItem> prov, String orig, String text, @Nullable Formatting formatting, @Nullable String hyperlink, Integer level) {
            this.selfRef = selfRef;
            this.parent = parent;
            this.children = children;
            this.contentLayer = contentLayer;
            this.meta = meta;
            this.label = label;
            this.prov = prov;
            this.orig = orig;
            this.text = text;
            this.formatting = formatting;
            this.hyperlink = hyperlink;
            this.level = level;
        }

        public static @NonNull Builder builder() {
            return new Builder();
        }

        public @NonNull Builder toBuilder() {
            Builder builder = new Builder().selfRef(this.selfRef).parent(this.parent).contentLayer(this.contentLayer).meta(this.meta).label(this.label).orig(this.orig).text(this.text).formatting(this.formatting).hyperlink(this.hyperlink).level(this.level);
            if (this.children != null) {
                builder.children(this.children);
            }
            if (this.prov != null) {
                builder.prov(this.prov);
            }
            return builder;
        }

        @Override
        public String getSelfRef() {
            return this.selfRef;
        }

        @Override
        public @Nullable RefItem getParent() {
            return this.parent;
        }

        @Override
        public List<RefItem> getChildren() {
            return this.children;
        }

        @Override
        public ContentLayer getContentLayer() {
            return this.contentLayer;
        }

        public @Nullable BaseMeta getMeta() {
            return this.meta;
        }

        @Override
        public DocItemLabel getLabel() {
            return this.label;
        }

        @Override
        public List<ProvenanceItem> getProv() {
            return this.prov;
        }

        @Override
        public String getOrig() {
            return this.orig;
        }

        @Override
        public String getText() {
            return this.text;
        }

        @Override
        public @Nullable Formatting getFormatting() {
            return this.formatting;
        }

        @Override
        public @Nullable String getHyperlink() {
            return this.hyperlink;
        }

        public Integer getLevel() {
            return this.level;
        }

        public @NonNull String toString() {
            return "DoclingDocument.SectionHeaderItem(selfRef=" + this.getSelfRef() + ", parent=" + String.valueOf(this.getParent()) + ", children=" + String.valueOf(this.getChildren()) + ", contentLayer=" + String.valueOf((Object)this.getContentLayer()) + ", meta=" + String.valueOf(this.getMeta()) + ", label=" + String.valueOf((Object)this.getLabel()) + ", prov=" + String.valueOf(this.getProv()) + ", orig=" + this.getOrig() + ", text=" + this.getText() + ", formatting=" + String.valueOf(this.getFormatting()) + ", hyperlink=" + this.getHyperlink() + ", level=" + this.getLevel() + ")";
        }

        @tools.jackson.databind.annotation.JsonPOJOBuilder(withPrefix="")
        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        public static class Builder {
            private String selfRef;
            private RefItem parent;
            private ArrayList<RefItem> children;
            private ContentLayer contentLayer;
            private BaseMeta meta;
            private DocItemLabel label;
            private ArrayList<ProvenanceItem> prov;
            private String orig;
            private String text;
            private Formatting formatting;
            private String hyperlink;
            private Integer level;

            Builder() {
            }

            @JsonProperty(value="self_ref")
            public @NonNull Builder selfRef(String selfRef) {
                this.selfRef = selfRef;
                return this;
            }

            @JsonProperty(value="parent")
            public @NonNull Builder parent(@Nullable RefItem parent) {
                this.parent = parent;
                return this;
            }

            public @NonNull Builder child(RefItem child) {
                if (this.children == null) {
                    this.children = new ArrayList();
                }
                this.children.add(child);
                return this;
            }

            @JsonProperty(value="children")
            @JsonSetter(nulls=Nulls.AS_EMPTY)
            public @NonNull Builder children(@NonNull Collection<? extends RefItem> children) {
                if (children == null) {
                    throw new IllegalArgumentException("children cannot be null");
                }
                if (this.children == null) {
                    this.children = new ArrayList();
                }
                this.children.addAll(children);
                return this;
            }

            public @NonNull Builder clearChildren() {
                if (this.children != null) {
                    this.children.clear();
                }
                return this;
            }

            @JsonProperty(value="content_layer")
            public @NonNull Builder contentLayer(ContentLayer contentLayer) {
                this.contentLayer = contentLayer;
                return this;
            }

            @JsonProperty(value="meta")
            public @NonNull Builder meta(@Nullable BaseMeta meta) {
                this.meta = meta;
                return this;
            }

            @JsonProperty(value="label")
            public @NonNull Builder label(DocItemLabel label) {
                this.label = label;
                return this;
            }

            public @NonNull Builder prov(ProvenanceItem prov) {
                if (this.prov == null) {
                    this.prov = new ArrayList();
                }
                this.prov.add(prov);
                return this;
            }

            @JsonProperty(value="prov")
            @JsonSetter(nulls=Nulls.AS_EMPTY)
            public @NonNull Builder prov(@NonNull Collection<? extends ProvenanceItem> prov) {
                if (prov == null) {
                    throw new IllegalArgumentException("prov cannot be null");
                }
                if (this.prov == null) {
                    this.prov = new ArrayList();
                }
                this.prov.addAll(prov);
                return this;
            }

            public @NonNull Builder clearProv() {
                if (this.prov != null) {
                    this.prov.clear();
                }
                return this;
            }

            @JsonProperty(value="orig")
            public @NonNull Builder orig(String orig) {
                this.orig = orig;
                return this;
            }

            @JsonProperty(value="text")
            public @NonNull Builder text(String text) {
                this.text = text;
                return this;
            }

            @JsonProperty(value="formatting")
            public @NonNull Builder formatting(@Nullable Formatting formatting) {
                this.formatting = formatting;
                return this;
            }

            @JsonProperty(value="hyperlink")
            public @NonNull Builder hyperlink(@Nullable String hyperlink) {
                this.hyperlink = hyperlink;
                return this;
            }

            @JsonProperty(value="level")
            public @NonNull Builder level(Integer level) {
                this.level = level;
                return this;
            }

            public @NonNull SectionHeaderItem build() {
                return new SectionHeaderItem(this.selfRef, this.parent, switch (this.children == null ? 0 : this.children.size()) {
                    case 0 -> Collections.emptyList();
                    case 1 -> Collections.singletonList(this.children.get(0));
                    default -> Collections.unmodifiableList(new ArrayList<RefItem>(this.children));
                }, this.contentLayer, this.meta, this.label, switch (this.prov == null ? 0 : this.prov.size()) {
                    case 0 -> Collections.emptyList();
                    case 1 -> Collections.singletonList(this.prov.get(0));
                    default -> Collections.unmodifiableList(new ArrayList<ProvenanceItem>(this.prov));
                }, this.orig, this.text, this.formatting, this.hyperlink, this.level);
            }

            public @NonNull String toString() {
                return "DoclingDocument.SectionHeaderItem.Builder(selfRef=" + this.selfRef + ", parent=" + String.valueOf(this.parent) + ", children=" + String.valueOf(this.children) + ", contentLayer=" + String.valueOf((Object)this.contentLayer) + ", meta=" + String.valueOf(this.meta) + ", label=" + String.valueOf((Object)this.label) + ", prov=" + String.valueOf(this.prov) + ", orig=" + this.orig + ", text=" + this.text + ", formatting=" + String.valueOf(this.formatting) + ", hyperlink=" + this.hyperlink + ", level=" + this.level + ")";
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonDeserialize(builder=Builder.class)
    @com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder=Builder.class)
    public static final class TitleItem
    implements BaseTextItem {
        @JsonProperty(value="self_ref")
        private final String selfRef;
        @JsonProperty(value="parent")
        private final @Nullable RefItem parent;
        @JsonProperty(value="children")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        private final List<RefItem> children;
        @JsonProperty(value="content_layer")
        private final ContentLayer contentLayer;
        @JsonProperty(value="meta")
        private final @Nullable BaseMeta meta;
        @JsonProperty(value="label")
        private final DocItemLabel label;
        @JsonProperty(value="prov")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        private final List<ProvenanceItem> prov;
        @JsonProperty(value="orig")
        private final String orig;
        @JsonProperty(value="text")
        private final String text;
        @JsonProperty(value="formatting")
        private final @Nullable Formatting formatting;
        @JsonProperty(value="hyperlink")
        private final @Nullable String hyperlink;

        TitleItem(String selfRef, @Nullable RefItem parent, List<RefItem> children, ContentLayer contentLayer, @Nullable BaseMeta meta, DocItemLabel label, List<ProvenanceItem> prov, String orig, String text, @Nullable Formatting formatting, @Nullable String hyperlink) {
            this.selfRef = selfRef;
            this.parent = parent;
            this.children = children;
            this.contentLayer = contentLayer;
            this.meta = meta;
            this.label = label;
            this.prov = prov;
            this.orig = orig;
            this.text = text;
            this.formatting = formatting;
            this.hyperlink = hyperlink;
        }

        public static @NonNull Builder builder() {
            return new Builder();
        }

        public @NonNull Builder toBuilder() {
            Builder builder = new Builder().selfRef(this.selfRef).parent(this.parent).contentLayer(this.contentLayer).meta(this.meta).label(this.label).orig(this.orig).text(this.text).formatting(this.formatting).hyperlink(this.hyperlink);
            if (this.children != null) {
                builder.children(this.children);
            }
            if (this.prov != null) {
                builder.prov(this.prov);
            }
            return builder;
        }

        @Override
        public String getSelfRef() {
            return this.selfRef;
        }

        @Override
        public @Nullable RefItem getParent() {
            return this.parent;
        }

        @Override
        public List<RefItem> getChildren() {
            return this.children;
        }

        @Override
        public ContentLayer getContentLayer() {
            return this.contentLayer;
        }

        public @Nullable BaseMeta getMeta() {
            return this.meta;
        }

        @Override
        public DocItemLabel getLabel() {
            return this.label;
        }

        @Override
        public List<ProvenanceItem> getProv() {
            return this.prov;
        }

        @Override
        public String getOrig() {
            return this.orig;
        }

        @Override
        public String getText() {
            return this.text;
        }

        @Override
        public @Nullable Formatting getFormatting() {
            return this.formatting;
        }

        @Override
        public @Nullable String getHyperlink() {
            return this.hyperlink;
        }

        public @NonNull String toString() {
            return "DoclingDocument.TitleItem(selfRef=" + this.getSelfRef() + ", parent=" + String.valueOf(this.getParent()) + ", children=" + String.valueOf(this.getChildren()) + ", contentLayer=" + String.valueOf((Object)this.getContentLayer()) + ", meta=" + String.valueOf(this.getMeta()) + ", label=" + String.valueOf((Object)this.getLabel()) + ", prov=" + String.valueOf(this.getProv()) + ", orig=" + this.getOrig() + ", text=" + this.getText() + ", formatting=" + String.valueOf(this.getFormatting()) + ", hyperlink=" + this.getHyperlink() + ")";
        }

        @tools.jackson.databind.annotation.JsonPOJOBuilder(withPrefix="")
        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        public static class Builder {
            private String selfRef;
            private RefItem parent;
            private ArrayList<RefItem> children;
            private ContentLayer contentLayer;
            private BaseMeta meta;
            private DocItemLabel label;
            private ArrayList<ProvenanceItem> prov;
            private String orig;
            private String text;
            private Formatting formatting;
            private String hyperlink;

            Builder() {
            }

            @JsonProperty(value="self_ref")
            public @NonNull Builder selfRef(String selfRef) {
                this.selfRef = selfRef;
                return this;
            }

            @JsonProperty(value="parent")
            public @NonNull Builder parent(@Nullable RefItem parent) {
                this.parent = parent;
                return this;
            }

            public @NonNull Builder child(RefItem child) {
                if (this.children == null) {
                    this.children = new ArrayList();
                }
                this.children.add(child);
                return this;
            }

            @JsonProperty(value="children")
            @JsonSetter(nulls=Nulls.AS_EMPTY)
            public @NonNull Builder children(@NonNull Collection<? extends RefItem> children) {
                if (children == null) {
                    throw new IllegalArgumentException("children cannot be null");
                }
                if (this.children == null) {
                    this.children = new ArrayList();
                }
                this.children.addAll(children);
                return this;
            }

            public @NonNull Builder clearChildren() {
                if (this.children != null) {
                    this.children.clear();
                }
                return this;
            }

            @JsonProperty(value="content_layer")
            public @NonNull Builder contentLayer(ContentLayer contentLayer) {
                this.contentLayer = contentLayer;
                return this;
            }

            @JsonProperty(value="meta")
            public @NonNull Builder meta(@Nullable BaseMeta meta) {
                this.meta = meta;
                return this;
            }

            @JsonProperty(value="label")
            public @NonNull Builder label(DocItemLabel label) {
                this.label = label;
                return this;
            }

            public @NonNull Builder prov(ProvenanceItem prov) {
                if (this.prov == null) {
                    this.prov = new ArrayList();
                }
                this.prov.add(prov);
                return this;
            }

            @JsonProperty(value="prov")
            @JsonSetter(nulls=Nulls.AS_EMPTY)
            public @NonNull Builder prov(@NonNull Collection<? extends ProvenanceItem> prov) {
                if (prov == null) {
                    throw new IllegalArgumentException("prov cannot be null");
                }
                if (this.prov == null) {
                    this.prov = new ArrayList();
                }
                this.prov.addAll(prov);
                return this;
            }

            public @NonNull Builder clearProv() {
                if (this.prov != null) {
                    this.prov.clear();
                }
                return this;
            }

            @JsonProperty(value="orig")
            public @NonNull Builder orig(String orig) {
                this.orig = orig;
                return this;
            }

            @JsonProperty(value="text")
            public @NonNull Builder text(String text) {
                this.text = text;
                return this;
            }

            @JsonProperty(value="formatting")
            public @NonNull Builder formatting(@Nullable Formatting formatting) {
                this.formatting = formatting;
                return this;
            }

            @JsonProperty(value="hyperlink")
            public @NonNull Builder hyperlink(@Nullable String hyperlink) {
                this.hyperlink = hyperlink;
                return this;
            }

            public @NonNull TitleItem build() {
                return new TitleItem(this.selfRef, this.parent, switch (this.children == null ? 0 : this.children.size()) {
                    case 0 -> Collections.emptyList();
                    case 1 -> Collections.singletonList(this.children.get(0));
                    default -> Collections.unmodifiableList(new ArrayList<RefItem>(this.children));
                }, this.contentLayer, this.meta, this.label, switch (this.prov == null ? 0 : this.prov.size()) {
                    case 0 -> Collections.emptyList();
                    case 1 -> Collections.singletonList(this.prov.get(0));
                    default -> Collections.unmodifiableList(new ArrayList<ProvenanceItem>(this.prov));
                }, this.orig, this.text, this.formatting, this.hyperlink);
            }

            public @NonNull String toString() {
                return "DoclingDocument.TitleItem.Builder(selfRef=" + this.selfRef + ", parent=" + String.valueOf(this.parent) + ", children=" + String.valueOf(this.children) + ", contentLayer=" + String.valueOf((Object)this.contentLayer) + ", meta=" + String.valueOf(this.meta) + ", label=" + String.valueOf((Object)this.label) + ", prov=" + String.valueOf(this.prov) + ", orig=" + this.orig + ", text=" + this.text + ", formatting=" + String.valueOf(this.formatting) + ", hyperlink=" + this.hyperlink + ")";
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonDeserialize(builder=Builder.class)
    @com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder=Builder.class)
    public static class Formatting {
        @JsonProperty(value="bold")
        private final boolean bold;
        @JsonProperty(value="italic")
        private final boolean italic;
        @JsonProperty(value="underline")
        private final boolean underline;
        @JsonProperty(value="strikethrough")
        private final boolean strikethrough;
        @JsonProperty(value="script")
        private final Script script;

        Formatting(boolean bold, boolean italic, boolean underline, boolean strikethrough, Script script) {
            this.bold = bold;
            this.italic = italic;
            this.underline = underline;
            this.strikethrough = strikethrough;
            this.script = script;
        }

        public static @NonNull Builder builder() {
            return new Builder();
        }

        public @NonNull Builder toBuilder() {
            return new Builder().bold(this.bold).italic(this.italic).underline(this.underline).strikethrough(this.strikethrough).script(this.script);
        }

        public boolean isBold() {
            return this.bold;
        }

        public boolean isItalic() {
            return this.italic;
        }

        public boolean isUnderline() {
            return this.underline;
        }

        public boolean isStrikethrough() {
            return this.strikethrough;
        }

        public Script getScript() {
            return this.script;
        }

        public @NonNull String toString() {
            return "DoclingDocument.Formatting(bold=" + this.isBold() + ", italic=" + this.isItalic() + ", underline=" + this.isUnderline() + ", strikethrough=" + this.isStrikethrough() + ", script=" + String.valueOf((Object)this.getScript()) + ")";
        }

        @tools.jackson.databind.annotation.JsonPOJOBuilder(withPrefix="")
        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        public static class Builder {
            private boolean bold;
            private boolean italic;
            private boolean underline;
            private boolean strikethrough;
            private Script script;

            Builder() {
            }

            @JsonProperty(value="bold")
            public @NonNull Builder bold(boolean bold) {
                this.bold = bold;
                return this;
            }

            @JsonProperty(value="italic")
            public @NonNull Builder italic(boolean italic) {
                this.italic = italic;
                return this;
            }

            @JsonProperty(value="underline")
            public @NonNull Builder underline(boolean underline) {
                this.underline = underline;
                return this;
            }

            @JsonProperty(value="strikethrough")
            public @NonNull Builder strikethrough(boolean strikethrough) {
                this.strikethrough = strikethrough;
                return this;
            }

            @JsonProperty(value="script")
            public @NonNull Builder script(Script script) {
                this.script = script;
                return this;
            }

            public @NonNull Formatting build() {
                return new Formatting(this.bold, this.italic, this.underline, this.strikethrough, this.script);
            }

            public @NonNull String toString() {
                return "DoclingDocument.Formatting.Builder(bold=" + this.bold + ", italic=" + this.italic + ", underline=" + this.underline + ", strikethrough=" + this.strikethrough + ", script=" + String.valueOf((Object)this.script) + ")";
            }
        }
    }

    public static enum Script {
        BASELINE,
        SUB,
        SUPER;

    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="label", visible=true)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=TitleItem.class, name="title"), @JsonSubTypes.Type(value=SectionHeaderItem.class, name="section_header"), @JsonSubTypes.Type(value=ListItem.class, name="list_item"), @JsonSubTypes.Type(value=CodeItem.class, name="code"), @JsonSubTypes.Type(value=FormulaItem.class, name="formula"), @JsonSubTypes.Type(value=TextItem.class, name="text"), @JsonSubTypes.Type(value=TextItem.class, name="paragraph"), @JsonSubTypes.Type(value=TextItem.class, name="caption"), @JsonSubTypes.Type(value=TextItem.class, name="footnote"), @JsonSubTypes.Type(value=TextItem.class, name="page_header"), @JsonSubTypes.Type(value=TextItem.class, name="page_footer"), @JsonSubTypes.Type(value=TextItem.class, name="reference"), @JsonSubTypes.Type(value=TextItem.class, name="checkbox_selected"), @JsonSubTypes.Type(value=TextItem.class, name="checkbox_unselected"), @JsonSubTypes.Type(value=TextItem.class, name="empty_value")})
    public static interface BaseTextItem {
        public String getSelfRef();

        public @Nullable RefItem getParent();

        public List<RefItem> getChildren();

        public ContentLayer getContentLayer();

        public DocItemLabel getLabel();

        public List<ProvenanceItem> getProv();

        public String getOrig();

        public String getText();

        public @Nullable Formatting getFormatting();

        public @Nullable String getHyperlink();
    }

    public static enum DocItemLabel {
        CAPTION,
        CHART,
        CHECKBOX_SELECTED,
        CHECKBOX_UNSELECTED,
        CODE,
        DOCUMENT_INDEX,
        EMPTY_VALUE,
        FOOTNOTE,
        FORM,
        FORMULA,
        GRADING_SCALE,
        HANDWRITTEN_TEXT,
        KEY_VALUE_REGION,
        LIST_ITEM,
        PAGE_FOOTER,
        PAGE_HEADER,
        PARAGRAPH,
        PICTURE,
        REFERENCE,
        SECTION_HEADER,
        TABLE,
        TEXT,
        TITLE;

    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonDeserialize(builder=Builder.class)
    @com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder=Builder.class)
    public static class SummaryMetaField {
        @JsonProperty(value="confidence")
        private final @Nullable Double confidence;
        @JsonProperty(value="created_by")
        private final @Nullable String createdBy;
        @JsonProperty(value="text")
        private final String text;

        SummaryMetaField(@Nullable Double confidence, @Nullable String createdBy, String text) {
            this.confidence = confidence;
            this.createdBy = createdBy;
            this.text = text;
        }

        public static @NonNull Builder builder() {
            return new Builder();
        }

        public @NonNull Builder toBuilder() {
            return new Builder().confidence(this.confidence).createdBy(this.createdBy).text(this.text);
        }

        public @Nullable Double getConfidence() {
            return this.confidence;
        }

        public @Nullable String getCreatedBy() {
            return this.createdBy;
        }

        public String getText() {
            return this.text;
        }

        public @NonNull String toString() {
            return "DoclingDocument.SummaryMetaField(confidence=" + this.getConfidence() + ", createdBy=" + this.getCreatedBy() + ", text=" + this.getText() + ")";
        }

        @tools.jackson.databind.annotation.JsonPOJOBuilder(withPrefix="")
        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        public static class Builder {
            private Double confidence;
            private String createdBy;
            private String text;

            Builder() {
            }

            @JsonProperty(value="confidence")
            public @NonNull Builder confidence(@Nullable Double confidence) {
                this.confidence = confidence;
                return this;
            }

            @JsonProperty(value="created_by")
            public @NonNull Builder createdBy(@Nullable String createdBy) {
                this.createdBy = createdBy;
                return this;
            }

            @JsonProperty(value="text")
            public @NonNull Builder text(String text) {
                this.text = text;
                return this;
            }

            public @NonNull SummaryMetaField build() {
                return new SummaryMetaField(this.confidence, this.createdBy, this.text);
            }

            public @NonNull String toString() {
                return "DoclingDocument.SummaryMetaField.Builder(confidence=" + this.confidence + ", createdBy=" + this.createdBy + ", text=" + this.text + ")";
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonDeserialize(builder=Builder.class)
    @com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder=Builder.class)
    public static class BaseMeta {
        @JsonProperty(value="summary")
        private final @Nullable SummaryMetaField summary;

        BaseMeta(@Nullable SummaryMetaField summary) {
            this.summary = summary;
        }

        public static @NonNull Builder builder() {
            return new Builder();
        }

        public @NonNull Builder toBuilder() {
            return new Builder().summary(this.summary);
        }

        public @Nullable SummaryMetaField getSummary() {
            return this.summary;
        }

        public @NonNull String toString() {
            return "DoclingDocument.BaseMeta(summary=" + String.valueOf(this.getSummary()) + ")";
        }

        @tools.jackson.databind.annotation.JsonPOJOBuilder(withPrefix="")
        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        public static class Builder {
            private SummaryMetaField summary;

            Builder() {
            }

            @JsonProperty(value="summary")
            public @NonNull Builder summary(@Nullable SummaryMetaField summary) {
                this.summary = summary;
                return this;
            }

            public @NonNull BaseMeta build() {
                return new BaseMeta(this.summary);
            }

            public @NonNull String toString() {
                return "DoclingDocument.BaseMeta.Builder(summary=" + String.valueOf(this.summary) + ")";
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonDeserialize(builder=Builder.class)
    @com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder=Builder.class)
    public static class RefItem {
        @JsonProperty(value="$ref")
        private final String ref;

        RefItem(String ref) {
            this.ref = ref;
        }

        public static @NonNull Builder builder() {
            return new Builder();
        }

        public @NonNull Builder toBuilder() {
            return new Builder().ref(this.ref);
        }

        public String getRef() {
            return this.ref;
        }

        public @NonNull String toString() {
            return "DoclingDocument.RefItem(ref=" + this.getRef() + ")";
        }

        @tools.jackson.databind.annotation.JsonPOJOBuilder(withPrefix="")
        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        public static class Builder {
            private String ref;

            Builder() {
            }

            @JsonProperty(value="$ref")
            public @NonNull Builder ref(String ref) {
                this.ref = ref;
                return this;
            }

            public @NonNull RefItem build() {
                return new RefItem(this.ref);
            }

            public @NonNull String toString() {
                return "DoclingDocument.RefItem.Builder(ref=" + this.ref + ")";
            }
        }
    }

    public static enum GroupLabel {
        UNSPECIFIED,
        LIST,
        ORDERED_LIST,
        CHAPTER,
        SECTION,
        SHEET,
        SLIDE,
        FORM_AREA,
        KEY_VALUE_AREA,
        COMMENT_SECTION,
        INLINE,
        PICTURE_AREA;

    }

    public static enum ContentLayer {
        BODY,
        FURNITURE,
        BACKGROUND,
        INVISIBLE,
        NOTES;

    }
}

