/*
 * Decompiled with CFR 0.152.
 */
package ai.docling.serve.api;

import ai.docling.serve.api.chunk.request.HierarchicalChunkDocumentRequest;
import ai.docling.serve.api.chunk.request.HybridChunkDocumentRequest;
import ai.docling.serve.api.chunk.response.ChunkDocumentResponse;
import ai.docling.serve.api.util.FileUtils;
import ai.docling.serve.api.util.ValidationUtils;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import org.jspecify.annotations.Nullable;

public interface DoclingServeChunkApi {
    public ChunkDocumentResponse chunkSourceWithHierarchicalChunker(HierarchicalChunkDocumentRequest var1);

    default public ChunkDocumentResponse chunkFilesWithHierarchicalChunker(Path ... files) {
        return this.chunkFilesWithHierarchicalChunker((HierarchicalChunkDocumentRequest)null, files);
    }

    default public ChunkDocumentResponse chunkFilesWithHierarchicalChunker(@Nullable HierarchicalChunkDocumentRequest request, Path ... files) {
        return this.chunkSourceWithHierarchicalChunker(this.createHierarchicalChunkRequest(request, files));
    }

    public ChunkDocumentResponse chunkSourceWithHybridChunker(HybridChunkDocumentRequest var1);

    default public ChunkDocumentResponse chunkFilesWithHybridChunker(Path ... files) {
        return this.chunkFilesWithHybridChunker((HybridChunkDocumentRequest)null, files);
    }

    default public ChunkDocumentResponse chunkFilesWithHybridChunker(@Nullable HybridChunkDocumentRequest request, Path ... files) {
        return this.chunkSourceWithHybridChunker(this.createHybridChunkRequest(request, files));
    }

    public CompletionStage<ChunkDocumentResponse> chunkSourceWithHierarchicalChunkerAsync(HierarchicalChunkDocumentRequest var1);

    default public CompletionStage<ChunkDocumentResponse> chunkFilesWithHierarchicalChunkerAsync(Path ... files) {
        return this.chunkFilesWithHierarchicalChunkerAsync((HierarchicalChunkDocumentRequest)null, files);
    }

    default public CompletionStage<ChunkDocumentResponse> chunkFilesWithHierarchicalChunkerAsync(@Nullable HierarchicalChunkDocumentRequest request, Path ... files) {
        return this.chunkSourceWithHierarchicalChunkerAsync(this.createHierarchicalChunkRequest(request, files));
    }

    public CompletionStage<ChunkDocumentResponse> chunkSourceWithHybridChunkerAsync(HybridChunkDocumentRequest var1);

    default public CompletionStage<ChunkDocumentResponse> chunkFilesWithHybridChunkerAsync(Path ... files) {
        return this.chunkFilesWithHybridChunkerAsync((HybridChunkDocumentRequest)null, files);
    }

    default public CompletionStage<ChunkDocumentResponse> chunkFilesWithHybridChunkerAsync(@Nullable HybridChunkDocumentRequest request, Path ... files) {
        return this.chunkSourceWithHybridChunkerAsync(this.createHybridChunkRequest(request, files));
    }

    private HierarchicalChunkDocumentRequest createHierarchicalChunkRequest(@Nullable HierarchicalChunkDocumentRequest request, Path ... files) {
        ValidationUtils.ensureNotEmpty(files, "files");
        HierarchicalChunkDocumentRequest.Builder builder = Optional.ofNullable(request).map(HierarchicalChunkDocumentRequest::toBuilder).orElseGet(HierarchicalChunkDocumentRequest::builder);
        FileUtils.createFileSources(files).forEach(builder::source);
        return builder.build();
    }

    private HybridChunkDocumentRequest createHybridChunkRequest(@Nullable HybridChunkDocumentRequest request, Path ... files) {
        ValidationUtils.ensureNotEmpty(files, "files");
        HybridChunkDocumentRequest.Builder builder = Optional.ofNullable(request).map(HybridChunkDocumentRequest::toBuilder).orElseGet(HybridChunkDocumentRequest::builder);
        FileUtils.createFileSources(files).forEach(builder::source);
        return builder.build();
    }
}

