/*
 * Decompiled with CFR 0.152.
 */
package ai.docling.serve.api.chunk.response;

import ai.docling.serve.api.chunk.response.ExportDocumentResponse;
import ai.docling.serve.api.convert.response.ErrorItem;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import tools.jackson.databind.annotation.JsonDeserialize;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder=Builder.class)
public class Document {
    @JsonProperty(value="kind")
    private final @Nullable String kind;
    @JsonProperty(value="content")
    private final ExportDocumentResponse content;
    @JsonProperty(value="status")
    private final String status;
    @JsonProperty(value="errors")
    @JsonSetter(nulls=Nulls.AS_EMPTY)
    private final List<ErrorItem> errors;

    Document(@Nullable String kind, ExportDocumentResponse content, String status, List<ErrorItem> errors) {
        this.kind = kind;
        this.content = content;
        this.status = status;
        this.errors = errors;
    }

    public static @NonNull Builder builder() {
        return new Builder();
    }

    public @NonNull Builder toBuilder() {
        Builder builder = new Builder().kind(this.kind).content(this.content).status(this.status);
        if (this.errors != null) {
            builder.errors(this.errors);
        }
        return builder;
    }

    public @Nullable String getKind() {
        return this.kind;
    }

    public ExportDocumentResponse getContent() {
        return this.content;
    }

    public String getStatus() {
        return this.status;
    }

    public List<ErrorItem> getErrors() {
        return this.errors;
    }

    public @NonNull String toString() {
        return "Document(kind=" + this.getKind() + ", content=" + String.valueOf(this.getContent()) + ", status=" + this.getStatus() + ", errors=" + String.valueOf(this.getErrors()) + ")";
    }

    @tools.jackson.databind.annotation.JsonPOJOBuilder(withPrefix="")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class Builder {
        private String kind;
        private ExportDocumentResponse content;
        private String status;
        private ArrayList<ErrorItem> errors;

        Builder() {
        }

        @JsonProperty(value="kind")
        public @NonNull Builder kind(@Nullable String kind) {
            this.kind = kind;
            return this;
        }

        @JsonProperty(value="content")
        public @NonNull Builder content(ExportDocumentResponse content) {
            this.content = content;
            return this;
        }

        @JsonProperty(value="status")
        public @NonNull Builder status(String status) {
            this.status = status;
            return this;
        }

        public @NonNull Builder error(ErrorItem error) {
            if (this.errors == null) {
                this.errors = new ArrayList();
            }
            this.errors.add(error);
            return this;
        }

        @JsonProperty(value="errors")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        public @NonNull Builder errors(@NonNull Collection<? extends ErrorItem> errors) {
            if (errors == null) {
                throw new IllegalArgumentException("errors cannot be null");
            }
            if (this.errors == null) {
                this.errors = new ArrayList();
            }
            this.errors.addAll(errors);
            return this;
        }

        public @NonNull Builder clearErrors() {
            if (this.errors != null) {
                this.errors.clear();
            }
            return this;
        }

        public @NonNull Document build() {
            return new Document(this.kind, this.content, this.status, switch (this.errors == null ? 0 : this.errors.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.errors.get(0));
                default -> Collections.unmodifiableList(new ArrayList<ErrorItem>(this.errors));
            });
        }

        public @NonNull String toString() {
            return "Document.Builder(kind=" + this.kind + ", content=" + String.valueOf(this.content) + ", status=" + this.status + ", errors=" + String.valueOf(this.errors) + ")";
        }
    }
}

