/*
 * Decompiled with CFR 0.152.
 */
package ai.docling.serve.api.convert.request.options;

import ai.docling.serve.api.convert.request.options.ResponseFormat;
import ai.docling.serve.api.serialization.DurationSerializationFormat;
import ai.docling.serve.api.serialization.Jackson2DurationSerializer;
import ai.docling.serve.api.serialization.Jackson3DurationSerializer;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.net.URI;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import tools.jackson.databind.annotation.JsonDeserialize;
import tools.jackson.databind.annotation.JsonSerialize;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder=Builder.class)
public class VlmModelApi {
    @JsonProperty(value="url")
    private final @Nullable URI url;
    @JsonProperty(value="headers")
    @JsonSetter(nulls=Nulls.AS_EMPTY)
    private final Map<String, Object> headers;
    @JsonProperty(value="params")
    @JsonSetter(nulls=Nulls.AS_EMPTY)
    private final Map<String, Object> params;
    @JsonProperty(value="timeout")
    @com.fasterxml.jackson.databind.annotation.JsonSerialize(using=Jackson2DurationSerializer.class)
    @JsonSerialize(using=Jackson3DurationSerializer.class)
    @DurationSerializationFormat(value=ChronoUnit.SECONDS)
    private final @Nullable Duration timeout;
    @JsonProperty(value="concurrency")
    private final @Nullable Integer concurrency;
    @JsonProperty(value="prompt")
    private final @Nullable String prompt;
    @JsonProperty(value="scale")
    private final @Nullable Integer scale;
    @JsonProperty(value="response_format")
    private final @Nullable ResponseFormat responseFormat;

    VlmModelApi(@Nullable URI url, Map<String, Object> headers, Map<String, Object> params, @Nullable Duration timeout, @Nullable Integer concurrency, @Nullable String prompt, @Nullable Integer scale, @Nullable ResponseFormat responseFormat) {
        this.url = url;
        this.headers = headers;
        this.params = params;
        this.timeout = timeout;
        this.concurrency = concurrency;
        this.prompt = prompt;
        this.scale = scale;
        this.responseFormat = responseFormat;
    }

    public static @NonNull Builder builder() {
        return new Builder();
    }

    public @NonNull Builder toBuilder() {
        Builder builder = new Builder().url(this.url).timeout(this.timeout).concurrency(this.concurrency).prompt(this.prompt).scale(this.scale).responseFormat(this.responseFormat);
        if (this.headers != null) {
            builder.headers(this.headers);
        }
        if (this.params != null) {
            builder.params(this.params);
        }
        return builder;
    }

    public @Nullable URI getUrl() {
        return this.url;
    }

    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public @Nullable Duration getTimeout() {
        return this.timeout;
    }

    public @Nullable Integer getConcurrency() {
        return this.concurrency;
    }

    public @Nullable String getPrompt() {
        return this.prompt;
    }

    public @Nullable Integer getScale() {
        return this.scale;
    }

    public @Nullable ResponseFormat getResponseFormat() {
        return this.responseFormat;
    }

    public @NonNull String toString() {
        return "VlmModelApi(url=" + String.valueOf(this.getUrl()) + ", headers=" + String.valueOf(this.getHeaders()) + ", params=" + String.valueOf(this.getParams()) + ", timeout=" + String.valueOf(this.getTimeout()) + ", concurrency=" + this.getConcurrency() + ", prompt=" + this.getPrompt() + ", scale=" + this.getScale() + ", responseFormat=" + String.valueOf((Object)this.getResponseFormat()) + ")";
    }

    @tools.jackson.databind.annotation.JsonPOJOBuilder(withPrefix="")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class Builder {
        private URI url;
        private ArrayList<String> headers$key;
        private ArrayList<Object> headers$value;
        private ArrayList<String> params$key;
        private ArrayList<Object> params$value;
        private Duration timeout;
        private Integer concurrency;
        private String prompt;
        private Integer scale;
        private ResponseFormat responseFormat;

        Builder() {
        }

        @JsonProperty(value="url")
        public @NonNull Builder url(@Nullable URI url) {
            this.url = url;
            return this;
        }

        public @NonNull Builder header(String headerKey, Object headerValue) {
            if (this.headers$key == null) {
                this.headers$key = new ArrayList();
                this.headers$value = new ArrayList();
            }
            this.headers$key.add(headerKey);
            this.headers$value.add(headerValue);
            return this;
        }

        @JsonProperty(value="headers")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        public @NonNull Builder headers(@NonNull Map<? extends String, ? extends Object> headers) {
            if (headers == null) {
                throw new IllegalArgumentException("headers cannot be null");
            }
            if (this.headers$key == null) {
                this.headers$key = new ArrayList();
                this.headers$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : headers.entrySet()) {
                this.headers$key.add($lombokEntry.getKey());
                this.headers$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public @NonNull Builder clearHeaders() {
            if (this.headers$key != null) {
                this.headers$key.clear();
                this.headers$value.clear();
            }
            return this;
        }

        public @NonNull Builder param(String paramKey, Object paramValue) {
            if (this.params$key == null) {
                this.params$key = new ArrayList();
                this.params$value = new ArrayList();
            }
            this.params$key.add(paramKey);
            this.params$value.add(paramValue);
            return this;
        }

        @JsonProperty(value="params")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        public @NonNull Builder params(@NonNull Map<? extends String, ? extends Object> params) {
            if (params == null) {
                throw new IllegalArgumentException("params cannot be null");
            }
            if (this.params$key == null) {
                this.params$key = new ArrayList();
                this.params$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : params.entrySet()) {
                this.params$key.add($lombokEntry.getKey());
                this.params$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public @NonNull Builder clearParams() {
            if (this.params$key != null) {
                this.params$key.clear();
                this.params$value.clear();
            }
            return this;
        }

        @JsonProperty(value="timeout")
        public @NonNull Builder timeout(@Nullable Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        @JsonProperty(value="concurrency")
        public @NonNull Builder concurrency(@Nullable Integer concurrency) {
            this.concurrency = concurrency;
            return this;
        }

        @JsonProperty(value="prompt")
        public @NonNull Builder prompt(@Nullable String prompt) {
            this.prompt = prompt;
            return this;
        }

        @JsonProperty(value="scale")
        public @NonNull Builder scale(@Nullable Integer scale) {
            this.scale = scale;
            return this;
        }

        @JsonProperty(value="response_format")
        public @NonNull Builder responseFormat(@Nullable ResponseFormat responseFormat) {
            this.responseFormat = responseFormat;
            return this;
        }

        public @NonNull VlmModelApi build() {
            Map<String, Object> params;
            Map<Object, Object> headers;
            switch (this.headers$key == null ? 0 : this.headers$key.size()) {
                case 0: {
                    headers = Collections.emptyMap();
                    break;
                }
                case 1: {
                    headers = Collections.singletonMap(this.headers$key.get(0), this.headers$value.get(0));
                    break;
                }
                default: {
                    headers = new LinkedHashMap(this.headers$key.size() < 0x40000000 ? 1 + this.headers$key.size() + (this.headers$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.headers$key.size(); ++$i) {
                        headers.put(this.headers$key.get($i), this.headers$value.get($i));
                    }
                    headers = Collections.unmodifiableMap(headers);
                }
            }
            switch (this.params$key == null ? 0 : this.params$key.size()) {
                case 0: {
                    params = Collections.emptyMap();
                    break;
                }
                case 1: {
                    params = Collections.singletonMap(this.params$key.get(0), this.params$value.get(0));
                    break;
                }
                default: {
                    params = new LinkedHashMap(this.params$key.size() < 0x40000000 ? 1 + this.params$key.size() + (this.params$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.params$key.size(); ++$i) {
                        params.put(this.params$key.get($i), this.params$value.get($i));
                    }
                    params = Collections.unmodifiableMap(params);
                }
            }
            return new VlmModelApi(this.url, headers, params, this.timeout, this.concurrency, this.prompt, this.scale, this.responseFormat);
        }

        public @NonNull String toString() {
            return "VlmModelApi.Builder(url=" + String.valueOf(this.url) + ", headers$key=" + String.valueOf(this.headers$key) + ", headers$value=" + String.valueOf(this.headers$value) + ", params$key=" + String.valueOf(this.params$key) + ", params$value=" + String.valueOf(this.params$value) + ", timeout=" + String.valueOf(this.timeout) + ", concurrency=" + this.concurrency + ", prompt=" + this.prompt + ", scale=" + this.scale + ", responseFormat=" + String.valueOf((Object)this.responseFormat) + ")";
        }
    }
}

