/*
 * Decompiled with CFR 0.152.
 */
package ai.docling.serve.api.util;

import ai.docling.serve.api.util.ValidationUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class Utils {
    private Utils() {
    }

    @SafeVarargs
    public static <T> @NonNull T firstNotNull(@NonNull String name, T ... values) {
        ValidationUtils.ensureNotEmpty(values, name + " values");
        return (T)Stream.of(values).filter(Objects::nonNull).findFirst().orElseThrow(() -> new IllegalArgumentException("At least one of the given '%s' values must be not null".formatted(name)));
    }

    public static <T> T getOrDefault(T value, T defaultValue) {
        return Optional.ofNullable(value).orElse(defaultValue);
    }

    public static <T> List<T> getOrDefault(List<T> list, List<T> defaultList) {
        return Utils.isNullOrEmpty(list) ? defaultList : list;
    }

    public static <K, V> Map<K, V> getOrDefault(Map<K, V> map, Map<K, V> defaultMap) {
        return Utils.isNullOrEmpty(map) ? defaultMap : map;
    }

    public static <T> T getOrDefault(@Nullable T value, Supplier<T> defaultValueSupplier) {
        return (T)Optional.ofNullable(value).orElseGet(defaultValueSupplier::get);
    }

    public static boolean isNullOrBlank(String string) {
        return string == null || string.trim().isBlank();
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static boolean isNotNullOrBlank(String string) {
        return !Utils.isNullOrBlank(string);
    }

    public static boolean isNotNullOrEmpty(String string) {
        return !Utils.isNullOrEmpty(string);
    }

    public static <T> boolean isNullOrEmpty(Collection<T> collection) {
        return collection == null || collection.isEmpty();
    }

    public static <T> boolean isNullOrEmpty(Iterable<T> iterable) {
        return iterable == null || !iterable.iterator().hasNext();
    }

    public static <T> boolean isNullOrEmpty(T[] array) {
        return array == null || array.length == 0;
    }

    public static <K, V> boolean isNullOrEmpty(@Nullable Map<K, V> map) {
        return map == null || map.isEmpty();
    }
}

