/*
 * Decompiled with CFR 0.152.
 */
package ai.docling.serve.api;

import ai.docling.serve.api.DoclingServeChunkApi;
import ai.docling.serve.api.DoclingServeClearApi;
import ai.docling.serve.api.DoclingServeConvertApi;
import ai.docling.serve.api.DoclingServeHealthApi;
import ai.docling.serve.api.DoclingServeTaskApi;
import ai.docling.serve.api.spi.DoclingServeApiBuilderFactory;
import ai.docling.serve.api.spi.ServiceLoaderHelper;
import ai.docling.serve.api.util.ValidationUtils;
import java.net.URI;
import java.time.Duration;
import java.util.Collection;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;

public interface DoclingServeApi
extends DoclingServeHealthApi,
DoclingServeConvertApi,
DoclingServeChunkApi,
DoclingServeClearApi,
DoclingServeTaskApi {
    public static <T extends DoclingServeApi, B extends DoclingApiBuilder<T, B>> B builder() {
        Collection<DoclingServeApiBuilderFactory> factories = ServiceLoaderHelper.loadFactories(DoclingServeApiBuilderFactory.class);
        if (factories.isEmpty()) {
            throw new IllegalStateException("No instance of %s found to build a %s instance. You are probably missing a library on your classpath.".formatted(DoclingServeApiBuilderFactory.class.getName(), DoclingApiBuilder.class.getName()));
        }
        if (factories.size() > 1) {
            throw new IllegalStateException("Multiple instances of %s found to build a %s instance: [%s]".formatted(DoclingServeApiBuilderFactory.class.getName(), DoclingApiBuilder.class.getName(), factories.stream().map(f -> f.getClass().getName()).collect(Collectors.joining(", "))));
        }
        return factories.iterator().next().getBuilder();
    }

    public <T extends DoclingServeApi, B extends DoclingApiBuilder<T, B>> DoclingApiBuilder<T, B> toBuilder();

    public static interface DoclingApiBuilder<T extends DoclingServeApi, B extends DoclingApiBuilder<T, B>> {
        default public B baseUrl(String baseUrl) {
            return this.baseUrl(URI.create(ValidationUtils.ensureNotBlank(baseUrl, "baseUrl")));
        }

        public B baseUrl(URI var1);

        public B apiKey(@Nullable String var1);

        default public B logRequests() {
            return this.logRequests(true);
        }

        public B logRequests(boolean var1);

        default public B logResponses() {
            return this.logResponses(true);
        }

        public B logResponses(boolean var1);

        public B prettyPrint(boolean var1);

        default public B prettyPrint() {
            return this.prettyPrint(true);
        }

        public B asyncPollInterval(Duration var1);

        public B asyncTimeout(Duration var1);

        public T build();
    }
}

