/*
 * Decompiled with CFR 0.152.
 */
package ai.docling.serve.api;

import ai.docling.serve.api.convert.request.ConvertDocumentRequest;
import ai.docling.serve.api.convert.response.ConvertDocumentResponse;
import ai.docling.serve.api.util.FileUtils;
import ai.docling.serve.api.util.ValidationUtils;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import org.jspecify.annotations.Nullable;

public interface DoclingServeConvertApi {
    public ConvertDocumentResponse convertSource(ConvertDocumentRequest var1);

    default public ConvertDocumentResponse convertFiles(Path ... files) {
        return this.convertFiles((ConvertDocumentRequest)null, files);
    }

    default public ConvertDocumentResponse convertFiles(@Nullable ConvertDocumentRequest request, Path ... files) {
        return this.convertSource(this.createRequest(request, files));
    }

    public CompletionStage<ConvertDocumentResponse> convertSourceAsync(ConvertDocumentRequest var1);

    default public CompletionStage<ConvertDocumentResponse> convertFilesAsync(Path ... files) {
        return this.convertFilesAsync((ConvertDocumentRequest)null, files);
    }

    default public CompletionStage<ConvertDocumentResponse> convertFilesAsync(@Nullable ConvertDocumentRequest request, Path ... files) {
        return this.convertSourceAsync(this.createRequest(request, files));
    }

    private ConvertDocumentRequest createRequest(@Nullable ConvertDocumentRequest request, Path ... files) {
        ValidationUtils.ensureNotEmpty(files, "files");
        ConvertDocumentRequest.Builder builder = Optional.ofNullable(request).map(ConvertDocumentRequest::toBuilder).orElseGet(ConvertDocumentRequest::builder);
        FileUtils.createFileSources(files).forEach(builder::source);
        return builder.build();
    }
}

