/*
 * Decompiled with CFR 0.152.
 */
package ai.docling.serve.api.chunk.request;

import ai.docling.serve.api.convert.request.options.ConvertDocumentOptions;
import ai.docling.serve.api.convert.request.source.Source;
import ai.docling.serve.api.convert.request.target.Target;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;
import tools.jackson.databind.annotation.JsonDeserialize;
import tools.jackson.databind.annotation.JsonPOJOBuilder;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=ChunkDocumentRequestBuilder.class)
public abstract class ChunkDocumentRequest {
    @JsonProperty(value="sources")
    @JsonSetter(nulls=Nulls.AS_EMPTY)
    private final List<Source> sources;
    @JsonProperty(value="convert_options")
    @NonNull
    private final ConvertDocumentOptions options;
    @JsonProperty(value="target")
    private final @Nullable Target target;
    @JsonProperty(value="include_converted_doc")
    private final boolean includeConvertedDoc;

    private static ConvertDocumentOptions $default$options() {
        return ConvertDocumentOptions.builder().build();
    }

    protected ChunkDocumentRequest(Builder<?, ?> b) {
        this.sources = switch (b.sources == null ? 0 : b.sources.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.sources.get(0));
            default -> Collections.unmodifiableList(new ArrayList<Source>(b.sources));
        };
        this.options = b.options$set ? b.options$value : ChunkDocumentRequest.$default$options();
        if (this.options == null) {
            throw new IllegalArgumentException("options is marked non-null but is null");
        }
        this.target = b.target;
        this.includeConvertedDoc = b.includeConvertedDoc;
    }

    public List<Source> getSources() {
        return this.sources;
    }

    @NonNull
    public ConvertDocumentOptions getOptions() {
        return this.options;
    }

    public @Nullable Target getTarget() {
        return this.target;
    }

    public boolean isIncludeConvertedDoc() {
        return this.includeConvertedDoc;
    }

    public @org.jspecify.annotations.NonNull String toString() {
        return "ChunkDocumentRequest(sources=" + String.valueOf(this.getSources()) + ", options=" + String.valueOf(this.getOptions()) + ", target=" + String.valueOf(this.getTarget()) + ", includeConvertedDoc=" + this.isIncludeConvertedDoc() + ")";
    }

    public static abstract class Builder<C extends ChunkDocumentRequest, B extends Builder<C, B>> {
        private ArrayList<Source> sources;
        private boolean options$set;
        private ConvertDocumentOptions options$value;
        private Target target;
        private boolean includeConvertedDoc;

        protected B $fillValuesFrom(C instance) {
            Builder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(ChunkDocumentRequest instance, Builder<?, ?> b) {
            b.sources(instance.sources == null ? Collections.emptyList() : instance.sources);
            b.options(instance.options);
            b.target(instance.target);
            b.includeConvertedDoc(instance.includeConvertedDoc);
        }

        public @org.jspecify.annotations.NonNull B source(Source source) {
            if (this.sources == null) {
                this.sources = new ArrayList();
            }
            this.sources.add(source);
            return this.self();
        }

        @JsonProperty(value="sources")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        public @org.jspecify.annotations.NonNull B sources(@org.jspecify.annotations.NonNull Collection<? extends Source> sources) {
            if (sources == null) {
                throw new IllegalArgumentException("sources cannot be null");
            }
            if (this.sources == null) {
                this.sources = new ArrayList();
            }
            this.sources.addAll(sources);
            return this.self();
        }

        public @org.jspecify.annotations.NonNull B clearSources() {
            if (this.sources != null) {
                this.sources.clear();
            }
            return this.self();
        }

        @JsonProperty(value="convert_options")
        public @org.jspecify.annotations.NonNull B options(@NonNull ConvertDocumentOptions options) {
            if (options == null) {
                throw new IllegalArgumentException("options is marked non-null but is null");
            }
            this.options$value = options;
            this.options$set = true;
            return this.self();
        }

        @JsonProperty(value="target")
        public @org.jspecify.annotations.NonNull B target(@Nullable Target target) {
            this.target = target;
            return this.self();
        }

        @JsonProperty(value="include_converted_doc")
        public @org.jspecify.annotations.NonNull B includeConvertedDoc(boolean includeConvertedDoc) {
            this.includeConvertedDoc = includeConvertedDoc;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public @org.jspecify.annotations.NonNull String toString() {
            return "ChunkDocumentRequest.Builder(sources=" + String.valueOf(this.sources) + ", options$value=" + String.valueOf(this.options$value) + ", target=" + String.valueOf(this.target) + ", includeConvertedDoc=" + this.includeConvertedDoc + ")";
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static abstract class ChunkDocumentRequestBuilder<C extends ChunkDocumentRequest, B extends ChunkDocumentRequestBuilder<C, B>> {
    }
}

