/*
 * Decompiled with CFR 0.152.
 */
package ai.docling.serve.api.chunk.request.options;

import ai.docling.serve.api.chunk.request.options.ChunkerOptions;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import tools.jackson.databind.annotation.JsonDeserialize;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder=Builder.class)
public final class HybridChunkerOptions
extends ChunkerOptions {
    @JsonProperty(value="use_markdown_tables")
    private final boolean useMarkdownTables;
    @JsonProperty(value="include_raw_text")
    private final boolean includeRawText;
    @JsonProperty(value="max_tokens")
    private final @Nullable Integer maxTokens;
    @JsonProperty(value="tokenizer")
    private final @Nullable String tokenizer;
    @JsonProperty(value="merge_peers")
    private final Boolean mergePeers;

    HybridChunkerOptions(boolean useMarkdownTables, boolean includeRawText, @Nullable Integer maxTokens, @Nullable String tokenizer, Boolean mergePeers) {
        this.useMarkdownTables = useMarkdownTables;
        this.includeRawText = includeRawText;
        this.maxTokens = maxTokens;
        this.tokenizer = tokenizer;
        this.mergePeers = mergePeers;
    }

    public static @NonNull Builder builder() {
        return new Builder();
    }

    public @NonNull Builder toBuilder() {
        return new Builder().useMarkdownTables(this.useMarkdownTables).includeRawText(this.includeRawText).maxTokens(this.maxTokens).tokenizer(this.tokenizer).mergePeers(this.mergePeers);
    }

    public boolean isUseMarkdownTables() {
        return this.useMarkdownTables;
    }

    public boolean isIncludeRawText() {
        return this.includeRawText;
    }

    public @Nullable Integer getMaxTokens() {
        return this.maxTokens;
    }

    public @Nullable String getTokenizer() {
        return this.tokenizer;
    }

    public Boolean getMergePeers() {
        return this.mergePeers;
    }

    @Override
    public @NonNull String toString() {
        return "HybridChunkerOptions(useMarkdownTables=" + this.isUseMarkdownTables() + ", includeRawText=" + this.isIncludeRawText() + ", maxTokens=" + this.getMaxTokens() + ", tokenizer=" + this.getTokenizer() + ", mergePeers=" + this.getMergePeers() + ")";
    }

    @tools.jackson.databind.annotation.JsonPOJOBuilder(withPrefix="")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class Builder {
        private boolean useMarkdownTables;
        private boolean includeRawText;
        private Integer maxTokens;
        private String tokenizer;
        private Boolean mergePeers;

        Builder() {
        }

        @JsonProperty(value="use_markdown_tables")
        public @NonNull Builder useMarkdownTables(boolean useMarkdownTables) {
            this.useMarkdownTables = useMarkdownTables;
            return this;
        }

        @JsonProperty(value="include_raw_text")
        public @NonNull Builder includeRawText(boolean includeRawText) {
            this.includeRawText = includeRawText;
            return this;
        }

        @JsonProperty(value="max_tokens")
        public @NonNull Builder maxTokens(@Nullable Integer maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        @JsonProperty(value="tokenizer")
        public @NonNull Builder tokenizer(@Nullable String tokenizer) {
            this.tokenizer = tokenizer;
            return this;
        }

        @JsonProperty(value="merge_peers")
        public @NonNull Builder mergePeers(Boolean mergePeers) {
            this.mergePeers = mergePeers;
            return this;
        }

        public @NonNull HybridChunkerOptions build() {
            return new HybridChunkerOptions(this.useMarkdownTables, this.includeRawText, this.maxTokens, this.tokenizer, this.mergePeers);
        }

        public @NonNull String toString() {
            return "HybridChunkerOptions.Builder(useMarkdownTables=" + this.useMarkdownTables + ", includeRawText=" + this.includeRawText + ", maxTokens=" + this.maxTokens + ", tokenizer=" + this.tokenizer + ", mergePeers=" + this.mergePeers + ")";
        }
    }
}

