/*
 * Decompiled with CFR 0.152.
 */
package ai.docling.serve.api.chunk.response;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import tools.jackson.databind.annotation.JsonDeserialize;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder=Builder.class)
public class Chunk {
    @JsonProperty(value="filename")
    private final String filename;
    @JsonProperty(value="chunk_index")
    private final int chunkIndex;
    @JsonProperty(value="text")
    private final String text;
    @JsonProperty(value="raw_text")
    private final @Nullable String rawText;
    @JsonProperty(value="num_tokens")
    private final Integer numTokens;
    @JsonProperty(value="headings")
    @JsonSetter(nulls=Nulls.AS_EMPTY)
    private final List<String> headings;
    @JsonProperty(value="captions")
    @JsonSetter(nulls=Nulls.AS_EMPTY)
    private final List<String> captions;
    @JsonProperty(value="doc_items")
    @JsonSetter(nulls=Nulls.AS_EMPTY)
    private final List<String> docItems;
    @JsonProperty(value="page_numbers")
    @JsonSetter(nulls=Nulls.AS_EMPTY)
    private final List<Integer> pageNumbers;
    @JsonProperty(value="metadata")
    @JsonSetter(nulls=Nulls.AS_EMPTY)
    private final Map<String, Object> metadata;

    Chunk(String filename, int chunkIndex, String text, @Nullable String rawText, Integer numTokens, List<String> headings, List<String> captions, List<String> docItems, List<Integer> pageNumbers, Map<String, Object> metadata) {
        this.filename = filename;
        this.chunkIndex = chunkIndex;
        this.text = text;
        this.rawText = rawText;
        this.numTokens = numTokens;
        this.headings = headings;
        this.captions = captions;
        this.docItems = docItems;
        this.pageNumbers = pageNumbers;
        this.metadata = metadata;
    }

    public static @NonNull Builder builder() {
        return new Builder();
    }

    public @NonNull Builder toBuilder() {
        Builder builder = new Builder().filename(this.filename).chunkIndex(this.chunkIndex).text(this.text).rawText(this.rawText).numTokens(this.numTokens);
        if (this.headings != null) {
            builder.headings(this.headings);
        }
        if (this.captions != null) {
            builder.captions(this.captions);
        }
        if (this.docItems != null) {
            builder.docItems(this.docItems);
        }
        if (this.pageNumbers != null) {
            builder.pageNumbers(this.pageNumbers);
        }
        if (this.metadata != null) {
            builder.metadata(this.metadata);
        }
        return builder;
    }

    public String getFilename() {
        return this.filename;
    }

    public int getChunkIndex() {
        return this.chunkIndex;
    }

    public String getText() {
        return this.text;
    }

    public @Nullable String getRawText() {
        return this.rawText;
    }

    public Integer getNumTokens() {
        return this.numTokens;
    }

    public List<String> getHeadings() {
        return this.headings;
    }

    public List<String> getCaptions() {
        return this.captions;
    }

    public List<String> getDocItems() {
        return this.docItems;
    }

    public List<Integer> getPageNumbers() {
        return this.pageNumbers;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public @NonNull String toString() {
        return "Chunk(filename=" + this.getFilename() + ", chunkIndex=" + this.getChunkIndex() + ", text=" + this.getText() + ", rawText=" + this.getRawText() + ", numTokens=" + this.getNumTokens() + ", headings=" + String.valueOf(this.getHeadings()) + ", captions=" + String.valueOf(this.getCaptions()) + ", docItems=" + String.valueOf(this.getDocItems()) + ", pageNumbers=" + String.valueOf(this.getPageNumbers()) + ", metadata=" + String.valueOf(this.getMetadata()) + ")";
    }

    @tools.jackson.databind.annotation.JsonPOJOBuilder(withPrefix="")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class Builder {
        private String filename;
        private int chunkIndex;
        private String text;
        private String rawText;
        private Integer numTokens;
        private ArrayList<String> headings;
        private ArrayList<String> captions;
        private ArrayList<String> docItems;
        private ArrayList<Integer> pageNumbers;
        private ArrayList<String> metadata$key;
        private ArrayList<Object> metadata$value;

        Builder() {
        }

        @JsonProperty(value="filename")
        public @NonNull Builder filename(String filename) {
            this.filename = filename;
            return this;
        }

        @JsonProperty(value="chunk_index")
        public @NonNull Builder chunkIndex(int chunkIndex) {
            this.chunkIndex = chunkIndex;
            return this;
        }

        @JsonProperty(value="text")
        public @NonNull Builder text(String text) {
            this.text = text;
            return this;
        }

        @JsonProperty(value="raw_text")
        public @NonNull Builder rawText(@Nullable String rawText) {
            this.rawText = rawText;
            return this;
        }

        @JsonProperty(value="num_tokens")
        public @NonNull Builder numTokens(Integer numTokens) {
            this.numTokens = numTokens;
            return this;
        }

        public @NonNull Builder heading(String heading) {
            if (this.headings == null) {
                this.headings = new ArrayList();
            }
            this.headings.add(heading);
            return this;
        }

        @JsonProperty(value="headings")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        public @NonNull Builder headings(@NonNull Collection<? extends String> headings) {
            if (headings == null) {
                throw new IllegalArgumentException("headings cannot be null");
            }
            if (this.headings == null) {
                this.headings = new ArrayList();
            }
            this.headings.addAll(headings);
            return this;
        }

        public @NonNull Builder clearHeadings() {
            if (this.headings != null) {
                this.headings.clear();
            }
            return this;
        }

        public @NonNull Builder caption(String caption) {
            if (this.captions == null) {
                this.captions = new ArrayList();
            }
            this.captions.add(caption);
            return this;
        }

        @JsonProperty(value="captions")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        public @NonNull Builder captions(@NonNull Collection<? extends String> captions) {
            if (captions == null) {
                throw new IllegalArgumentException("captions cannot be null");
            }
            if (this.captions == null) {
                this.captions = new ArrayList();
            }
            this.captions.addAll(captions);
            return this;
        }

        public @NonNull Builder clearCaptions() {
            if (this.captions != null) {
                this.captions.clear();
            }
            return this;
        }

        public @NonNull Builder docItem(String docItem) {
            if (this.docItems == null) {
                this.docItems = new ArrayList();
            }
            this.docItems.add(docItem);
            return this;
        }

        @JsonProperty(value="doc_items")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        public @NonNull Builder docItems(@NonNull Collection<? extends String> docItems) {
            if (docItems == null) {
                throw new IllegalArgumentException("docItems cannot be null");
            }
            if (this.docItems == null) {
                this.docItems = new ArrayList();
            }
            this.docItems.addAll(docItems);
            return this;
        }

        public @NonNull Builder clearDocItems() {
            if (this.docItems != null) {
                this.docItems.clear();
            }
            return this;
        }

        public @NonNull Builder pageNumber(Integer pageNumber) {
            if (this.pageNumbers == null) {
                this.pageNumbers = new ArrayList();
            }
            this.pageNumbers.add(pageNumber);
            return this;
        }

        @JsonProperty(value="page_numbers")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        public @NonNull Builder pageNumbers(@NonNull Collection<? extends Integer> pageNumbers) {
            if (pageNumbers == null) {
                throw new IllegalArgumentException("pageNumbers cannot be null");
            }
            if (this.pageNumbers == null) {
                this.pageNumbers = new ArrayList();
            }
            this.pageNumbers.addAll(pageNumbers);
            return this;
        }

        public @NonNull Builder clearPageNumbers() {
            if (this.pageNumbers != null) {
                this.pageNumbers.clear();
            }
            return this;
        }

        public @NonNull Builder metadata(String metadataKey, Object metadataValue) {
            if (this.metadata$key == null) {
                this.metadata$key = new ArrayList();
                this.metadata$value = new ArrayList();
            }
            this.metadata$key.add(metadataKey);
            this.metadata$value.add(metadataValue);
            return this;
        }

        @JsonProperty(value="metadata")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        public @NonNull Builder metadata(@NonNull Map<? extends String, ? extends Object> metadata) {
            if (metadata == null) {
                throw new IllegalArgumentException("metadata cannot be null");
            }
            if (this.metadata$key == null) {
                this.metadata$key = new ArrayList();
                this.metadata$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : metadata.entrySet()) {
                this.metadata$key.add($lombokEntry.getKey());
                this.metadata$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public @NonNull Builder clearMetadata() {
            if (this.metadata$key != null) {
                this.metadata$key.clear();
                this.metadata$value.clear();
            }
            return this;
        }

        public @NonNull Chunk build() {
            Map<String, Object> metadata;
            List<String> headings = switch (this.headings == null ? 0 : this.headings.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.headings.get(0));
                default -> Collections.unmodifiableList(new ArrayList<String>(this.headings));
            };
            List<String> captions = switch (this.captions == null ? 0 : this.captions.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.captions.get(0));
                default -> Collections.unmodifiableList(new ArrayList<String>(this.captions));
            };
            List<String> docItems = switch (this.docItems == null ? 0 : this.docItems.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.docItems.get(0));
                default -> Collections.unmodifiableList(new ArrayList<String>(this.docItems));
            };
            List<Integer> pageNumbers = switch (this.pageNumbers == null ? 0 : this.pageNumbers.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.pageNumbers.get(0));
                default -> Collections.unmodifiableList(new ArrayList<Integer>(this.pageNumbers));
            };
            switch (this.metadata$key == null ? 0 : this.metadata$key.size()) {
                case 0: {
                    metadata = Collections.emptyMap();
                    break;
                }
                case 1: {
                    metadata = Collections.singletonMap(this.metadata$key.get(0), this.metadata$value.get(0));
                    break;
                }
                default: {
                    metadata = new LinkedHashMap(this.metadata$key.size() < 0x40000000 ? 1 + this.metadata$key.size() + (this.metadata$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.metadata$key.size(); ++$i) {
                        metadata.put(this.metadata$key.get($i), this.metadata$value.get($i));
                    }
                    metadata = Collections.unmodifiableMap(metadata);
                }
            }
            return new Chunk(this.filename, this.chunkIndex, this.text, this.rawText, this.numTokens, headings, captions, docItems, pageNumbers, metadata);
        }

        public @NonNull String toString() {
            return "Chunk.Builder(filename=" + this.filename + ", chunkIndex=" + this.chunkIndex + ", text=" + this.text + ", rawText=" + this.rawText + ", numTokens=" + this.numTokens + ", headings=" + String.valueOf(this.headings) + ", captions=" + String.valueOf(this.captions) + ", docItems=" + String.valueOf(this.docItems) + ", pageNumbers=" + String.valueOf(this.pageNumbers) + ", metadata$key=" + String.valueOf(this.metadata$key) + ", metadata$value=" + String.valueOf(this.metadata$value) + ")";
        }
    }
}

