/*
 * Decompiled with CFR 0.152.
 */
package ai.docling.serve.api.chunk.response;

import ai.docling.serve.api.chunk.response.Chunk;
import ai.docling.serve.api.chunk.response.Document;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jspecify.annotations.NonNull;
import tools.jackson.databind.annotation.JsonDeserialize;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder=Builder.class)
public class ChunkDocumentResponse {
    @JsonProperty(value="chunks")
    @JsonSetter(nulls=Nulls.AS_EMPTY)
    private final List<Chunk> chunks;
    @JsonProperty(value="documents")
    @JsonSetter(nulls=Nulls.AS_EMPTY)
    private final List<Document> documents;
    @JsonProperty(value="processing_time")
    private final Double processingTime;

    ChunkDocumentResponse(List<Chunk> chunks, List<Document> documents, Double processingTime) {
        this.chunks = chunks;
        this.documents = documents;
        this.processingTime = processingTime;
    }

    public static @NonNull Builder builder() {
        return new Builder();
    }

    public @NonNull Builder toBuilder() {
        Builder builder = new Builder().processingTime(this.processingTime);
        if (this.chunks != null) {
            builder.chunks(this.chunks);
        }
        if (this.documents != null) {
            builder.documents(this.documents);
        }
        return builder;
    }

    public List<Chunk> getChunks() {
        return this.chunks;
    }

    public List<Document> getDocuments() {
        return this.documents;
    }

    public Double getProcessingTime() {
        return this.processingTime;
    }

    public @NonNull String toString() {
        return "ChunkDocumentResponse(chunks=" + String.valueOf(this.getChunks()) + ", documents=" + String.valueOf(this.getDocuments()) + ", processingTime=" + this.getProcessingTime() + ")";
    }

    @tools.jackson.databind.annotation.JsonPOJOBuilder(withPrefix="")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class Builder {
        private ArrayList<Chunk> chunks;
        private ArrayList<Document> documents;
        private Double processingTime;

        Builder() {
        }

        public @NonNull Builder chunk(Chunk chunk) {
            if (this.chunks == null) {
                this.chunks = new ArrayList();
            }
            this.chunks.add(chunk);
            return this;
        }

        @JsonProperty(value="chunks")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        public @NonNull Builder chunks(@NonNull Collection<? extends Chunk> chunks) {
            if (chunks == null) {
                throw new IllegalArgumentException("chunks cannot be null");
            }
            if (this.chunks == null) {
                this.chunks = new ArrayList();
            }
            this.chunks.addAll(chunks);
            return this;
        }

        public @NonNull Builder clearChunks() {
            if (this.chunks != null) {
                this.chunks.clear();
            }
            return this;
        }

        public @NonNull Builder document(Document document) {
            if (this.documents == null) {
                this.documents = new ArrayList();
            }
            this.documents.add(document);
            return this;
        }

        @JsonProperty(value="documents")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        public @NonNull Builder documents(@NonNull Collection<? extends Document> documents) {
            if (documents == null) {
                throw new IllegalArgumentException("documents cannot be null");
            }
            if (this.documents == null) {
                this.documents = new ArrayList();
            }
            this.documents.addAll(documents);
            return this;
        }

        public @NonNull Builder clearDocuments() {
            if (this.documents != null) {
                this.documents.clear();
            }
            return this;
        }

        @JsonProperty(value="processing_time")
        public @NonNull Builder processingTime(Double processingTime) {
            this.processingTime = processingTime;
            return this;
        }

        public @NonNull ChunkDocumentResponse build() {
            return new ChunkDocumentResponse(switch (this.chunks == null ? 0 : this.chunks.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.chunks.get(0));
                default -> Collections.unmodifiableList(new ArrayList<Chunk>(this.chunks));
            }, switch (this.documents == null ? 0 : this.documents.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.documents.get(0));
                default -> Collections.unmodifiableList(new ArrayList<Document>(this.documents));
            }, this.processingTime);
        }

        public @NonNull String toString() {
            return "ChunkDocumentResponse.Builder(chunks=" + String.valueOf(this.chunks) + ", documents=" + String.valueOf(this.documents) + ", processingTime=" + this.processingTime + ")";
        }
    }
}

