/*
 * Decompiled with CFR 0.152.
 */
package ai.docling.serve.api.convert.request.options;

import ai.docling.serve.api.convert.request.options.ImageRefMode;
import ai.docling.serve.api.convert.request.options.InputFormat;
import ai.docling.serve.api.convert.request.options.OcrEngine;
import ai.docling.serve.api.convert.request.options.OutputFormat;
import ai.docling.serve.api.convert.request.options.PdfBackend;
import ai.docling.serve.api.convert.request.options.PictureDescriptionApi;
import ai.docling.serve.api.convert.request.options.PictureDescriptionLocal;
import ai.docling.serve.api.convert.request.options.ProcessingPipeline;
import ai.docling.serve.api.convert.request.options.TableFormerMode;
import ai.docling.serve.api.convert.request.options.VlmModelType;
import ai.docling.serve.api.serialization.DurationSerializationFormat;
import ai.docling.serve.api.serialization.Jackson2DurationSerializer;
import ai.docling.serve.api.serialization.Jackson3DurationSerializer;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import tools.jackson.databind.annotation.JsonDeserialize;
import tools.jackson.databind.annotation.JsonSerialize;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder=Builder.class)
public class ConvertDocumentOptions {
    @JsonProperty(value="from_formats")
    @JsonSetter(nulls=Nulls.AS_EMPTY)
    private final List<InputFormat> fromFormats;
    @JsonProperty(value="to_formats")
    @JsonSetter(nulls=Nulls.AS_EMPTY)
    private final List<OutputFormat> toFormats;
    @JsonProperty(value="image_export_mode")
    private final @Nullable ImageRefMode imageExportMode;
    @JsonProperty(value="do_ocr")
    private final @Nullable Boolean doOcr;
    @JsonProperty(value="force_ocr")
    private final @Nullable Boolean forceOcr;
    @JsonProperty(value="ocr_engine")
    private final @Nullable OcrEngine ocrEngine;
    @JsonProperty(value="ocr_lang")
    @JsonSetter(nulls=Nulls.AS_EMPTY)
    private final List<String> ocrLang;
    @JsonProperty(value="pdf_backend")
    private final @Nullable PdfBackend pdfBackend;
    @JsonProperty(value="table_mode")
    private final @Nullable TableFormerMode tableMode;
    @JsonProperty(value="table_cell_matching")
    private final @Nullable Boolean tableCellMatching;
    @JsonProperty(value="pipeline")
    private final @Nullable ProcessingPipeline pipeline;
    @JsonProperty(value="page_range")
    @JsonSetter(nulls=Nulls.AS_EMPTY)
    private final List<Integer> pageRange;
    @JsonProperty(value="document_timeout")
    @com.fasterxml.jackson.databind.annotation.JsonSerialize(using=Jackson2DurationSerializer.class)
    @JsonSerialize(using=Jackson3DurationSerializer.class)
    @DurationSerializationFormat(value=ChronoUnit.SECONDS)
    private final @Nullable Duration documentTimeout;
    @JsonProperty(value="abort_on_error")
    private final @Nullable Boolean abortOnError;
    @JsonProperty(value="do_table_structure")
    private final @Nullable Boolean doTableStructure;
    @JsonProperty(value="include_images")
    private final @Nullable Boolean includeImages;
    @JsonProperty(value="images_scale")
    private final @Nullable Double imagesScale;
    @JsonProperty(value="md_page_break_placeholder")
    private final @Nullable String mdPageBreakPlaceholder;
    @JsonProperty(value="do_code_enrichment")
    private final @Nullable Boolean doCodeEnrichment;
    @JsonProperty(value="do_formula_enrichment")
    private final @Nullable Boolean doFormulaEnrichment;
    @JsonProperty(value="do_picture_classification")
    private final @Nullable Boolean doPictureClassification;
    @JsonProperty(value="do_picture_description")
    private final @Nullable Boolean doPictureDescription;
    @JsonProperty(value="picture_description_area_threshold")
    private final @Nullable Double pictureDescriptionAreaThreshold;
    @JsonProperty(value="picture_description_local")
    private final @Nullable PictureDescriptionLocal pictureDescriptionLocal;
    @JsonProperty(value="picture_description_api")
    private final @Nullable PictureDescriptionApi pictureDescriptionApi;
    @JsonProperty(value="vlm_pipeline_model")
    private final @Nullable VlmModelType vlmPipelineModel;
    @JsonProperty(value="vlm_pipeline_model_local")
    private final @Nullable String vlmPipelineModelLocal;
    @JsonProperty(value="vlm_pipeline_model_api")
    private final @Nullable String vlmPipelineModelApi;

    ConvertDocumentOptions(List<InputFormat> fromFormats, List<OutputFormat> toFormats, @Nullable ImageRefMode imageExportMode, @Nullable Boolean doOcr, @Nullable Boolean forceOcr, @Nullable OcrEngine ocrEngine, List<String> ocrLang, @Nullable PdfBackend pdfBackend, @Nullable TableFormerMode tableMode, @Nullable Boolean tableCellMatching, @Nullable ProcessingPipeline pipeline, List<Integer> pageRange, @Nullable Duration documentTimeout, @Nullable Boolean abortOnError, @Nullable Boolean doTableStructure, @Nullable Boolean includeImages, @Nullable Double imagesScale, @Nullable String mdPageBreakPlaceholder, @Nullable Boolean doCodeEnrichment, @Nullable Boolean doFormulaEnrichment, @Nullable Boolean doPictureClassification, @Nullable Boolean doPictureDescription, @Nullable Double pictureDescriptionAreaThreshold, @Nullable PictureDescriptionLocal pictureDescriptionLocal, @Nullable PictureDescriptionApi pictureDescriptionApi, @Nullable VlmModelType vlmPipelineModel, @Nullable String vlmPipelineModelLocal, @Nullable String vlmPipelineModelApi) {
        this.fromFormats = fromFormats;
        this.toFormats = toFormats;
        this.imageExportMode = imageExportMode;
        this.doOcr = doOcr;
        this.forceOcr = forceOcr;
        this.ocrEngine = ocrEngine;
        this.ocrLang = ocrLang;
        this.pdfBackend = pdfBackend;
        this.tableMode = tableMode;
        this.tableCellMatching = tableCellMatching;
        this.pipeline = pipeline;
        this.pageRange = pageRange;
        this.documentTimeout = documentTimeout;
        this.abortOnError = abortOnError;
        this.doTableStructure = doTableStructure;
        this.includeImages = includeImages;
        this.imagesScale = imagesScale;
        this.mdPageBreakPlaceholder = mdPageBreakPlaceholder;
        this.doCodeEnrichment = doCodeEnrichment;
        this.doFormulaEnrichment = doFormulaEnrichment;
        this.doPictureClassification = doPictureClassification;
        this.doPictureDescription = doPictureDescription;
        this.pictureDescriptionAreaThreshold = pictureDescriptionAreaThreshold;
        this.pictureDescriptionLocal = pictureDescriptionLocal;
        this.pictureDescriptionApi = pictureDescriptionApi;
        this.vlmPipelineModel = vlmPipelineModel;
        this.vlmPipelineModelLocal = vlmPipelineModelLocal;
        this.vlmPipelineModelApi = vlmPipelineModelApi;
    }

    public static @NonNull Builder builder() {
        return new Builder();
    }

    public @NonNull Builder toBuilder() {
        Builder builder = new Builder().imageExportMode(this.imageExportMode).doOcr(this.doOcr).forceOcr(this.forceOcr).ocrEngine(this.ocrEngine).pdfBackend(this.pdfBackend).tableMode(this.tableMode).tableCellMatching(this.tableCellMatching).pipeline(this.pipeline).documentTimeout(this.documentTimeout).abortOnError(this.abortOnError).doTableStructure(this.doTableStructure).includeImages(this.includeImages).imagesScale(this.imagesScale).mdPageBreakPlaceholder(this.mdPageBreakPlaceholder).doCodeEnrichment(this.doCodeEnrichment).doFormulaEnrichment(this.doFormulaEnrichment).doPictureClassification(this.doPictureClassification).doPictureDescription(this.doPictureDescription).pictureDescriptionAreaThreshold(this.pictureDescriptionAreaThreshold).pictureDescriptionLocal(this.pictureDescriptionLocal).pictureDescriptionApi(this.pictureDescriptionApi).vlmPipelineModel(this.vlmPipelineModel).vlmPipelineModelLocal(this.vlmPipelineModelLocal).vlmPipelineModelApi(this.vlmPipelineModelApi);
        if (this.fromFormats != null) {
            builder.fromFormats(this.fromFormats);
        }
        if (this.toFormats != null) {
            builder.toFormats(this.toFormats);
        }
        if (this.ocrLang != null) {
            builder.ocrLang(this.ocrLang);
        }
        if (this.pageRange != null) {
            builder.pageRange(this.pageRange);
        }
        return builder;
    }

    public List<InputFormat> getFromFormats() {
        return this.fromFormats;
    }

    public List<OutputFormat> getToFormats() {
        return this.toFormats;
    }

    public @Nullable ImageRefMode getImageExportMode() {
        return this.imageExportMode;
    }

    public @Nullable Boolean getDoOcr() {
        return this.doOcr;
    }

    public @Nullable Boolean getForceOcr() {
        return this.forceOcr;
    }

    public @Nullable OcrEngine getOcrEngine() {
        return this.ocrEngine;
    }

    public List<String> getOcrLang() {
        return this.ocrLang;
    }

    public @Nullable PdfBackend getPdfBackend() {
        return this.pdfBackend;
    }

    public @Nullable TableFormerMode getTableMode() {
        return this.tableMode;
    }

    public @Nullable Boolean getTableCellMatching() {
        return this.tableCellMatching;
    }

    public @Nullable ProcessingPipeline getPipeline() {
        return this.pipeline;
    }

    public List<Integer> getPageRange() {
        return this.pageRange;
    }

    public @Nullable Duration getDocumentTimeout() {
        return this.documentTimeout;
    }

    public @Nullable Boolean getAbortOnError() {
        return this.abortOnError;
    }

    public @Nullable Boolean getDoTableStructure() {
        return this.doTableStructure;
    }

    public @Nullable Boolean getIncludeImages() {
        return this.includeImages;
    }

    public @Nullable Double getImagesScale() {
        return this.imagesScale;
    }

    public @Nullable String getMdPageBreakPlaceholder() {
        return this.mdPageBreakPlaceholder;
    }

    public @Nullable Boolean getDoCodeEnrichment() {
        return this.doCodeEnrichment;
    }

    public @Nullable Boolean getDoFormulaEnrichment() {
        return this.doFormulaEnrichment;
    }

    public @Nullable Boolean getDoPictureClassification() {
        return this.doPictureClassification;
    }

    public @Nullable Boolean getDoPictureDescription() {
        return this.doPictureDescription;
    }

    public @Nullable Double getPictureDescriptionAreaThreshold() {
        return this.pictureDescriptionAreaThreshold;
    }

    public @Nullable PictureDescriptionLocal getPictureDescriptionLocal() {
        return this.pictureDescriptionLocal;
    }

    public @Nullable PictureDescriptionApi getPictureDescriptionApi() {
        return this.pictureDescriptionApi;
    }

    public @Nullable VlmModelType getVlmPipelineModel() {
        return this.vlmPipelineModel;
    }

    public @Nullable String getVlmPipelineModelLocal() {
        return this.vlmPipelineModelLocal;
    }

    public @Nullable String getVlmPipelineModelApi() {
        return this.vlmPipelineModelApi;
    }

    public @NonNull String toString() {
        return "ConvertDocumentOptions(fromFormats=" + String.valueOf(this.getFromFormats()) + ", toFormats=" + String.valueOf(this.getToFormats()) + ", imageExportMode=" + String.valueOf((Object)this.getImageExportMode()) + ", doOcr=" + this.getDoOcr() + ", forceOcr=" + this.getForceOcr() + ", ocrEngine=" + String.valueOf((Object)this.getOcrEngine()) + ", ocrLang=" + String.valueOf(this.getOcrLang()) + ", pdfBackend=" + String.valueOf((Object)this.getPdfBackend()) + ", tableMode=" + String.valueOf((Object)this.getTableMode()) + ", tableCellMatching=" + this.getTableCellMatching() + ", pipeline=" + String.valueOf((Object)this.getPipeline()) + ", pageRange=" + String.valueOf(this.getPageRange()) + ", documentTimeout=" + String.valueOf(this.getDocumentTimeout()) + ", abortOnError=" + this.getAbortOnError() + ", doTableStructure=" + this.getDoTableStructure() + ", includeImages=" + this.getIncludeImages() + ", imagesScale=" + this.getImagesScale() + ", mdPageBreakPlaceholder=" + this.getMdPageBreakPlaceholder() + ", doCodeEnrichment=" + this.getDoCodeEnrichment() + ", doFormulaEnrichment=" + this.getDoFormulaEnrichment() + ", doPictureClassification=" + this.getDoPictureClassification() + ", doPictureDescription=" + this.getDoPictureDescription() + ", pictureDescriptionAreaThreshold=" + this.getPictureDescriptionAreaThreshold() + ", pictureDescriptionLocal=" + String.valueOf(this.getPictureDescriptionLocal()) + ", pictureDescriptionApi=" + String.valueOf(this.getPictureDescriptionApi()) + ", vlmPipelineModel=" + String.valueOf((Object)this.getVlmPipelineModel()) + ", vlmPipelineModelLocal=" + this.getVlmPipelineModelLocal() + ", vlmPipelineModelApi=" + this.getVlmPipelineModelApi() + ")";
    }

    @tools.jackson.databind.annotation.JsonPOJOBuilder(withPrefix="")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class Builder {
        private ArrayList<InputFormat> fromFormats;
        private ArrayList<OutputFormat> toFormats;
        private ImageRefMode imageExportMode;
        private Boolean doOcr;
        private Boolean forceOcr;
        private OcrEngine ocrEngine;
        private ArrayList<String> ocrLang;
        private PdfBackend pdfBackend;
        private TableFormerMode tableMode;
        private Boolean tableCellMatching;
        private ProcessingPipeline pipeline;
        private ArrayList<Integer> pageRange;
        private Duration documentTimeout;
        private Boolean abortOnError;
        private Boolean doTableStructure;
        private Boolean includeImages;
        private Double imagesScale;
        private String mdPageBreakPlaceholder;
        private Boolean doCodeEnrichment;
        private Boolean doFormulaEnrichment;
        private Boolean doPictureClassification;
        private Boolean doPictureDescription;
        private Double pictureDescriptionAreaThreshold;
        private PictureDescriptionLocal pictureDescriptionLocal;
        private PictureDescriptionApi pictureDescriptionApi;
        private VlmModelType vlmPipelineModel;
        private String vlmPipelineModelLocal;
        private String vlmPipelineModelApi;

        Builder() {
        }

        public @NonNull Builder fromFormat(InputFormat fromFormat) {
            if (this.fromFormats == null) {
                this.fromFormats = new ArrayList();
            }
            this.fromFormats.add(fromFormat);
            return this;
        }

        @JsonProperty(value="from_formats")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        public @NonNull Builder fromFormats(@NonNull Collection<? extends InputFormat> fromFormats) {
            if (fromFormats == null) {
                throw new IllegalArgumentException("fromFormats cannot be null");
            }
            if (this.fromFormats == null) {
                this.fromFormats = new ArrayList();
            }
            this.fromFormats.addAll(fromFormats);
            return this;
        }

        public @NonNull Builder clearFromFormats() {
            if (this.fromFormats != null) {
                this.fromFormats.clear();
            }
            return this;
        }

        public @NonNull Builder toFormat(OutputFormat toFormat) {
            if (this.toFormats == null) {
                this.toFormats = new ArrayList();
            }
            this.toFormats.add(toFormat);
            return this;
        }

        @JsonProperty(value="to_formats")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        public @NonNull Builder toFormats(@NonNull Collection<? extends OutputFormat> toFormats) {
            if (toFormats == null) {
                throw new IllegalArgumentException("toFormats cannot be null");
            }
            if (this.toFormats == null) {
                this.toFormats = new ArrayList();
            }
            this.toFormats.addAll(toFormats);
            return this;
        }

        public @NonNull Builder clearToFormats() {
            if (this.toFormats != null) {
                this.toFormats.clear();
            }
            return this;
        }

        @JsonProperty(value="image_export_mode")
        public @NonNull Builder imageExportMode(@Nullable ImageRefMode imageExportMode) {
            this.imageExportMode = imageExportMode;
            return this;
        }

        @JsonProperty(value="do_ocr")
        public @NonNull Builder doOcr(@Nullable Boolean doOcr) {
            this.doOcr = doOcr;
            return this;
        }

        @JsonProperty(value="force_ocr")
        public @NonNull Builder forceOcr(@Nullable Boolean forceOcr) {
            this.forceOcr = forceOcr;
            return this;
        }

        @JsonProperty(value="ocr_engine")
        public @NonNull Builder ocrEngine(@Nullable OcrEngine ocrEngine) {
            this.ocrEngine = ocrEngine;
            return this;
        }

        public @NonNull Builder ocrLang(String ocrLang) {
            if (this.ocrLang == null) {
                this.ocrLang = new ArrayList();
            }
            this.ocrLang.add(ocrLang);
            return this;
        }

        @JsonProperty(value="ocr_lang")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        public @NonNull Builder ocrLang(@NonNull Collection<? extends String> ocrLang) {
            if (ocrLang == null) {
                throw new IllegalArgumentException("ocrLang cannot be null");
            }
            if (this.ocrLang == null) {
                this.ocrLang = new ArrayList();
            }
            this.ocrLang.addAll(ocrLang);
            return this;
        }

        public @NonNull Builder clearOcrLang() {
            if (this.ocrLang != null) {
                this.ocrLang.clear();
            }
            return this;
        }

        @JsonProperty(value="pdf_backend")
        public @NonNull Builder pdfBackend(@Nullable PdfBackend pdfBackend) {
            this.pdfBackend = pdfBackend;
            return this;
        }

        @JsonProperty(value="table_mode")
        public @NonNull Builder tableMode(@Nullable TableFormerMode tableMode) {
            this.tableMode = tableMode;
            return this;
        }

        @JsonProperty(value="table_cell_matching")
        public @NonNull Builder tableCellMatching(@Nullable Boolean tableCellMatching) {
            this.tableCellMatching = tableCellMatching;
            return this;
        }

        @JsonProperty(value="pipeline")
        public @NonNull Builder pipeline(@Nullable ProcessingPipeline pipeline) {
            this.pipeline = pipeline;
            return this;
        }

        public @NonNull Builder pageRange(Integer pageRange) {
            if (this.pageRange == null) {
                this.pageRange = new ArrayList();
            }
            this.pageRange.add(pageRange);
            return this;
        }

        @JsonProperty(value="page_range")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        public @NonNull Builder pageRange(@NonNull Collection<? extends Integer> pageRange) {
            if (pageRange == null) {
                throw new IllegalArgumentException("pageRange cannot be null");
            }
            if (this.pageRange == null) {
                this.pageRange = new ArrayList();
            }
            this.pageRange.addAll(pageRange);
            return this;
        }

        public @NonNull Builder clearPageRange() {
            if (this.pageRange != null) {
                this.pageRange.clear();
            }
            return this;
        }

        @JsonProperty(value="document_timeout")
        public @NonNull Builder documentTimeout(@Nullable Duration documentTimeout) {
            this.documentTimeout = documentTimeout;
            return this;
        }

        @JsonProperty(value="abort_on_error")
        public @NonNull Builder abortOnError(@Nullable Boolean abortOnError) {
            this.abortOnError = abortOnError;
            return this;
        }

        @JsonProperty(value="do_table_structure")
        public @NonNull Builder doTableStructure(@Nullable Boolean doTableStructure) {
            this.doTableStructure = doTableStructure;
            return this;
        }

        @JsonProperty(value="include_images")
        public @NonNull Builder includeImages(@Nullable Boolean includeImages) {
            this.includeImages = includeImages;
            return this;
        }

        @JsonProperty(value="images_scale")
        public @NonNull Builder imagesScale(@Nullable Double imagesScale) {
            this.imagesScale = imagesScale;
            return this;
        }

        @JsonProperty(value="md_page_break_placeholder")
        public @NonNull Builder mdPageBreakPlaceholder(@Nullable String mdPageBreakPlaceholder) {
            this.mdPageBreakPlaceholder = mdPageBreakPlaceholder;
            return this;
        }

        @JsonProperty(value="do_code_enrichment")
        public @NonNull Builder doCodeEnrichment(@Nullable Boolean doCodeEnrichment) {
            this.doCodeEnrichment = doCodeEnrichment;
            return this;
        }

        @JsonProperty(value="do_formula_enrichment")
        public @NonNull Builder doFormulaEnrichment(@Nullable Boolean doFormulaEnrichment) {
            this.doFormulaEnrichment = doFormulaEnrichment;
            return this;
        }

        @JsonProperty(value="do_picture_classification")
        public @NonNull Builder doPictureClassification(@Nullable Boolean doPictureClassification) {
            this.doPictureClassification = doPictureClassification;
            return this;
        }

        @JsonProperty(value="do_picture_description")
        public @NonNull Builder doPictureDescription(@Nullable Boolean doPictureDescription) {
            this.doPictureDescription = doPictureDescription;
            return this;
        }

        @JsonProperty(value="picture_description_area_threshold")
        public @NonNull Builder pictureDescriptionAreaThreshold(@Nullable Double pictureDescriptionAreaThreshold) {
            this.pictureDescriptionAreaThreshold = pictureDescriptionAreaThreshold;
            return this;
        }

        @JsonProperty(value="picture_description_local")
        public @NonNull Builder pictureDescriptionLocal(@Nullable PictureDescriptionLocal pictureDescriptionLocal) {
            this.pictureDescriptionLocal = pictureDescriptionLocal;
            return this;
        }

        @JsonProperty(value="picture_description_api")
        public @NonNull Builder pictureDescriptionApi(@Nullable PictureDescriptionApi pictureDescriptionApi) {
            this.pictureDescriptionApi = pictureDescriptionApi;
            return this;
        }

        @JsonProperty(value="vlm_pipeline_model")
        public @NonNull Builder vlmPipelineModel(@Nullable VlmModelType vlmPipelineModel) {
            this.vlmPipelineModel = vlmPipelineModel;
            return this;
        }

        @JsonProperty(value="vlm_pipeline_model_local")
        public @NonNull Builder vlmPipelineModelLocal(@Nullable String vlmPipelineModelLocal) {
            this.vlmPipelineModelLocal = vlmPipelineModelLocal;
            return this;
        }

        @JsonProperty(value="vlm_pipeline_model_api")
        public @NonNull Builder vlmPipelineModelApi(@Nullable String vlmPipelineModelApi) {
            this.vlmPipelineModelApi = vlmPipelineModelApi;
            return this;
        }

        public @NonNull ConvertDocumentOptions build() {
            return new ConvertDocumentOptions(switch (this.fromFormats == null ? 0 : this.fromFormats.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.fromFormats.get(0));
                default -> Collections.unmodifiableList(new ArrayList<InputFormat>(this.fromFormats));
            }, switch (this.toFormats == null ? 0 : this.toFormats.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.toFormats.get(0));
                default -> Collections.unmodifiableList(new ArrayList<OutputFormat>(this.toFormats));
            }, this.imageExportMode, this.doOcr, this.forceOcr, this.ocrEngine, switch (this.ocrLang == null ? 0 : this.ocrLang.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.ocrLang.get(0));
                default -> Collections.unmodifiableList(new ArrayList<String>(this.ocrLang));
            }, this.pdfBackend, this.tableMode, this.tableCellMatching, this.pipeline, switch (this.pageRange == null ? 0 : this.pageRange.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.pageRange.get(0));
                default -> Collections.unmodifiableList(new ArrayList<Integer>(this.pageRange));
            }, this.documentTimeout, this.abortOnError, this.doTableStructure, this.includeImages, this.imagesScale, this.mdPageBreakPlaceholder, this.doCodeEnrichment, this.doFormulaEnrichment, this.doPictureClassification, this.doPictureDescription, this.pictureDescriptionAreaThreshold, this.pictureDescriptionLocal, this.pictureDescriptionApi, this.vlmPipelineModel, this.vlmPipelineModelLocal, this.vlmPipelineModelApi);
        }

        public @NonNull String toString() {
            return "ConvertDocumentOptions.Builder(fromFormats=" + String.valueOf(this.fromFormats) + ", toFormats=" + String.valueOf(this.toFormats) + ", imageExportMode=" + String.valueOf((Object)this.imageExportMode) + ", doOcr=" + this.doOcr + ", forceOcr=" + this.forceOcr + ", ocrEngine=" + String.valueOf((Object)this.ocrEngine) + ", ocrLang=" + String.valueOf(this.ocrLang) + ", pdfBackend=" + String.valueOf((Object)this.pdfBackend) + ", tableMode=" + String.valueOf((Object)this.tableMode) + ", tableCellMatching=" + this.tableCellMatching + ", pipeline=" + String.valueOf((Object)this.pipeline) + ", pageRange=" + String.valueOf(this.pageRange) + ", documentTimeout=" + String.valueOf(this.documentTimeout) + ", abortOnError=" + this.abortOnError + ", doTableStructure=" + this.doTableStructure + ", includeImages=" + this.includeImages + ", imagesScale=" + this.imagesScale + ", mdPageBreakPlaceholder=" + this.mdPageBreakPlaceholder + ", doCodeEnrichment=" + this.doCodeEnrichment + ", doFormulaEnrichment=" + this.doFormulaEnrichment + ", doPictureClassification=" + this.doPictureClassification + ", doPictureDescription=" + this.doPictureDescription + ", pictureDescriptionAreaThreshold=" + this.pictureDescriptionAreaThreshold + ", pictureDescriptionLocal=" + String.valueOf(this.pictureDescriptionLocal) + ", pictureDescriptionApi=" + String.valueOf(this.pictureDescriptionApi) + ", vlmPipelineModel=" + String.valueOf((Object)this.vlmPipelineModel) + ", vlmPipelineModelLocal=" + this.vlmPipelineModelLocal + ", vlmPipelineModelApi=" + this.vlmPipelineModelApi + ")";
        }
    }
}

