/*
 * Decompiled with CFR 0.152.
 */
package ai.docling.serve.api.convert.request.source;

import ai.docling.serve.api.convert.request.source.Source;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.NonNull;
import tools.jackson.databind.annotation.JsonDeserialize;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder=Builder.class)
public final class HttpSource
extends Source {
    @JsonProperty(value="url")
    @NonNull
    private final URI url;
    @JsonProperty(value="headers")
    @JsonSetter(nulls=Nulls.AS_EMPTY)
    private final Map<String, Object> headers;

    HttpSource(@NonNull URI url, Map<String, Object> headers) {
        if (url == null) {
            throw new IllegalArgumentException("url is marked non-null but is null");
        }
        this.url = url;
        this.headers = headers;
    }

    public static @org.jspecify.annotations.NonNull Builder builder() {
        return new Builder();
    }

    public @org.jspecify.annotations.NonNull Builder toBuilder() {
        Builder builder = new Builder().url(this.url);
        if (this.headers != null) {
            builder.headers(this.headers);
        }
        return builder;
    }

    @NonNull
    public URI getUrl() {
        return this.url;
    }

    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    @Override
    public @org.jspecify.annotations.NonNull String toString() {
        return "HttpSource(url=" + String.valueOf(this.getUrl()) + ", headers=" + String.valueOf(this.getHeaders()) + ")";
    }

    @tools.jackson.databind.annotation.JsonPOJOBuilder(withPrefix="")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class Builder {
        private URI url;
        private ArrayList<String> headers$key;
        private ArrayList<Object> headers$value;

        Builder() {
        }

        @JsonProperty(value="url")
        public @org.jspecify.annotations.NonNull Builder url(@NonNull URI url) {
            if (url == null) {
                throw new IllegalArgumentException("url is marked non-null but is null");
            }
            this.url = url;
            return this;
        }

        public @org.jspecify.annotations.NonNull Builder header(String headerKey, Object headerValue) {
            if (this.headers$key == null) {
                this.headers$key = new ArrayList();
                this.headers$value = new ArrayList();
            }
            this.headers$key.add(headerKey);
            this.headers$value.add(headerValue);
            return this;
        }

        @JsonProperty(value="headers")
        @JsonSetter(nulls=Nulls.AS_EMPTY)
        public @org.jspecify.annotations.NonNull Builder headers(@org.jspecify.annotations.NonNull Map<? extends String, ? extends Object> headers) {
            if (headers == null) {
                throw new IllegalArgumentException("headers cannot be null");
            }
            if (this.headers$key == null) {
                this.headers$key = new ArrayList();
                this.headers$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : headers.entrySet()) {
                this.headers$key.add($lombokEntry.getKey());
                this.headers$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public @org.jspecify.annotations.NonNull Builder clearHeaders() {
            if (this.headers$key != null) {
                this.headers$key.clear();
                this.headers$value.clear();
            }
            return this;
        }

        public @org.jspecify.annotations.NonNull HttpSource build() {
            Map<String, Object> headers;
            switch (this.headers$key == null ? 0 : this.headers$key.size()) {
                case 0: {
                    headers = Collections.emptyMap();
                    break;
                }
                case 1: {
                    headers = Collections.singletonMap(this.headers$key.get(0), this.headers$value.get(0));
                    break;
                }
                default: {
                    headers = new LinkedHashMap<String, Object>(this.headers$key.size() < 0x40000000 ? 1 + this.headers$key.size() + (this.headers$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.headers$key.size(); ++$i) {
                        headers.put(this.headers$key.get($i), this.headers$value.get($i));
                    }
                    headers = Collections.unmodifiableMap(headers);
                }
            }
            return new HttpSource(this.url, headers);
        }

        public @org.jspecify.annotations.NonNull String toString() {
            return "HttpSource.Builder(url=" + String.valueOf(this.url) + ", headers$key=" + String.valueOf(this.headers$key) + ", headers$value=" + String.valueOf(this.headers$value) + ")";
        }
    }
}

