/*
 * Decompiled with CFR 0.152.
 */
package ai.docling.serve.api.util;

import ai.docling.serve.api.util.Utils;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;

public final class ValidationUtils {
    private ValidationUtils() {
    }

    public static void ensureEq(Object lhs, Object rhs, String format, Object ... args) {
        if (!Objects.equals(lhs, rhs)) {
            throw new IllegalArgumentException(format.formatted(args));
        }
    }

    public static <T> T ensureNotNull(T object, String name) {
        return ValidationUtils.ensureNotNull(object, "%s cannot be null", name);
    }

    public static <T> T ensureNotNull(T object, String format, Object ... args) {
        if (object == null) {
            throw new IllegalArgumentException(format.formatted(args));
        }
        return object;
    }

    public static <T> Collection<T> ensureNotEmpty(Collection<T> collection, String name) {
        if (Utils.isNullOrEmpty(collection)) {
            throw new IllegalArgumentException("%s cannot be null or empty".formatted(name));
        }
        return collection;
    }

    public static <T> T[] ensureNotEmpty(T[] array, String name) {
        return ValidationUtils.ensureNotEmpty(array, "%s cannot be null or empty", name);
    }

    public static <T> T[] ensureNotEmpty(T[] array, String format, Object ... args) {
        if (array == null || array.length == 0) {
            throw new IllegalArgumentException(format.formatted(args));
        }
        return array;
    }

    public static <K, V> Map<K, V> ensureNotEmpty(Map<K, V> map, String name) {
        if (Utils.isNullOrEmpty(map)) {
            throw new IllegalArgumentException("%s cannot be null or empty".formatted(name));
        }
        return map;
    }

    public static String ensureNotEmpty(String string, String name) {
        return ValidationUtils.ensureNotEmpty(string, "%s cannot be null or empty", name);
    }

    public static String ensureNotEmpty(String string, String format, Object ... args) {
        if (Utils.isNullOrEmpty(string)) {
            throw new IllegalArgumentException(format.formatted(args));
        }
        return string;
    }

    public static String ensureNotBlank(String string, String name) {
        return ValidationUtils.ensureNotBlank(string, "%s cannot be null or blank", name);
    }

    public static String ensureNotBlank(String string, String format, Object ... args) {
        if (Utils.isNullOrBlank(string)) {
            throw new IllegalArgumentException(format.formatted(args));
        }
        return string;
    }

    public static void ensureTrue(boolean expression, String msg) {
        if (!expression) {
            throw new IllegalArgumentException(msg);
        }
    }

    public static int ensureNotNegative(Integer i, String name) {
        if (i == null || i < 0) {
            throw new IllegalArgumentException("%s must not be negative, but is: %s".formatted(name, i));
        }
        return i;
    }

    public static int ensureGreaterThanZero(Integer i, String name) {
        if (i == null || i <= 0) {
            throw new IllegalArgumentException("%s must be greater than zero, but is: %s".formatted(name, i));
        }
        return i;
    }

    public static double ensureGreaterThanZero(Double i, String name) {
        if (i == null || i <= 0.0) {
            throw new IllegalArgumentException("%s must be greater than zero, but is: %s".formatted(name, i));
        }
        return i;
    }

    public static double ensureBetween(Double d, double min, double max, String name) {
        if (d == null || d < min || d > max) {
            throw new IllegalArgumentException("%s must be between %s and %s, but is: %s".formatted(name, min, max, d));
        }
        return d;
    }

    public static int ensureBetween(Integer i, int min, int max, String name) {
        if (i == null || i < min || i > max) {
            throw new IllegalArgumentException("%s must be between %s and %s, but is: %s".formatted(name, min, max, i));
        }
        return i;
    }

    public static long ensureBetween(Long i, long min, long max, String name) {
        if (i == null || i < min || i > max) {
            throw new IllegalArgumentException("%s must be between %s and %s, but is: %s".formatted(name, min, max, i));
        }
        return i;
    }
}

