/*
 * Decompiled with CFR 0.152.
 */
package ai.docling.serve.client;

import ai.docling.serve.client.DoclingServeClient;
import ai.docling.serve.client.DoclingServeJackson2Client;
import ai.docling.serve.client.DoclingServeJackson3Client;

public final class DoclingServeClientBuilderFactory {
    private DoclingServeClientBuilderFactory() {
    }

    public static <C extends DoclingServeClient, B extends DoclingServeClient.DoclingServeClientBuilder<C, B>> B newBuilder(ClassLoader classLoader) {
        if (JacksonVersion.JACKSON_3.isOnClasspath(classLoader)) {
            return (B)DoclingServeJackson3Client.builder();
        }
        if (JacksonVersion.JACKSON_2.isOnClasspath(classLoader)) {
            return (B)DoclingServeJackson2Client.builder();
        }
        throw new IllegalStateException("Neither Jackson 2 or 3 is on the classpath");
    }

    public static <C extends DoclingServeClient, B extends DoclingServeClient.DoclingServeClientBuilder<C, B>> B newBuilder() {
        return DoclingServeClientBuilderFactory.newBuilder(Thread.currentThread().getContextClassLoader());
    }

    private static enum JacksonVersion {
        JACKSON_2("com.fasterxml.jackson.databind.json.JsonMapper"),
        JACKSON_3("tools.jackson.databind.json.JsonMapper");

        private final String jacksonClassName;

        private JacksonVersion(String jacksonClassName) {
            this.jacksonClassName = jacksonClassName;
        }

        private boolean isOnClasspath() {
            return this.isOnClasspath(Thread.currentThread().getContextClassLoader());
        }

        private boolean isOnClasspath(ClassLoader classLoader) {
            try {
                Class.forName(this.jacksonClassName, false, classLoader);
                return true;
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        }
    }
}

