/*
 * Decompiled with CFR 0.152.
 */
package ai.docling.serve.client;

import ai.docling.serve.api.util.ValidationUtils;
import ai.docling.serve.client.DoclingServeClient;
import tools.jackson.databind.json.JsonMapper;

public class DoclingServeJackson3Client
extends DoclingServeClient {
    private final JsonMapper jsonMapper;

    private DoclingServeJackson3Client(Builder builder) {
        super(builder);
        this.jsonMapper = ((JsonMapper.Builder)ValidationUtils.ensureNotNull((Object)builder.jsonMapperBuilder, (String)"jsonMapperBuilder")).build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    static Builder builder() {
        return new Builder();
    }

    @Override
    protected <T> T readValue(String json, Class<T> valueType) {
        return (T)this.jsonMapper.readValue(json, valueType);
    }

    @Override
    protected <T> String writeValueAsString(T value) {
        return this.prettyPrintJson() ? this.jsonMapper.writerWithDefaultPrettyPrinter().writeValueAsString(value) : this.jsonMapper.writeValueAsString(value);
    }

    public static final class Builder
    extends DoclingServeClient.DoclingServeClientBuilder<DoclingServeJackson3Client, Builder> {
        private JsonMapper.Builder jsonMapperBuilder = JsonMapper.builder();

        private Builder() {
        }

        private Builder(DoclingServeJackson3Client doclingClient) {
            super(doclingClient);
            this.jsonMapperBuilder = doclingClient.jsonMapper.rebuild();
        }

        public Builder jsonParser(JsonMapper.Builder jsonMapperBuilder) {
            this.jsonMapperBuilder = jsonMapperBuilder;
            return this;
        }

        public DoclingServeJackson3Client build() {
            return new DoclingServeJackson3Client(this);
        }
    }
}

