/*
 * Decompiled with CFR 0.152.
 */
package ai.docling.serve.client.operations;

import ai.docling.serve.api.DoclingServeClearApi;
import ai.docling.serve.api.clear.request.ClearConvertersRequest;
import ai.docling.serve.api.clear.request.ClearResultsRequest;
import ai.docling.serve.api.clear.response.ClearResponse;
import ai.docling.serve.api.util.ValidationUtils;
import ai.docling.serve.client.operations.HttpOperations;
import ai.docling.serve.client.operations.RequestContext;

public final class ClearOperations
implements DoclingServeClearApi {
    private final HttpOperations httpOperations;

    public ClearOperations(HttpOperations httpOperations) {
        this.httpOperations = httpOperations;
    }

    public ClearResponse clearConverters(ClearConvertersRequest request) {
        return this.httpOperations.executeGet(this.createRequestContext("/v1/clear/converters", request));
    }

    public ClearResponse clearResults(ClearResultsRequest request) {
        ValidationUtils.ensureNotNull((Object)request, (String)"request");
        return this.httpOperations.executeGet(this.createRequestContext("/v1/clear/results?older_then=%d".formatted(request.getOlderThen().toSeconds()), request));
    }

    private <I> RequestContext<I, ClearResponse> createRequestContext(String uri, I request) {
        return RequestContext.builder().request(request).responseType(ClearResponse.class).uri(uri).build();
    }
}

