/*
 * Decompiled with CFR 0.152.
 */
package ai.docling.serve.client.operations;

import ai.docling.serve.api.util.ValidationUtils;
import org.jspecify.annotations.Nullable;

public class RequestContext<I, O> {
    private final String uri;
    private final I request;
    private final Class<O> responseType;

    private RequestContext(Builder<I, O> builder) {
        this.uri = ValidationUtils.ensureNotBlank((String)builder.uri, (String)"uri");
        this.request = builder.request;
        this.responseType = (Class)ValidationUtils.ensureNotNull(builder.responseType, (String)"responseType");
    }

    public String getUri() {
        return this.uri;
    }

    public @Nullable I getRequest() {
        return this.request;
    }

    public Class<O> getResponseType() {
        return this.responseType;
    }

    public static <I, O> Builder<I, O> builder() {
        return new Builder();
    }

    public Builder<I, O> toBuilder() {
        return new Builder(this);
    }

    public static class Builder<I, O> {
        private String uri;
        private @Nullable I request;
        private Class<O> responseType;

        public Builder() {
        }

        public Builder(RequestContext<I, O> context) {
            this.uri = context.uri;
            this.request = context.request;
            this.responseType = context.responseType;
        }

        public Builder<I, O> uri(String uri) {
            this.uri = uri;
            return this;
        }

        public Builder<I, O> request(@Nullable I request) {
            this.request = request;
            return this;
        }

        public Builder<I, O> responseType(Class<O> responseType) {
            this.responseType = responseType;
            return this;
        }

        public RequestContext<I, O> build() {
            return new RequestContext(this);
        }
    }
}

