/*
 * Decompiled with CFR 0.152.
 */
package ai.docling.serve.client;

import ai.docling.serve.api.DoclingServeApi;
import ai.docling.serve.api.chunk.request.HierarchicalChunkDocumentRequest;
import ai.docling.serve.api.chunk.request.HybridChunkDocumentRequest;
import ai.docling.serve.api.chunk.response.ChunkDocumentResponse;
import ai.docling.serve.api.clear.request.ClearConvertersRequest;
import ai.docling.serve.api.clear.request.ClearResultsRequest;
import ai.docling.serve.api.clear.response.ClearResponse;
import ai.docling.serve.api.convert.request.ConvertDocumentRequest;
import ai.docling.serve.api.convert.response.ConvertDocumentResponse;
import ai.docling.serve.api.health.HealthCheckResponse;
import ai.docling.serve.api.task.request.TaskResultRequest;
import ai.docling.serve.api.task.request.TaskStatusPollRequest;
import ai.docling.serve.api.task.response.TaskStatusPollResponse;
import ai.docling.serve.api.util.Utils;
import ai.docling.serve.api.util.ValidationUtils;
import ai.docling.serve.api.validation.ValidationError;
import ai.docling.serve.api.validation.ValidationException;
import ai.docling.serve.client.DoclingServeClientException;
import ai.docling.serve.client.operations.ChunkOperations;
import ai.docling.serve.client.operations.ClearOperations;
import ai.docling.serve.client.operations.ConvertOperations;
import ai.docling.serve.client.operations.HealthOperations;
import ai.docling.serve.client.operations.HttpOperations;
import ai.docling.serve.client.operations.RequestContext;
import ai.docling.serve.client.operations.TaskOperations;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DoclingServeClient
extends HttpOperations
implements DoclingServeApi {
    private static final Logger LOG = LoggerFactory.getLogger(DoclingServeClient.class);
    protected static final URI DEFAULT_BASE_URL = URI.create("http://localhost:5001");
    private final URI baseUrl;
    private final HttpClient httpClient;
    private final boolean logRequests;
    private final boolean logResponses;
    private final boolean prettyPrintJson;
    private final @Nullable String apiKey;
    private final Duration asyncPollInterval;
    private final Duration asyncTimeout;
    private final HealthOperations healthOps;
    private final ConvertOperations convertOps;
    private final ChunkOperations chunkOps;
    private final ClearOperations clearOps;
    private final TaskOperations taskOps;

    protected DoclingServeClient(DoclingServeClientBuilder builder) {
        this.baseUrl = (URI)ValidationUtils.ensureNotNull((Object)builder.baseUrl, (String)"baseUrl");
        if (Objects.equals(this.baseUrl.getScheme(), "http")) {
            builder.httpClientBuilder.version(HttpClient.Version.HTTP_1_1);
        }
        this.httpClient = ((HttpClient.Builder)ValidationUtils.ensureNotNull((Object)builder.httpClientBuilder, (String)"httpClientBuilder")).build();
        this.logRequests = builder.logRequests;
        this.logResponses = builder.logResponses;
        this.prettyPrintJson = builder.prettyPrintJson;
        this.apiKey = builder.apiKey;
        this.asyncPollInterval = builder.asyncPollInterval;
        this.asyncTimeout = builder.asyncTimeout;
        this.healthOps = new HealthOperations(this);
        this.taskOps = new TaskOperations(this);
        this.convertOps = new ConvertOperations(this, this.taskOps, this.asyncPollInterval, this.asyncTimeout);
        this.chunkOps = new ChunkOperations(this, this.taskOps, this.asyncPollInterval, this.asyncTimeout);
        this.clearOps = new ClearOperations(this);
    }

    protected abstract <T> T readValue(String var1, Class<T> var2);

    protected abstract <T> String writeValueAsString(T var1);

    protected boolean prettyPrintJson() {
        return this.prettyPrintJson;
    }

    protected void logRequest(HttpRequest request) {
        if (LOG.isInfoEnabled()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\n\u2192 REQUEST: %s %s\n".formatted(request.method(), request.uri()));
            stringBuilder.append("  HEADERS:\n");
            request.headers().map().entrySet().stream().map(this::maskSensitiveHeaderValues).forEach(entry -> stringBuilder.append("  %s: %s\n".formatted(entry.getKey(), String.join((CharSequence)", ", (Iterable)entry.getValue()))));
            LOG.info(stringBuilder.toString());
        }
    }

    private boolean isSensitiveHeader(String headerName) {
        return "X-Api-Key".equalsIgnoreCase(headerName);
    }

    private Map.Entry<String, List<String>> maskSensitiveHeaderValues(Map.Entry<String, List<String>> entry) {
        return Map.entry(entry.getKey(), entry.getValue().stream().map(value -> this.isSensitiveHeader((String)entry.getKey()) ? "*".repeat(value.length()) : value).toList());
    }

    protected void logResponse(HttpResponse<String> response, Optional<String> responseBody) {
        if (LOG.isInfoEnabled()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\n\u2190 RESPONSE: %s\n".formatted(response.statusCode()));
            stringBuilder.append("  HEADERS:\n");
            response.headers().map().forEach((key, values) -> stringBuilder.append("  %s: %s\n".formatted(key, String.join((CharSequence)", ", values))));
            responseBody.map(body -> this.prettyPrintJson ? this.writeValueAsString(this.readValue((String)body, (Class)Object.class)) : body).ifPresent(body -> stringBuilder.append("  BODY:\n%s".formatted(body)));
            LOG.info(stringBuilder.toString());
        }
    }

    protected <T> T execute(HttpRequest request, Class<T> expectedValueType) {
        T t;
        if (this.logRequests) {
            this.logRequest(request);
        }
        long startTime = System.currentTimeMillis();
        try {
            HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            t = this.getResponse(request, response, expectedValueType);
        }
        catch (IOException | InterruptedException e) {
            try {
                throw new DoclingServeClientException(e);
            }
            catch (Throwable throwable) {
                long duration = System.currentTimeMillis() - startTime;
                LOG.info("Request [{} {}] took {}ms", new Object[]{request.method(), request.uri(), duration});
                throw throwable;
            }
        }
        long duration = System.currentTimeMillis() - startTime;
        LOG.info("Request [{} {}] took {}ms", new Object[]{request.method(), request.uri(), duration});
        return t;
    }

    @Override
    protected <I, O> O executePost(RequestContext<I, O> requestContext) {
        HttpRequest httpRequest = this.createRequestBuilder(requestContext).header("Content-Type", "application/json").POST(new LoggingBodyPublisher<I>(requestContext.getRequest())).build();
        return this.execute(httpRequest, requestContext.getResponseType());
    }

    @Override
    protected <I, O> O executeGet(RequestContext<I, O> requestContext) {
        HttpRequest httpRequest = this.createRequestBuilder(requestContext).GET().build();
        return this.execute(httpRequest, requestContext.getResponseType());
    }

    protected <I, O> HttpRequest.Builder createRequestBuilder(RequestContext<I, O> requestContext) {
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(this.baseUrl.resolve(requestContext.getUri())).header("Accept", "application/json");
        if (Utils.isNotNullOrBlank((String)this.apiKey)) {
            requestBuilder.header("X-Api-Key", this.apiKey);
        }
        return requestBuilder;
    }

    protected <T> T getResponse(HttpRequest request, HttpResponse<String> response, Class<T> expectedReturnType) {
        int statusCode;
        String body = response.body();
        if (this.logResponses) {
            this.logResponse(response, Optional.ofNullable(body));
        }
        if ((statusCode = response.statusCode()) == 422) {
            throw new ValidationException(this.readValue(body, ValidationError.class), "An error occurred while making %s request to %s".formatted(request.method(), request.uri()));
        }
        if (statusCode >= 400) {
            throw new DoclingServeClientException("An error occurred: %s".formatted(body), statusCode, body);
        }
        return this.readValue(body, expectedReturnType);
    }

    public HealthCheckResponse health() {
        return this.healthOps.health();
    }

    public ConvertDocumentResponse convertSource(ConvertDocumentRequest request) {
        return this.convertOps.convertSource(request);
    }

    public ChunkDocumentResponse chunkSourceWithHierarchicalChunker(HierarchicalChunkDocumentRequest request) {
        return this.chunkOps.chunkSourceWithHierarchicalChunker(request);
    }

    public ChunkDocumentResponse chunkSourceWithHybridChunker(HybridChunkDocumentRequest request) {
        return this.chunkOps.chunkSourceWithHybridChunker(request);
    }

    public CompletionStage<ChunkDocumentResponse> chunkSourceWithHierarchicalChunkerAsync(HierarchicalChunkDocumentRequest request) {
        return this.chunkOps.chunkSourceWithHierarchicalChunkerAsync(request);
    }

    public CompletionStage<ChunkDocumentResponse> chunkSourceWithHybridChunkerAsync(HybridChunkDocumentRequest request) {
        return this.chunkOps.chunkSourceWithHybridChunkerAsync(request);
    }

    public TaskStatusPollResponse pollTaskStatus(TaskStatusPollRequest request) {
        return this.taskOps.pollTaskStatus(request);
    }

    public ConvertDocumentResponse convertTaskResult(TaskResultRequest request) {
        return this.taskOps.convertTaskResult(request);
    }

    public ChunkDocumentResponse chunkTaskResult(TaskResultRequest request) {
        return this.taskOps.chunkTaskResult(request);
    }

    public ClearResponse clearConverters(ClearConvertersRequest request) {
        return this.clearOps.clearConverters(request);
    }

    public ClearResponse clearResults(ClearResultsRequest request) {
        return this.clearOps.clearResults(request);
    }

    public CompletionStage<ConvertDocumentResponse> convertSourceAsync(ConvertDocumentRequest request) {
        return this.convertOps.convertSourceAsync(request);
    }

    public static abstract class DoclingServeClientBuilder<C extends DoclingServeClient, B extends DoclingServeClientBuilder<C, B>>
    implements DoclingServeApi.DoclingApiBuilder<C, B> {
        private URI baseUrl = DEFAULT_BASE_URL;
        private HttpClient.Builder httpClientBuilder = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL);
        private boolean logRequests = false;
        private boolean logResponses = false;
        private boolean prettyPrintJson = false;
        private @Nullable String apiKey;
        private Duration asyncPollInterval = Duration.ofSeconds(2L);
        private Duration asyncTimeout = Duration.ofMinutes(5L);

        protected DoclingServeClientBuilder() {
        }

        protected DoclingServeClientBuilder(DoclingServeClient doclingClient) {
            this.baseUrl = doclingClient.baseUrl;
            this.httpClientBuilder = HttpClient.newBuilder();
            this.apiKey = doclingClient.apiKey;
            this.logRequests = doclingClient.logRequests;
            this.logResponses = doclingClient.logResponses;
            this.prettyPrintJson = doclingClient.prettyPrintJson;
            this.asyncPollInterval = doclingClient.asyncPollInterval;
            this.asyncTimeout = doclingClient.asyncTimeout;
        }

        public B baseUrl(URI baseUrl) {
            this.baseUrl = baseUrl;
            return (B)this;
        }

        public B httpClientBuilder(HttpClient.Builder httpClientBuilder) {
            this.httpClientBuilder = httpClientBuilder;
            return (B)this;
        }

        public B apiKey(@Nullable String apiKey) {
            this.apiKey = apiKey;
            return (B)this;
        }

        public B logRequests(boolean logRequests) {
            this.logRequests = logRequests;
            return (B)this;
        }

        public B logResponses(boolean logResponses) {
            this.logResponses = logResponses;
            return (B)this;
        }

        public B prettyPrint(boolean prettyPrint) {
            this.prettyPrintJson = prettyPrint;
            return (B)this;
        }

        public B asyncPollInterval(Duration asyncPollInterval) {
            if (asyncPollInterval == null || asyncPollInterval.isNegative() || asyncPollInterval.isZero()) {
                throw new IllegalArgumentException("asyncPollInterval must be a positive duration");
            }
            this.asyncPollInterval = asyncPollInterval;
            return (B)this;
        }

        public B asyncTimeout(Duration asyncTimeout) {
            if (asyncTimeout == null || asyncTimeout.isNegative() || asyncTimeout.isZero()) {
                throw new IllegalArgumentException("asyncTimeout must be a positive duration");
            }
            this.asyncTimeout = asyncTimeout;
            return (B)this;
        }
    }

    private class LoggingBodyPublisher<T>
    implements HttpRequest.BodyPublisher {
        private final HttpRequest.BodyPublisher delegate;
        private final String stringContent;

        private LoggingBodyPublisher(T content) {
            if (content == null) {
                this.stringContent = "";
                this.delegate = HttpRequest.BodyPublishers.noBody();
            } else {
                this.stringContent = DoclingServeClient.this.writeValueAsString(content);
                this.delegate = HttpRequest.BodyPublishers.ofString(this.stringContent);
            }
        }

        @Override
        public long contentLength() {
            return this.delegate.contentLength();
        }

        @Override
        public void subscribe(Flow.Subscriber<? super ByteBuffer> subscriber) {
            if (DoclingServeClient.this.logRequests) {
                LOG.info("\n\u2192 REQUEST BODY: \n{}", (Object)this.stringContent);
            }
            this.delegate.subscribe(subscriber);
        }
    }
}

