/*
 * Decompiled with CFR 0.152.
 */
package ai.docling.serve.client;

import ai.docling.serve.api.util.ValidationUtils;
import ai.docling.serve.client.DoclingServeClient;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;

public class DoclingServeJackson2Client
extends DoclingServeClient {
    private final JsonMapper jsonMapper;

    private DoclingServeJackson2Client(Builder builder) {
        super(builder);
        this.jsonMapper = (JsonMapper)((JsonMapper.Builder)ValidationUtils.ensureNotNull((Object)builder.jsonMapperBuilder, (String)"jsonMapperBuilder")).build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    static Builder builder() {
        return new Builder();
    }

    @Override
    protected <T> T readValue(String json, Class<T> valueType) {
        try {
            return (T)this.jsonMapper.readValue(json, valueType);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected <T> String writeValueAsString(T value) {
        try {
            return this.prettyPrintJson() ? this.jsonMapper.writerWithDefaultPrettyPrinter().writeValueAsString(value) : this.jsonMapper.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static final class Builder
    extends DoclingServeClient.DoclingServeClientBuilder<DoclingServeJackson2Client, Builder> {
        private JsonMapper.Builder jsonMapperBuilder = (JsonMapper.Builder)JsonMapper.builder().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

        private Builder() {
        }

        private Builder(DoclingServeJackson2Client doclingClient) {
            super(doclingClient);
            this.jsonMapperBuilder = doclingClient.jsonMapper.rebuild();
        }

        public Builder jsonParser(JsonMapper.Builder jsonMapperBuilder) {
            this.jsonMapperBuilder = jsonMapperBuilder;
            return this;
        }

        public DoclingServeJackson2Client build() {
            return new DoclingServeJackson2Client(this);
        }
    }
}

