/*
 * Decompiled with CFR 0.152.
 */
package ai.docling.serve.client.operations;

import ai.docling.serve.api.DoclingServeTaskApi;
import ai.docling.serve.api.task.request.TaskResultRequest;
import ai.docling.serve.api.task.request.TaskStatusPollRequest;
import ai.docling.serve.api.task.response.TaskStatus;
import ai.docling.serve.api.task.response.TaskStatusPollResponse;
import ai.docling.serve.api.util.ValidationUtils;
import ai.docling.serve.client.operations.HttpOperations;
import ai.docling.serve.client.operations.RequestContext;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AsyncOperations {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncOperations.class);
    private final HttpOperations httpOperations;
    private final DoclingServeTaskApi taskApi;
    private final Duration asyncPollInterval;
    private final Duration asyncTimeout;

    protected AsyncOperations(HttpOperations httpOperations, DoclingServeTaskApi taskApi, Duration asyncPollInterval, Duration asyncTimeout) {
        this.httpOperations = httpOperations;
        this.taskApi = taskApi;
        this.asyncPollInterval = asyncPollInterval;
        this.asyncTimeout = asyncTimeout;
    }

    protected abstract <O> O getTaskResult(TaskResultRequest var1);

    protected <I, O> CompletionStage<O> executeAsync(I request, String uri) {
        ValidationUtils.ensureNotNull(request, (String)"request");
        return CompletableFuture.supplyAsync(() -> this.httpOperations.executePost(this.createAsyncRequestContext(uri, request))).thenCompose(taskResponse -> {
            LOG.info("Started async conversion with task ID: {}", (Object)taskResponse.getTaskId());
            long startTime = System.currentTimeMillis();
            return this.pollTaskUntilComplete((TaskStatusPollResponse)taskResponse, startTime);
        });
    }

    private <I> RequestContext<I, TaskStatusPollResponse> createAsyncRequestContext(String uri, I request) {
        return RequestContext.builder().request(request).responseType(TaskStatusPollResponse.class).uri(uri).build();
    }

    private <O> CompletionStage<O> pollTaskUntilComplete(TaskStatusPollResponse statusPollResponse, long startTime) {
        String taskId = statusPollResponse.getTaskId();
        if (System.currentTimeMillis() - startTime > this.asyncTimeout.toMillis()) {
            return CompletableFuture.failedFuture(new RuntimeException("Async conversion timed out after %s for task: %s".formatted(this.asyncTimeout, taskId)));
        }
        TaskStatusPollRequest pollRequest = TaskStatusPollRequest.builder().taskId(taskId).build();
        return CompletableFuture.supplyAsync(() -> this.taskApi.pollTaskStatus(pollRequest)).thenCompose(statusResponse -> this.pollTaskStatus((TaskStatusPollResponse)statusResponse, startTime));
    }

    private <O> CompletionStage<O> pollTaskStatus(TaskStatusPollResponse statusResponse, long startTime) {
        TaskStatus status = statusResponse.getTaskStatus();
        String taskId = statusResponse.getTaskId();
        LOG.debug("Task {} status: {}", (Object)taskId, (Object)status);
        return switch (status) {
            case TaskStatus.SUCCESS -> {
                LOG.info("Task {} completed successfully", (Object)taskId);
                TaskResultRequest taskResult = TaskResultRequest.builder().taskId(statusResponse.getTaskId()).build();
                yield CompletableFuture.supplyAsync(() -> this.getTaskResult(taskResult));
            }
            case TaskStatus.FAILURE -> {
                String errorMessage = Optional.ofNullable(statusResponse.getTaskStatusMetadata()).map(metadata -> "Task failed: %s".formatted(metadata)).orElse("Task failed");
                yield CompletableFuture.failedStage(new RuntimeException("Async conversion failed for task %s: %s".formatted(taskId, errorMessage)));
            }
            default -> CompletableFuture.supplyAsync(() -> null, CompletableFuture.delayedExecutor(this.asyncPollInterval.toMillis(), TimeUnit.MILLISECONDS)).thenCompose(v -> this.pollTaskUntilComplete(statusResponse, startTime));
        };
    }
}

