/*
 * Decompiled with CFR 0.152.
 */
package ai.docling.serve.client.operations;

import ai.docling.serve.api.DoclingServeChunkApi;
import ai.docling.serve.api.DoclingServeTaskApi;
import ai.docling.serve.api.chunk.request.HierarchicalChunkDocumentRequest;
import ai.docling.serve.api.chunk.request.HybridChunkDocumentRequest;
import ai.docling.serve.api.chunk.response.ChunkDocumentResponse;
import ai.docling.serve.api.task.request.TaskResultRequest;
import ai.docling.serve.api.util.ValidationUtils;
import ai.docling.serve.client.operations.AsyncOperations;
import ai.docling.serve.client.operations.HttpOperations;
import ai.docling.serve.client.operations.RequestContext;
import java.time.Duration;
import java.util.concurrent.CompletionStage;

public final class ChunkOperations
extends AsyncOperations
implements DoclingServeChunkApi {
    private final HttpOperations httpOperations;
    private final DoclingServeTaskApi taskApi;

    public ChunkOperations(HttpOperations httpOperations, DoclingServeTaskApi taskApi, Duration asyncPollInterval, Duration asyncTimeout) {
        super(httpOperations, taskApi, asyncPollInterval, asyncTimeout);
        this.httpOperations = httpOperations;
        this.taskApi = taskApi;
    }

    protected ChunkDocumentResponse getTaskResult(TaskResultRequest taskResultRequest) {
        return this.taskApi.chunkTaskResult(taskResultRequest);
    }

    public ChunkDocumentResponse chunkSourceWithHierarchicalChunker(HierarchicalChunkDocumentRequest request) {
        ValidationUtils.ensureNotNull((Object)request, (String)"request");
        return this.httpOperations.executePost(this.createRequestContext("/v1/chunk/hierarchical/source", request));
    }

    public ChunkDocumentResponse chunkSourceWithHybridChunker(HybridChunkDocumentRequest request) {
        ValidationUtils.ensureNotNull((Object)request, (String)"request");
        return this.httpOperations.executePost(this.createRequestContext("/v1/chunk/hybrid/source", request));
    }

    public CompletionStage<ChunkDocumentResponse> chunkSourceWithHierarchicalChunkerAsync(HierarchicalChunkDocumentRequest request) {
        return this.executeAsync(request, "/v1/chunk/hierarchical/source/async");
    }

    public CompletionStage<ChunkDocumentResponse> chunkSourceWithHybridChunkerAsync(HybridChunkDocumentRequest request) {
        return this.executeAsync(request, "/v1/chunk/hybrid/source/async");
    }

    private <I> RequestContext<I, ChunkDocumentResponse> createRequestContext(String uri, I request) {
        return RequestContext.builder().request(request).responseType(ChunkDocumentResponse.class).uri(uri).build();
    }
}

