/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.constraint.streams.bavet;

import ai.timefold.solver.constraint.streams.bavet.BavetConstraint;
import ai.timefold.solver.constraint.streams.bavet.common.BavetAbstractConstraintStream;
import ai.timefold.solver.constraint.streams.bavet.uni.BavetAbstractUniConstraintStream;
import ai.timefold.solver.constraint.streams.bavet.uni.BavetForEachUniConstraintStream;
import ai.timefold.solver.constraint.streams.common.InnerConstraintFactory;
import ai.timefold.solver.constraint.streams.common.RetrievalSemantics;
import ai.timefold.solver.core.api.score.stream.uni.UniConstraintStream;
import ai.timefold.solver.core.config.solver.EnvironmentMode;
import ai.timefold.solver.core.impl.domain.constraintweight.descriptor.ConstraintConfigurationDescriptor;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;

public final class BavetConstraintFactory<Solution_>
extends InnerConstraintFactory<Solution_, BavetConstraint<Solution_>> {
    private final SolutionDescriptor<Solution_> solutionDescriptor;
    private final EnvironmentMode environmentMode;
    private final String defaultConstraintPackage;
    private final Map<BavetAbstractConstraintStream<Solution_>, BavetAbstractConstraintStream<Solution_>> sharingStreamMap = new HashMap<BavetAbstractConstraintStream<Solution_>, BavetAbstractConstraintStream<Solution_>>(256);

    public BavetConstraintFactory(SolutionDescriptor<Solution_> solutionDescriptor, EnvironmentMode environmentMode) {
        Package pack;
        this.solutionDescriptor = solutionDescriptor;
        this.environmentMode = Objects.requireNonNull(environmentMode);
        ConstraintConfigurationDescriptor configurationDescriptor = solutionDescriptor.getConstraintConfigurationDescriptor();
        this.defaultConstraintPackage = configurationDescriptor == null ? ((pack = solutionDescriptor.getSolutionClass().getPackage()) == null ? "" : pack.getName()) : configurationDescriptor.getConstraintPackage();
    }

    public <Stream_ extends BavetAbstractConstraintStream<Solution_>> Stream_ share(Stream_ stream) {
        return (Stream_)this.share(stream, t -> {});
    }

    public <Stream_ extends BavetAbstractConstraintStream<Solution_>> Stream_ share(Stream_ stream, Consumer<Stream_> consumer) {
        return (Stream_)this.sharingStreamMap.computeIfAbsent(stream, k -> {
            consumer.accept(stream);
            return stream;
        });
    }

    public <A> UniConstraintStream<A> forEach(Class<A> sourceClass) {
        this.assertValidFromType(sourceClass);
        Predicate<A> nullityFilter = this.getNullityFilter(sourceClass);
        return this.share(new BavetForEachUniConstraintStream(this, sourceClass, nullityFilter, RetrievalSemantics.STANDARD));
    }

    private <A> Predicate<A> getNullityFilter(Class<A> fromClass) {
        EntityDescriptor entityDescriptor = this.getSolutionDescriptor().findEntityDescriptor(fromClass);
        if (entityDescriptor != null && entityDescriptor.hasAnyGenuineVariables()) {
            return entityDescriptor.getHasNoNullVariables();
        }
        return null;
    }

    public <A> UniConstraintStream<A> forEachIncludingNullVars(Class<A> sourceClass) {
        this.assertValidFromType(sourceClass);
        return this.share(new BavetForEachUniConstraintStream(this, sourceClass, null, RetrievalSemantics.STANDARD));
    }

    public <A> UniConstraintStream<A> from(Class<A> fromClass) {
        this.assertValidFromType(fromClass);
        EntityDescriptor entityDescriptor = this.getSolutionDescriptor().findEntityDescriptor(fromClass);
        if (entityDescriptor != null && entityDescriptor.hasAnyGenuineVariables()) {
            Predicate predicate = entityDescriptor.getIsInitializedPredicate();
            return this.share(new BavetForEachUniConstraintStream(this, fromClass, predicate, RetrievalSemantics.LEGACY));
        }
        return this.share(new BavetForEachUniConstraintStream(this, fromClass, null, RetrievalSemantics.LEGACY));
    }

    public <A> BavetAbstractUniConstraintStream<Solution_, A> fromUnfiltered(Class<A> fromClass) {
        this.assertValidFromType(fromClass);
        return this.share(new BavetForEachUniConstraintStream(this, fromClass, null, RetrievalSemantics.LEGACY));
    }

    @Override
    public SolutionDescriptor<Solution_> getSolutionDescriptor() {
        return this.solutionDescriptor;
    }

    public EnvironmentMode getEnvironmentMode() {
        return this.environmentMode;
    }

    public String getDefaultConstraintPackage() {
        return this.defaultConstraintPackage;
    }
}

