/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.constraint.streams.bavet;

import ai.timefold.solver.constraint.streams.bavet.BavetConstraintFactory;
import ai.timefold.solver.constraint.streams.bavet.BavetConstraintStreamScoreDirectorFactory;
import ai.timefold.solver.constraint.streams.common.AbstractConstraintStreamScoreDirectorFactory;
import ai.timefold.solver.constraint.streams.common.AbstractConstraintStreamScoreDirectorFactoryService;
import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.stream.ConstraintFactory;
import ai.timefold.solver.core.api.score.stream.ConstraintProvider;
import ai.timefold.solver.core.api.score.stream.ConstraintStreamImplType;
import ai.timefold.solver.core.config.score.director.ScoreDirectorFactoryConfig;
import ai.timefold.solver.core.config.solver.EnvironmentMode;
import ai.timefold.solver.core.config.util.ConfigUtils;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.score.director.AbstractScoreDirectorFactory;
import ai.timefold.solver.core.impl.score.director.ScoreDirectorType;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;

public final class BavetConstraintStreamScoreDirectorFactoryService<Solution_, Score_ extends Score<Score_>>
extends AbstractConstraintStreamScoreDirectorFactoryService<Solution_, Score_> {
    public ScoreDirectorType getSupportedScoreDirectorType() {
        return ScoreDirectorType.CONSTRAINT_STREAMS;
    }

    public Supplier<AbstractScoreDirectorFactory<Solution_, Score_>> buildScoreDirectorFactory(ClassLoader classLoader, SolutionDescriptor<Solution_> solutionDescriptor, ScoreDirectorFactoryConfig config, EnvironmentMode environmentMode) {
        ConstraintStreamImplType constraintStreamImplType_ = Objects.requireNonNullElse(config.getConstraintStreamImplType(), ConstraintStreamImplType.BAVET);
        if (constraintStreamImplType_ != ConstraintStreamImplType.BAVET) {
            return null;
        }
        if (config.getConstraintProviderClass() != null) {
            if (!ConstraintProvider.class.isAssignableFrom(config.getConstraintProviderClass())) {
                throw new IllegalArgumentException("The constraintProviderClass (" + config.getConstraintProviderClass() + ") does not implement " + ConstraintProvider.class.getSimpleName() + ".");
            }
            return () -> {
                ConstraintProvider constraintProvider = (ConstraintProvider)ConfigUtils.newInstance((Object)config, (String)"constraintProviderClass", (Class)config.getConstraintProviderClass());
                ConfigUtils.applyCustomProperties((Object)constraintProvider, (String)"constraintProviderClass", (Map)config.getConstraintProviderCustomProperties(), (String)"constraintProviderCustomProperties");
                return this.buildScoreDirectorFactory(solutionDescriptor, constraintProvider, environmentMode);
            };
        }
        if (config.getConstraintProviderCustomProperties() != null) {
            throw new IllegalStateException("If there is no constraintProviderClass (" + config.getConstraintProviderClass() + "), then there can be no constraintProviderCustomProperties (" + config.getConstraintProviderCustomProperties() + ") either.");
        }
        return null;
    }

    @Override
    public AbstractConstraintStreamScoreDirectorFactory<Solution_, Score_> buildScoreDirectorFactory(SolutionDescriptor<Solution_> solutionDescriptor, ConstraintProvider constraintProvider, EnvironmentMode environmentMode) {
        return new BavetConstraintStreamScoreDirectorFactory(solutionDescriptor, constraintProvider, environmentMode);
    }

    @Override
    public ConstraintFactory buildConstraintFactory(SolutionDescriptor<Solution_> solutionDescriptor, EnvironmentMode environmentMode) {
        return new BavetConstraintFactory<Solution_>(solutionDescriptor, environmentMode);
    }
}

