/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.constraint.streams.bavet.common;

import ai.timefold.solver.constraint.streams.bavet.common.AbstractJoinNode;
import ai.timefold.solver.constraint.streams.bavet.common.index.IndexProperties;
import ai.timefold.solver.constraint.streams.bavet.common.index.Indexer;
import ai.timefold.solver.constraint.streams.bavet.common.tuple.AbstractTuple;
import ai.timefold.solver.constraint.streams.bavet.common.tuple.LeftTupleLifecycle;
import ai.timefold.solver.constraint.streams.bavet.common.tuple.RightTupleLifecycle;
import ai.timefold.solver.constraint.streams.bavet.common.tuple.TupleLifecycle;
import ai.timefold.solver.constraint.streams.bavet.common.tuple.UniTuple;
import ai.timefold.solver.core.impl.util.ElementAwareList;
import ai.timefold.solver.core.impl.util.ElementAwareListEntry;
import java.util.function.Consumer;
import java.util.function.Function;

public abstract class AbstractIndexedJoinNode<LeftTuple_ extends AbstractTuple, Right_, OutTuple_ extends AbstractTuple>
extends AbstractJoinNode<LeftTuple_, Right_, OutTuple_>
implements LeftTupleLifecycle<LeftTuple_>,
RightTupleLifecycle<UniTuple<Right_>> {
    private final Function<Right_, IndexProperties> mappingRight;
    private final int inputStoreIndexLeftProperties;
    private final int inputStoreIndexLeftEntry;
    private final int inputStoreIndexRightProperties;
    private final int inputStoreIndexRightEntry;
    private final Indexer<LeftTuple_> indexerLeft;
    private final Indexer<UniTuple<Right_>> indexerRight;

    protected AbstractIndexedJoinNode(Function<Right_, IndexProperties> mappingRight, int inputStoreIndexLeftProperties, int inputStoreIndexLeftEntry, int inputStoreIndexLeftOutTupleList, int inputStoreIndexRightProperties, int inputStoreIndexRightEntry, int inputStoreIndexRightOutTupleList, TupleLifecycle<OutTuple_> nextNodesTupleLifecycle, boolean isFiltering, int outputStoreIndexLeftOutEntry, int outputStoreIndexRightOutEntry, Indexer<LeftTuple_> indexerLeft, Indexer<UniTuple<Right_>> indexerRight) {
        super(inputStoreIndexLeftOutTupleList, inputStoreIndexRightOutTupleList, nextNodesTupleLifecycle, isFiltering, outputStoreIndexLeftOutEntry, outputStoreIndexRightOutEntry);
        this.mappingRight = mappingRight;
        this.inputStoreIndexLeftProperties = inputStoreIndexLeftProperties;
        this.inputStoreIndexLeftEntry = inputStoreIndexLeftEntry;
        this.inputStoreIndexRightProperties = inputStoreIndexRightProperties;
        this.inputStoreIndexRightEntry = inputStoreIndexRightEntry;
        this.indexerLeft = indexerLeft;
        this.indexerRight = indexerRight;
    }

    @Override
    public final void insertLeft(LeftTuple_ leftTuple) {
        if (((AbstractTuple)leftTuple).getStore(this.inputStoreIndexLeftProperties) != null) {
            throw new IllegalStateException("Impossible state: the input for the tuple (" + leftTuple + ") was already added in the tupleStore.");
        }
        IndexProperties indexProperties = this.createIndexPropertiesLeft(leftTuple);
        ElementAwareList outTupleListLeft = new ElementAwareList();
        ((AbstractTuple)leftTuple).setStore(this.inputStoreIndexLeftOutTupleList, outTupleListLeft);
        this.indexAndPropagateLeft(leftTuple, indexProperties);
    }

    @Override
    public final void updateLeft(LeftTuple_ leftTuple) {
        IndexProperties oldIndexProperties = (IndexProperties)((AbstractTuple)leftTuple).getStore(this.inputStoreIndexLeftProperties);
        if (oldIndexProperties == null) {
            this.insertLeft(leftTuple);
            return;
        }
        IndexProperties newIndexProperties = this.createIndexPropertiesLeft(leftTuple);
        if (oldIndexProperties.equals(newIndexProperties)) {
            this.innerUpdateLeft(leftTuple, consumer -> this.indexerRight.forEach(oldIndexProperties, (Consumer<UniTuple<Right_>>)consumer));
        } else {
            ElementAwareListEntry leftEntry = (ElementAwareListEntry)((AbstractTuple)leftTuple).getStore(this.inputStoreIndexLeftEntry);
            ElementAwareList outTupleListLeft = (ElementAwareList)((AbstractTuple)leftTuple).getStore(this.inputStoreIndexLeftOutTupleList);
            this.indexerLeft.remove(oldIndexProperties, leftEntry);
            outTupleListLeft.forEach(this::retractOutTuple);
            this.indexAndPropagateLeft(leftTuple, newIndexProperties);
        }
    }

    private void indexAndPropagateLeft(LeftTuple_ leftTuple, IndexProperties indexProperties) {
        ((AbstractTuple)leftTuple).setStore(this.inputStoreIndexLeftProperties, indexProperties);
        ElementAwareListEntry<LeftTuple_> leftEntry = this.indexerLeft.put(indexProperties, leftTuple);
        ((AbstractTuple)leftTuple).setStore(this.inputStoreIndexLeftEntry, leftEntry);
        this.indexerRight.forEach(indexProperties, rightTuple -> this.insertOutTupleFiltered(leftTuple, rightTuple));
    }

    @Override
    public final void retractLeft(LeftTuple_ leftTuple) {
        IndexProperties indexProperties = (IndexProperties)((AbstractTuple)leftTuple).removeStore(this.inputStoreIndexLeftProperties);
        if (indexProperties == null) {
            return;
        }
        ElementAwareListEntry leftEntry = (ElementAwareListEntry)((AbstractTuple)leftTuple).removeStore(this.inputStoreIndexLeftEntry);
        ElementAwareList outTupleListLeft = (ElementAwareList)((AbstractTuple)leftTuple).removeStore(this.inputStoreIndexLeftOutTupleList);
        this.indexerLeft.remove(indexProperties, leftEntry);
        outTupleListLeft.forEach(this::retractOutTuple);
    }

    @Override
    public final void insertRight(UniTuple<Right_> rightTuple) {
        if (rightTuple.getStore(this.inputStoreIndexRightProperties) != null) {
            throw new IllegalStateException("Impossible state: the input for the tuple (" + rightTuple + ") was already added in the tupleStore.");
        }
        IndexProperties indexProperties = this.mappingRight.apply(rightTuple.factA);
        ElementAwareList outTupleListRight = new ElementAwareList();
        rightTuple.setStore(this.inputStoreIndexRightOutTupleList, outTupleListRight);
        this.indexAndPropagateRight(rightTuple, indexProperties);
    }

    @Override
    public final void updateRight(UniTuple<Right_> rightTuple) {
        IndexProperties oldIndexProperties = (IndexProperties)rightTuple.getStore(this.inputStoreIndexRightProperties);
        if (oldIndexProperties == null) {
            this.insertRight(rightTuple);
            return;
        }
        IndexProperties newIndexProperties = this.mappingRight.apply(rightTuple.factA);
        if (oldIndexProperties.equals(newIndexProperties)) {
            this.innerUpdateRight(rightTuple, consumer -> this.indexerLeft.forEach(oldIndexProperties, (Consumer<LeftTuple_>)consumer));
        } else {
            ElementAwareListEntry rightEntry = (ElementAwareListEntry)rightTuple.getStore(this.inputStoreIndexRightEntry);
            ElementAwareList outTupleListRight = (ElementAwareList)rightTuple.getStore(this.inputStoreIndexRightOutTupleList);
            this.indexerRight.remove(oldIndexProperties, rightEntry);
            outTupleListRight.forEach(this::retractOutTuple);
            this.indexAndPropagateRight(rightTuple, newIndexProperties);
        }
    }

    private void indexAndPropagateRight(UniTuple<Right_> rightTuple, IndexProperties indexProperties) {
        rightTuple.setStore(this.inputStoreIndexRightProperties, indexProperties);
        ElementAwareListEntry<UniTuple<Right_>> rightEntry = this.indexerRight.put(indexProperties, rightTuple);
        rightTuple.setStore(this.inputStoreIndexRightEntry, rightEntry);
        this.indexerLeft.forEach(indexProperties, leftTuple -> this.insertOutTupleFiltered(leftTuple, rightTuple));
    }

    @Override
    public final void retractRight(UniTuple<Right_> rightTuple) {
        IndexProperties indexProperties = (IndexProperties)rightTuple.removeStore(this.inputStoreIndexRightProperties);
        if (indexProperties == null) {
            return;
        }
        ElementAwareListEntry rightEntry = (ElementAwareListEntry)rightTuple.removeStore(this.inputStoreIndexRightEntry);
        ElementAwareList outTupleListRight = (ElementAwareList)rightTuple.removeStore(this.inputStoreIndexRightOutTupleList);
        this.indexerRight.remove(indexProperties, rightEntry);
        outTupleListRight.forEach(this::retractOutTuple);
    }

    protected abstract IndexProperties createIndexPropertiesLeft(LeftTuple_ var1);
}

