/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.constraint.streams.bavet.common.index;

import ai.timefold.solver.constraint.streams.bavet.common.index.IndexProperties;
import ai.timefold.solver.constraint.streams.bavet.common.index.IndexerKey;
import ai.timefold.solver.core.impl.util.Pair;
import ai.timefold.solver.core.impl.util.Quadruple;
import ai.timefold.solver.core.impl.util.Triple;
import java.util.Arrays;

final class ManyIndexProperties
implements IndexProperties {
    private final Object[] properties;

    ManyIndexProperties(Object ... properties) {
        this.properties = properties;
    }

    @Override
    public <Type_> Type_ toKey(int index) {
        return (Type_)this.properties[index];
    }

    @Override
    public <Type_> Type_ toKey(int from, int to) {
        switch (to - from) {
            case 1: {
                return this.toKey(from);
            }
            case 2: {
                return (Type_)Pair.of(this.toKey(from), this.toKey(from + 1));
            }
            case 3: {
                return (Type_)Triple.of(this.toKey(from), this.toKey(from + 1), this.toKey(from + 2));
            }
            case 4: {
                return (Type_)Quadruple.of(this.toKey(from), this.toKey(from + 1), this.toKey(from + 2), this.toKey(from + 3));
            }
        }
        return (Type_)new IndexerKey(this, from, to);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ManyIndexProperties)) {
            return false;
        }
        ManyIndexProperties other = (ManyIndexProperties)o;
        return Arrays.equals(this.properties, other.properties);
    }

    public int hashCode() {
        return Arrays.hashCode(this.properties);
    }

    public String toString() {
        return Arrays.toString(this.properties);
    }
}

