/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.constraint.streams.bavet.quad;

import ai.timefold.solver.constraint.streams.bavet.BavetConstraintFactory;
import ai.timefold.solver.constraint.streams.bavet.common.AbstractConcatNode;
import ai.timefold.solver.constraint.streams.bavet.common.BavetAbstractConstraintStream;
import ai.timefold.solver.constraint.streams.bavet.common.BavetConcatConstraintStream;
import ai.timefold.solver.constraint.streams.bavet.common.NodeBuildHelper;
import ai.timefold.solver.constraint.streams.bavet.common.bridge.BavetForeBridgeBiConstraintStream;
import ai.timefold.solver.constraint.streams.bavet.common.bridge.BavetForeBridgeQuadConstraintStream;
import ai.timefold.solver.constraint.streams.bavet.common.bridge.BavetForeBridgeTriConstraintStream;
import ai.timefold.solver.constraint.streams.bavet.common.bridge.BavetForeBridgeUniConstraintStream;
import ai.timefold.solver.constraint.streams.bavet.common.tuple.QuadTuple;
import ai.timefold.solver.constraint.streams.bavet.common.tuple.TupleLifecycle;
import ai.timefold.solver.constraint.streams.bavet.quad.BavetAbstractQuadConstraintStream;
import ai.timefold.solver.constraint.streams.bavet.quad.ConcatBiQuadNode;
import ai.timefold.solver.constraint.streams.bavet.quad.ConcatQuadBiNode;
import ai.timefold.solver.constraint.streams.bavet.quad.ConcatQuadQuadNode;
import ai.timefold.solver.constraint.streams.bavet.quad.ConcatQuadTriNode;
import ai.timefold.solver.constraint.streams.bavet.quad.ConcatQuadUniNode;
import ai.timefold.solver.constraint.streams.bavet.quad.ConcatTriQuadNode;
import ai.timefold.solver.constraint.streams.bavet.quad.ConcatUniQuadNode;
import ai.timefold.solver.core.api.score.Score;
import java.util.Objects;
import java.util.Set;

public final class BavetConcatQuadConstraintStream<Solution_, A, B, C, D>
extends BavetAbstractQuadConstraintStream<Solution_, A, B, C, D>
implements BavetConcatConstraintStream<Solution_> {
    private final BavetAbstractConstraintStream<Solution_> leftParent;
    private final BavetAbstractConstraintStream<Solution_> rightParent;
    private final ConcatNodeConstructor<A, B, C, D> nodeConstructor;

    public BavetConcatQuadConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetForeBridgeUniConstraintStream<Solution_, A> leftParent, BavetForeBridgeQuadConstraintStream<Solution_, A, B, C, D> rightParent) {
        super(constraintFactory, leftParent.getRetrievalSemantics());
        this.leftParent = leftParent;
        this.rightParent = rightParent;
        this.nodeConstructor = ConcatUniQuadNode::new;
    }

    public BavetConcatQuadConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetForeBridgeBiConstraintStream<Solution_, A, B> leftParent, BavetForeBridgeQuadConstraintStream<Solution_, A, B, C, D> rightParent) {
        super(constraintFactory, leftParent.getRetrievalSemantics());
        this.leftParent = leftParent;
        this.rightParent = rightParent;
        this.nodeConstructor = ConcatBiQuadNode::new;
    }

    public BavetConcatQuadConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetForeBridgeTriConstraintStream<Solution_, A, B, C> leftParent, BavetForeBridgeQuadConstraintStream<Solution_, A, B, C, D> rightParent) {
        super(constraintFactory, leftParent.getRetrievalSemantics());
        this.leftParent = leftParent;
        this.rightParent = rightParent;
        this.nodeConstructor = ConcatTriQuadNode::new;
    }

    public BavetConcatQuadConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetForeBridgeQuadConstraintStream<Solution_, A, B, C, D> leftParent, BavetForeBridgeUniConstraintStream<Solution_, A> rightParent) {
        super(constraintFactory, leftParent.getRetrievalSemantics());
        this.leftParent = leftParent;
        this.rightParent = rightParent;
        this.nodeConstructor = ConcatQuadUniNode::new;
    }

    public BavetConcatQuadConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetForeBridgeQuadConstraintStream<Solution_, A, B, C, D> leftParent, BavetForeBridgeBiConstraintStream<Solution_, A, B> rightParent) {
        super(constraintFactory, leftParent.getRetrievalSemantics());
        this.leftParent = leftParent;
        this.rightParent = rightParent;
        this.nodeConstructor = ConcatQuadBiNode::new;
    }

    public BavetConcatQuadConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetForeBridgeQuadConstraintStream<Solution_, A, B, C, D> leftParent, BavetForeBridgeTriConstraintStream<Solution_, A, B, C> rightParent) {
        super(constraintFactory, leftParent.getRetrievalSemantics());
        this.leftParent = leftParent;
        this.rightParent = rightParent;
        this.nodeConstructor = ConcatQuadTriNode::new;
    }

    public BavetConcatQuadConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetForeBridgeQuadConstraintStream<Solution_, A, B, C, D> leftParent, BavetForeBridgeQuadConstraintStream<Solution_, A, B, C, D> rightParent) {
        super(constraintFactory, leftParent.getRetrievalSemantics());
        this.leftParent = leftParent;
        this.rightParent = rightParent;
        this.nodeConstructor = ConcatQuadQuadNode::new;
    }

    @Override
    public boolean guaranteesDistinct() {
        if (this.leftParent instanceof BavetAbstractQuadConstraintStream && this.rightParent instanceof BavetAbstractQuadConstraintStream) {
            return false;
        }
        return this.leftParent.guaranteesDistinct() && this.rightParent.guaranteesDistinct();
    }

    @Override
    public void collectActiveConstraintStreams(Set<BavetAbstractConstraintStream<Solution_>> constraintStreamSet) {
        this.leftParent.collectActiveConstraintStreams(constraintStreamSet);
        this.rightParent.collectActiveConstraintStreams(constraintStreamSet);
        constraintStreamSet.add(this);
    }

    @Override
    public <Score_ extends Score<Score_>> void buildNode(NodeBuildHelper<Score_> buildHelper) {
        TupleLifecycle downstream = buildHelper.getAggregatedTupleLifecycle(this.childStreamList);
        int leftCloneStoreIndex = buildHelper.reserveTupleStoreIndex(this.leftParent.getTupleSource());
        int rightCloneStoreIndex = buildHelper.reserveTupleStoreIndex(this.rightParent.getTupleSource());
        int outputStoreSize = buildHelper.extractTupleStoreSize(this);
        AbstractConcatNode<?, ?, ?> node = this.nodeConstructor.apply(downstream, leftCloneStoreIndex, rightCloneStoreIndex, outputStoreSize);
        buildHelper.addNode(node, this, this.leftParent, this.rightParent);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BavetConcatQuadConstraintStream other = (BavetConcatQuadConstraintStream)o;
        return Objects.equals(this.leftParent.getParent(), other.leftParent.getParent()) && Objects.equals(this.rightParent.getParent(), other.rightParent.getParent());
    }

    public int hashCode() {
        return Objects.hash(this.leftParent.getParent(), this.rightParent.getParent());
    }

    public String toString() {
        return "Concat() with " + this.childStreamList.size() + " children";
    }

    @Override
    public BavetAbstractConstraintStream<Solution_> getLeftParent() {
        return this.leftParent;
    }

    @Override
    public BavetAbstractConstraintStream<Solution_> getRightParent() {
        return this.rightParent;
    }

    private static interface ConcatNodeConstructor<A, B, C, D> {
        public AbstractConcatNode<?, ?, ?> apply(TupleLifecycle<QuadTuple<A, B, C, D>> var1, int var2, int var3, int var4);
    }
}

