/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.constraint.streams.bavet.quad;

import ai.timefold.solver.constraint.streams.bavet.common.AbstractMapNode;
import ai.timefold.solver.constraint.streams.bavet.common.tuple.QuadTuple;
import ai.timefold.solver.constraint.streams.bavet.common.tuple.TupleLifecycle;
import ai.timefold.solver.constraint.streams.bavet.common.tuple.UniTuple;
import ai.timefold.solver.core.api.function.QuadFunction;
import java.util.Objects;

final class MapQuadToUniNode<A, B, C, D, NewA>
extends AbstractMapNode<QuadTuple<A, B, C, D>, UniTuple<NewA>> {
    private final QuadFunction<A, B, C, D, NewA> mappingFunction;

    MapQuadToUniNode(int mapStoreIndex, QuadFunction<A, B, C, D, NewA> mappingFunction, TupleLifecycle<UniTuple<NewA>> nextNodesTupleLifecycle, int outputStoreSize) {
        super(mapStoreIndex, nextNodesTupleLifecycle, outputStoreSize);
        this.mappingFunction = Objects.requireNonNull(mappingFunction);
    }

    @Override
    protected UniTuple<NewA> map(QuadTuple<A, B, C, D> tuple) {
        Object factA = tuple.factA;
        Object factB = tuple.factB;
        Object factC = tuple.factC;
        Object factD = tuple.factD;
        return new UniTuple<Object>(this.mappingFunction.apply(factA, factB, factC, factD), this.outputStoreSize);
    }

    @Override
    protected void remap(QuadTuple<A, B, C, D> inTuple, UniTuple<NewA> outTuple) {
        Object factA = inTuple.factA;
        Object factB = inTuple.factB;
        Object factC = inTuple.factC;
        Object factD = inTuple.factD;
        Object newA = this.mappingFunction.apply(factA, factB, factC, factD);
        outTuple.factA = newA;
    }
}

