/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.constraint.streams.bavet.uni;

import ai.timefold.solver.constraint.streams.bavet.common.AbstractNode;
import ai.timefold.solver.constraint.streams.bavet.common.Propagator;
import ai.timefold.solver.constraint.streams.bavet.common.StaticPropagationQueue;
import ai.timefold.solver.constraint.streams.bavet.common.tuple.TupleLifecycle;
import ai.timefold.solver.constraint.streams.bavet.common.tuple.TupleState;
import ai.timefold.solver.constraint.streams.bavet.common.tuple.UniTuple;
import java.util.IdentityHashMap;
import java.util.Map;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class AbstractForEachUniNode<A>
extends AbstractNode {
    private final Class<A> forEachClass;
    private final int outputStoreSize;
    private final StaticPropagationQueue<UniTuple<A>> propagationQueue;
    protected final Map<A, UniTuple<A>> tupleMap = new IdentityHashMap<A, UniTuple<A>>(1000);

    public AbstractForEachUniNode(Class<A> forEachClass, TupleLifecycle<UniTuple<A>> nextNodesTupleLifecycle, int outputStoreSize) {
        this.forEachClass = forEachClass;
        this.outputStoreSize = outputStoreSize;
        this.propagationQueue = new StaticPropagationQueue<UniTuple<A>>(nextNodesTupleLifecycle);
    }

    public void insert(A a) {
        UniTuple<A> tuple = new UniTuple<A>(a, this.outputStoreSize);
        UniTuple<A> old = this.tupleMap.put(a, tuple);
        if (old != null) {
            throw new IllegalStateException("The fact (" + a + ") was already inserted, so it cannot insert again.");
        }
        this.propagationQueue.insert(tuple);
    }

    public abstract void update(A var1);

    protected final void innerUpdate(A a, UniTuple<A> tuple) {
        TupleState state = tuple.state;
        if (state.isDirty()) {
            if (state == TupleState.DYING || state == TupleState.ABORTING) {
                throw new IllegalStateException("The fact (" + a + ") was retracted, so it cannot update.");
            }
        } else {
            this.propagationQueue.update(tuple);
        }
    }

    public void retract(A a) {
        UniTuple<A> tuple = this.tupleMap.remove(a);
        if (tuple == null) {
            throw new IllegalStateException("The fact (" + a + ") was never inserted, so it cannot retract.");
        }
        TupleState state = tuple.state;
        if (state.isDirty()) {
            if (state == TupleState.DYING || state == TupleState.ABORTING) {
                throw new IllegalStateException("The fact (" + a + ") was already retracted, so it cannot retract.");
            }
            this.propagationQueue.retract(tuple, state == TupleState.CREATING ? TupleState.ABORTING : TupleState.DYING);
        } else {
            this.propagationQueue.retract(tuple, TupleState.DYING);
        }
    }

    @Override
    public Propagator getPropagator() {
        return this.propagationQueue;
    }

    public final Class<A> getForEachClass() {
        return this.forEachClass;
    }

    @Override
    public final String toString() {
        return super.toString() + "(" + this.forEachClass.getSimpleName() + ")";
    }
}

