/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.constraint.streams.common;

import ai.timefold.solver.constraint.streams.common.InnerConstraintFactory;
import ai.timefold.solver.constraint.streams.common.ScoreImpactType;
import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.constraint.ConstraintRef;
import ai.timefold.solver.core.api.score.stream.Constraint;
import java.math.BigDecimal;
import java.util.function.Function;

public abstract class AbstractConstraint<Solution_, Constraint_ extends AbstractConstraint<Solution_, Constraint_, ConstraintFactory_>, ConstraintFactory_ extends InnerConstraintFactory<Solution_, Constraint_>>
implements Constraint {
    private final ConstraintFactory_ constraintFactory;
    private final ConstraintRef constraintRef;
    private final Function<Solution_, Score<?>> constraintWeightExtractor;
    private final ScoreImpactType scoreImpactType;
    private final boolean isConstraintWeightConfigurable;
    private final Object justificationMapping;
    private final Object indictedObjectsMapping;

    protected AbstractConstraint(ConstraintFactory_ constraintFactory, ConstraintRef constraintRef, Function<Solution_, Score<?>> constraintWeightExtractor, ScoreImpactType scoreImpactType, boolean isConstraintWeightConfigurable, Object justificationMapping, Object indictedObjectsMapping) {
        this.constraintFactory = constraintFactory;
        this.constraintRef = constraintRef;
        this.constraintWeightExtractor = constraintWeightExtractor;
        this.scoreImpactType = scoreImpactType;
        this.isConstraintWeightConfigurable = isConstraintWeightConfigurable;
        this.justificationMapping = justificationMapping;
        this.indictedObjectsMapping = indictedObjectsMapping;
    }

    public final <Score_ extends Score<Score_>> Score_ extractConstraintWeight(Solution_ workingSolution) {
        if (this.isConstraintWeightConfigurable && workingSolution == null) {
            return (Score_)((InnerConstraintFactory)this.constraintFactory).getSolutionDescriptor().getScoreDefinition().getOneSoftestScore();
        }
        Score constraintWeight = this.constraintWeightExtractor.apply(workingSolution);
        ((InnerConstraintFactory)this.constraintFactory).getSolutionDescriptor().validateConstraintWeight(this.constraintRef, constraintWeight);
        return (Score_)(switch (this.scoreImpactType) {
            default -> throw new IncompatibleClassChangeError();
            case ScoreImpactType.PENALTY -> constraintWeight.negate();
            case ScoreImpactType.REWARD, ScoreImpactType.MIXED -> constraintWeight;
        });
    }

    public final void assertCorrectImpact(int impact) {
        if (impact >= 0) {
            return;
        }
        if (this.scoreImpactType != ScoreImpactType.MIXED) {
            throw new IllegalStateException("Negative match weight (" + impact + ") for constraint (" + this.constraintRef + "). Check constraint provider implementation.");
        }
    }

    public final void assertCorrectImpact(long impact) {
        if (impact >= 0L) {
            return;
        }
        if (this.scoreImpactType != ScoreImpactType.MIXED) {
            throw new IllegalStateException("Negative match weight (" + impact + ") for constraint (" + this.getConstraintRef() + "). Check constraint provider implementation.");
        }
    }

    public final void assertCorrectImpact(BigDecimal impact) {
        if (impact.signum() >= 0) {
            return;
        }
        if (this.scoreImpactType != ScoreImpactType.MIXED) {
            throw new IllegalStateException("Negative match weight (" + impact + ") for constraint (" + this.getConstraintRef() + "). Check constraint provider implementation.");
        }
    }

    public final ConstraintFactory_ getConstraintFactory() {
        return this.constraintFactory;
    }

    public ConstraintRef getConstraintRef() {
        return this.constraintRef;
    }

    public final ScoreImpactType getScoreImpactType() {
        return this.scoreImpactType;
    }

    public <JustificationMapping_> JustificationMapping_ getJustificationMapping() {
        return (JustificationMapping_)this.justificationMapping;
    }

    public <IndictedObjectsMapping_> IndictedObjectsMapping_ getIndictedObjectsMapping() {
        return (IndictedObjectsMapping_)this.indictedObjectsMapping;
    }
}

