/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.constraint.streams.common.inliner;

import ai.timefold.solver.constraint.streams.common.AbstractConstraint;
import ai.timefold.solver.constraint.streams.common.inliner.BendableLongScoreInliner;
import ai.timefold.solver.constraint.streams.common.inliner.ConstraintMatchSupplier;
import ai.timefold.solver.constraint.streams.common.inliner.ScoreContext;
import ai.timefold.solver.constraint.streams.common.inliner.UndoScoreImpacter;
import ai.timefold.solver.core.api.score.buildin.bendablelong.BendableLongScore;

final class BendableLongScoreContext
extends ScoreContext<BendableLongScore, BendableLongScoreInliner> {
    private final int hardScoreLevelCount;
    private final int softScoreLevelCount;
    private final int scoreLevel;
    private final long scoreLevelWeight;

    public BendableLongScoreContext(BendableLongScoreInliner parent, AbstractConstraint<?, ?, ?> constraint, BendableLongScore constraintWeight, int hardScoreLevelCount, int softScoreLevelCount, int scoreLevel, long scoreLevelWeight) {
        super(parent, constraint, constraintWeight);
        this.hardScoreLevelCount = hardScoreLevelCount;
        this.softScoreLevelCount = softScoreLevelCount;
        this.scoreLevel = scoreLevel;
        this.scoreLevelWeight = scoreLevelWeight;
    }

    public BendableLongScoreContext(BendableLongScoreInliner parent, AbstractConstraint<?, ?, ?> constraint, BendableLongScore constraintWeight, int hardScoreLevelCount, int softScoreLevelCount) {
        this(parent, constraint, constraintWeight, hardScoreLevelCount, softScoreLevelCount, -1, -1L);
    }

    public UndoScoreImpacter changeSoftScoreBy(long matchWeight, ConstraintMatchSupplier<BendableLongScore> constraintMatchSupplier) {
        long softImpact = this.scoreLevelWeight * matchWeight;
        int n = this.scoreLevel;
        ((BendableLongScoreInliner)this.parent).softScores[n] = ((BendableLongScoreInliner)this.parent).softScores[n] + softImpact;
        UndoScoreImpacter undoScoreImpact = () -> {
            int n = this.scoreLevel;
            ((BendableLongScoreInliner)this.parent).softScores[n] = ((BendableLongScoreInliner)this.parent).softScores[n] - softImpact;
        };
        if (!this.constraintMatchEnabled) {
            return undoScoreImpact;
        }
        return this.impactWithConstraintMatch(undoScoreImpact, BendableLongScore.ofSoft((int)this.hardScoreLevelCount, (int)this.softScoreLevelCount, (int)this.scoreLevel, (long)softImpact), constraintMatchSupplier);
    }

    public UndoScoreImpacter changeHardScoreBy(long matchWeight, ConstraintMatchSupplier<BendableLongScore> constraintMatchSupplier) {
        long hardImpact = this.scoreLevelWeight * matchWeight;
        int n = this.scoreLevel;
        ((BendableLongScoreInliner)this.parent).hardScores[n] = ((BendableLongScoreInliner)this.parent).hardScores[n] + hardImpact;
        UndoScoreImpacter undoScoreImpact = () -> {
            int n = this.scoreLevel;
            ((BendableLongScoreInliner)this.parent).hardScores[n] = ((BendableLongScoreInliner)this.parent).hardScores[n] - hardImpact;
        };
        if (!this.constraintMatchEnabled) {
            return undoScoreImpact;
        }
        return this.impactWithConstraintMatch(undoScoreImpact, BendableLongScore.ofHard((int)this.hardScoreLevelCount, (int)this.softScoreLevelCount, (int)this.scoreLevel, (long)hardImpact), constraintMatchSupplier);
    }

    public UndoScoreImpacter changeScoreBy(long matchWeight, ConstraintMatchSupplier<BendableLongScore> constraintMatchSupplier) {
        long[] hardImpacts = new long[this.hardScoreLevelCount];
        long[] softImpacts = new long[this.softScoreLevelCount];
        int hardScoreLevel = 0;
        while (hardScoreLevel < this.hardScoreLevelCount) {
            long hardImpact;
            hardImpacts[hardScoreLevel] = hardImpact = ((BendableLongScore)this.constraintWeight).hardScore(hardScoreLevel) * matchWeight;
            int n = hardScoreLevel++;
            ((BendableLongScoreInliner)this.parent).hardScores[n] = ((BendableLongScoreInliner)this.parent).hardScores[n] + hardImpact;
        }
        int softScoreLevel = 0;
        while (softScoreLevel < this.softScoreLevelCount) {
            long softImpact;
            softImpacts[softScoreLevel] = softImpact = ((BendableLongScore)this.constraintWeight).softScore(softScoreLevel) * matchWeight;
            int n = softScoreLevel++;
            ((BendableLongScoreInliner)this.parent).softScores[n] = ((BendableLongScoreInliner)this.parent).softScores[n] + softImpact;
        }
        UndoScoreImpacter undoScoreImpact = () -> {
            for (int hardScoreLevel = 0; hardScoreLevel < this.hardScoreLevelCount; ++hardScoreLevel) {
                int n = hardScoreLevel;
                ((BendableLongScoreInliner)this.parent).hardScores[n] = ((BendableLongScoreInliner)this.parent).hardScores[n] - hardImpacts[hardScoreLevel];
            }
            for (int softScoreLevel = 0; softScoreLevel < this.softScoreLevelCount; ++softScoreLevel) {
                int n = softScoreLevel;
                ((BendableLongScoreInliner)this.parent).softScores[n] = ((BendableLongScoreInliner)this.parent).softScores[n] - softImpacts[softScoreLevel];
            }
        };
        if (!this.constraintMatchEnabled) {
            return undoScoreImpact;
        }
        return this.impactWithConstraintMatch(undoScoreImpact, BendableLongScore.of((long[])hardImpacts, (long[])softImpacts), constraintMatchSupplier);
    }
}

