/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.constraint.streams.common.quad;

import ai.timefold.solver.constraint.streams.common.quad.DefaultQuadJoiner;
import ai.timefold.solver.constraint.streams.common.quad.FilteringQuadJoiner;
import ai.timefold.solver.core.api.function.QuadPredicate;
import ai.timefold.solver.core.api.score.stream.quad.QuadJoiner;
import java.util.ArrayList;
import java.util.List;

public final class QuadJoinerComber<A, B, C, D> {
    private final DefaultQuadJoiner<A, B, C, D> mergedJoiner;
    private final QuadPredicate<A, B, C, D> mergedFiltering;

    public static <A, B, C, D> QuadJoinerComber<A, B, C, D> comb(QuadJoiner<A, B, C, D>[] joiners) {
        ArrayList defaultJoinerList = new ArrayList(joiners.length);
        ArrayList<QuadPredicate<A, B, C, D>> filteringList = new ArrayList<QuadPredicate<A, B, C, D>>(joiners.length);
        int indexOfFirstFilter = -1;
        for (int i = 0; i < joiners.length; ++i) {
            QuadJoiner<A, B, C, D> joiner = joiners[i];
            if (joiner instanceof FilteringQuadJoiner) {
                indexOfFirstFilter = i;
                filteringList.add(((FilteringQuadJoiner)joiner).getFilter());
                continue;
            }
            if (joiner instanceof DefaultQuadJoiner) {
                if (indexOfFirstFilter >= 0) {
                    throw new IllegalStateException("Indexing joiner (" + joiner + ") must not follow a filtering joiner (" + joiners[indexOfFirstFilter] + ").\nMaybe reorder the joiners such that filtering() joiners are later in the parameter list.");
                }
                defaultJoinerList.add((DefaultQuadJoiner)joiner);
                continue;
            }
            throw new IllegalArgumentException("The joiner class (" + joiner.getClass() + ") is not supported.");
        }
        DefaultQuadJoiner mergedJoiner = DefaultQuadJoiner.merge(defaultJoinerList);
        QuadPredicate<A, B, C, D> mergedFiltering = QuadJoinerComber.mergeFiltering(filteringList);
        return new QuadJoinerComber(mergedJoiner, mergedFiltering);
    }

    private static <A, B, C, D> QuadPredicate<A, B, C, D> mergeFiltering(List<QuadPredicate<A, B, C, D>> filteringList) {
        if (filteringList.isEmpty()) {
            return null;
        }
        switch (filteringList.size()) {
            case 1: {
                return filteringList.get(0);
            }
            case 2: {
                return filteringList.get(0).and(filteringList.get(1));
            }
        }
        return (a, b, c, d) -> {
            for (QuadPredicate predicate : filteringList) {
                if (predicate.test(a, b, c, d)) continue;
                return false;
            }
            return true;
        };
    }

    public QuadJoinerComber(DefaultQuadJoiner<A, B, C, D> mergedJoiner, QuadPredicate<A, B, C, D> mergedFiltering) {
        this.mergedJoiner = mergedJoiner;
        this.mergedFiltering = mergedFiltering;
    }

    public DefaultQuadJoiner<A, B, C, D> getMergedJoiner() {
        return this.mergedJoiner;
    }

    public QuadPredicate<A, B, C, D> getMergedFiltering() {
        return this.mergedFiltering;
    }
}

