/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.test.impl.score.stream;

import ai.timefold.solver.constraint.streams.common.AbstractConstraintStreamScoreDirectorFactory;
import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.test.impl.score.stream.SessionBasedAssertionBuilder;
import java.util.Arrays;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractConstraintVerification<Solution_, Score_ extends Score<Score_>> {
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    protected final AbstractConstraintStreamScoreDirectorFactory<Solution_, Score_> scoreDirectorFactory;
    protected final SessionBasedAssertionBuilder<Solution_, Score_> sessionBasedAssertionBuilder;

    AbstractConstraintVerification(AbstractConstraintStreamScoreDirectorFactory<Solution_, Score_> scoreDirectorFactory) {
        this.scoreDirectorFactory = scoreDirectorFactory;
        this.sessionBasedAssertionBuilder = new SessionBasedAssertionBuilder<Solution_, Score_>(scoreDirectorFactory);
    }

    protected void assertCorrectArguments(Object ... facts) {
        Class solutionClass = this.scoreDirectorFactory.getSolutionDescriptor().getSolutionClass();
        if (facts.length == 1 && facts[0].getClass() == solutionClass) {
            this.LOGGER.warn("Called given() with the planning solution instance ({}) as an argument.This will treat the solution as a fact, which is likely not intended.\nMaybe call givenSolution() instead?", facts[0]);
        }
        Arrays.stream(facts).filter(fact -> fact instanceof Collection).findFirst().ifPresent(collection -> this.LOGGER.warn("Called given() with collection ({}) as argument.This will treat the collection itself as a fact, and not its contents.\nMaybe enumerate the contents instead?", collection));
    }
}

