/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.extension;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.tools.ant.taskdefs.optional.extension.Compatibility;
import org.apache.tools.ant.taskdefs.optional.extension.DeweyDecimal;

public final class Extension {
    public static final Attributes.Name EXTENSION_LIST = new Attributes.Name("Extension-List");
    public static final Attributes.Name OPTIONAL_EXTENSION_LIST = new Attributes.Name("Optional-Extension-List");
    public static final Attributes.Name EXTENSION_NAME = new Attributes.Name("Extension-Name");
    public static final Attributes.Name SPECIFICATION_VERSION = Attributes.Name.SPECIFICATION_VERSION;
    public static final Attributes.Name SPECIFICATION_VENDOR = Attributes.Name.SPECIFICATION_VENDOR;
    public static final Attributes.Name IMPLEMENTATION_VERSION = Attributes.Name.IMPLEMENTATION_VERSION;
    public static final Attributes.Name IMPLEMENTATION_VENDOR = Attributes.Name.IMPLEMENTATION_VENDOR;
    public static final Attributes.Name IMPLEMENTATION_URL = new Attributes.Name("Implementation-URL");
    public static final Attributes.Name IMPLEMENTATION_VENDOR_ID = new Attributes.Name("Implementation-Vendor-Id");
    public static final Compatibility COMPATIBLE = new Compatibility("COMPATIBLE");
    public static final Compatibility REQUIRE_SPECIFICATION_UPGRADE = new Compatibility("REQUIRE_SPECIFICATION_UPGRADE");
    public static final Compatibility REQUIRE_VENDOR_SWITCH = new Compatibility("REQUIRE_VENDOR_SWITCH");
    public static final Compatibility REQUIRE_IMPLEMENTATION_UPGRADE = new Compatibility("REQUIRE_IMPLEMENTATION_UPGRADE");
    public static final Compatibility INCOMPATIBLE = new Compatibility("INCOMPATIBLE");
    private String m_extensionName;
    private DeweyDecimal m_specificationVersion;
    private String m_specificationVendor;
    private String m_implementationVendorID;
    private String m_implementationVendor;
    private DeweyDecimal m_implementationVersion;
    private String m_implementationURL;

    public static Extension[] getAvailable(Manifest manifest) {
        Extension extension;
        if (null == manifest) {
            return new Extension[0];
        }
        ArrayList<Extension> results = new ArrayList<Extension>();
        Attributes mainAttributes = manifest.getMainAttributes();
        if (null != mainAttributes && null != (extension = Extension.getExtension("", mainAttributes))) {
            results.add(extension);
        }
        Map<String, Attributes> entries = manifest.getEntries();
        Iterator<String> keys = entries.keySet().iterator();
        while (keys.hasNext()) {
            String key = keys.next();
            Attributes attributes = entries.get(key);
            Extension extension2 = Extension.getExtension("", attributes);
            if (null == extension2) continue;
            results.add(extension2);
        }
        return results.toArray(new Extension[0]);
    }

    public static Extension[] getRequired(Manifest manifest) {
        return Extension.getListed(manifest, EXTENSION_LIST);
    }

    public static Extension[] getOptions(Manifest manifest) {
        return Extension.getListed(manifest, OPTIONAL_EXTENSION_LIST);
    }

    public static void addExtension(Extension extension, Attributes attributes) {
        Extension.addExtension(extension, "", attributes);
    }

    public static void addExtension(Extension extension, String prefix, Attributes attributes) {
        String implementationURL;
        DeweyDecimal implementationVersion;
        String implementationVendor;
        String implementationVendorID;
        DeweyDecimal specificationVersion;
        attributes.putValue(prefix + EXTENSION_NAME, extension.getExtensionName());
        String specificationVendor = extension.getSpecificationVendor();
        if (null != specificationVendor) {
            attributes.putValue(prefix + SPECIFICATION_VENDOR, specificationVendor);
        }
        if (null != (specificationVersion = extension.getSpecificationVersion())) {
            attributes.putValue(prefix + SPECIFICATION_VERSION, specificationVersion.toString());
        }
        if (null != (implementationVendorID = extension.getImplementationVendorID())) {
            attributes.putValue(prefix + IMPLEMENTATION_VENDOR_ID, implementationVendorID);
        }
        if (null != (implementationVendor = extension.getImplementationVendor())) {
            attributes.putValue(prefix + IMPLEMENTATION_VENDOR, implementationVendor);
        }
        if (null != (implementationVersion = extension.getImplementationVersion())) {
            attributes.putValue(prefix + IMPLEMENTATION_VERSION, implementationVersion.toString());
        }
        if (null != (implementationURL = extension.getImplementationURL())) {
            attributes.putValue(prefix + IMPLEMENTATION_URL, implementationURL);
        }
    }

    public Extension(String extensionName, String specificationVersion, String specificationVendor, String implementationVersion, String implementationVendor, String implementationVendorId, String implementationURL) {
        this.m_extensionName = extensionName;
        this.m_specificationVendor = specificationVendor;
        if (null != specificationVersion) {
            try {
                this.m_specificationVersion = new DeweyDecimal(specificationVersion);
            }
            catch (NumberFormatException nfe) {
                String error = "Bad specification version format '" + specificationVersion + "' in '" + extensionName + "'. (Reason: " + nfe + ")";
                throw new IllegalArgumentException(error);
            }
        }
        this.m_implementationURL = implementationURL;
        this.m_implementationVendor = implementationVendor;
        this.m_implementationVendorID = implementationVendorId;
        if (null != implementationVersion) {
            try {
                this.m_implementationVersion = new DeweyDecimal(implementationVersion);
            }
            catch (NumberFormatException nfe) {
                String error = "Bad implementation version format '" + implementationVersion + "' in '" + extensionName + "'. (Reason: " + nfe + ")";
                throw new IllegalArgumentException(error);
            }
        }
        if (null == this.m_extensionName) {
            throw new NullPointerException("extensionName property is null");
        }
    }

    public String getExtensionName() {
        return this.m_extensionName;
    }

    public String getSpecificationVendor() {
        return this.m_specificationVendor;
    }

    public DeweyDecimal getSpecificationVersion() {
        return this.m_specificationVersion;
    }

    public String getImplementationURL() {
        return this.m_implementationURL;
    }

    public String getImplementationVendor() {
        return this.m_implementationVendor;
    }

    public String getImplementationVendorID() {
        return this.m_implementationVendorID;
    }

    public DeweyDecimal getImplementationVersion() {
        return this.m_implementationVersion;
    }

    public Compatibility getCompatibilityWith(Extension required) {
        if (!this.m_extensionName.equals(required.getExtensionName())) {
            return INCOMPATIBLE;
        }
        DeweyDecimal specificationVersion = required.getSpecificationVersion();
        if (!(null == specificationVersion || null != this.m_specificationVersion && this.isCompatible(this.m_specificationVersion, specificationVersion))) {
            return REQUIRE_SPECIFICATION_UPGRADE;
        }
        String implementationVendorId = required.getImplementationVendorID();
        if (!(null == implementationVendorId || null != this.m_implementationVendorID && this.m_implementationVendorID.equals(implementationVendorId))) {
            return REQUIRE_VENDOR_SWITCH;
        }
        DeweyDecimal implementationVersion = required.getImplementationVersion();
        if (!(null == implementationVersion || null != this.m_implementationVersion && this.isCompatible(this.m_implementationVersion, implementationVersion))) {
            return REQUIRE_IMPLEMENTATION_UPGRADE;
        }
        return COMPATIBLE;
    }

    public boolean isCompatibleWith(Extension required) {
        return COMPATIBLE == this.getCompatibilityWith(required);
    }

    public String toString() {
        String lineSeparator = System.getProperty("line.separator");
        String brace = ": ";
        StringBuffer sb = new StringBuffer(EXTENSION_NAME.toString());
        sb.append(": ");
        sb.append(this.m_extensionName);
        sb.append(lineSeparator);
        if (null != this.m_specificationVersion) {
            sb.append(SPECIFICATION_VERSION);
            sb.append(": ");
            sb.append(this.m_specificationVersion);
            sb.append(lineSeparator);
        }
        if (null != this.m_specificationVendor) {
            sb.append(SPECIFICATION_VENDOR);
            sb.append(": ");
            sb.append(this.m_specificationVendor);
            sb.append(lineSeparator);
        }
        if (null != this.m_implementationVersion) {
            sb.append(IMPLEMENTATION_VERSION);
            sb.append(": ");
            sb.append(this.m_implementationVersion);
            sb.append(lineSeparator);
        }
        if (null != this.m_implementationVendorID) {
            sb.append(IMPLEMENTATION_VENDOR_ID);
            sb.append(": ");
            sb.append(this.m_implementationVendorID);
            sb.append(lineSeparator);
        }
        if (null != this.m_implementationVendor) {
            sb.append(IMPLEMENTATION_VENDOR);
            sb.append(": ");
            sb.append(this.m_implementationVendor);
            sb.append(lineSeparator);
        }
        if (null != this.m_implementationURL) {
            sb.append(IMPLEMENTATION_URL);
            sb.append(": ");
            sb.append(this.m_implementationURL);
            sb.append(lineSeparator);
        }
        return sb.toString();
    }

    private boolean isCompatible(DeweyDecimal first, DeweyDecimal second) {
        return first.isGreaterThanOrEqual(second);
    }

    private static Extension[] getListed(Manifest manifest, Attributes.Name listKey) {
        ArrayList results = new ArrayList();
        Attributes mainAttributes = manifest.getMainAttributes();
        if (null != mainAttributes) {
            Extension.getExtension(mainAttributes, results, listKey);
        }
        Map<String, Attributes> entries = manifest.getEntries();
        Iterator<String> keys = entries.keySet().iterator();
        while (keys.hasNext()) {
            String key = keys.next();
            Attributes attributes = entries.get(key);
            Extension.getExtension(attributes, results, listKey);
        }
        return results.toArray(new Extension[0]);
    }

    private static void getExtension(Attributes attributes, ArrayList required, Attributes.Name listKey) {
        String names = attributes.getValue(listKey);
        if (null == names) {
            return;
        }
        String[] extentions = Extension.split(names, " ");
        int i = 0;
        while (i < extentions.length) {
            String prefix = extentions[i] + "-";
            Extension extension = Extension.getExtension(prefix, attributes);
            if (null != extension) {
                required.add(extension);
            }
            ++i;
        }
    }

    private static final String[] split(String string, String onToken) {
        StringTokenizer tokenizer = new StringTokenizer(string, onToken);
        String[] result = new String[tokenizer.countTokens()];
        int i = 0;
        while (i < result.length) {
            result[i] = tokenizer.nextToken();
            ++i;
        }
        return result;
    }

    private static Extension getExtension(String prefix, Attributes attributes) {
        String nameKey = prefix + EXTENSION_NAME;
        String name = Extension.getTrimmedString(attributes.getValue(nameKey));
        if (null == name) {
            return null;
        }
        String specVendorKey = prefix + SPECIFICATION_VENDOR;
        String specVendor = Extension.getTrimmedString(attributes.getValue(specVendorKey));
        String specVersionKey = prefix + SPECIFICATION_VERSION;
        String specVersion = Extension.getTrimmedString(attributes.getValue(specVersionKey));
        String impVersionKey = prefix + IMPLEMENTATION_VERSION;
        String impVersion = Extension.getTrimmedString(attributes.getValue(impVersionKey));
        String impVendorKey = prefix + IMPLEMENTATION_VENDOR;
        String impVendor = Extension.getTrimmedString(attributes.getValue(impVendorKey));
        String impVendorIDKey = prefix + IMPLEMENTATION_VENDOR_ID;
        String impVendorId = Extension.getTrimmedString(attributes.getValue(impVendorIDKey));
        String impURLKey = prefix + IMPLEMENTATION_URL;
        String impURL = Extension.getTrimmedString(attributes.getValue(impURLKey));
        return new Extension(name, specVersion, specVendor, impVersion, impVendor, impVendorId, impURL);
    }

    private static String getTrimmedString(String value) {
        if (null == value) {
            return null;
        }
        return value.trim();
    }
}

