/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.consumer.dsl;

import au.com.dius.pact.consumer.InvalidMatcherException;
import au.com.dius.pact.consumer.dsl.DslPart;
import au.com.dius.pact.consumer.dsl.PactDslJsonArray;
import au.com.dius.pact.consumer.dsl.PactDslJsonBody;
import au.com.dius.pact.core.matchers.UrlMatcherSupport;
import au.com.dius.pact.core.model.generators.Category;
import au.com.dius.pact.core.model.generators.DateGenerator;
import au.com.dius.pact.core.model.generators.DateTimeGenerator;
import au.com.dius.pact.core.model.generators.Generator;
import au.com.dius.pact.core.model.generators.ProviderStateGenerator;
import au.com.dius.pact.core.model.generators.RandomDecimalGenerator;
import au.com.dius.pact.core.model.generators.RandomHexadecimalGenerator;
import au.com.dius.pact.core.model.generators.RandomIntGenerator;
import au.com.dius.pact.core.model.generators.RandomStringGenerator;
import au.com.dius.pact.core.model.generators.RegexGenerator;
import au.com.dius.pact.core.model.generators.TimeGenerator;
import au.com.dius.pact.core.model.generators.UuidGenerator;
import au.com.dius.pact.core.model.matchingrules.MatchingRule;
import au.com.dius.pact.core.model.matchingrules.MatchingRuleGroup;
import au.com.dius.pact.core.model.matchingrules.NumberTypeMatcher;
import au.com.dius.pact.core.model.matchingrules.RegexMatcher;
import au.com.dius.pact.core.model.matchingrules.RuleLogic;
import au.com.dius.pact.core.model.matchingrules.TypeMatcher;
import au.com.dius.pact.core.support.Json;
import au.com.dius.pact.core.support.expressions.DataType;
import com.mifmif.common.regex.Generex;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.UUID;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.json.JSONObject;

public class PactDslJsonRootValue
extends DslPart {
    private static final String USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS = "Use PactDslJsonArray for arrays";
    private static final String USE_PACT_DSL_JSON_BODY_FOR_OBJECTS = "Use PactDslJsonBody for objects";
    private static final String EXAMPLE = "Example \"";
    private Object value;
    private boolean encodeJson = false;

    public PactDslJsonRootValue() {
        super("", "");
    }

    @Override
    protected void putObject(DslPart object) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void putArray(DslPart object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getBody() {
        if (this.encodeJson) {
            return Json.toJson((Object)this.value).serialise();
        }
        return this.value;
    }

    public boolean isEncodeJson() {
        return this.encodeJson;
    }

    public void setEncodeJson(boolean encodeJson) {
        this.encodeJson = encodeJson;
    }

    @Override
    @Deprecated
    public PactDslJsonArray array(String name) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    @Deprecated
    public PactDslJsonArray array() {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    @Deprecated
    public DslPart closeArray() {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    @Deprecated
    public PactDslJsonBody eachLike(String name) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    @Deprecated
    public PactDslJsonBody eachLike(int numberExamples) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    @Deprecated
    public PactDslJsonBody eachLike(String name, int numberExamples) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    @Deprecated
    public PactDslJsonBody eachLike() {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    @Deprecated
    public PactDslJsonBody minArrayLike(String name, Integer size) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    @Deprecated
    public PactDslJsonBody minArrayLike(Integer size) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    @Deprecated
    public PactDslJsonBody minArrayLike(String name, Integer size, int numberExamples) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    @Deprecated
    public PactDslJsonBody minArrayLike(Integer size, int numberExamples) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    @Deprecated
    public PactDslJsonBody maxArrayLike(String name, Integer size) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    @Deprecated
    public PactDslJsonBody maxArrayLike(Integer size) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    @Deprecated
    public PactDslJsonBody maxArrayLike(String name, Integer size, int numberExamples) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    @Deprecated
    public PactDslJsonBody maxArrayLike(Integer size, int numberExamples) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    @Deprecated
    public PactDslJsonBody minMaxArrayLike(String name, Integer minSize, Integer maxSize) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    @Deprecated
    public PactDslJsonBody minMaxArrayLike(Integer minSize, Integer maxSize) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    @Deprecated
    public PactDslJsonBody minMaxArrayLike(String name, Integer minSize, Integer maxSize, int numberExamples) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    @Deprecated
    public PactDslJsonBody minMaxArrayLike(Integer minSize, Integer maxSize, int numberExamples) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    @Deprecated
    public PactDslJsonBody object(String name) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_BODY_FOR_OBJECTS);
    }

    @Override
    @Deprecated
    public PactDslJsonBody object() {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_BODY_FOR_OBJECTS);
    }

    @Override
    @Deprecated
    public DslPart closeObject() {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_BODY_FOR_OBJECTS);
    }

    @Override
    public DslPart close() {
        this.getMatchers().applyMatcherRootPrefix("$");
        this.getGenerators().applyRootPrefix("$");
        return this;
    }

    public static PactDslJsonRootValue stringType() {
        PactDslJsonRootValue value = new PactDslJsonRootValue();
        value.generators.addGenerator(Category.BODY, "", (Generator)new RandomStringGenerator(20));
        value.setValue("string");
        value.setMatcher((MatchingRule)TypeMatcher.INSTANCE);
        return value;
    }

    public static PactDslJsonRootValue stringType(String example) {
        PactDslJsonRootValue value = new PactDslJsonRootValue();
        value.setValue(example);
        value.setMatcher((MatchingRule)TypeMatcher.INSTANCE);
        return value;
    }

    public static PactDslJsonRootValue numberType() {
        PactDslJsonRootValue value = new PactDslJsonRootValue();
        value.generators.addGenerator(Category.BODY, "", (Generator)new RandomIntGenerator(0, Integer.MAX_VALUE));
        value.setValue(100);
        value.setMatcher((MatchingRule)TypeMatcher.INSTANCE);
        return value;
    }

    public static PactDslJsonRootValue numberType(Number number) {
        PactDslJsonRootValue value = new PactDslJsonRootValue();
        value.setValue(number);
        value.setMatcher((MatchingRule)TypeMatcher.INSTANCE);
        return value;
    }

    public static PactDslJsonRootValue integerType() {
        PactDslJsonRootValue value = new PactDslJsonRootValue();
        value.generators.addGenerator(Category.BODY, "", (Generator)new RandomIntGenerator(0, Integer.MAX_VALUE));
        value.setValue(100);
        value.setMatcher((MatchingRule)new NumberTypeMatcher(NumberTypeMatcher.NumberType.INTEGER));
        return value;
    }

    public static PactDslJsonRootValue integerType(Long number) {
        PactDslJsonRootValue value = new PactDslJsonRootValue();
        value.setValue(number);
        value.setMatcher((MatchingRule)new NumberTypeMatcher(NumberTypeMatcher.NumberType.INTEGER));
        return value;
    }

    public static PactDslJsonRootValue integerType(Integer number) {
        PactDslJsonRootValue value = new PactDslJsonRootValue();
        value.setValue(number);
        value.setMatcher((MatchingRule)new NumberTypeMatcher(NumberTypeMatcher.NumberType.INTEGER));
        return value;
    }

    public static PactDslJsonRootValue decimalType() {
        PactDslJsonRootValue value = new PactDslJsonRootValue();
        value.generators.addGenerator(Category.BODY, "", (Generator)new RandomDecimalGenerator(10));
        value.setValue(100);
        value.setMatcher((MatchingRule)new NumberTypeMatcher(NumberTypeMatcher.NumberType.DECIMAL));
        return value;
    }

    public static PactDslJsonRootValue decimalType(BigDecimal number) {
        PactDslJsonRootValue value = new PactDslJsonRootValue();
        value.setValue(number);
        value.setMatcher((MatchingRule)new NumberTypeMatcher(NumberTypeMatcher.NumberType.DECIMAL));
        return value;
    }

    public static PactDslJsonRootValue decimalType(Double number) {
        PactDslJsonRootValue value = new PactDslJsonRootValue();
        value.setValue(number);
        value.setMatcher((MatchingRule)new NumberTypeMatcher(NumberTypeMatcher.NumberType.DECIMAL));
        return value;
    }

    public static PactDslJsonRootValue booleanType() {
        return PactDslJsonRootValue.booleanType(true);
    }

    public static PactDslJsonRootValue booleanType(Boolean example) {
        PactDslJsonRootValue value = new PactDslJsonRootValue();
        value.setValue(example);
        value.setMatcher((MatchingRule)TypeMatcher.INSTANCE);
        return value;
    }

    public static PactDslJsonRootValue stringMatcher(String regex, String value) {
        if (!value.matches(regex)) {
            throw new InvalidMatcherException(EXAMPLE + value + "\" does not match regular expression \"" + regex + "\"");
        }
        PactDslJsonRootValue rootValue = new PactDslJsonRootValue();
        rootValue.setValue(value);
        rootValue.setMatcher((MatchingRule)new RegexMatcher(regex, value));
        return rootValue;
    }

    @Deprecated
    public static PactDslJsonRootValue stringMatcher(String regex) {
        PactDslJsonRootValue rootValue = new PactDslJsonRootValue();
        rootValue.generators.addGenerator(Category.BODY, "", (Generator)new RegexGenerator(regex));
        rootValue.setValue(new Generex(regex).random());
        rootValue.setMatcher((MatchingRule)rootValue.regexp(regex));
        return rootValue;
    }

    public static PactDslJsonRootValue timestamp() {
        return PactDslJsonRootValue.timestamp(DateFormatUtils.ISO_DATETIME_FORMAT.getPattern());
    }

    public static PactDslJsonRootValue timestamp(String format) {
        PactDslJsonRootValue value = new PactDslJsonRootValue();
        value.generators.addGenerator(Category.BODY, "", (Generator)new DateTimeGenerator(format));
        FastDateFormat instance = FastDateFormat.getInstance((String)format);
        value.setValue(instance.format(new Date(949323600000L)));
        value.setMatcher((MatchingRule)value.matchTimestamp(format));
        return value;
    }

    public static PactDslJsonRootValue timestamp(String format, Date example) {
        FastDateFormat instance = FastDateFormat.getInstance((String)format);
        PactDslJsonRootValue value = new PactDslJsonRootValue();
        value.setValue(instance.format(example));
        value.setMatcher((MatchingRule)value.matchTimestamp(format));
        return value;
    }

    public static PactDslJsonRootValue date() {
        return PactDslJsonRootValue.date(DateFormatUtils.ISO_DATE_FORMAT.getPattern());
    }

    public static PactDslJsonRootValue date(String format) {
        FastDateFormat instance = FastDateFormat.getInstance((String)format);
        PactDslJsonRootValue value = new PactDslJsonRootValue();
        value.generators.addGenerator(Category.BODY, "", (Generator)new DateGenerator(format));
        value.setValue(instance.format(new Date(949323600000L)));
        value.setMatcher((MatchingRule)value.matchDate(format));
        return value;
    }

    public static PactDslJsonRootValue date(String format, Date example) {
        FastDateFormat instance = FastDateFormat.getInstance((String)format);
        PactDslJsonRootValue value = new PactDslJsonRootValue();
        value.setValue(instance.format(example));
        value.setMatcher((MatchingRule)value.matchDate(format));
        return value;
    }

    public static PactDslJsonRootValue time() {
        return PactDslJsonRootValue.time(DateFormatUtils.ISO_TIME_FORMAT.getPattern());
    }

    public static PactDslJsonRootValue time(String format) {
        FastDateFormat instance = FastDateFormat.getInstance((String)format);
        PactDslJsonRootValue value = new PactDslJsonRootValue();
        value.generators.addGenerator(Category.BODY, "", (Generator)new TimeGenerator(format));
        value.setValue(instance.format(new Date(949323600000L)));
        value.setMatcher((MatchingRule)value.matchTime(format));
        return value;
    }

    public static PactDslJsonRootValue time(String format, Date example) {
        FastDateFormat instance = FastDateFormat.getInstance((String)format);
        PactDslJsonRootValue value = new PactDslJsonRootValue();
        value.setValue(instance.format(example));
        value.setMatcher((MatchingRule)value.matchTime(format));
        return value;
    }

    public static PactDslJsonRootValue ipAddress() {
        PactDslJsonRootValue value = new PactDslJsonRootValue();
        value.setValue("127.0.0.1");
        value.setMatcher((MatchingRule)value.regexp("(\\d{1,3}\\.)+\\d{1,3}"));
        return value;
    }

    public static PactDslJsonRootValue id() {
        return PactDslJsonRootValue.numberType();
    }

    public static PactDslJsonRootValue id(Long id) {
        return PactDslJsonRootValue.numberType(id);
    }

    public static PactDslJsonRootValue hexValue() {
        PactDslJsonRootValue value = new PactDslJsonRootValue();
        value.generators.addGenerator(Category.BODY, "", (Generator)new RandomHexadecimalGenerator(10));
        value.setValue("1234a");
        value.setMatcher((MatchingRule)value.regexp("[0-9a-fA-F]+"));
        return value;
    }

    public static PactDslJsonRootValue hexValue(String hexValue) {
        if (!hexValue.matches("[0-9a-fA-F]+")) {
            throw new InvalidMatcherException(EXAMPLE + hexValue + "\" is not a hexadecimal value");
        }
        PactDslJsonRootValue value = new PactDslJsonRootValue();
        value.setValue(hexValue);
        value.setMatcher((MatchingRule)value.regexp("[0-9a-fA-F]+"));
        return value;
    }

    public static PactDslJsonRootValue uuid() {
        PactDslJsonRootValue value = new PactDslJsonRootValue();
        value.generators.addGenerator(Category.BODY, "", (Generator)UuidGenerator.INSTANCE);
        value.setValue("e2490de5-5bd3-43d5-b7c4-526e33f71304");
        value.setMatcher((MatchingRule)value.regexp("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}"));
        return value;
    }

    public static PactDslJsonRootValue uuid(UUID uuid) {
        return PactDslJsonRootValue.uuid(uuid.toString());
    }

    public static PactDslJsonRootValue uuid(String uuid) {
        if (!uuid.matches("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}")) {
            throw new InvalidMatcherException(EXAMPLE + uuid + "\" is not an UUID");
        }
        PactDslJsonRootValue value = new PactDslJsonRootValue();
        value.setValue(uuid);
        value.setMatcher((MatchingRule)value.regexp("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}"));
        return value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setMatcher(MatchingRule matcher) {
        this.matchers.addRule(matcher);
    }

    @Override
    @Deprecated
    public PactDslJsonArray eachArrayLike(String name) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    @Deprecated
    public PactDslJsonArray eachArrayLike(int numberExamples) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    @Deprecated
    public PactDslJsonArray eachArrayWithMaxLike(String name, Integer size) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    @Deprecated
    public PactDslJsonArray eachArrayWithMaxLike(Integer size) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    @Deprecated
    public PactDslJsonArray eachArrayWithMaxLike(String name, int numberExamples, Integer size) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    @Deprecated
    public PactDslJsonArray eachArrayWithMaxLike(int numberExamples, Integer size) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    @Deprecated
    public PactDslJsonArray eachArrayWithMinLike(String name, Integer size) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    @Deprecated
    public PactDslJsonArray eachArrayWithMinLike(Integer size) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    @Deprecated
    public PactDslJsonArray eachArrayWithMinLike(String name, int numberExamples, Integer size) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    @Deprecated
    public PactDslJsonArray eachArrayWithMinLike(int numberExamples, Integer size) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    @Deprecated
    public PactDslJsonArray eachArrayWithMinMaxLike(String name, Integer minSize, Integer maxSize) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    @Deprecated
    public PactDslJsonArray eachArrayWithMinMaxLike(Integer minSize, Integer maxSize) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    @Deprecated
    public PactDslJsonArray eachArrayWithMinMaxLike(String name, int numberExamples, Integer minSize, Integer maxSize) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    @Deprecated
    public PactDslJsonArray eachArrayWithMinMaxLike(int numberExamples, Integer minSize, Integer maxSize) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    @Deprecated
    public PactDslJsonArray eachArrayLike(String name, int numberExamples) {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    @Override
    @Deprecated
    public PactDslJsonArray eachArrayLike() {
        throw new UnsupportedOperationException(USE_PACT_DSL_JSON_ARRAY_FOR_ARRAYS);
    }

    public static PactDslJsonRootValue and(Object example, MatchingRule ... rules) {
        PactDslJsonRootValue value = new PactDslJsonRootValue();
        if (example != null) {
            value.setValue(example);
        } else {
            value.setValue(JSONObject.NULL);
        }
        value.matchers.setRules("", new MatchingRuleGroup(Arrays.asList(rules), RuleLogic.AND));
        return value;
    }

    public static PactDslJsonRootValue or(Object example, MatchingRule ... rules) {
        PactDslJsonRootValue value = new PactDslJsonRootValue();
        if (example != null) {
            value.setValue(example);
        } else {
            value.setValue(JSONObject.NULL);
        }
        value.matchers.setRules("", new MatchingRuleGroup(Arrays.asList(rules), RuleLogic.OR));
        return value;
    }

    public PactDslJsonRootValue matchUrl(String basePath, Object ... pathFragments) {
        UrlMatcherSupport urlMatcher = new UrlMatcherSupport(basePath, Arrays.asList(pathFragments));
        PactDslJsonRootValue value = new PactDslJsonRootValue();
        value.setValue(urlMatcher.getExampleValue());
        value.setMatcher((MatchingRule)value.regexp(urlMatcher.getRegexExpression()));
        return value;
    }

    public static PactDslJsonRootValue valueFromProviderState(String expression, Object example) {
        PactDslJsonRootValue value = new PactDslJsonRootValue();
        value.generators.addGenerator(Category.BODY, "", (Generator)new ProviderStateGenerator(expression, DataType.from((Object)example)));
        value.setValue(example);
        value.setMatcher((MatchingRule)TypeMatcher.INSTANCE);
        return value;
    }

    public static PactDslJsonRootValue dateExpression(String expression) {
        return PactDslJsonRootValue.dateExpression(expression, DateFormatUtils.ISO_DATE_FORMAT.getPattern());
    }

    public static PactDslJsonRootValue dateExpression(String expression, String format) {
        FastDateFormat instance = FastDateFormat.getInstance((String)format);
        PactDslJsonRootValue value = new PactDslJsonRootValue();
        value.generators.addGenerator(Category.BODY, "", (Generator)new DateGenerator(format, expression));
        value.setValue(instance.format(new Date(949323600000L)));
        value.setMatcher((MatchingRule)value.matchDate(format));
        return value;
    }

    public static PactDslJsonRootValue timeExpression(String expression) {
        return PactDslJsonRootValue.timeExpression(expression, DateFormatUtils.ISO_TIME_NO_T_FORMAT.getPattern());
    }

    public static PactDslJsonRootValue timeExpression(String expression, String format) {
        FastDateFormat instance = FastDateFormat.getInstance((String)format);
        PactDslJsonRootValue value = new PactDslJsonRootValue();
        value.generators.addGenerator(Category.BODY, "", (Generator)new TimeGenerator(format, expression));
        value.setValue(instance.format(new Date(949323600000L)));
        value.setMatcher((MatchingRule)value.matchTime(format));
        return value;
    }

    public static PactDslJsonRootValue datetimeExpression(String expression) {
        return PactDslJsonRootValue.datetimeExpression(expression, DateFormatUtils.ISO_DATETIME_FORMAT.getPattern());
    }

    public static PactDslJsonRootValue datetimeExpression(String expression, String format) {
        FastDateFormat instance = FastDateFormat.getInstance((String)format);
        PactDslJsonRootValue value = new PactDslJsonRootValue();
        value.generators.addGenerator(Category.BODY, "", (Generator)new DateTimeGenerator(format, expression));
        value.setValue(instance.format(new Date(949323600000L)));
        value.setMatcher((MatchingRule)value.matchTimestamp(format));
        return value;
    }
}

