/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.consumer.dsl;

import au.com.dius.pact.consumer.InvalidMatcherException;
import au.com.dius.pact.consumer.dsl.DslPart;
import au.com.dius.pact.core.matchers.UrlMatcherSupport;
import au.com.dius.pact.core.model.generators.DateGenerator;
import au.com.dius.pact.core.model.generators.DateTimeGenerator;
import au.com.dius.pact.core.model.generators.Generator;
import au.com.dius.pact.core.model.generators.ProviderStateGenerator;
import au.com.dius.pact.core.model.generators.RandomHexadecimalGenerator;
import au.com.dius.pact.core.model.generators.TimeGenerator;
import au.com.dius.pact.core.model.generators.UuidGenerator;
import au.com.dius.pact.core.model.matchingrules.DateMatcher;
import au.com.dius.pact.core.model.matchingrules.IncludeMatcher;
import au.com.dius.pact.core.model.matchingrules.MatchingRule;
import au.com.dius.pact.core.model.matchingrules.MatchingRuleCategory;
import au.com.dius.pact.core.model.matchingrules.NumberTypeMatcher;
import au.com.dius.pact.core.model.matchingrules.RegexMatcher;
import au.com.dius.pact.core.model.matchingrules.TimeMatcher;
import au.com.dius.pact.core.model.matchingrules.TimestampMatcher;
import au.com.dius.pact.core.model.matchingrules.TypeMatcher;
import au.com.dius.pact.core.support.expressions.DataType;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B=\u0012\u0016\b\u0002\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u0003\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u00042\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001J\u0016\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0004J\u0016\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0004J\u001e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0018J&\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u0016\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0004J\u001e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0004J\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0004J\u0016\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0004J\u001e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u001eJ&\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u001aJ\u001e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0018J&\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u0016\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0004J\u001e\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0004J\u0016\u0010 \u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010!\u001a\u00020\"J\u0016\u0010 \u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010!\u001a\u00020#J\u000e\u0010$\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0004J\u0016\u0010$\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u0004J\u0016\u0010%\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004J\u0016\u0010&\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010!\u001a\u00020'J\u0016\u0010&\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010!\u001a\u00020(J\u000e\u0010)\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0004J\u0016\u0010*\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0001J\u001e\u0010+\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010,\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004J/\u0010-\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010.\u001a\u00020\u00042\u0012\u0010/\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000100\"\u00020\u0001\u00a2\u0006\u0002\u00101J\u0016\u00102\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010!\u001a\u000203J\u000e\u00104\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0004J\u0016\u00104\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0004J\u001e\u00104\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0018J&\u00104\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u0016\u00105\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0004J\u001e\u00105\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0004J\u000e\u00106\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0004J\u0016\u00106\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u00106\u001a\u000207J\u0016\u00106\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u00106\u001a\u00020\u0004J\u001e\u00108\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0001R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001f\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000b\u00a8\u00069"}, d2={"Lau/com/dius/pact/consumer/dsl/MetadataBuilder;", "", "values", "", "", "matchers", "Lau/com/dius/pact/core/model/matchingrules/MatchingRuleCategory;", "generators", "Lau/com/dius/pact/core/model/generators/Generator;", "(Ljava/util/Map;Lau/com/dius/pact/core/model/matchingrules/MatchingRuleCategory;Ljava/util/Map;)V", "getGenerators", "()Ljava/util/Map;", "getMatchers", "()Lau/com/dius/pact/core/model/matchingrules/MatchingRuleCategory;", "getValues", "add", "key", "value", "booleanType", "name", "example", "", "date", "format", "Ljava/util/Date;", "timeZone", "Ljava/util/TimeZone;", "dateExpression", "expression", "datetime", "Ljava/time/Instant;", "datetimeExpression", "decimalType", "number", "Ljava/math/BigDecimal;", "", "hexValue", "includesStr", "integerType", "", "", "ipAddress", "like", "matchRegex", "regex", "matchUrl", "basePath", "pathFragments", "", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Object;)Lau/com/dius/pact/consumer/dsl/MetadataBuilder;", "numberType", "", "time", "timeExpression", "uuid", "Ljava/util/UUID;", "valueFromProviderState", "consumer"})
public class MetadataBuilder {
    @NotNull
    private final Map<String, Object> values;
    @NotNull
    private final MatchingRuleCategory matchers;
    @NotNull
    private final Map<String, Generator> generators;

    public MetadataBuilder(@NotNull Map<String, Object> values, @NotNull MatchingRuleCategory matchers, @NotNull Map<String, Generator> generators) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        Intrinsics.checkNotNullParameter((Object)matchers, (String)"matchers");
        Intrinsics.checkNotNullParameter(generators, (String)"generators");
        this.values = values;
        this.matchers = matchers;
        this.generators = generators;
    }

    public /* synthetic */ MetadataBuilder(Map map, MatchingRuleCategory matchingRuleCategory, Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            map = new LinkedHashMap();
        }
        if ((n & 2) != 0) {
            matchingRuleCategory = new MatchingRuleCategory("metadata", null, 2, null);
        }
        if ((n & 4) != 0) {
            map2 = new LinkedHashMap();
        }
        this(map, matchingRuleCategory, map2);
    }

    @NotNull
    public final Map<String, Object> getValues() {
        return this.values;
    }

    @NotNull
    public final MatchingRuleCategory getMatchers() {
        return this.matchers;
    }

    @NotNull
    public final Map<String, Generator> getGenerators() {
        return this.generators;
    }

    @NotNull
    public final MetadataBuilder add(@NotNull String key, @Nullable Object value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.values.put(key, value);
        return this;
    }

    @NotNull
    public final MetadataBuilder like(@NotNull String name, @NotNull Object example) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)example, (String)"example");
        this.values.put(name, example);
        MatchingRuleCategory.addRule$default((MatchingRuleCategory)this.matchers, (String)name, (MatchingRule)((MatchingRule)TypeMatcher.INSTANCE), null, (int)4, null);
        return this;
    }

    @NotNull
    public final MetadataBuilder numberType(@NotNull String name, @NotNull Number number) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        this.values.put(name, number);
        MatchingRuleCategory.addRule$default((MatchingRuleCategory)this.matchers, (String)name, (MatchingRule)((MatchingRule)new NumberTypeMatcher(NumberTypeMatcher.NumberType.NUMBER)), null, (int)4, null);
        return this;
    }

    @NotNull
    public final MetadataBuilder integerType(@NotNull String name, long number) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Long l = number;
        this.values.put(name, l);
        MatchingRuleCategory.addRule$default((MatchingRuleCategory)this.matchers, (String)name, (MatchingRule)((MatchingRule)new NumberTypeMatcher(NumberTypeMatcher.NumberType.INTEGER)), null, (int)4, null);
        return this;
    }

    @NotNull
    public final MetadataBuilder integerType(@NotNull String name, int number) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Integer n = number;
        this.values.put(name, n);
        MatchingRuleCategory.addRule$default((MatchingRuleCategory)this.matchers, (String)name, (MatchingRule)((MatchingRule)new NumberTypeMatcher(NumberTypeMatcher.NumberType.INTEGER)), null, (int)4, null);
        return this;
    }

    @NotNull
    public final MetadataBuilder decimalType(@NotNull String name, @NotNull BigDecimal number) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        this.values.put(name, number);
        MatchingRuleCategory.addRule$default((MatchingRuleCategory)this.matchers, (String)name, (MatchingRule)((MatchingRule)new NumberTypeMatcher(NumberTypeMatcher.NumberType.DECIMAL)), null, (int)4, null);
        return this;
    }

    @NotNull
    public final MetadataBuilder decimalType(@NotNull String name, double number) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Double d = number;
        this.values.put(name, d);
        MatchingRuleCategory.addRule$default((MatchingRuleCategory)this.matchers, (String)name, (MatchingRule)((MatchingRule)new NumberTypeMatcher(NumberTypeMatcher.NumberType.DECIMAL)), null, (int)4, null);
        return this;
    }

    @NotNull
    public final MetadataBuilder booleanType(@NotNull String name, boolean example) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Boolean bl = example;
        this.values.put(name, bl);
        MatchingRuleCategory.addRule$default((MatchingRuleCategory)this.matchers, (String)name, (MatchingRule)((MatchingRule)TypeMatcher.INSTANCE), null, (int)4, null);
        return this;
    }

    @NotNull
    public final MetadataBuilder matchRegex(@NotNull String name, @NotNull String regex, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        CharSequence charSequence = value;
        if (!new Regex(regex).matches(charSequence)) {
            throw new InvalidMatcherException("Example \"" + value + "\" does not match regular expression \"" + regex + "\"");
        }
        this.values.put(name, value);
        MatchingRuleCategory.addRule$default((MatchingRuleCategory)this.matchers, (String)name, (MatchingRule)((MatchingRule)new RegexMatcher(regex, null, 2, null)), null, (int)4, null);
        return this;
    }

    @NotNull
    public final MetadataBuilder datetime(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String pattern = DateFormatUtils.ISO_DATETIME_FORMAT.getPattern();
        this.generators.put(name, (Generator)new DateTimeGenerator(pattern, null));
        this.values.put(name, DateFormatUtils.ISO_DATETIME_FORMAT.format(new Date(DslPart.Companion.getDATE_2000())));
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"pattern");
        MatchingRuleCategory.addRule$default((MatchingRuleCategory)this.matchers, (String)name, (MatchingRule)((MatchingRule)new TimestampMatcher(pattern)), null, (int)4, null);
        return this;
    }

    @NotNull
    public final MetadataBuilder datetime(@NotNull String name, @NotNull String format) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        this.generators.put(name, (Generator)new DateTimeGenerator(format, null));
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format).withZone(ZoneId.systemDefault());
        this.values.put(name, formatter.format(new Date(DslPart.Companion.getDATE_2000()).toInstant()));
        MatchingRuleCategory.addRule$default((MatchingRuleCategory)this.matchers, (String)name, (MatchingRule)((MatchingRule)new TimestampMatcher(format)), null, (int)4, null);
        return this;
    }

    @NotNull
    public final MetadataBuilder datetime(@NotNull String name, @NotNull String format, @NotNull Date example) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)example, (String)"example");
        TimeZone timeZone = TimeZone.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)timeZone, (String)"getDefault()");
        return this.datetime(name, format, example, timeZone);
    }

    @NotNull
    public final MetadataBuilder datetime(@NotNull String name, @NotNull String format, @NotNull Date example, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)example, (String)"example");
        Intrinsics.checkNotNullParameter((Object)timeZone, (String)"timeZone");
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format).withZone(timeZone.toZoneId());
        this.values.put(name, formatter.format(example.toInstant()));
        MatchingRuleCategory.addRule$default((MatchingRuleCategory)this.matchers, (String)name, (MatchingRule)((MatchingRule)new TimestampMatcher(format)), null, (int)4, null);
        return this;
    }

    @NotNull
    public final MetadataBuilder datetime(@NotNull String name, @NotNull String format, @NotNull Instant example) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)example, (String)"example");
        TimeZone timeZone = TimeZone.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)timeZone, (String)"getDefault()");
        return this.datetime(name, format, example, timeZone);
    }

    @NotNull
    public final MetadataBuilder datetime(@NotNull String name, @NotNull String format, @NotNull Instant example, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)example, (String)"example");
        Intrinsics.checkNotNullParameter((Object)timeZone, (String)"timeZone");
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format).withZone(timeZone.toZoneId());
        this.values.put(name, formatter.format(example));
        MatchingRuleCategory.addRule$default((MatchingRuleCategory)this.matchers, (String)name, (MatchingRule)((MatchingRule)new TimestampMatcher(format)), null, (int)4, null);
        return this;
    }

    @NotNull
    public final MetadataBuilder date(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String pattern = DateFormatUtils.ISO_DATE_FORMAT.getPattern();
        this.generators.put(name, (Generator)new DateGenerator(pattern, null));
        this.values.put(name, DateFormatUtils.ISO_DATE_FORMAT.format(new Date(DslPart.Companion.getDATE_2000())));
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"pattern");
        MatchingRuleCategory.addRule$default((MatchingRuleCategory)this.matchers, (String)name, (MatchingRule)((MatchingRule)new DateMatcher(pattern)), null, (int)4, null);
        return this;
    }

    @NotNull
    public final MetadataBuilder date(@NotNull String name, @NotNull String format) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        this.generators.put(name, (Generator)new DateGenerator(format, null));
        FastDateFormat instance = FastDateFormat.getInstance((String)format);
        this.values.put(name, instance.format(new Date(DslPart.Companion.getDATE_2000())));
        MatchingRuleCategory.addRule$default((MatchingRuleCategory)this.matchers, (String)name, (MatchingRule)((MatchingRule)new DateMatcher(format)), null, (int)4, null);
        return this;
    }

    @NotNull
    public final MetadataBuilder date(@NotNull String name, @NotNull String format, @NotNull Date example) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)example, (String)"example");
        TimeZone timeZone = TimeZone.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)timeZone, (String)"getDefault()");
        return this.date(name, format, example, timeZone);
    }

    @NotNull
    public final MetadataBuilder date(@NotNull String name, @NotNull String format, @NotNull Date example, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)example, (String)"example");
        Intrinsics.checkNotNullParameter((Object)timeZone, (String)"timeZone");
        FastDateFormat instance = FastDateFormat.getInstance((String)format, (TimeZone)timeZone);
        this.values.put(name, instance.format(example));
        MatchingRuleCategory.addRule$default((MatchingRuleCategory)this.matchers, (String)name, (MatchingRule)((MatchingRule)new DateMatcher(format)), null, (int)4, null);
        return this;
    }

    @NotNull
    public final MetadataBuilder time(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String pattern = DateFormatUtils.ISO_TIME_FORMAT.getPattern();
        this.generators.put(name, (Generator)new TimeGenerator(pattern, null));
        this.values.put(name, DateFormatUtils.ISO_TIME_FORMAT.format(new Date(DslPart.Companion.getDATE_2000())));
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"pattern");
        MatchingRuleCategory.addRule$default((MatchingRuleCategory)this.matchers, (String)name, (MatchingRule)((MatchingRule)new TimeMatcher(pattern)), null, (int)4, null);
        return this;
    }

    @NotNull
    public final MetadataBuilder time(@NotNull String name, @NotNull String format) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        this.generators.put(name, (Generator)new TimeGenerator(format, null));
        FastDateFormat instance = FastDateFormat.getInstance((String)format);
        this.values.put(name, instance.format(new Date(DslPart.Companion.getDATE_2000())));
        MatchingRuleCategory.addRule$default((MatchingRuleCategory)this.matchers, (String)name, (MatchingRule)((MatchingRule)new TimeMatcher(format)), null, (int)4, null);
        return this;
    }

    @NotNull
    public final MetadataBuilder time(@NotNull String name, @NotNull String format, @NotNull Date example) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)example, (String)"example");
        TimeZone timeZone = TimeZone.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)timeZone, (String)"getDefault()");
        return this.time(name, format, example, timeZone);
    }

    @NotNull
    public final MetadataBuilder time(@NotNull String name, @NotNull String format, @NotNull Date example, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)example, (String)"example");
        Intrinsics.checkNotNullParameter((Object)timeZone, (String)"timeZone");
        FastDateFormat instance = FastDateFormat.getInstance((String)format, (TimeZone)timeZone);
        this.values.put(name, instance.format(example));
        MatchingRuleCategory.addRule$default((MatchingRuleCategory)this.matchers, (String)name, (MatchingRule)((MatchingRule)new TimeMatcher(format)), null, (int)4, null);
        return this;
    }

    @NotNull
    public final MetadataBuilder ipAddress(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.values.put(name, "127.0.0.1");
        MatchingRuleCategory.addRule$default((MatchingRuleCategory)this.matchers, (String)name, (MatchingRule)((MatchingRule)new RegexMatcher("(\\d{1,3}\\.)+\\d{1,3}", null, 2, null)), null, (int)4, null);
        return this;
    }

    @NotNull
    public final MetadataBuilder hexValue(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.generators.put(name, (Generator)new RandomHexadecimalGenerator(10));
        return this.hexValue(name, "1234a");
    }

    @NotNull
    public final MetadataBuilder hexValue(@NotNull String name, @NotNull String hexValue) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)hexValue, (String)"hexValue");
        CharSequence charSequence = hexValue;
        if (!DslPart.Companion.getHEXADECIMAL().matches(charSequence)) {
            throw new InvalidMatcherException("Example \"" + hexValue + "\" is not a valid hexadecimal value");
        }
        this.values.put(name, hexValue);
        MatchingRuleCategory.addRule$default((MatchingRuleCategory)this.matchers, (String)name, (MatchingRule)((MatchingRule)new RegexMatcher(DslPart.Companion.getHEXADECIMAL().getPattern(), null, 2, null)), null, (int)4, null);
        return this;
    }

    @NotNull
    public final MetadataBuilder uuid(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.generators.put(name, (Generator)new UuidGenerator(null, 1, null));
        return this.uuid(name, "e2490de5-5bd3-43d5-b7c4-526e33f71304");
    }

    @NotNull
    public final MetadataBuilder uuid(@NotNull String name, @NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        String string = uuid.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uuid.toString()");
        return this.uuid(name, string);
    }

    @NotNull
    public final MetadataBuilder uuid(@NotNull String name, @NotNull String uuid) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        CharSequence charSequence = uuid;
        if (!DslPart.Companion.getUUID_REGEX().matches(charSequence)) {
            throw new InvalidMatcherException("Example \"" + uuid + "\" is not a valid UUID");
        }
        this.values.put(name, uuid);
        MatchingRuleCategory.addRule$default((MatchingRuleCategory)this.matchers, (String)name, (MatchingRule)((MatchingRule)new RegexMatcher(DslPart.Companion.getUUID_REGEX().getPattern(), null, 2, null)), null, (int)4, null);
        return this;
    }

    @NotNull
    public final MetadataBuilder includesStr(@NotNull String name, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.values.put(name, value);
        MatchingRuleCategory.addRule$default((MatchingRuleCategory)this.matchers, (String)name, (MatchingRule)((MatchingRule)new IncludeMatcher(value)), null, (int)4, null);
        return this;
    }

    @NotNull
    public final MetadataBuilder matchUrl(@NotNull String name, @NotNull String basePath, Object ... pathFragments) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        Intrinsics.checkNotNullParameter((Object)pathFragments, (String)"pathFragments");
        UrlMatcherSupport urlMatcher = new UrlMatcherSupport(basePath, CollectionsKt.listOf((Object[])Arrays.copyOf(pathFragments, pathFragments.length)));
        this.values.put(name, urlMatcher.getExampleValue());
        MatchingRuleCategory.addRule$default((MatchingRuleCategory)this.matchers, (String)name, (MatchingRule)((MatchingRule)new RegexMatcher(urlMatcher.getRegexExpression(), null, 2, null)), null, (int)4, null);
        return this;
    }

    @NotNull
    public final MetadataBuilder valueFromProviderState(@NotNull String name, @NotNull String expression, @NotNull Object example) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)example, (String)"example");
        this.generators.put(name, (Generator)new ProviderStateGenerator(expression, DataType.Companion.from(example)));
        this.values.put(name, example);
        MatchingRuleCategory.addRule$default((MatchingRuleCategory)this.matchers, (String)name, (MatchingRule)((MatchingRule)TypeMatcher.INSTANCE), null, (int)4, null);
        return this;
    }

    @NotNull
    public final MetadataBuilder dateExpression(@NotNull String name, @NotNull String expression) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        String string = DateFormatUtils.ISO_DATE_FORMAT.getPattern();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ISO_DATE_FORMAT.pattern");
        return this.dateExpression(name, expression, string);
    }

    @NotNull
    public final MetadataBuilder dateExpression(@NotNull String name, @NotNull String expression, @NotNull String format) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        this.generators.put(name, (Generator)new DateGenerator(format, expression));
        FastDateFormat instance = FastDateFormat.getInstance((String)format);
        this.values.put(name, instance.format(new Date(DslPart.Companion.getDATE_2000())));
        MatchingRuleCategory.addRule$default((MatchingRuleCategory)this.matchers, (String)name, (MatchingRule)((MatchingRule)new DateMatcher(format)), null, (int)4, null);
        return this;
    }

    @NotNull
    public final MetadataBuilder timeExpression(@NotNull String name, @NotNull String expression) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        String string = DateFormatUtils.ISO_TIME_NO_T_FORMAT.getPattern();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ISO_TIME_NO_T_FORMAT.pattern");
        return this.timeExpression(name, expression, string);
    }

    @NotNull
    public final MetadataBuilder timeExpression(@NotNull String name, @NotNull String expression, @NotNull String format) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        this.generators.put(name, (Generator)new TimeGenerator(format, expression));
        FastDateFormat instance = FastDateFormat.getInstance((String)format);
        this.values.put(name, instance.format(new Date(DslPart.Companion.getDATE_2000())));
        MatchingRuleCategory.addRule$default((MatchingRuleCategory)this.matchers, (String)name, (MatchingRule)((MatchingRule)new TimeMatcher(format)), null, (int)4, null);
        return this;
    }

    @NotNull
    public final MetadataBuilder datetimeExpression(@NotNull String name, @NotNull String expression) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        String string = DateFormatUtils.ISO_DATETIME_FORMAT.getPattern();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ISO_DATETIME_FORMAT.pattern");
        return this.datetimeExpression(name, expression, string);
    }

    @NotNull
    public final MetadataBuilder datetimeExpression(@NotNull String name, @NotNull String expression, @NotNull String format) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        this.generators.put(name, (Generator)new DateTimeGenerator(format, expression));
        FastDateFormat instance = FastDateFormat.getInstance((String)format);
        this.values.put(name, instance.format(new Date(DslPart.Companion.getDATE_2000())));
        MatchingRuleCategory.addRule$default((MatchingRuleCategory)this.matchers, (String)name, (MatchingRule)((MatchingRule)new TimestampMatcher(format)), null, (int)4, null);
        return this;
    }

    public MetadataBuilder() {
        this(null, null, null, 7, null);
    }
}

