/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.SVGDecoratedShapeElementBridge;
import org.apache.batik.gvt.ShapeNode;
import org.apache.batik.parser.AWTPathProducer;
import org.apache.batik.parser.ParseException;
import org.apache.batik.parser.PathParser;
import org.w3c.dom.Element;
import org.w3c.dom.events.MutationEvent;

public class SVGPathElementBridge
extends SVGDecoratedShapeElementBridge {
    public String getLocalName() {
        return "path";
    }

    public Bridge getInstance() {
        return new SVGPathElementBridge();
    }

    protected void buildShape(BridgeContext ctx, Element e, ShapeNode shapeNode) {
        block5: {
            String s = e.getAttributeNS(null, "d");
            if (s.length() != 0) {
                AWTPathProducer app = new AWTPathProducer();
                app.setWindingRule(CSSUtilities.convertFillRule(e));
                try {
                    try {
                        PathParser pathParser = new PathParser();
                        pathParser.setPathHandler(app);
                        pathParser.parse(s);
                    }
                    catch (ParseException ex) {
                        BridgeException bex = new BridgeException(e, "attribute.malformed", new Object[]{"d"});
                        bex.setGraphicsNode(shapeNode);
                        throw bex;
                    }
                    Object var9_8 = null;
                    shapeNode.setShape(app.getShape());
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    shapeNode.setShape(app.getShape());
                    throw throwable;
                }
            }
            throw new BridgeException(e, "attribute.missing", new Object[]{"d"});
        }
    }

    public void handleDOMAttrModifiedEvent(MutationEvent evt) {
        String attrName = evt.getAttrName();
        if (attrName.equals("d")) {
            this.buildShape(this.ctx, this.e, (ShapeNode)this.node);
            this.handleGeometryChanged();
        } else {
            super.handleDOMAttrModifiedEvent(evt);
        }
    }
}

