/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.build;

import aQute.bnd.build.CircularDependencyException;
import aQute.bnd.build.Container;
import aQute.bnd.build.ProjectBuilder;
import aQute.bnd.build.ReflectAction;
import aQute.bnd.build.ScriptAction;
import aQute.bnd.build.Workspace;
import aQute.bnd.help.Syntax;
import aQute.bnd.service.DependencyContributor;
import aQute.bnd.service.RepositoryPlugin;
import aQute.bnd.service.action.Action;
import aQute.bnd.service.action.NamedAction;
import aQute.bnd.test.ProjectLauncher;
import aQute.lib.osgi.Builder;
import aQute.lib.osgi.Instruction;
import aQute.lib.osgi.Jar;
import aQute.lib.osgi.Processor;
import aQute.lib.osgi.Resource;
import aQute.lib.osgi.eclipse.EclipseClasspath;
import aQute.libg.sed.Sed;
import aQute.service.scripting.Scripter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Manifest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Project
extends Processor {
    static final String DEFAULT_ACTIONS = "build; label='Build', test; label='Test', clean; label='Clean', release; label='Release', refreshAll; label=Refresh";
    public static final String BNDFILE = "bnd.bnd";
    public static final String BNDCNF = "cnf";
    final Workspace workspace;
    boolean preparedPaths;
    final Collection<Project> dependson = new LinkedHashSet<Project>();
    final Collection<Container> buildpath = new LinkedHashSet<Container>();
    final Collection<Container> runpath = new LinkedHashSet<Container>();
    final Collection<File> sourcepath = new LinkedHashSet<File>();
    final Collection<File> allsourcepath = new LinkedHashSet<File>();
    final Collection<Container> bootclasspath = new LinkedHashSet<Container>();
    final Collection<Container> runbundles = new LinkedHashSet<Container>();
    File output;
    File target;
    boolean inPrepare;
    int revision;
    File[] files;

    public Project(Workspace workspace, File projectDir, File buildFile) throws Exception {
        super(workspace);
        this.workspace = workspace;
        this.setFileMustExist(false);
        this.setProperties(buildFile);
        assert (workspace != null);
        this.readBuildProperties();
    }

    public Project(Workspace workspace, File buildDir) throws Exception {
        this(workspace, buildDir, new File(buildDir, BNDFILE));
    }

    private void readBuildProperties() throws Exception {
        try {
            File f = this.getFile("build.properties");
            if (f.isFile()) {
                Properties p = this.loadProperties(f);
                Enumeration<?> e = p.propertyNames();
                while (e.hasMoreElements()) {
                    String key;
                    String newkey = key = (String)e.nextElement();
                    if (key.indexOf(36) >= 0) {
                        newkey = this.getReplacer().process(key);
                    }
                    this.setProperty(newkey, p.getProperty(key));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Project getUnparented(File propertiesFile) throws Exception {
        propertiesFile = propertiesFile.getAbsoluteFile();
        Workspace workspace = new Workspace(propertiesFile.getParentFile());
        Project project = new Project(workspace, propertiesFile.getParentFile());
        project.setProperties(propertiesFile);
        project.setFileMustExist(true);
        return project;
    }

    public synchronized boolean isValid() {
        return this.getBase().isDirectory() && this.getPropertiesFile().isFile();
    }

    public synchronized ProjectBuilder getBuilder(ProjectBuilder parent) throws Exception {
        ProjectBuilder builder = parent == null ? new ProjectBuilder(this) : new ProjectBuilder(parent);
        builder.setBase(this.getBase());
        for (Container container : this.getBuildpath()) {
            builder.addClasspath(container.getFile());
        }
        for (Container container : this.getBootclasspath()) {
            builder.addClasspath(container.getFile());
        }
        for (File file : this.getAllsourcepath()) {
            builder.addSourcepath(file);
        }
        return builder;
    }

    public synchronized int getChanged() {
        return this.revision;
    }

    public synchronized void setChanged() {
        this.preparedPaths = false;
        this.files = null;
        ++this.revision;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public String toString() {
        return this.getBase().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void prepare() throws Exception {
        if (this.inPrepare) {
            throw new CircularDependencyException(this.toString());
        }
        if (!this.preparedPaths) {
            this.inPrepare = true;
            try {
                File src;
                this.dependson.clear();
                this.buildpath.clear();
                this.sourcepath.clear();
                this.allsourcepath.clear();
                this.bootclasspath.clear();
                this.runpath.clear();
                this.runbundles.clear();
                this.setProperty("basedir", this.getBase().getAbsolutePath());
                if (!this.getPropertiesFile().isFile() && new File(this.getBase(), ".classpath").isFile()) {
                    this.doEclipseClasspath();
                }
                if ((src = this.getSrc()).isDirectory()) {
                    this.sourcepath.add(src);
                    this.allsourcepath.add(src);
                } else {
                    this.sourcepath.add(this.getBase());
                }
                this.output = this.getFile(this.getProperty("bin", "bin")).getAbsoluteFile();
                if (this.output.isDirectory()) {
                    if (!this.buildpath.contains(this.output)) {
                        this.buildpath.add(new Container(this, this.output));
                    }
                } else {
                    if (!this.output.exists()) {
                        this.output.mkdirs();
                    }
                    if (!this.output.isDirectory()) {
                        this.error("Can not find output directory: " + this.output, new Object[0]);
                    }
                }
                this.target = this.getFile(this.getProperty("target", "generated"));
                ArrayList<Project> dependencies = new ArrayList<Project>();
                String dp = this.getProperty("-dependson");
                Set<String> requiredProjectNames = this.parseHeader(dp).keySet();
                List<DependencyContributor> dcs = this.getPlugins(DependencyContributor.class);
                for (DependencyContributor dc : dcs) {
                    dc.addDependencies(this, requiredProjectNames);
                }
                for (String p : requiredProjectNames) {
                    Project required = this.getWorkspace().getProject(p);
                    if (required == null) {
                        this.error("No such project " + required + " on " + "-dependson", new Object[0]);
                        continue;
                    }
                    dependencies.add(required);
                }
                this.doPath(this.buildpath, dependencies, this.parseBuildpath(), this.bootclasspath);
                this.doPath(this.runpath, dependencies, this.parseTestpath(), this.bootclasspath);
                this.doPath(this.runbundles, dependencies, this.parseTestbundles(), null);
                HashSet<Project> done = new HashSet<Project>();
                done.add(this);
                this.allsourcepath.addAll(this.sourcepath);
                for (Project project : dependencies) {
                    project.traverse(this.dependson, done);
                }
                for (Project project : this.dependson) {
                    this.allsourcepath.addAll(project.getSourcepath());
                }
                if (this.isOk()) {
                    this.preparedPaths = true;
                }
            }
            finally {
                this.inPrepare = false;
            }
        }
    }

    public File getSrc() {
        return new File(this.getBase(), this.getProperty("src", "src"));
    }

    private void traverse(Collection<Project> dependencies, Set<Project> visited) throws Exception {
        if (visited.contains(this)) {
            return;
        }
        visited.add(this);
        for (Project project : this.getDependson()) {
            project.traverse(dependencies, visited);
        }
        dependencies.add(this);
    }

    private void doPath(Collection<Container> resultpath, Collection<Project> projects, Collection<Container> entries, Collection<Container> bootclasspath) {
        for (Container cpe : entries) {
            if (cpe.getError() != null) {
                this.error(cpe.getError(), new Object[0]);
                continue;
            }
            if (cpe.getType() == Container.TYPE.PROJECT) {
                projects.add(cpe.getProject());
            }
            if (bootclasspath != null && cpe.getBundleSymbolicName().startsWith("ee.") || cpe.getAttributes().containsKey("boot")) {
                bootclasspath.add(cpe);
                continue;
            }
            resultpath.add(cpe);
        }
    }

    private List<Container> parseBuildpath() throws Exception {
        return this.getBundles(-1, this.getProperty("-buildpath"));
    }

    private List<Container> parseTestpath() throws Exception {
        return this.getBundles(1, this.getProperty("-runpath"));
    }

    private List<Container> parseTestbundles() throws Exception {
        return this.getBundles(1, this.getProperty("-runbundles"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Container> getBundles(int strategy, String spec) throws Exception {
        ArrayList<Container> result = new ArrayList<Container>();
        Map<String, Map<String, String>> bundles = this.parseHeader(spec);
        try {
            for (Map.Entry<String, Map<String, String>> entry : bundles.entrySet()) {
                String versionRange;
                Container found;
                Map<String, String> attrs;
                String bsn;
                block14: {
                    bsn = entry.getKey();
                    attrs = entry.getValue();
                    found = null;
                    versionRange = attrs.get("version");
                    if (versionRange != null && versionRange.equals("latest")) {
                        found = this.getBundle(bsn, versionRange, strategy, attrs);
                    }
                    if (found == null) {
                        if (versionRange != null && (versionRange.equals("project") || versionRange.equals("latest"))) {
                            Project project = this.getWorkspace().getProject(bsn);
                            if (project.exists()) {
                                File f = project.getOutput();
                                found = new Container(project, bsn, "project", Container.TYPE.PROJECT, f, null, attrs);
                                break block14;
                            } else {
                                this.error("Reference to project that does not exist in workspace\n  Project       %s\n  Specification %s", bsn, spec);
                                continue;
                            }
                        }
                        if (versionRange != null && versionRange.equals("file")) {
                            File f = this.getFile(bsn);
                            String error = null;
                            if (!f.exists()) {
                                error = "File does not exist";
                            }
                            found = f.getName().endsWith(".lib") ? new Container(this, bsn, "file", Container.TYPE.LIBRARY, f, error, attrs) : new Container(this, bsn, "file", Container.TYPE.EXTERNAL, f, error, attrs);
                        } else {
                            found = this.getBundle(bsn, versionRange, strategy, attrs);
                        }
                    }
                }
                if (found != null) {
                    List<Container> libs = found.getMembers();
                    for (Container cc : libs) {
                        if (result.contains(cc)) {
                            this.warning("Multiple bundles with the same final URL: " + cc, new Object[0]);
                        }
                        result.add(cc);
                    }
                    continue;
                }
                Container x = new Container(this, bsn, versionRange, Container.TYPE.ERROR, null, bsn + ";version=" + versionRange + " not found", attrs);
                result.add(x);
                this.warning("Can not find URL for bsn " + bsn, new Object[0]);
            }
            return result;
        }
        catch (Exception e) {
            this.error("While tring to get the bundles from " + spec, e, new Object[0]);
            e.printStackTrace();
        }
        return result;
    }

    public Collection<Project> getDependson() throws Exception {
        this.prepare();
        return this.dependson;
    }

    public Collection<Container> getBuildpath() throws Exception {
        this.prepare();
        return this.buildpath;
    }

    public Collection<Container> getRunpath() throws Exception {
        this.prepare();
        return this.runpath;
    }

    public Collection<Container> getRunbundles() throws Exception {
        this.prepare();
        return this.runbundles;
    }

    public Collection<File> getSourcepath() throws Exception {
        this.prepare();
        return this.sourcepath;
    }

    public Collection<File> getAllsourcepath() throws Exception {
        this.prepare();
        return this.allsourcepath;
    }

    public Collection<Container> getBootclasspath() throws Exception {
        this.prepare();
        return this.bootclasspath;
    }

    public File getOutput() throws Exception {
        this.prepare();
        return this.output;
    }

    private void doEclipseClasspath() throws Exception {
        EclipseClasspath eclipse = new EclipseClasspath(this, this.getWorkspace().getBase(), this.getBase());
        eclipse.setRecurse(false);
        for (File dependent : eclipse.getDependents()) {
            Project required = this.workspace.getProject(dependent.getName());
            this.dependson.add(required);
        }
        for (File f : eclipse.getClasspath()) {
            this.buildpath.add(new Container(f));
        }
        for (File f : eclipse.getBootclasspath()) {
            this.bootclasspath.add(new Container(f));
        }
        this.sourcepath.addAll(eclipse.getSourcepath());
        this.allsourcepath.addAll(eclipse.getAllSources());
        this.output = eclipse.getOutput();
    }

    public String _p_dependson(String[] args) throws Exception {
        return this.list(args, this.toFiles(this.getDependson()));
    }

    private Collection<?> toFiles(Collection<Project> projects) {
        ArrayList<File> files = new ArrayList<File>();
        for (Project p : projects) {
            files.add(p.getBase());
        }
        return files;
    }

    public String _p_buildpath(String[] args) throws Exception {
        return this.list(args, this.getBuildpath());
    }

    public String _p_testpath(String[] args) throws Exception {
        return this.list(args, this.getRunpath());
    }

    public String _p_sourcepath(String[] args) throws Exception {
        return this.list(args, this.getSourcepath());
    }

    public String _p_allsourcepath(String[] args) throws Exception {
        return this.list(args, this.getAllsourcepath());
    }

    public String _p_bootclasspath(String[] args) throws Exception {
        return this.list(args, this.getBootclasspath());
    }

    public String _p_output(String[] args) throws Exception {
        if (args.length != 1) {
            throw new IllegalArgumentException("${output} should not have arguments");
        }
        return this.getOutput().getAbsolutePath();
    }

    private String list(String[] args, Collection<?> list) {
        if (args.length > 3) {
            throw new IllegalArgumentException("${" + args[0] + "[;<separator>]} can only take a separator as argument, has " + Arrays.toString(args));
        }
        String separator = ",";
        if (args.length == 2) {
            separator = args[1];
        }
        return Project.join(list, separator);
    }

    @Override
    protected Object[] getMacroDomains() {
        return new Object[]{this.workspace};
    }

    public File release(Jar jar) throws Exception {
        String name = this.getProperty("-releaserepo");
        return this.release(name, jar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File release(String name, Jar jar) throws Exception {
        List<RepositoryPlugin> plugins = this.getPlugins(RepositoryPlugin.class);
        RepositoryPlugin rp = null;
        for (RepositoryPlugin plugin : plugins) {
            if (!plugin.canWrite()) continue;
            if (name == null) {
                rp = plugin;
                break;
            }
            if (!name.equals(plugin.getName())) continue;
            rp = plugin;
            break;
        }
        if (rp != null) {
            try {
                File i$ = rp.put(jar);
                return i$;
            }
            catch (Exception e) {
                this.error("Deploying " + jar.getName() + " on " + rp.getName(), e, new Object[0]);
            }
            finally {
                jar.close();
            }
        }
        return null;
    }

    public void release(boolean test) throws Exception {
        String name = this.getProperty("-releaserepo");
        this.release(name, test);
    }

    public void release(String name, boolean test) throws Exception {
        File[] jars = this.build(test);
        if (jars == null) {
            return;
        }
        for (File jar : jars) {
            Jar j = new Jar(jar);
            this.release(name, j);
            j.close();
        }
    }

    public Container getBundle(String bsn, String range, int strategy, Map<String, String> attrs) throws Exception {
        List<RepositoryPlugin> plugins = this.getPlugins(RepositoryPlugin.class);
        if (range != null && range.equals("latest")) {
            strategy = 1;
        }
        for (RepositoryPlugin plugin : plugins) {
            File[] results = plugin.get(bsn, range);
            if (results == null || results.length <= 0) continue;
            File f = results[strategy == -1 ? 0 : results.length - 1];
            if (f.getName().endsWith("lib")) {
                return new Container(this, bsn, range, Container.TYPE.LIBRARY, f, null, attrs);
            }
            return new Container(this, bsn, range, Container.TYPE.REPO, f, null, attrs);
        }
        return new Container(this, bsn, range, Container.TYPE.ERROR, null, bsn + ";version=" + range + " Not found in " + plugins, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(String name, File file) throws Exception {
        List<RepositoryPlugin> plugins = this.getPlugins(RepositoryPlugin.class);
        RepositoryPlugin rp = null;
        for (RepositoryPlugin plugin : plugins) {
            if (!plugin.canWrite()) continue;
            if (name == null) {
                rp = plugin;
                break;
            }
            if (!name.equals(plugin.getName())) continue;
            rp = plugin;
            break;
        }
        if (rp != null) {
            Jar jar = new Jar(file);
            try {
                rp.put(jar);
                return;
            }
            catch (Exception e) {
                this.error("Deploying " + file + " on " + rp.getName(), e, new Object[0]);
            }
            finally {
                jar.close();
            }
            return;
        }
        this.trace("No repo found " + file, new Object[0]);
        throw new IllegalArgumentException("No repository found for " + file);
    }

    public void deploy(File file) throws Exception {
        String name = this.getProperty("-deployrepo");
        this.deploy(name, file);
    }

    public String _repo(String[] args) throws Exception {
        if (args.length < 2) {
            throw new IllegalArgumentException("Too few arguments for repo, syntax=: ${repo ';'<bsn> [ ; <version> ]}");
        }
        String bsns = args[1];
        String version = null;
        int strategy = 1;
        if (args.length > 2) {
            version = args[2];
            if (args.length == 4) {
                if (args[3].equalsIgnoreCase("HIGHEST")) {
                    strategy = 1;
                } else if (args[3].equalsIgnoreCase("LOWEST")) {
                    strategy = -1;
                } else {
                    this.error("${repo;<bsn>;<version>;<'highest'|'lowest'>} macro requires a strategy of 'highest' or 'lowest', and is " + args[3], new Object[0]);
                }
            }
        }
        Collection<String> parts = Project.split(bsns);
        ArrayList<String> paths = new ArrayList<String>();
        for (String bsn : parts) {
            Container jar = this.getBundle(bsn, version, strategy, null);
            if (jar.getError() == null) {
                paths.add(jar.getFile().getAbsolutePath());
                continue;
            }
            this.error("The ${repo} macro could not find " + bsn + " in the repo, because " + jar.getError() + "\n" + "Repositories     : " + this.getPlugins(RepositoryPlugin.class) + "\n" + "Strategy         : " + strategy + "\n" + "Bsn              : " + bsn + ";version=" + version, new Object[0]);
        }
        return Project.join(paths);
    }

    public File getTarget() throws Exception {
        this.prepare();
        return this.target;
    }

    public File[] build(boolean underTest) throws Exception {
        if (this.isUptodate()) {
            return this.files;
        }
        return this.buildLocal(underTest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File[] getBuildFiles() throws Exception {
        File f = new File(this.getTarget(), "buildfiles");
        if (f.isFile()) {
            FileReader fin = new FileReader(f);
            BufferedReader rdr = new BufferedReader(fin);
            try {
                List<File> files = this.newList();
                String s = rdr.readLine();
                while (s != null) {
                    File ff = new File(s = s.trim());
                    if (!ff.isFile()) {
                        this.error("buildfile lists file but the file does not exist %s", ff);
                    } else {
                        files.add(ff);
                    }
                    s = rdr.readLine();
                }
                File[] fileArray = files.toArray(new File[files.size()]);
                return fileArray;
            }
            finally {
                fin.close();
            }
        }
        return this.buildLocal(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File[] buildLocal(boolean underTest) throws Exception {
        System.out.println("Building " + this);
        File bfs = new File(this.getTarget(), "buildfiles");
        bfs.delete();
        this.files = null;
        ProjectBuilder builder = this.getBuilder(null);
        if (underTest) {
            builder.setProperty("-undertest", "true");
        }
        Jar[] jars = builder.builds();
        File[] files = new File[jars.length];
        File target = this.getTarget();
        target.mkdirs();
        for (int i = 0; i < jars.length; ++i) {
            Jar jar = jars[i];
            try {
                String bsn = jar.getName();
                files[i] = new File(target, bsn + ".jar");
                String msg = "";
                if (!files[i].exists() || files[i].lastModified() < jar.lastModified()) {
                    this.reportNewer(files[i].lastModified(), jar);
                    files[i].delete();
                    jar.write(files[i]);
                } else {
                    msg = "(not modified since " + new Date(files[i].lastModified()) + ")";
                }
                this.trace(jar.getName() + " (" + files[i].getName() + ") " + jar.getResources().size() + " " + msg, new Object[0]);
                continue;
            }
            finally {
                jar.close();
            }
        }
        this.getInfo(builder);
        builder.close();
        if (this.isOk()) {
            this.files = files;
            FileWriter fw = new FileWriter(bfs);
            try {
                for (File f : files) {
                    fw.append(f.getAbsolutePath());
                    fw.append("\n");
                }
            }
            finally {
                fw.close();
            }
            return files;
        }
        return null;
    }

    private boolean isUptodate() throws Exception {
        if (this.files == null) {
            return false;
        }
        for (Project project : this.getDependson()) {
            if (project.isUptodate()) continue;
            return false;
        }
        return true;
    }

    private void reportNewer(long lastModified, Jar jar) {
        if (Project.isTrue(this.getProperty("-reportnewer"))) {
            StringBuilder sb = new StringBuilder();
            String del = "Newer than " + new Date(lastModified);
            for (Map.Entry<String, Resource> entry : jar.getResources().entrySet()) {
                if (entry.getValue().lastModified() <= lastModified) continue;
                sb.append(del);
                del = ", \n     ";
                sb.append(entry.getKey());
            }
            if (sb.length() > 0) {
                this.warning(sb.toString(), new Object[0]);
            }
        }
    }

    @Override
    public boolean refresh() {
        boolean changed = false;
        if (this.isCnf()) {
            changed = this.workspace.refresh();
        }
        return super.refresh() || changed;
    }

    public boolean isCnf() {
        return this.getBase().getName().equals(BNDCNF);
    }

    @Override
    public void propertiesChanged() {
        super.propertiesChanged();
        this.preparedPaths = false;
    }

    public String getName() {
        return this.getBase().getName();
    }

    public Map<String, Action> getActions() {
        Map<String, Action> all = Project.newMap();
        Map<String, Action> actions = Project.newMap();
        this.fillActions(all);
        this.getWorkspace().fillActions(all);
        for (Map.Entry<String, Action> action : all.entrySet()) {
            String key = this.getReplacer().process(action.getKey());
            if (key == null || key.trim().length() == 0) continue;
            actions.put(key, action.getValue());
        }
        return actions;
    }

    public void fillActions(Map<String, Action> all) {
        List<NamedAction> plugins = this.getPlugins(NamedAction.class);
        for (NamedAction a : plugins) {
            all.put(a.getName(), a);
        }
        Map<String, Map<String, String>> actions = this.parseHeader(this.getProperty("-actions", DEFAULT_ACTIONS));
        for (Map.Entry<String, Map<String, String>> entry : actions.entrySet()) {
            String key = Processor.removeDuplicateMarker(entry.getKey());
            Action action = entry.getValue().get("script") != null ? new ScriptAction(entry.getValue().get("type"), entry.getValue().get("script")) : new ReflectAction(key);
            String label = entry.getValue().get("label");
            all.put(label, action);
        }
    }

    public void release() throws Exception {
        this.release(false);
    }

    public void release(String name) throws Exception {
        this.release(name, false);
    }

    public void clean() throws Exception {
        File target = this.getTarget();
        if (target.isDirectory() && target.getParentFile() != null) {
            this.delete(target);
        }
    }

    public File[] build() throws Exception {
        return this.build(false);
    }

    public boolean test() throws Exception {
        boolean ok = true;
        String testbundles = this.getProperty("-testbundles");
        if (testbundles == null) {
            File[] jars;
            for (File jar : jars = this.build(true)) {
                ok &= this.test(jar);
            }
        } else {
            List<Container> containers = this.getBundles(1, testbundles);
            for (Container container : containers) {
                if (container.getError() == null) {
                    File jar = container.getFile();
                    ok &= this.test(jar);
                    continue;
                }
                this.error(container.getError(), new Object[0]);
            }
        }
        return ok;
    }

    public boolean test(File f) throws Exception {
        ProjectLauncher pl = new ProjectLauncher(this);
        pl.setReport(this.getProperty("target") + "/" + f.getName().replace(".jar", ".xml"));
        int errors = pl.run(f);
        this.getInfo(pl);
        if (errors == 0) {
            this.trace("ok", new Object[0]);
            return true;
        }
        this.error("Failed: " + this.normalize(f) + ", " + errors + " test" + (errors > 1 ? "s" : "") + " failures, see " + this.normalize(pl.getTestreport()), new Object[0]);
        return false;
    }

    private void delete(File target) {
        if (target.getParentFile() == null) {
            throw new IllegalArgumentException("Can not delete root!");
        }
        if (!target.exists()) {
            return;
        }
        if (target.isDirectory()) {
            File[] sub;
            for (File s : sub = target.listFiles()) {
                this.delete(s);
            }
        }
        target.delete();
    }

    public Jar getValidJar(File f) throws Exception {
        Jar jar = new Jar(f);
        Manifest manifest = jar.getManifest();
        if (manifest == null) {
            this.trace("Wrapping with all defaults", new Object[0]);
            Builder b = new Builder(this);
            b.addClasspath(jar);
            b.setProperty("Bnd-Message", "Wrapped from " + f.getAbsolutePath() + "because lacked manifest");
            b.setProperty("Export-Package", "*");
            b.setProperty("Import-Package", "*;resolution:=optional");
            jar = b.build();
        } else if (manifest.getMainAttributes().getValue("Bundle-ManifestVersion") == null) {
            this.trace("Not a release 4 bundle, wrapping with manifest as source", new Object[0]);
            Builder b = new Builder(this);
            b.addClasspath(jar);
            b.setProperty("Private-Package", "*");
            b.mergeManifest(manifest);
            String imprts = manifest.getMainAttributes().getValue("Import-Package");
            imprts = imprts == null ? "" : imprts + ",";
            imprts = imprts + "*;resolution=optional";
            b.setProperty("Import-Package", imprts);
            b.setProperty("Bnd-Message", "Wrapped from " + f.getAbsolutePath() + "because had incomplete manifest");
            jar = b.build();
        }
        return jar;
    }

    public String _project(String[] args) {
        return this.getBase().getAbsolutePath();
    }

    public void bump(String mask) throws IOException {
        Sed sed = new Sed(this.getReplacer(), this.getPropertiesFile());
        sed.replace("(Bundle-Version\\s*(:|=)\\s*)(([0-9]+(\\.[0-9]+(\\.[0-9]+)?)?))", "$1${version;" + mask + ";$3}");
        sed.doIt();
        this.refresh();
    }

    public void bump() throws IOException {
        this.bump(this.getProperty("-bumppolicy", "=+0"));
    }

    public void action(String command) throws Exception {
        Map<String, Action> actions = this.getActions();
        Action a = actions.get(command);
        if (a == null) {
            a = new ReflectAction(command);
        }
        a.execute(this, command);
    }

    public String _findfile(String[] args) {
        File f = this.getFile(args[1]);
        ArrayList<String> files = new ArrayList<String>();
        this.tree(files, f, "", Instruction.getPattern(args[2]));
        return Project.join(files);
    }

    void tree(List<String> list, File current, String path, Instruction instr) {
        String[] subs;
        if (path.length() > 0) {
            path = path + "/";
        }
        if ((subs = current.list()) != null) {
            for (String sub : subs) {
                File f = new File(current, sub);
                if (f.isFile()) {
                    if (!instr.matches(sub) || instr.isNegated()) continue;
                    list.add(path + sub);
                    continue;
                }
                this.tree(list, f, path + sub, instr);
            }
        }
    }

    public void refreshAll() {
        this.workspace.refresh();
        this.refresh();
    }

    public void script(String type, String script) throws Exception {
        List<Scripter> scripters = this.getPlugins(Scripter.class);
        if (scripters.isEmpty()) {
            this.error("Can not execute script because there are no scripters registered: %s", script);
            return;
        }
        Properties x = this.getProperties();
        scripters.get(0).eval(x, new StringReader(script));
    }

    public String _repos(String[] args) throws Exception {
        List<RepositoryPlugin> repos = this.getPlugins(RepositoryPlugin.class);
        ArrayList<String> names = new ArrayList<String>();
        for (RepositoryPlugin rp : repos) {
            names.add(rp.getName());
        }
        return Project.join(names, ", ");
    }

    public String _help(String[] args) throws Exception {
        if (args.length == 1) {
            return "Specify the option or header you want information for";
        }
        Syntax syntax = Syntax.HELP.get(args[1]);
        if (syntax == null) {
            return "No help for " + args[1];
        }
        String what = null;
        if (args.length > 2) {
            what = args[2];
        }
        if (what == null || what.equals("lead")) {
            return syntax.getLead();
        }
        if (what == null || what.equals("example")) {
            return syntax.getExample();
        }
        if (what == null || what.equals("pattern")) {
            return syntax.getPattern();
        }
        if (what == null || what.equals("values")) {
            return syntax.getValues();
        }
        return "Invalid type specified for help: lead, example, pattern, values";
    }
}

