/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.main;

import aQute.bnd.build.Container;
import aQute.bnd.build.Project;
import aQute.bnd.build.Workspace;
import aQute.bnd.maven.MavenRepository;
import aQute.bnd.service.RepositoryPlugin;
import aQute.bnd.test.ProjectLauncher;
import aQute.lib.deployer.FileRepo;
import aQute.lib.jardiff.Diff;
import aQute.lib.osgi.Analyzer;
import aQute.lib.osgi.Builder;
import aQute.lib.osgi.Clazz;
import aQute.lib.osgi.Instruction;
import aQute.lib.osgi.Jar;
import aQute.lib.osgi.Processor;
import aQute.lib.osgi.Resource;
import aQute.lib.osgi.Verifier;
import aQute.lib.osgi.eclipse.EclipseClasspath;
import aQute.lib.tag.Tag;
import aQute.libg.generics.Create;
import aQute.libg.version.Version;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class bnd
extends Processor {
    PrintStream out = System.out;
    static boolean exceptions = false;
    static boolean failok = false;
    private Project project;
    static final int BUILD_SOURCES = 1;
    static final int BUILD_POM = 2;
    static final int BUILD_FORCE = 4;
    static final int VERIFY = 1;
    static final int MANIFEST = 2;
    static final int LIST = 4;
    static final int ECLIPSE = 8;
    static final int IMPEXP = 16;
    static final int USES = 32;
    static final int USEDBY = 64;
    static final int COMPONENT = 128;
    static final int HEX = 0;

    public static void main(String[] args) {
        block3: {
            bnd main = new bnd();
            try {
                main.run(args);
                if (failok) {
                    return;
                }
                System.exit(main.getErrors().size());
            }
            catch (Exception e) {
                System.err.println("Software error occurred " + e);
                if (!exceptions) break block3;
                e.printStackTrace();
            }
        }
        System.exit(-1);
    }

    void run(String[] args) throws Exception {
        int cnt = 0;
        for (int i = 0; i < args.length; ++i) {
            if ("-failok".equals(args[i])) {
                failok = true;
                continue;
            }
            if ("-exceptions".equals(args[i])) {
                exceptions = true;
                continue;
            }
            if ("-trace".equals(args[i])) {
                this.setTrace(true);
                continue;
            }
            if ("-pedantic".equals(args[i])) {
                this.setPedantic(true);
                continue;
            }
            if ("-base".equals(args[i])) {
                this.setBase(new File(args[++i]).getAbsoluteFile());
                if (this.getBase().isDirectory()) continue;
                System.out.println("-base must be a valid directory");
                continue;
            }
            if ("wrap".equals(args[i])) {
                ++cnt;
                this.doWrap(args, ++i);
                break;
            }
            if ("print".equals(args[i])) {
                ++cnt;
                this.doPrint(args, ++i);
                break;
            }
            if ("release".equals(args[i])) {
                ++cnt;
                this.doRelease(args, ++i);
                break;
            }
            if ("debug".equals(args[i])) {
                ++cnt;
                this.debug(args, ++i);
                break;
            }
            if ("view".equals(args[i])) {
                ++cnt;
                this.doView(args, ++i);
                break;
            }
            if ("build".equals(args[i])) {
                ++cnt;
                this.doBuild(args, ++i);
                break;
            }
            if ("extract".equals(args[i])) {
                ++cnt;
                this.doExtract(args, ++i);
                break;
            }
            if ("patch".equals(args[i])) {
                ++cnt;
                this.patch(args, ++i);
                break;
            }
            if ("runtests".equals(args[i])) {
                ++cnt;
                this.runtests(args, ++i);
                break;
            }
            if ("xref".equals(args[i])) {
                ++cnt;
                this.doXref(args, ++i);
                break;
            }
            if ("eclipse".equals(args[i])) {
                ++cnt;
                this.doEclipse(args, ++i);
                break;
            }
            if ("repo".equals(args[i])) {
                ++cnt;
                this.repo(args, ++i);
                break;
            }
            if ("diff".equals(args[i])) {
                ++cnt;
                this.doDiff(args, ++i);
                break;
            }
            if ("test".equals(args[i])) {
                ++cnt;
                this.test(args, ++i);
                break;
            }
            if ("help".equals(args[i])) {
                ++cnt;
                this.doHelp(args, ++i);
                break;
            }
            if ("macro".equals(args[i])) {
                ++cnt;
                this.doMacro(args, ++i);
                break;
            }
            ++cnt;
            String path = args[i];
            if (path.startsWith("-")) {
                this.doHelp(args, i);
                this.error("Invalid option on commandline: " + args[i], new Object[0]);
                break;
            }
            if (path.endsWith(".bnd")) {
                this.doBuild(new File(path), new File[0], new File[0], null, "", new File(path).getParentFile(), 0, new HashSet<File>());
                continue;
            }
            if (path.endsWith(".jar") || path.endsWith(".bar")) {
                this.doPrint(path, -1);
                continue;
            }
            try {
                i = this.doMacro(args, i);
                continue;
            }
            catch (Throwable t) {
                t.printStackTrace();
                this.doHelp(args, i);
                this.error("Invalid commandline: " + args[i], new Object[0]);
                break;
            }
        }
        if (cnt == 0) {
            File f = new File("bnd.bnd");
            if (f.exists()) {
                this.doBuild(f, new File[0], new File[0], null, "", f.getParentFile(), 0, new HashSet<File>());
            } else {
                this.doHelp();
                this.error("No files on commandline", new Object[0]);
            }
        }
        int n = 1;
        switch (this.getErrors().size()) {
            case 0: {
                break;
            }
            case 1: {
                System.err.println("One error");
                break;
            }
            default: {
                System.err.println(this.getErrors().size() + " errors");
            }
        }
        for (String msg : this.getErrors()) {
            System.err.println(n++ + " : " + msg);
        }
        n = 1;
        switch (this.getWarnings().size()) {
            case 0: {
                break;
            }
            case 1: {
                System.err.println("One warning");
                break;
            }
            default: {
                System.err.println(this.getWarnings().size() + " warnings");
            }
        }
        for (String msg : this.getWarnings()) {
            System.err.println(n++ + " : " + msg);
        }
    }

    private int doMacro(String[] args, int i) throws Exception {
        while (i < args.length) {
            String cmd = args[i];
            cmd = cmd.replaceAll("@\\{([^}])\\}", "\\${$1}");
            cmd = cmd.replaceAll(":", ";");
            cmd = cmd.replaceAll("[^$](.*)", "\\${$0}");
            String result = this.getProject().getReplacer().process(cmd);
            if (result != null || result.length() != 0) {
                Collection<String> parts = bnd.split(result);
                for (String s : parts) {
                    this.out.println(s);
                }
            } else {
                this.out.println("No result for " + cmd);
            }
            ++i;
        }
        return i;
    }

    private void doRelease(String[] args, int i) throws Exception {
        Project project = this.getProject();
        project.release(false);
        this.getInfo(project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doXref(String[] args, int i) {
        while (i < args.length) {
            try {
                File file = new File(args[i]);
                Jar jar = new Jar(file.getName(), file);
                try {
                    for (Map.Entry<String, Resource> entry : jar.getResources().entrySet()) {
                        String key = entry.getKey();
                        Resource r = entry.getValue();
                        if (!key.endsWith(".class")) continue;
                        InputStream in = r.openInputStream();
                        Clazz clazz = new Clazz(key, r);
                        this.out.print(key);
                        Set<String> xref = clazz.parseClassFile();
                        in.close();
                        for (String element : xref) {
                            this.out.print("\t");
                            this.out.print(element);
                        }
                        this.out.println();
                    }
                }
                finally {
                    jar.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    private void doEclipse(String[] args, int i) throws Exception {
        File dir = new File("").getAbsoluteFile();
        if (args.length == i) {
            this.doEclipse(dir);
        } else {
            while (i < args.length) {
                this.doEclipse(new File(dir, args[i]));
                ++i;
            }
        }
    }

    private void doEclipse(File file) throws Exception {
        if (!file.isDirectory()) {
            this.error("Eclipse requires a path to a directory: " + file.getAbsolutePath(), new Object[0]);
        } else {
            File cp = new File(file, ".classpath");
            if (!cp.exists()) {
                this.error("Cannot find .classpath in project directory: " + file.getAbsolutePath(), new Object[0]);
            } else {
                EclipseClasspath eclipse = new EclipseClasspath(this, file.getParentFile(), file);
                this.out.println("Classpath    " + eclipse.getClasspath());
                this.out.println("Dependents   " + eclipse.getDependents());
                this.out.println("Sourcepath   " + eclipse.getSourcepath());
                this.out.println("Output       " + eclipse.getOutput());
                this.out.println();
            }
        }
    }

    private void doBuild(String[] args, int i) throws Exception {
        File[] classpath = new File[]{};
        File workspace = null;
        File[] sourcepath = new File[]{};
        File output = null;
        String eclipse = "";
        int options = 0;
        while (i < args.length) {
            if ("-workspace".startsWith(args[i])) {
                workspace = new File(args[++i]);
            } else if ("-classpath".startsWith(args[i])) {
                classpath = this.getClasspath(args[++i]);
            } else if ("-sourcepath".startsWith(args[i])) {
                String arg = args[++i];
                String[] spaces = arg.split("\\s*,\\s*");
                sourcepath = new File[spaces.length];
                for (int j = 0; j < spaces.length; ++j) {
                    File f = new File(spaces[j]);
                    if (!f.exists()) {
                        this.error("No such sourcepath entry: " + f.getAbsolutePath(), new Object[0]);
                    }
                    sourcepath[j] = f;
                }
            } else if ("-eclipse".startsWith(args[i])) {
                eclipse = args[++i];
            } else if ("-noeclipse".startsWith(args[i])) {
                eclipse = null;
            } else if ("-output".startsWith(args[i])) {
                output = new File(args[++i]);
            } else if ("-sources".startsWith(args[i])) {
                options |= 1;
            } else if ("-pom".startsWith(args[i])) {
                options |= 2;
            } else if ("-force".startsWith(args[i])) {
                options |= 4;
            } else if (args[i].startsWith("-")) {
                this.error("Invalid option for bnd: " + args[i], new Object[0]);
            } else {
                File properties = new File(args[i]);
                if (!properties.exists()) {
                    this.error("Cannot find bnd file: " + args[i], new Object[0]);
                } else {
                    if (workspace == null) {
                        workspace = properties.getParentFile();
                    }
                    this.doBuild(properties, classpath, sourcepath, output, eclipse, workspace, options, new HashSet<File>());
                }
                output = null;
            }
            ++i;
        }
    }

    private File[] getClasspath(String string) {
        String[] spaces = string.split("\\s*,\\s*");
        File[] classpath = new File[spaces.length];
        for (int j = 0; j < spaces.length; ++j) {
            File f = new File(spaces[j]);
            if (!f.exists()) {
                this.error("No such classpath entry: " + f.getAbsolutePath(), new Object[0]);
            }
            classpath[j] = f;
        }
        return classpath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doBuild(File properties, File[] classpath, File[] sourcepath, File output, String eclipse, File workspace, int options, Set<File> building) throws Exception {
        if (building.contains(properties = properties.getAbsoluteFile())) {
            this.error("Circular dependency in pre build " + properties, new Object[0]);
            return;
        }
        building.add(properties);
        Builder builder = new Builder();
        try {
            String prebuild;
            builder.setPedantic(this.isPedantic());
            builder.setProperties(properties);
            if (output == null) {
                String out = builder.getProperty("-output");
                if (out != null) {
                    output = bnd.getFile(properties.getParentFile(), out);
                    if (!output.getName().endsWith(".jar")) {
                        output.mkdirs();
                    }
                } else {
                    output = properties.getAbsoluteFile().getParentFile();
                }
            }
            if ((prebuild = builder.getProperty("-prebuild")) != null) {
                this.prebuild(prebuild, properties.getParentFile(), classpath, sourcepath, output, eclipse, workspace, options, building);
            }
            this.doEclipse(builder, properties, classpath, sourcepath, eclipse, workspace);
            if ((options & 1) != 0) {
                builder.getProperties().setProperty("-sources", "true");
            }
            if (failok) {
                builder.setProperty("-failok", "true");
            }
            Jar jar = builder.build();
            this.getInfo(builder);
            if (this.getErrors().size() > 0 && !failok) {
                return;
            }
            String name = builder.getBsn() + ".jar";
            if (output.isDirectory()) {
                output = new File(output, name);
            }
            if ((options & 2) != 0) {
                builder.doPom(jar);
            }
            jar.setName(output.getName());
            String msg = "";
            if (!output.exists() || output.lastModified() <= jar.lastModified() || (options & 4) != 0) {
                jar.write(output);
            } else {
                msg = "(not modified)";
            }
            this.statistics(jar, output, msg);
        }
        finally {
            builder.close();
        }
    }

    private void prebuild(String prebuild, File base, File[] classpath, File[] sourcepath, File output, String eclipse2, File workspace, int options, Set<File> building) throws Exception {
        if (output.isFile()) {
            output = output.getParentFile();
        }
        Collection<String> parts = Processor.split(prebuild);
        for (String part : parts) {
            File f = new File(part);
            if (!f.exists()) {
                f = new File(base, part);
            }
            if (!f.exists()) {
                this.error("Trying to build a non-existent file: " + parts, new Object[0]);
                continue;
            }
            try {
                this.doBuild(f, classpath, sourcepath, output, eclipse2, workspace, options, building);
            }
            catch (Exception e) {
                this.error("Trying to build: " + part + " " + e, new Object[0]);
            }
        }
    }

    private void statistics(Jar jar, File output, String msg) {
        this.out.println(jar.getName() + " " + jar.getResources().size() + " " + output.length() + msg);
    }

    void doEclipse(Builder builder, File properties, File[] classpath, File[] sourcepath, String eclipse, File workspace) throws IOException {
        if (eclipse != null) {
            File project = new File(workspace, eclipse).getAbsoluteFile();
            if (project.exists() && project.isDirectory()) {
                try {
                    EclipseClasspath path = new EclipseClasspath(this, project.getParentFile(), project);
                    List<File> newClasspath = Create.copy(Arrays.asList(classpath));
                    newClasspath.addAll(path.getClasspath());
                    classpath = newClasspath.toArray(classpath);
                    List<File> newSourcepath = Create.copy(Arrays.asList(sourcepath));
                    newSourcepath.addAll(path.getSourcepath());
                    sourcepath = newSourcepath.toArray(sourcepath);
                }
                catch (Exception e) {
                    if (eclipse.length() > 0) {
                        this.error("Eclipse specified (" + eclipse + ") but getting error processing: " + e, new Object[0]);
                    }
                }
            } else if (eclipse.length() > 0) {
                this.error("Eclipse specified (" + eclipse + ") but no project directory found", new Object[0]);
            }
        }
        builder.setClasspath(classpath);
        builder.setSourcepath(sourcepath);
    }

    private void doHelp() {
        this.doHelp(new String[0], 0);
    }

    private void doHelp(String[] args, int i) {
        if (args.length <= i) {
            this.out.println("bnd -failok? -exceptions? ( wrap | print | build | eclipse | xref | view )?");
            this.out.println("See http://www.aQute.biz/Code/Bnd");
        } else {
            while (args.length > i) {
                if ("wrap".equals(args[i])) {
                    this.out.println("bnd wrap (-output <file|dir>)? (-properties <file>)? <jar-file>");
                } else if ("print".equals(args[i])) {
                    this.out.println("bnd wrap -verify? -manifest? -list? -eclipse <jar-file>");
                } else if ("build".equals(args[i])) {
                    this.out.println("bnd build (-output <file|dir>)? (-classpath <list>)? (-sourcepath <list>)? ");
                    this.out.println("    -eclipse? -noeclipse? -sources? <bnd-file>");
                } else if ("eclipse".equals(args[i])) {
                    this.out.println("bnd eclipse");
                } else if ("view".equals(args[i])) {
                    this.out.println("bnd view <file.jar> <resource-names>+");
                }
                ++i;
            }
        }
    }

    private void doPrint(String[] args, int i) throws Exception {
        int options = 0;
        while (i < args.length) {
            if ("-verify".startsWith(args[i])) {
                options |= 1;
            } else if ("-manifest".startsWith(args[i])) {
                options |= 2;
            } else if ("-list".startsWith(args[i])) {
                options |= 4;
            } else if ("-eclipse".startsWith(args[i])) {
                options |= 8;
            } else if ("-impexp".startsWith(args[i])) {
                options |= 0x10;
            } else if ("-uses".startsWith(args[i])) {
                options |= 0x20;
            } else if ("-usedby".startsWith(args[i])) {
                options |= 0x40;
            } else if ("-component".startsWith(args[i])) {
                options |= 0x80;
            } else if ("-all".startsWith(args[i])) {
                options = -1;
            } else if (args[i].startsWith("-")) {
                this.error("Invalid option for print: " + args[i], new Object[0]);
            } else {
                this.doPrint(args[i], options);
            }
            ++i;
        }
    }

    public void doPrint(String string, int options) throws Exception {
        File file = new File(string);
        if (!file.exists()) {
            this.error("File to print not found: " + string, new Object[0]);
        } else {
            if (options == 0) {
                options = 51;
            }
            this.doPrint(file, options);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPrint(File file, int options) throws ZipException, IOException, Exception {
        block22: {
            Jar jar = new Jar(file.getName(), file);
            try {
                if ((options & 1) != 0) {
                    Verifier verifier = new Verifier(jar);
                    verifier.setPedantic(this.isPedantic());
                    verifier.verify();
                    this.getInfo(verifier);
                }
                if ((options & 2) != 0) {
                    Manifest manifest = jar.getManifest();
                    if (manifest == null) {
                        this.warning("JAR file has no manifest " + file, new Object[0]);
                    } else {
                        this.out.println("[MANIFEST " + jar.getName() + "]");
                        TreeSet<String> sorted = new TreeSet<String>();
                        for (Object element : manifest.getMainAttributes().keySet()) {
                            sorted.add(element.toString());
                        }
                        for (String key : sorted) {
                            String value = manifest.getMainAttributes().getValue(key);
                            this.format("%-40s %-40s\r\n", key, value);
                        }
                    }
                    this.out.println();
                }
                if ((options & 0x10) != 0) {
                    this.out.println("[IMPEXP]");
                    Manifest m = jar.getManifest();
                    if (m != null) {
                        Map<String, Map<String, String>> imports = this.parseHeader(m.getMainAttributes().getValue("Import-Package"));
                        Map<String, Map<String, String>> exports = this.parseHeader(m.getMainAttributes().getValue("Export-Package"));
                        imports.keySet().removeAll(exports.keySet());
                        this.print("Import-Package", new TreeMap<String, Map<String, String>>(imports));
                        this.print("Export-Package", new TreeMap<String, Map<String, String>>(exports));
                    } else {
                        this.warning("File has no manifest", new Object[0]);
                    }
                }
                if ((options & 0x60) != 0) {
                    this.out.println();
                    Analyzer analyzer = new Analyzer();
                    analyzer.setPedantic(this.isPedantic());
                    analyzer.setJar(jar);
                    analyzer.analyze();
                    if ((options & 0x20) != 0) {
                        this.out.println("[USES]");
                        this.printMapOfSets(new TreeMap<String, Set<String>>(analyzer.getUses()));
                        this.out.println();
                    }
                    if ((options & 0x40) != 0) {
                        this.out.println("[USEDBY]");
                        this.printMapOfSets(this.invertMapOfCollection(analyzer.getUses()));
                    }
                }
                if ((options & 0x80) != 0) {
                    this.printComponents(this.out, jar);
                }
                if ((options & 4) == 0) break block22;
                this.out.println("[LIST]");
                for (Map.Entry<String, Map<String, Resource>> entry : jar.getDirectories().entrySet()) {
                    String name = entry.getKey();
                    Map<String, Resource> contents = entry.getValue();
                    this.out.println(name);
                    if (contents != null) {
                        for (String element : contents.keySet()) {
                            String extra;
                            Resource r;
                            int n = element.lastIndexOf(47);
                            if (n > 0) {
                                element = element.substring(n + 1);
                            }
                            this.out.print("  ");
                            this.out.print(element);
                            String path = element;
                            if (name.length() != 0) {
                                path = name + "/" + element;
                            }
                            if ((r = contents.get(path)) != null && (extra = r.getExtra()) != null) {
                                this.out.print(" extra='" + extra + "'");
                            }
                            this.out.println();
                        }
                        continue;
                    }
                    this.out.println(name + " <no contents>");
                }
                this.out.println();
            }
            finally {
                jar.close();
            }
        }
    }

    private void printComponents(PrintStream out, Jar jar) throws IOException {
        out.println("[COMPONENTS]");
        Manifest manifest = jar.getManifest();
        if (manifest == null) {
            out.println("No manifest");
            return;
        }
        String componentHeader = manifest.getMainAttributes().getValue("Service-Component");
        Map<String, Map<String, String>> clauses = this.parseHeader(componentHeader);
        for (String path : clauses.keySet()) {
            out.println(path);
        }
        out.println();
    }

    Map<String, Set<String>> invertMapOfCollection(Map<String, Set<String>> map) {
        TreeMap<String, Set<String>> result = new TreeMap<String, Set<String>>();
        for (Map.Entry<String, Set<String>> entry : map.entrySet()) {
            String name = entry.getKey();
            if (name.startsWith("java.") && !name.equals("java.sql")) continue;
            Collection used = entry.getValue();
            for (String n : used) {
                if (n.startsWith("java.") && !n.equals("java.sql")) continue;
                TreeSet<String> set = (TreeSet<String>)result.get(n);
                if (set == null) {
                    set = new TreeSet<String>();
                    result.put(n, set);
                }
                set.add(name);
            }
        }
        return result;
    }

    void printMapOfSets(Map<String, Set<String>> map) {
        for (Map.Entry<String, Set<String>> entry : map.entrySet()) {
            String name = entry.getKey();
            TreeSet<String> used = new TreeSet<String>((Collection)entry.getValue());
            Iterator k = used.iterator();
            while (k.hasNext()) {
                String n = (String)k.next();
                if (!n.startsWith("java.") || n.equals("java.sql")) continue;
                k.remove();
            }
            String list = this.vertical(40, used);
            this.format("%-40s %s", name, list);
        }
    }

    String vertical(int padding, Set<String> used) {
        StringBuffer sb = new StringBuffer();
        String del = "";
        for (String name : used) {
            sb.append(del);
            sb.append(name);
            sb.append("\r\n");
            del = this.pad(padding);
        }
        if (sb.length() == 0) {
            sb.append("\r\n");
        }
        return sb.toString();
    }

    String pad(int i) {
        StringBuffer sb = new StringBuffer();
        while (i-- > 0) {
            sb.append(' ');
        }
        return sb.toString();
    }

    private void doView(String[] args, int i) throws Exception {
        int options = 0;
        String charset = "UTF-8";
        File output = null;
        while (i < args.length) {
            if ("-charset".startsWith(args[i])) {
                charset = args[++i];
            } else {
                if (!"-output".startsWith(args[i])) break;
                output = new File(args[++i]);
            }
            ++i;
        }
        if (i >= args.length) {
            this.error("Insufficient arguments for view, no JAR file", new Object[0]);
            return;
        }
        String jar = args[i++];
        if (i >= args.length) {
            this.error("No Files to view", new Object[0]);
            return;
        }
        this.doView(jar, args, i, charset, options, output);
    }

    private void doView(String jar, String[] args, int i, String charset, int options, File output) {
        File path = new File(jar).getAbsoluteFile();
        File dir = path.getParentFile();
        if (dir == null) {
            dir = new File("");
        }
        if (!dir.exists()) {
            this.error("No such file: " + dir.getAbsolutePath(), new Object[0]);
            return;
        }
        String name = path.getName();
        if (name == null) {
            name = "META-INF/MANIFEST.MF";
        }
        Instruction instruction = Instruction.getPattern(path.getName());
        File[] children = dir.listFiles();
        for (int j = 0; j < children.length; ++j) {
            String base = children[j].getName();
            if (!(instruction.matches(base) ^ instruction.isNegated())) continue;
            while (i < args.length) {
                this.doView(children[j], args[i], charset, options, output);
                ++i;
            }
        }
    }

    private void doView(File file, String resource, String charset, int options, File output) {
        try {
            Instruction instruction = Instruction.getPattern(resource);
            FileInputStream fin = new FileInputStream(file);
            ZipInputStream in = new ZipInputStream(fin);
            ZipEntry entry = in.getNextEntry();
            while (entry != null) {
                if (instruction.matches(entry.getName()) ^ instruction.isNegated()) {
                    this.doView(entry.getName(), in, charset, options, output);
                }
                in.closeEntry();
                entry = in.getNextEntry();
            }
            in.close();
            fin.close();
        }
        catch (Exception e) {
            this.out.println("Can not process: " + file.getAbsolutePath());
            e.printStackTrace();
        }
    }

    private void doView(String name, ZipInputStream in, String charset, int options, File output) throws Exception {
        int n = name.lastIndexOf(47);
        name = name.substring(n + 1);
        InputStreamReader rds = new InputStreamReader((InputStream)in, charset);
        OutputStreamWriter wrt = new OutputStreamWriter(this.out);
        if (output != null) {
            wrt = output.isDirectory() ? new FileWriter(new File(output, name)) : new FileWriter(output);
        }
        this.copy(rds, wrt);
        if (output != null) {
            wrt.close();
        } else {
            wrt.flush();
        }
    }

    private void copy(Reader rds, Writer wrt) throws IOException {
        char[] buffer = new char[1024];
        int size = rds.read(buffer);
        while (size > 0) {
            wrt.write(buffer, 0, size);
            size = rds.read(buffer);
        }
    }

    private void print(String msg, Map<String, Map<String, String>> ports) {
        if (ports.isEmpty()) {
            return;
        }
        this.out.println(msg);
        for (Map.Entry<String, Map<String, String>> entry : ports.entrySet()) {
            String key = entry.getKey();
            Map<String, String> clause = Create.copy(entry.getValue());
            clause.remove("uses:");
            this.format("  %-38s %s\r\n", key.trim(), clause.isEmpty() ? "" : clause.toString());
        }
    }

    private void format(String string, Object ... objects) {
        if (objects == null || objects.length == 0) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        int index = 0;
        block13: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '%': {
                    String s = objects[index++] + "";
                    int width = 0;
                    int justify = -1;
                    int n = ++i;
                    ++i;
                    c = string.charAt(n);
                    switch (c) {
                        case '-': {
                            justify = -1;
                            break;
                        }
                        case '+': {
                            justify = 1;
                            break;
                        }
                        case '|': {
                            justify = 0;
                            break;
                        }
                    }
                    int n2 = --i;
                    ++i;
                    c = string.charAt(n2);
                    while (c >= '0' && c <= '9') {
                        width *= 10;
                        width += c - 48;
                        c = string.charAt(i++);
                    }
                    if (c != 's') {
                        throw new IllegalArgumentException("Invalid sprintf format:  " + string);
                    }
                    if (s.length() > width) {
                        sb.append(s);
                        continue block13;
                    }
                    switch (justify) {
                        case -1: {
                            int j;
                            sb.append(s);
                            for (j = 0; j < width - s.length(); ++j) {
                                sb.append(" ");
                            }
                            continue block13;
                        }
                        case 1: {
                            int j;
                            for (j = 0; j < width - s.length(); ++j) {
                                sb.append(" ");
                            }
                            sb.append(s);
                            break;
                        }
                        case 0: {
                            int j;
                            int spaces = (width - s.length()) / 2;
                            for (j = 0; j < spaces; ++j) {
                                sb.append(" ");
                            }
                            sb.append(s);
                            for (j = 0; j < width - s.length() - spaces; ++j) {
                                sb.append(" ");
                            }
                        }
                    }
                    continue block13;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        this.out.print(sb);
    }

    private void doWrap(String[] args, int i) throws Exception {
        int options = 0;
        File properties = null;
        File output = null;
        File[] classpath = null;
        while (i < args.length) {
            if ("-output".startsWith(args[i])) {
                output = new File(args[++i]);
            } else if ("-properties".startsWith(args[i])) {
                properties = new File(args[++i]);
            } else if ("-classpath".startsWith(args[i])) {
                classpath = this.getClasspath(args[++i]);
            } else {
                File bundle = new File(args[i]);
                this.doWrap(properties, bundle, output, classpath, options, null);
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doWrap(File properties, File bundle, File output, File[] classpath, int options, Map<String, String> additional) throws Exception {
        if (!bundle.exists()) {
            this.error("No such file: " + bundle.getAbsolutePath(), new Object[0]);
            return false;
        }
        Analyzer analyzer = new Analyzer();
        try {
            String path;
            analyzer.setPedantic(this.isPedantic());
            analyzer.setJar(bundle);
            Jar dot = analyzer.getJar();
            if (properties != null) {
                analyzer.setProperties(properties);
            }
            if (additional != null) {
                analyzer.putAll(additional, false);
            }
            if (analyzer.getProperty("Import-Package") == null) {
                analyzer.setProperty("Import-Package", "*;resolution:=optional");
            }
            if (analyzer.getProperty("Bundle-SymbolicName") == null) {
                Pattern p = Pattern.compile("(" + Verifier.SYMBOLICNAME.pattern() + ")(-[0-9])?.*\\.jar");
                String base = bundle.getName();
                Matcher m = p.matcher(base);
                base = "Untitled";
                if (m.matches()) {
                    base = m.group(1);
                } else {
                    this.error("Can not calculate name of output bundle, rename jar or use -properties", new Object[0]);
                }
                analyzer.setProperty("Bundle-SymbolicName", base);
            }
            if (analyzer.getProperty("Export-Package") == null) {
                String export = analyzer.calculateExportsFromContents(dot);
                analyzer.setProperty("Export-Package", export);
            }
            if (classpath != null) {
                analyzer.setClasspath(classpath);
            }
            analyzer.mergeManifest(dot.getManifest());
            String version = analyzer.getProperty("Bundle-Version");
            if (version != null) {
                version = Builder.cleanupVersion(version);
                analyzer.setProperty("Bundle-Version", version);
            }
            if (output == null) {
                output = properties != null ? properties.getAbsoluteFile().getParentFile() : bundle.getAbsoluteFile().getParentFile();
            }
            path = (path = bundle.getName()).endsWith(".jar") ? path.substring(0, path.length() - ".jar".length()) + ".bar" : bundle.getName() + ".bar";
            if (output.isDirectory()) {
                output = new File(output, path);
            }
            analyzer.calcManifest();
            Jar jar = analyzer.getJar();
            this.getInfo(analyzer);
            this.statistics(jar, output, "");
            File f = File.createTempFile("tmpbnd", ".jar");
            jar.write(f);
            jar.close();
            if (!f.renameTo(output)) {
                this.copy(f, output);
                f.deleteOnExit();
            }
            boolean bl = this.getErrors().size() == 0;
            return bl;
        }
        finally {
            analyzer.close();
        }
    }

    void doDiff(String[] args, int first) throws IOException {
        File base = new File("");
        boolean strict = false;
        Jar[] targets = new Jar[2];
        int n = 0;
        for (int i = first; i < args.length; ++i) {
            if ("-d".equals(args[i])) {
                base = bnd.getFile(base, args[++i]);
                continue;
            }
            if ("-strict".equals(args[i])) {
                strict = "true".equalsIgnoreCase(args[++i]);
                continue;
            }
            if (args[i].startsWith("-")) {
                this.error("Unknown option for diff: " + args[i], new Object[0]);
                continue;
            }
            if (n >= 2) {
                System.err.println("Must have 2 files ... not more");
                continue;
            }
            File f = bnd.getFile(base, args[i]);
            if (!f.isFile()) {
                System.err.println("Not a file: " + f);
                continue;
            }
            try {
                Jar jar = new Jar(f);
                targets[n++] = jar;
                continue;
            }
            catch (Exception e) {
                System.err.println("Not a JAR file: " + f);
            }
        }
        if (n != 2) {
            System.err.println("Must have 2 files ...");
            return;
        }
        Diff diff = new Diff();
        Map<String, Object> map = diff.diff(targets[0], targets[1], strict);
        diff.print(System.out, map, 0);
        for (Jar jar : targets) {
            jar.close();
        }
        diff.close();
    }

    void copy(File a, File b) {
        try {
            FileInputStream in = new FileInputStream(a);
            FileOutputStream out = new FileOutputStream(b);
            byte[] buffer = new byte[8196];
            int size = ((InputStream)in).read(buffer);
            while (size > 0) {
                ((OutputStream)out).write(buffer, 0, size);
                size = ((InputStream)in).read(buffer);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
        catch (IOException e) {
            this.error("While copying the output file: " + a + "->" + b, new Object[0]);
        }
    }

    public void setOut(PrintStream out) {
        this.out = out;
    }

    public void test(String[] args, int i) throws Exception {
        Project project = this.getProject();
        project.test();
        this.getInfo(project);
    }

    public Project getProject() throws Exception {
        if (this.project != null) {
            return this.project;
        }
        this.project = Workspace.getProject(this.getBase());
        if (!this.project.isValid()) {
            throw new IllegalArgumentException("The base directory " + this.getBase() + " is not a project directory ");
        }
        return this.project;
    }

    public void debug(String[] args, int i) throws Exception {
        Project project = this.getProject();
        System.out.println("Project: " + project);
        Properties p = project.getFlattenedProperties();
        for (Object k : p.keySet()) {
            String key = (String)k;
            String s = p.getProperty(key);
            Collection<String> l = null;
            if (s.indexOf(44) > 0) {
                l = bnd.split(s);
            } else if (s.indexOf(58) > 0) {
                l = bnd.split(s, "\\s*:\\s*");
            }
            if (l != null) {
                String del = key;
                for (String ss : l) {
                    System.out.printf("%-40s %s\n", del, ss);
                    del = "";
                }
                continue;
            }
            System.out.printf("%-40s %s\n", key, s);
        }
    }

    public void repo(String[] args, int i) throws Exception {
        String bsn = null;
        String version = null;
        Project p = Workspace.getProject(this.getBase());
        List<RepositoryPlugin> repos = p.getPlugins(RepositoryPlugin.class);
        RepositoryPlugin writable = null;
        for (RepositoryPlugin rpp : repos) {
            if (!rpp.canWrite()) continue;
            writable = rpp;
            break;
        }
        while (i < args.length) {
            if ("repos".equals(args[i])) {
                int n = 0;
                for (RepositoryPlugin repo : repos) {
                    this.out.printf("%3d. %s\n", n++, repo);
                }
            } else if ("list".equals(args[i])) {
                String mask = null;
                if (i < args.length - 1) {
                    mask = args[++i];
                }
                this.repoList(repos, mask);
            } else if ("-repo".equals(args[i])) {
                String location;
                if ((location = args[++i]).equals("maven")) {
                    System.out.println("Maven");
                    MavenRepository maven = new MavenRepository();
                    maven.setProperties(new HashMap<String, String>());
                    maven.setReporter(this);
                    repos = Arrays.asList(maven);
                } else {
                    FileRepo repo = new FileRepo();
                    repo.setReporter(this);
                    repo.setLocation(location);
                    repos = Arrays.asList(repo);
                    writable = repo;
                }
            } else if ("-bsn".equals(args[i])) {
                bsn = args[++i];
            } else if ("-version".equals(args[i])) {
                version = args[++i];
            } else if ("put".equals(args[i])) {
                this.repoPut(writable, p, args[++i], bsn, version);
            } else if ("get".equals(args[i])) {
                this.repoGet(repos, args[++i]);
            } else {
                this.repoFetch(repos, args[++i]);
            }
            ++i;
        }
    }

    private void repoGet(List<RepositoryPlugin> writable, String string) {
    }

    private void repoPut(RepositoryPlugin writable, Project project, String file, String bsn, String version) throws Exception {
        File f = this.getFile(file);
        if (f.isFile()) {
            Jar jar = project.getValidJar(f);
            Manifest manifest = jar.getManifest();
            if (bsn != null) {
                manifest.getMainAttributes().putValue("Bundle-SymbolicName", bsn);
            }
            if (version != null) {
                manifest.getMainAttributes().putValue("Bundle-Version", version);
            }
            writable.put(jar);
        } else {
            this.error("There is no such file: " + f.getAbsolutePath(), new Object[0]);
        }
    }

    private void repoFetch(List<RepositoryPlugin> repos, String string) {
        File f = this.getFile(string);
        if (f.isFile()) {
            // empty if block
        }
    }

    void repoList(List<RepositoryPlugin> repos, String mask) throws Exception {
        this.trace("list repo " + repos + " " + mask, new Object[0]);
        TreeSet<String> bsns = new TreeSet<String>();
        for (RepositoryPlugin repo : repos) {
            bsns.addAll(repo.list(mask));
        }
        for (String bsn : bsns) {
            TreeSet<Version> versions = new TreeSet<Version>();
            for (RepositoryPlugin repo : repos) {
                List<Version> result = repo.versions(bsn);
                if (result == null) continue;
                versions.addAll(result);
            }
            this.out.printf("%-40s %s\n", bsn, versions);
        }
    }

    void patch(String[] args, int i) throws Exception {
        while (i < args.length) {
            if ("create".equals(args[i]) && i + 3 < args.length) {
                this.createPatch(args[++i], args[++i], args[++i]);
            } else if ("apply".equals(args[i]) && i + 3 < args.length) {
                this.applyPatch(args[++i], args[++i], args[++i]);
            } else if ("help".equals(args[i])) {
                this.out.println("patch (create <old> <new> <patch> | patch <old> <patch> <new>)");
            } else {
                this.out.println("Patch does not recognize command? " + Arrays.toString(args));
            }
            ++i;
        }
    }

    void createPatch(String old, String newer, String patch) throws Exception {
        Jar a = new Jar(new File(old));
        Manifest am = a.getManifest();
        Jar b = new Jar(new File(newer));
        Manifest bm = b.getManifest();
        Set delete = this.newSet();
        for (String path : a.getResources().keySet()) {
            Resource br = b.getResource(path);
            if (br == null) {
                this.trace("DELETE    %s", path);
                delete.add(path);
                continue;
            }
            Resource ar = a.getResource(path);
            if (this.isEqual(ar, br)) {
                this.trace("UNCHANGED %s", path);
                b.remove(path);
                continue;
            }
            this.trace("UPDATE    %s", path);
        }
        bm.getMainAttributes().putValue("Patch-Delete", bnd.join(delete, ", "));
        bm.getMainAttributes().putValue("Patch-Version", am.getMainAttributes().getValue("Bundle-Version"));
        b.write(new File(patch));
        a.close();
        a.close();
    }

    private boolean isEqual(Resource ar, Resource br) throws Exception {
        InputStream ain = ar.openInputStream();
        try {
            InputStream bin = br.openInputStream();
            try {
                while (true) {
                    int bn;
                    int an;
                    if ((an = ain.read()) == (bn = bin.read())) {
                        if (an != -1) continue;
                        boolean bl = true;
                        return bl;
                    }
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                bin.close();
            }
        }
        finally {
            ain.close();
        }
    }

    void applyPatch(String old, String patch, String newer) throws Exception {
        Jar a = new Jar(new File(old));
        Jar b = new Jar(new File(patch));
        Manifest bm = b.getManifest();
        String patchDelete = bm.getMainAttributes().getValue("Patch-Delete");
        String patchVersion = bm.getMainAttributes().getValue("Patch-Version");
        if (patchVersion == null) {
            this.error("To patch, you must provide a patch bundle.\nThe given " + patch + " bundle does not contain the Patch-Version header", new Object[0]);
            return;
        }
        Collection<String> delete = bnd.split(patchDelete);
        HashSet<String> paths = new HashSet<String>(a.getResources().keySet());
        paths.removeAll(delete);
        for (String path : paths) {
            Resource br = b.getResource(path);
            if (br != null) continue;
            b.putResource(path, a.getResource(path));
        }
        bm.getMainAttributes().putValue("Bundle-Version", patchVersion);
        b.write(new File(newer));
        a.close();
        b.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runtests(String[] args, int i) throws Exception {
        int errors = 0;
        File cwd = new File("").getAbsoluteFile();
        Workspace ws = Workspace.getWorkspace(cwd);
        File reportDir = this.getFile("reports");
        Tag summary = new Tag("summary");
        summary.addAttribute("date", new Date());
        summary.addAttribute("ws", ws.getBase());
        boolean hadOne = false;
        while (i < args.length) {
            if (args[i].startsWith("-reportdir")) {
                reportDir = this.getFile(args[i]).getAbsoluteFile();
                if (reportDir.isFile()) {
                    this.error("-reportdir must be a directory", new Object[0]);
                }
            } else if (args[i].startsWith("-title")) {
                summary.addAttribute("title", args[++i]);
            } else if (args[i].startsWith("-dir")) {
                cwd = this.getFile(args[++i]).getAbsoluteFile();
            } else {
                File f = this.getFile(args[i]);
                errors += this.runtTest(f, ws, reportDir, summary);
                hadOne = true;
            }
            ++i;
        }
        if (!hadOne) {
            File[] files;
            for (File f : files = cwd.listFiles()) {
                if (!f.getName().endsWith(".bnd")) continue;
                errors += this.runtTest(f, ws, reportDir, summary);
            }
        }
        if (errors > 0) {
            summary.addAttribute("errors", errors);
        }
        File r = this.getFile(reportDir + "/summary.xml");
        FileOutputStream out = new FileOutputStream(r);
        PrintWriter pw = new PrintWriter(new OutputStreamWriter(out));
        try {
            summary.print(0, pw);
        }
        finally {
            pw.close();
            out.close();
        }
    }

    private int runtTest(File testFile, Workspace ws, File reportDir, Tag summary) throws Exception {
        System.out.println("Report dir=" + reportDir + " testFile=" + testFile);
        reportDir.mkdirs();
        int errors = -1;
        Tag report = new Tag("report");
        summary.addContent(report);
        report.addAttribute("path", testFile.getAbsolutePath());
        if (!testFile.isFile()) {
            this.error("No bnd file: " + testFile, new Object[0]);
            report.addAttribute("exception", "No bnd file found");
        } else {
            long start = System.currentTimeMillis();
            errors = this.runtTests(report, ws, reportDir, testFile);
            long duration = System.currentTimeMillis() - start;
            report.addAttribute("duration", (duration + 500L) / 1000L);
        }
        return errors;
    }

    private int runtTests(Tag report, Workspace ws, File reportDir, File f) throws Exception {
        int errors = -1;
        Project p = new Project(ws, f.getAbsoluteFile().getParentFile(), f.getAbsoluteFile());
        ProjectLauncher pl = new ProjectLauncher(p);
        String t = p.getProperty("-target");
        if (t == null) {
            this.error("No target set for " + f, new Object[0]);
            report.addAttribute("exception", "No -target property found");
        } else {
            List<Container> targets = p.getBundles(1, t);
            if (targets.size() != 1) {
                this.error("Only one -target supported " + t, new Object[0]);
                report.addAttribute("exception", "Only one -target supported " + t);
            } else {
                for (Container c : targets) {
                    File target = c.getFile();
                    if (!target.isFile()) {
                        this.error("The target is not a proper JAR file: " + target, new Object[0]);
                        continue;
                    }
                    report.addAttribute("title", f.getName().replace(".bnd", ""));
                    report.addAttribute("id", target.getName());
                    errors = this.runtTests(report, reportDir, f, pl, target);
                }
            }
        }
        return errors;
    }

    private int runtTests(Tag report, File reportDir, File f, ProjectLauncher pl, File target) throws Exception {
        String path = f.getName().replace(".bnd", "") + ".xml";
        pl.setReport(bnd.getFile(reportDir, path));
        report.addAttribute("report", path);
        int errors = pl.run(target);
        this.getInfo(pl);
        if (errors == 0) {
            this.trace("ok", new Object[0]);
        } else {
            report.addAttribute("error", errors);
            this.error("Failed: " + this.normalize(f) + ", " + errors + " test" + (errors > 1 ? "s" : "") + " failures, see " + this.normalize(pl.getTestreport().getAbsolutePath()), new Object[0]);
        }
        return errors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doExtract(String[] args, int i) throws Exception {
        File f;
        if (i >= args.length) {
            this.error("No arguments for extract", new Object[0]);
            return;
        }
        if (!(f = this.getFile(args[i++])).isFile()) {
            this.error("No JAR file to extract from: %s", f);
            return;
        }
        if (i == args.length) {
            System.out.println("FILES:");
            this.doPrint(f, 4);
            return;
        }
        Jar j = new Jar(f);
        try {
            OutputStreamWriter output = new OutputStreamWriter(this.out);
            while (i < args.length) {
                String path;
                Resource r;
                if ((r = j.getResource(path = args[i++])) == null) {
                    this.error("No such resource: %s in %s", path, f);
                    continue;
                }
                InputStream in = r.openInputStream();
                try {
                    InputStreamReader rds = new InputStreamReader(in);
                    this.copy(rds, output);
                    ((Writer)output).flush();
                }
                finally {
                    in.close();
                }
            }
        }
        finally {
            j.close();
        }
    }
}

