/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.make;

import aQute.bnd.service.AnalyzerPlugin;
import aQute.lib.osgi.Analyzer;
import aQute.lib.osgi.EmbeddedResource;
import aQute.lib.osgi.Processor;
import aQute.lib.osgi.Resource;
import aQute.lib.osgi.Verifier;
import aQute.libg.version.Version;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ServiceComponent
implements AnalyzerPlugin {
    public static final String NAMESPACE_STEM = "http://www.osgi.org/xmlns/scr";
    public static final String JIDENTIFIER = "<<identifier>>";
    public static final String COMPONENT_FACTORY = "factory:";
    public static final String COMPONENT_SERVICEFACTORY = "servicefactory:";
    public static final String COMPONENT_IMMEDIATE = "immediate:";
    public static final String COMPONENT_ENABLED = "enabled:";
    public static final String COMPONENT_DYNAMIC = "dynamic:";
    public static final String COMPONENT_MULTIPLE = "multiple:";
    public static final String COMPONENT_PROVIDE = "provide:";
    public static final String COMPONENT_OPTIONAL = "optional:";
    public static final String COMPONENT_PROPERTIES = "properties:";
    public static final String COMPONENT_IMPLEMENTATION = "implementation:";
    public static final String COMPONENT_VERSION = "version:";
    public static final String COMPONENT_CONFIGURATION_POLICY = "configuration-policy:";
    public static final String COMPONENT_MODIFIED = "modified:";
    public static final String COMPONENT_ACTIVATE = "activate:";
    public static final String COMPONENT_DEACTIVATE = "deactivate:";
    public static final String[] componentDirectives = new String[]{"factory:", "immediate:", "enabled:", "dynamic:", "multiple:", "provide:", "optional:", "properties:", "implementation:", "servicefactory:", "version:", "configuration-policy:", "modified:", "activate:", "deactivate:"};
    public static final Set<String> SET_COMPONENT_DIRECTIVES = new HashSet<String>(Arrays.asList(componentDirectives));
    public static final Set<String> SET_COMPONENT_DIRECTIVES_1_1 = new HashSet<String>(Arrays.asList("version:", "configuration-policy:", "modified:", "activate:", "deactivate:"));

    public boolean analyzeJar(Analyzer analyzer) throws Exception {
        ComponentMaker m = new ComponentMaker(analyzer);
        Map<String, Map<String, String>> l = m.doServiceComponent();
        if (!l.isEmpty()) {
            analyzer.setProperty("Service-Component", Processor.printClauses(l, ""));
        }
        analyzer.getInfo(m, "Service Component");
        m.close();
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ComponentMaker
    extends Processor {
        Analyzer analyzer;
        public static final Pattern REFERENCE = Pattern.compile("([^(]+)(\\(.+\\))?");

        ComponentMaker(Analyzer analyzer) {
            super(analyzer);
            this.analyzer = analyzer;
        }

        Map<String, Map<String, String>> doServiceComponent() throws Exception {
            String header = this.getProperty("Service-Component");
            return this.doServiceComponent(header);
        }

        public Map<String, Map<String, String>> doServiceComponent(String serviceComponent) throws IOException {
            Map<String, Map<String, String>> list = ComponentMaker.newMap();
            Map<String, Map<String, String>> sc = this.parseHeader(serviceComponent);
            Map empty = Collections.emptyMap();
            for (Map.Entry<String, Map<String, String>> entry : sc.entrySet()) {
                String name = entry.getKey();
                Map<String, String> info = entry.getValue();
                if (name == null) {
                    this.error("No name in Service-Component header: " + info, new Object[0]);
                    continue;
                }
                if (name.indexOf("*") >= 0 || name.indexOf(47) >= 0 || name.endsWith(".xml") || this.analyzer.getJar().exists(name)) {
                    list.put(name, info);
                    continue;
                }
                String impl = name;
                if (info.containsKey(ServiceComponent.COMPONENT_IMPLEMENTATION)) {
                    impl = info.get(ServiceComponent.COMPONENT_IMPLEMENTATION);
                }
                if (!this.analyzer.checkClass(impl)) {
                    this.error("Not found Service-Component header: " + name, new Object[0]);
                    continue;
                }
                Resource resource = this.createComponentResource(name, info);
                this.analyzer.getJar().putResource("OSGI-INF/" + name + ".xml", resource);
                list.put("OSGI-INF/" + name + ".xml", empty);
            }
            return list;
        }

        Resource createComponentResource(String name, Map<String, String> info) throws IOException {
            String namespace = this.getNamespace(info);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)out, "UTF-8"));
            pw.println("<?xml version='1.0' encoding='utf-8'?>");
            pw.print("<component name='" + name + "'");
            if (namespace != null) {
                pw.print(" xmlns='" + namespace + "'");
            }
            this.doAttribute(pw, info.get(ServiceComponent.COMPONENT_FACTORY), "factory", new String[0]);
            this.doAttribute(pw, info.get(ServiceComponent.COMPONENT_IMMEDIATE), "immediate", "false", "true");
            this.doAttribute(pw, info.get(ServiceComponent.COMPONENT_ENABLED), "enabled", "true", "false");
            this.doAttribute(pw, info.get(ServiceComponent.COMPONENT_CONFIGURATION_POLICY), "configuration-policy", "optional", "require", "ignore");
            this.doAttribute(pw, info.get(ServiceComponent.COMPONENT_ACTIVATE), "activate", ServiceComponent.JIDENTIFIER);
            this.doAttribute(pw, info.get(ServiceComponent.COMPONENT_DEACTIVATE), "deactivate", ServiceComponent.JIDENTIFIER);
            this.doAttribute(pw, info.get(ServiceComponent.COMPONENT_MODIFIED), "modified", ServiceComponent.JIDENTIFIER);
            pw.println(">");
            String impl = info.get(ServiceComponent.COMPONENT_IMPLEMENTATION);
            pw.println("  <implementation class='" + (impl == null ? name : impl) + "'/>");
            String provides = info.get(ServiceComponent.COMPONENT_PROVIDE);
            boolean servicefactory = Boolean.getBoolean(info.get(ServiceComponent.COMPONENT_SERVICEFACTORY) + "");
            this.provides(pw, provides, servicefactory);
            this.properties(pw, info);
            this.reference(info, pw);
            pw.println("</component>");
            pw.close();
            byte[] data = out.toByteArray();
            out.close();
            return new EmbeddedResource(data, 0L);
        }

        private void doAttribute(PrintWriter pw, String value, String name, String ... matches) {
            if (value != null) {
                if (matches.length != 0) {
                    if (matches.length == 1 && matches[0].equals(ServiceComponent.JIDENTIFIER)) {
                        if (!Verifier.isIdentifier(value)) {
                            this.error("Component attribute %s has value %s but is not a Java identifier", name, value);
                        }
                    } else if (!Verifier.isMember(value, matches)) {
                        this.error("Component attribute %s has value %s but is not a member of %s", name, value, Arrays.toString(matches));
                    }
                }
                pw.print(" ");
                pw.print(name);
                pw.print("='");
                pw.print(value);
                pw.print("'");
            }
        }

        private String getNamespace(Map<String, String> info) {
            String version = info.get(ServiceComponent.COMPONENT_VERSION);
            if (version != null) {
                try {
                    Version v = new Version(version);
                    return "http://www.osgi.org/xmlns/scr/v" + v;
                }
                catch (Exception e) {
                    this.error("version: specified on component header but not a valid version: " + version, new Object[0]);
                    return null;
                }
            }
            for (String key : info.keySet()) {
                if (!SET_COMPONENT_DIRECTIVES_1_1.contains(key)) continue;
                return "http://www.osgi.org/xmlns/scr/v1.1.0";
            }
            return null;
        }

        void properties(PrintWriter pw, Map<String, String> info) {
            Collection<String> properties = ComponentMaker.split(info.get(ServiceComponent.COMPONENT_PROPERTIES));
            for (String clause : properties) {
                String[] parts;
                int n = clause.indexOf(61);
                if (n <= 0) {
                    this.error("Not a valid property in service component: " + clause, new Object[0]);
                    continue;
                }
                String type = null;
                String name = clause.substring(0, n);
                if (name.indexOf(64) >= 0) {
                    String[] parts2 = name.split("@");
                    name = parts2[1];
                    type = parts2[0];
                }
                String value = clause.substring(n + 1).trim();
                pw.print("<property name='");
                pw.print(name);
                pw.print("'");
                if (type != null) {
                    if (VALID_PROPERTY_TYPES.matcher(type).matches()) {
                        pw.print(" type='");
                        pw.print(type);
                        pw.print("'");
                    } else {
                        this.warning("Invalid property type '" + type + "' for property " + name, new Object[0]);
                    }
                }
                if ((parts = value.split("\\s*(\\||\\n)\\s*")).length > 1) {
                    pw.println(">");
                    for (String part : parts) {
                        pw.println(part);
                    }
                    pw.println("</property>");
                    continue;
                }
                pw.print(" value='");
                pw.print(parts[0]);
                pw.print("'/>");
            }
        }

        void provides(PrintWriter pw, String provides, boolean servicefactory) {
            if (provides != null) {
                if (!servicefactory) {
                    pw.println("  <service>");
                } else {
                    pw.println("  <service servicefactory='true'>");
                }
                StringTokenizer st = new StringTokenizer(provides, ",");
                while (st.hasMoreTokens()) {
                    String interfaceName = st.nextToken();
                    pw.println("    <provide interface='" + interfaceName + "'/>");
                    if (this.analyzer.checkClass(interfaceName)) continue;
                    this.error("Component definition provides a class that is neither imported nor contained: " + interfaceName, new Object[0]);
                }
                pw.println("  </service>");
            }
        }

        void reference(Map<String, String> info, PrintWriter pw) {
            ArrayList<String> dynamic = new ArrayList<String>(ComponentMaker.split(info.get(ServiceComponent.COMPONENT_DYNAMIC)));
            ArrayList<String> optional = new ArrayList<String>(ComponentMaker.split(info.get(ServiceComponent.COMPONENT_OPTIONAL)));
            ArrayList<String> multiple = new ArrayList<String>(ComponentMaker.split(info.get(ServiceComponent.COMPONENT_MULTIPLE)));
            for (Map.Entry<String, String> ref : info.entrySet()) {
                char c;
                String referenceName = ref.getKey();
                String target = null;
                String interfaceName = ref.getValue();
                if (interfaceName == null || interfaceName.length() == 0) {
                    this.error("Invalid Interface Name for references in Service Component: " + referenceName + "=" + interfaceName, new Object[0]);
                }
                if ("?+*~".indexOf(c = interfaceName.charAt(interfaceName.length() - 1)) >= 0) {
                    if (c == '?' || c == '*' || c == '~') {
                        optional.add(referenceName);
                    }
                    if (c == '+' || c == '*') {
                        multiple.add(referenceName);
                    }
                    if (c == '+' || c == '*' || c == '?') {
                        dynamic.add(referenceName);
                    }
                    interfaceName = interfaceName.substring(0, interfaceName.length() - 1);
                }
                if (referenceName.endsWith(":")) {
                    if (SET_COMPONENT_DIRECTIVES.contains(referenceName)) continue;
                    this.error("Unrecognized directive in Service-Component header: " + referenceName, new Object[0]);
                    continue;
                }
                Matcher m = REFERENCE.matcher(interfaceName);
                if (m.matches()) {
                    interfaceName = m.group(1);
                    target = m.group(2);
                }
                if (!this.analyzer.checkClass(interfaceName)) {
                    this.error("Component definition refers to a class that is neither imported nor contained: " + interfaceName, new Object[0]);
                }
                pw.print("  <reference name='" + referenceName + "' interface='" + interfaceName + "'");
                String cardinality = optional.contains(referenceName) ? "0" : "1";
                cardinality = cardinality + "..";
                cardinality = cardinality + (multiple.contains(referenceName) ? "n" : "1");
                if (!cardinality.equals("1..1")) {
                    pw.print(" cardinality='" + cardinality + "'");
                }
                if (Character.isLowerCase(referenceName.charAt(0))) {
                    String z = referenceName.substring(0, 1).toUpperCase() + referenceName.substring(1);
                    pw.print(" bind='set" + z + "'");
                    pw.print(" unbind='unset" + z + "'");
                }
                if (dynamic.contains(referenceName)) {
                    pw.print(" policy='dynamic'");
                }
                if (target != null) {
                    pw.print(" target='" + target + "'");
                }
                pw.println("/>");
            }
        }
    }
}

