/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.plugin.editors;

import aQute.bnd.help.Syntax;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;

public class BndHover
implements ITextHover {
    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        if (hoverRegion != null) {
            IDocument doc = textViewer.getDocument();
            try {
                String key = doc.get(hoverRegion.getOffset(), hoverRegion.getLength());
                Syntax syntax = Syntax.HELP.get(key);
                if (syntax == null) {
                    return null;
                }
                StringBuilder sb = new StringBuilder();
                sb.append(syntax.getLead());
                sb.append("\nE.g. ");
                sb.append(syntax.getExample());
                String text = sb.toString();
                if (text == null) {
                    return null;
                }
                if (text.length() > 30) {
                    text = this.wrap(text, 30);
                }
                return text;
            }
            catch (Exception e) {
                return e + "";
            }
        }
        return null;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        IDocument doc = textViewer.getDocument();
        try {
            int start;
            int end = offset;
            for (start = offset; start >= 0 && this.isWordChar(doc.getChar(start)); --start) {
            }
            while (end < doc.getLength() && this.isWordChar(doc.getChar(end))) {
                ++end;
            }
            int length = Math.min(doc.getLength(), end - ++start);
            start = Math.max(0, start);
            return new Region(start, length);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return null;
        }
    }

    boolean isWordChar(char c) {
        return Character.isJavaIdentifierPart(c) || c == '-' || c == '.';
    }

    String wrap(String text, int width) {
        StringBuilder sb = new StringBuilder();
        int n = 0;
        int r = 0;
        block4: while (r < text.length()) {
            char c = text.charAt(r++);
            switch (c) {
                case '\n': 
                case '\r': {
                    if (n != 0) {
                        sb.append('\n');
                    }
                    n = 0;
                    continue block4;
                }
                case '\t': 
                case ' ': {
                    if (n > 20) {
                        sb.append("\n");
                        n = 0;
                        continue block4;
                    }
                    sb.append(" ");
                    ++n;
                    continue block4;
                }
            }
            sb.append(c);
            ++n;
        }
        return sb.toString();
    }

    static class DocString
    implements CharSequence {
        IDocument doc;

        DocString() {
        }

        public char charAt(int index) {
            try {
                return this.doc.getChar(index);
            }
            catch (BadLocationException e) {
                throw new IndexOutOfBoundsException();
            }
        }

        public int length() {
            return this.doc.getLength();
        }

        public CharSequence subSequence(int start, int end) {
            return this.doc.get().subSequence(start, end);
        }
    }
}

