/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.plugin.popup;

import aQute.bnd.build.Project;
import aQute.bnd.plugin.Activator;
import aQute.bnd.plugin.popup.SubMenu;
import aQute.bnd.service.action.Action;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.console.IOConsole;

public class Scripts
extends CompoundContributionItem {
    final List<Project> projects = new ArrayList<Project>();
    static IOConsole console;

    public Scripts() {
        ISelectionService is = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getSelectionService();
        ISelection s = is.getSelection();
        if (s != null && s instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)s;
            for (Object oo : ss) {
                Project project;
                File bndFile;
                IJavaProject jp = null;
                if (oo instanceof IResource) {
                    IResource r = (IResource)oo;
                    IProject iproject = r.getProject();
                    jp = JavaCore.create((IProject)iproject);
                } else if (oo instanceof IJavaProject) {
                    jp = (IJavaProject)oo;
                }
                if (jp == null || !jp.getProject().isAccessible() || !(bndFile = (project = Activator.getDefault().getCentral().getModel(jp)).getFile("bnd.bnd")).exists()) continue;
                this.projects.add(project);
            }
        }
    }

    public Scripts(String id) {
        super(id);
    }

    protected IContributionItem[] getContributionItems() {
        if (this.projects.isEmpty()) {
            return new IContributionItem[0];
        }
        HashSet<String> titles = new HashSet<String>();
        boolean first = true;
        for (Project project : this.projects) {
            if (first) {
                titles.addAll(project.getActions().keySet());
                first = false;
                continue;
            }
            titles.retainAll(project.getActions().keySet());
        }
        SubMenu root = new SubMenu("root");
        SubMenu sub = new SubMenu("Bnd");
        root.add(sub);
        for (String title : titles) {
            sub.add(this, title, title);
        }
        return root.getItems();
    }

    void exec(final String label) {
        Job job = new Job(label){

            protected IStatus run(IProgressMonitor monitor) {
                for (Project project : Scripts.this.projects) {
                    if (monitor != null) {
                        if (monitor.isCanceled()) break;
                        monitor.subTask("" + project + " " + label);
                    }
                    Map<String, Action> actions = project.getActions();
                    Action cmd = actions.get(label);
                    try {
                        cmd.execute(project, label);
                        monitor.worked(1);
                        Activator.getDefault().getCentral().refresh(project);
                        if (project.isPerfect()) continue;
                        Activator.getDefault().report(true, true, project, "During execution of " + label, "");
                        return Status.CANCEL_STATUS;
                    }
                    catch (Exception e) {
                        Activator.getDefault().error("While executing action: " + cmd, e);
                    }
                }
                try {
                    Activator.getDefault().getCentral().refreshPlugins();
                    return Status.OK_STATUS;
                }
                catch (Exception e) {
                    return new Status(4, "aQute.bmaker", "Failed to refresh: " + e);
                }
            }
        };
        job.setPriority(20);
        job.schedule();
    }
}

