/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.plugin.popup.actions;

import aQute.bnd.build.Workspace;
import aQute.bnd.plugin.Activator;
import aQute.bnd.plugin.Central;
import aQute.bnd.plugin.popup.actions.repo.RepoDialog;
import aQute.bnd.service.RepositoryPlugin;
import aQute.lib.osgi.Jar;
import aQute.lib.osgi.Verifier;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class AddToRepo
implements IObjectActionDelegate {
    IFile[] locations;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(IAction action) {
        block11: {
            try {
                if (this.locations == null) break block11;
                for (int i = 0; i < this.locations.length; ++i) {
                    File mf = this.locations[i].getLocation().toFile();
                    try {
                        Jar jar = new Jar(mf.getName(), mf);
                        try {
                            Verifier verifier = new Verifier(jar);
                            verifier.verify();
                            if (verifier.getErrors().size() + verifier.getWarnings().size() > 0) {
                                ArrayList<String> info = new ArrayList<String>(verifier.getErrors());
                                info.addAll(verifier.getWarnings());
                                Activator.getDefault().error(info);
                            } else {
                                Workspace ws = Central.getWorkspace();
                                List<RepositoryPlugin> repos = ws.getPlugins(RepositoryPlugin.class);
                                RepoDialog d = new RepoDialog(null, jar, repos);
                                d.setBlockOnOpen(true);
                                if (d.open() == 0) {
                                    RepositoryPlugin repo = d.getRepository();
                                    File f = repo.put(jar);
                                    Central.refresh(Path.fromOSString((String)f.getAbsolutePath()));
                                }
                            }
                        }
                        finally {
                            jar.close();
                        }
                    }
                    catch (Exception e) {
                        Activator.getDefault().error("While verifying JAR " + this.locations[i], e);
                    }
                    this.locations[i].getParent().refreshLocal(1, null);
                }
            }
            catch (Exception e) {
                Activator.getDefault().error("Could not start verification", e);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.locations = this.getLocations(selection);
    }

    IFile[] getLocations(ISelection selection) {
        if (selection != null && selection instanceof StructuredSelection) {
            StructuredSelection ss = (StructuredSelection)selection;
            IFile[] result = new IFile[ss.size()];
            int n = 0;
            Iterator i = ss.iterator();
            while (i.hasNext()) {
                result[n++] = (IFile)i.next();
            }
            return result;
        }
        return null;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }
}

