/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.set;

import aQute.lib.osgi.Analyzer;
import aQute.lib.osgi.Jar;
import aQute.lib.osgi.Processor;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Group
extends Processor {
    List<Analyzer> analyzers = new ArrayList<Analyzer>();
    Map<String, List<Analyzer>> exports;

    public Group(Processor parent) {
        super(parent);
    }

    void add(File jar) throws Exception {
        this.add(new Jar(jar));
    }

    void add(Jar jar) throws Exception {
        Analyzer analyzer = new Analyzer(this);
        analyzer.setJar(jar);
        analyzer.analyze();
        this.analyzers.add(analyzer);
    }

    void analyze() {
        this.circular();
    }

    void circular() {
        for (Analyzer analyzer : this.analyzers) {
            Set<String> ps = analyzer.getExports().keySet();
            for (String p : ps) {
                if (this.exports.containsKey(p)) {
                    this.exports.get(p).add(analyzer);
                    continue;
                }
                this.exports.put(p, Arrays.asList(analyzer));
            }
        }
        ArrayList<String> paths = new ArrayList<String>();
        for (Analyzer analyzer : this.analyzers) {
            this.traverse(new Path(null, ".", analyzer), paths);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void traverse(Path path, List<String> paths) {
        for (String p : path.analyzer.getImports().keySet()) {
            List<Analyzer> from = this.exports.get(p);
            if (from == null) continue;
            for (Analyzer f : from) {
            }
        }
    }

    static class Path {
        final Analyzer analyzer;
        final String pack;
        final Path previous;

        public Path(Path path, String pack, Analyzer analyzer) {
            this.analyzer = analyzer;
            this.previous = path;
            this.pack = pack;
        }

        boolean visited(Analyzer analyzer) {
            return this.analyzer == analyzer || this.previous == null || this.previous.visited(analyzer);
        }
    }
}

