/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.test;

import aQute.bnd.build.Container;
import aQute.bnd.build.Project;
import aQute.lib.osgi.Processor;
import aQute.libg.header.OSGiHeader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectLauncher
extends Processor {
    final Project project;
    static File runtime;
    File report;
    Process process;
    long timeout = 3600000L;

    public ProjectLauncher(Project project) {
        super(project);
        this.project = project;
    }

    public String[] getClasspath() {
        try {
            ArrayList<String> classpath = new ArrayList<String>();
            classpath.add(ProjectLauncher.getRuntime().getAbsolutePath());
            for (Container c : this.project.getRunpath()) {
                if (c.getType() != Container.TYPE.ERROR) {
                    if (c.getFile().getName().startsWith("ee.")) continue;
                    classpath.add(c.getFile().getAbsolutePath());
                    continue;
                }
                this.error("Invalid entry on the -runpath: " + c, new Object[0]);
            }
            return classpath.toArray(new String[classpath.size()]);
        }
        catch (Exception e) {
            this.error("Calculating class path", e, new Object[0]);
            return null;
        }
    }

    public static File getRuntime() {
        if (runtime == null) {
            try {
                URL url = ProjectLauncher.class.getResource("aQute.runtime.jar");
                if (url == null) {
                    throw new IllegalStateException("Can not find my runtime.jar");
                }
                runtime = File.createTempFile("aQute.runtime", ".jar");
                FileOutputStream out = new FileOutputStream(runtime);
                InputStream in = url.openStream();
                ProjectLauncher.copy(in, out);
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return runtime;
    }

    public void doRunbundles(List<String> programArguments) throws Exception {
        Collection<Container> testbundles = this.project.getRunbundles();
        for (Container c : testbundles) {
            if (c.getError() != null) {
                this.error("Invalid bundle on -runbundles " + c.getError(), new Object[0]);
                continue;
            }
            if (c.getVersion() != null && c.getVersion().equals("project")) {
                if (c.getError() == null && c.getProject() != null) {
                    File[] outputs;
                    Project sub = c.getProject();
                    sub.clear();
                    for (File f : outputs = sub.build(false)) {
                        programArguments.add("-bundle");
                        programArguments.add(f.getAbsolutePath());
                    }
                    this.getInfo(sub);
                    continue;
                }
                this.error("Cannot find project " + c.getBundleSymbolicName() + " " + c.getError(), new Object[0]);
                continue;
            }
            programArguments.add("-bundle");
            programArguments.add(c.getFile().getAbsolutePath());
        }
    }

    private void doRunpath(List<String> programArguments) throws Exception {
        Collection<Container> testpath = this.project.getRunpath();
        Container found = null;
        for (Container c : testpath) {
            String[] parts;
            String exports;
            if (c.getAttributes().containsKey("framework")) {
                if (found != null) {
                    this.warning("Specifying multiple framework classes on the -runpath\nPrevious found: " + found.getProject() + " " + found.getAttributes() + "\n" + "Now found     : " + c.getProject() + " " + c.getAttributes(), new Object[0]);
                }
                programArguments.add("-framework");
                programArguments.add(c.getAttributes().get("framework"));
                found = c;
            }
            if (c.getAttributes().containsKey("factory")) {
                if (found != null) {
                    this.warning("Specifying multiple framework factories on the -runpath\nPrevious found: " + found.getProject() + " " + found.getAttributes() + "\n" + "Now found     : " + c.getProject() + " " + c.getAttributes(), new Object[0]);
                }
                programArguments.add("-framework");
                programArguments.add(c.getAttributes().get("factory"));
                found = c;
            }
            if ((exports = c.getAttributes().get("export")) == null) continue;
            for (String p : parts = exports.split("\\s*,\\s*")) {
                programArguments.add("-export");
                programArguments.add(p);
            }
        }
        this.doSystemPackages(programArguments);
        this.doRunProperties(programArguments);
    }

    private void doRunProperties(List<String> programArguments) {
        Map<String, String> properties = OSGiHeader.parseProperties(this.getProperty("-runproperties"));
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            programArguments.add("-set");
            programArguments.add(entry.getKey());
            programArguments.add(entry.getValue());
        }
    }

    private void doSystemPackages(List<String> programArguments) {
        Map<String, Map<String, String>> systemPackages = this.parseHeader(this.getProperty("-runsystempackages"));
        for (Map.Entry<String, Map<String, String>> entry : systemPackages.entrySet()) {
            programArguments.add("-export");
            StringBuffer sb = new StringBuffer();
            sb.append(entry.getKey());
            ProjectLauncher.printClause(entry.getValue(), null, sb);
            programArguments.add(sb.toString());
        }
    }

    private void doStorage(List<String> programArguments) throws Exception {
        File tmp = new File(this.project.getTarget(), "fwtmp");
        tmp.mkdirs();
        tmp.deleteOnExit();
        programArguments.add("-storage");
        programArguments.add(tmp.getAbsolutePath());
    }

    private static void copy(InputStream in, FileOutputStream out) throws IOException {
        byte[] buf = new byte[8192];
        int size = in.read(buf);
        while (size > 0) {
            out.write(buf, 0, size);
            size = in.read(buf);
        }
        in.close();
    }

    private Process launch(File[] targets) throws Exception {
        List<String> arguments = this.newList();
        List<String> vmArguments = this.newList();
        vmArguments.add(this.getProperty("java", "java"));
        String jpda = System.getProperty("jpda");
        if (jpda != null) {
            vmArguments.add(jpda);
        }
        this.doClasspath(vmArguments);
        this.getArguments(targets, vmArguments, arguments);
        vmArguments.add("aQute.junit.runtime.Target");
        arguments.add("-report");
        arguments.add(this.getTestreport().getAbsolutePath());
        List<String> all = this.newList();
        all.addAll(vmArguments);
        all.addAll(arguments);
        System.out.println("Cmd: " + all);
        String[] cmdarray = all.toArray(new String[all.size()]);
        if (this.getErrors().size() > 0) {
            return null;
        }
        return Runtime.getRuntime().exec(cmdarray, null, this.project.getBase());
    }

    private void doVMArguments(List<String> arguments) {
        Map<String, String> map = OSGiHeader.parseProperties(this.getProperty("-runvm"));
        for (String key : map.keySet()) {
            if (key.startsWith("-")) {
                arguments.add(key);
                continue;
            }
            arguments.add("-D" + key.trim() + "=" + map.get(key));
        }
    }

    private void doClasspath(List<String> arguments) {
        List<String> cp = Arrays.asList(this.getClasspath());
        if (!cp.isEmpty()) {
            arguments.add("-classpath");
            arguments.add(ProjectLauncher.join(cp, File.pathSeparator));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(File f) throws Exception {
        this.process = this.launch(new File[]{f});
        Thread killer = new Thread(){

            public void run() {
                ProjectLauncher.this.process.destroy();
            }
        };
        Runtime.getRuntime().addShutdownHook(killer);
        Thread killer2 = new Thread("killer2"){

            public void run() {
                try {
                    while (true) {
                        Thread.sleep(ProjectLauncher.this.timeout);
                        System.out.println("EXITING BECAUSE OF OVERALL TIMEOUT: " + ProjectLauncher.this.timeout / 1000L + " secs");
                        ProjectLauncher.this.process.destroy();
                    }
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        };
        Streamer sin = new Streamer(this.process.getInputStream(), System.out);
        Streamer serr = new Streamer(this.process.getErrorStream(), System.out);
        try {
            killer2.start();
            sin.start();
            serr.start();
            int n = this.process.waitFor();
            return n;
        }
        finally {
            Runtime.getRuntime().removeShutdownHook(killer);
            killer2.interrupt();
            sin.join();
            serr.join();
        }
    }

    public File getTestreport() {
        if (this.report != null) {
            return this.report;
        }
        String path = this.getProperty("-testreport", "${target}/test-report.xml");
        this.report = this.getFile(path);
        return this.report;
    }

    public void getArguments(List<String> vmArguments, List<String> programArguments, boolean undertest) throws Exception {
        File[] files = this.project.build(undertest);
        this.getInfo(this.project);
        if (files == null) {
            return;
        }
        this.getArguments(files, vmArguments, programArguments);
    }

    public void getArguments(File[] files, List<String> vmArguments, List<String> programArguments) throws Exception {
        this.doVMArguments(vmArguments);
        this.doStorage(programArguments);
        this.doRunpath(programArguments);
        this.doRunbundles(programArguments);
        for (File file : files) {
            programArguments.add("-target");
            programArguments.add(file.getAbsolutePath());
        }
    }

    public File getReport() {
        return this.report;
    }

    public File setReport(String report) {
        this.report = this.getFile(report);
        return this.report;
    }

    public File setReport(File report) {
        this.report = report;
        return this.report;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    static class Streamer
    extends Thread {
        final InputStream in;
        final OutputStream out;

        Streamer(InputStream in, OutputStream out) {
            this.in = in;
            this.out = out;
        }

        public void run() {
            try {
                int c;
                while ((c = this.in.read()) > 0) {
                    this.out.write(c);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

