/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.jardiff;

import aQute.lib.osgi.Jar;
import aQute.lib.osgi.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Diff {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> diff(Jar a, Jar b, boolean strict) throws IOException {
        TreeMap<String, Object> different = new TreeMap<String, Object>();
        this.compareManifest(different, a.getManifest(), b.getManifest(), strict);
        this.diff(different, a.getResources().keySet(), b.getResources().keySet());
        HashSet<String> shared = new HashSet<String>(a.getResources().keySet());
        shared.retainAll(b.getResources().keySet());
        for (String path : a.getResources().keySet()) {
            Resource ra = a.getResource(path);
            Resource rb = a.getResource(path);
            if (rb == null) continue;
            if (ra.getClass() != rb.getClass()) {
                different.put(path, "Different types: " + a.getClass().getName() + " : " + b.getClass().getName());
                continue;
            }
            if (path.endsWith(".jar")) {
                Jar aa = new Jar(path, ra.openInputStream());
                Jar bb = new Jar(path, rb.openInputStream());
                try {
                    Map<String, Object> result = this.diff(aa, bb, strict);
                    if (result.isEmpty()) continue;
                    different.put(path, result);
                    continue;
                }
                finally {
                    aa.close();
                    bb.close();
                    continue;
                }
            }
            String cmp = this.diff(ra.openInputStream(), rb.openInputStream());
            if (cmp == null) continue;
            different.put(path, cmp);
        }
        return different;
    }

    String diff(InputStream a, InputStream b) throws IOException {
        int n = 0;
        int binary = 0;
        StringBuffer sb = new StringBuffer();
        while (true) {
            int ac = a.read();
            int bc = b.read();
            if (ac < 0) {
                if (bc < 0) {
                    return null;
                }
                return "a is smaller";
            }
            if (bc < 0) {
                return "b is smaller";
            }
            if (ac != bc) {
                String s = "Difference at pos: " + n;
                if (binary == 0 && sb.length() > 5) {
                    s = s + "Context: " + sb.substring(sb.length() - 5);
                }
            }
            if (ac >= 32 && ac <= 126) {
                sb.append((char)ac);
            } else {
                ++binary;
            }
            ++n;
        }
    }

    void diff(Map<String, Object> different, Set<?> a, Set<?> b) {
        HashSet onlyInA = new HashSet(a);
        onlyInA.removeAll(b);
        HashSet onlyInB = new HashSet(b);
        onlyInB.removeAll(a);
        for (Object element : onlyInA) {
            different.put(element.toString(), "a");
        }
        for (Object element : onlyInB) {
            different.put(element.toString(), "b");
        }
    }

    public void compareManifest(Map<String, Object> different, Manifest a, Manifest b, boolean strict) {
        if (a == null || b == null) {
            different.put("Manifest null", (a == null ? "a=null" : "a exists") + " " + (b == null ? "b=null" : "b exists"));
            return;
        }
        Attributes attrs = a.getMainAttributes();
        Attributes bttrs = b.getMainAttributes();
        this.diff(different, attrs.keySet(), bttrs.keySet());
        for (Object element : attrs.keySet()) {
            Attributes.Name name = (Attributes.Name)element;
            String av = attrs.getValue(name);
            String bv = bttrs.getValue(name);
            if (bv == null || av.equals(bv)) continue;
            different.put(name.toString(), "M:" + name + ":" + av + "!=" + bv);
        }
    }

    public void print(PrintStream pout, Map<String, Object> map, int indent) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            for (int j = 0; j < indent; ++j) {
                pout.print(" ");
            }
            String key = entry.getKey();
            pout.print(key);
            for (int j = 0; j < 70 - indent - key.length(); ++j) {
                pout.print(" ");
            }
            if (entry.getValue() instanceof Map) {
                pout.println();
                this.print(pout, (Map)entry.getValue(), indent + 1);
                continue;
            }
            pout.println(entry.getValue());
        }
    }

    public void close() {
    }
}

