/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.osgi;

import aQute.lib.osgi.Instruction;
import aQute.lib.osgi.Processor;
import aQute.lib.osgi.Verifier;
import aQute.libg.sed.Replacer;
import aQute.libg.version.Version;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;

public class Macro
implements Replacer {
    Properties properties;
    Processor domain;
    Object[] targets;
    boolean flattening;
    static Pattern commands = Pattern.compile("(?<!\\\\);");
    static String _uniqHelp = "${uniq;<list> ...}";
    static String _filterHelp = "${%s;<list>;<regex>}";
    static String _sortHelp = "${sort;<list>...}";
    static String _joinHelp = "${join;<list>...}";
    static String _ifHelp = "${if;<condition>;<iftrue> [;<iffalse>] }";
    public static String _fmodifiedHelp = "${fmodified;<list of filenames>...}, return latest modification date";
    static String _toclassnameHelp = "${classname;<list of class names>}, convert class paths to FQN class names ";
    static String _toclasspathHelp = "${toclasspath;<list>[;boolean]}, convert a list of class names to paths";
    static String _versionHelp = "${version;<mask>;<version>}, modify a version\n<mask> ::= [ M [ M [ M [ MQ ]]]\nM ::= '+' | '-' | MQ\nMQ ::= '~' | '='";
    static Pattern[] _versionPattern = new Pattern[]{null, null, Pattern.compile("[-+=~]{0,3}[=~]?"), Verifier.VERSION};

    public Macro(Properties properties, Processor domain, Object ... targets) {
        this.properties = properties;
        this.domain = domain;
        this.targets = targets;
        if (targets != null) {
            for (Object o : targets) {
                assert (o != null);
            }
        }
    }

    public Macro(Processor processor) {
        this(new Properties(), processor, new Object[0]);
    }

    public String process(String line) {
        return this.process(line, null);
    }

    String process(String line, Link link) {
        StringBuffer sb = new StringBuffer();
        this.process(line, 0, '\u0000', '\u0000', sb, link);
        return sb.toString();
    }

    int process(CharSequence org, int index, char begin, char end, StringBuffer result, Link link) {
        StringBuilder line = new StringBuilder(org);
        int nesting = 1;
        StringBuffer variable = new StringBuffer();
        while (index < line.length()) {
            char c1;
            if ((c1 = line.charAt(index++)) == end) {
                if (--nesting == 0) {
                    result.append(this.replace(variable.toString(), link));
                    return index;
                }
            } else if (c1 == begin) {
                ++nesting;
            } else {
                char c2;
                char terminator;
                if (c1 == '\\' && index < line.length() - 1 && line.charAt(index) == '$') {
                    ++index;
                    variable.append('$');
                    continue;
                }
                if (c1 == '$' && index < line.length() - 2 && (terminator = Macro.getTerminator(c2 = line.charAt(index))) != '\u0000') {
                    index = this.process(line, index + 1, c2, terminator, variable, link);
                    continue;
                }
            }
            variable.append(c1);
        }
        result.append(variable);
        return index;
    }

    public static char getTerminator(char c) {
        switch (c) {
            case '(': {
                return ')';
            }
            case '[': {
                return ']';
            }
            case '{': {
                return '}';
            }
            case '<': {
                return '>';
            }
            case '\u00ab': {
                return '\u00bb';
            }
            case '\u2039': {
                return '\u203a';
            }
        }
        return '\u0000';
    }

    protected String replace(String key, Link link) {
        if (link != null && link.contains(key)) {
            return "${infinite:" + link.toString() + "}";
        }
        if (key != null) {
            if ((key = key.trim()).length() > 0) {
                String value = this.properties.getProperty(key);
                if (value != null) {
                    return this.process(value, new Link(link, key));
                }
                value = this.doCommands(key);
                if (value != null) {
                    return this.process(value, new Link(link, key));
                }
                if (key != null && key.trim().length() > 0 && (value = System.getProperty(key)) != null) {
                    return value;
                }
                if (!this.flattening) {
                    this.domain.warning("No translation found for macro: " + key, new Object[0]);
                }
            } else {
                this.domain.warning("Found empty macro key", new Object[0]);
            }
        } else {
            this.domain.warning("Found null macro key", new Object[0]);
        }
        return "${" + key + "}";
    }

    private String doCommands(String key) {
        String[] args = commands.split(key);
        if (args == null || args.length == 0) {
            return null;
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].indexOf(92) < 0) continue;
            args[i] = args[i].replaceAll("\\\\;", ";");
        }
        for (Processor rover = this.domain; rover != null; rover = rover.getParent()) {
            String result = this.doCommand(rover, args[0], args);
            if (result == null) continue;
            return result;
        }
        for (int i = 0; this.targets != null && i < this.targets.length; ++i) {
            String result = this.doCommand(this.targets[i], args[0], args);
            if (result == null) continue;
            return result;
        }
        return this.doCommand(this, args[0], args);
    }

    private String doCommand(Object target, String method, String[] args) {
        if (target != null) {
            String cname = "_" + method.replaceAll("-", "_");
            try {
                Method m = target.getClass().getMethod(cname, String[].class);
                return (String)m.invoke(target, new Object[]{args});
            }
            catch (NoSuchMethodException e) {
            }
            catch (InvocationTargetException e) {
                this.domain.warning("Exception in replace: " + e.getCause(), new Object[0]);
                e.printStackTrace();
            }
            catch (Exception e) {
                this.domain.warning("Exception in replace: " + e + " method=" + method, new Object[0]);
                e.printStackTrace();
            }
        }
        return null;
    }

    public String _uniq(String[] args) {
        Macro.verifyCommand(args, _uniqHelp, null, 1, Integer.MAX_VALUE);
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (int i = 1; i < args.length; ++i) {
            Processor.split(args[i], set);
        }
        return Processor.join(set, ",");
    }

    public String _filter(String[] args) {
        return this.filter(args, false);
    }

    public String _filterout(String[] args) {
        return this.filter(args, true);
    }

    String filter(String[] args, boolean include) {
        Macro.verifyCommand(args, String.format(_filterHelp, args[0]), null, 3, 3);
        ArrayList<String> list = new ArrayList<String>(Processor.split(args[1]));
        Pattern pattern = Pattern.compile(args[2]);
        Iterator i = list.iterator();
        while (i.hasNext()) {
            if (pattern.matcher((CharSequence)i.next()).matches() != include) continue;
            i.remove();
        }
        return Processor.join(list);
    }

    public String _sort(String[] args) {
        Macro.verifyCommand(args, _sortHelp, null, 2, Integer.MAX_VALUE);
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 1; i < args.length; ++i) {
            Processor.split(args[i], result);
        }
        Collections.sort(result);
        return Processor.join(result);
    }

    public String _join(String[] args) {
        Macro.verifyCommand(args, _joinHelp, null, 1, Integer.MAX_VALUE);
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 1; i < args.length; ++i) {
            Processor.split(args[i], result);
        }
        return Processor.join(result);
    }

    public String _if(String[] args) {
        Macro.verifyCommand(args, _ifHelp, null, 3, 4);
        String condition = args[1].trim();
        if (condition.length() != 0) {
            return args[2];
        }
        if (args.length > 3) {
            return args[3];
        }
        return "";
    }

    public String _now(String[] args) {
        return new Date().toString();
    }

    public String _fmodified(String[] args) throws Exception {
        Macro.verifyCommand(args, _fmodifiedHelp, null, 2, Integer.MAX_VALUE);
        long time = 0L;
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 1; i < args.length; ++i) {
            Processor.split(args[i], names);
        }
        for (String name : names) {
            File f = new File(name);
            if (!f.exists() || f.lastModified() <= time) continue;
            time = f.lastModified();
        }
        return "" + time;
    }

    public String _long2date(String[] args) {
        try {
            return new Date(Long.parseLong(args[1])).toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "not a valid long";
        }
    }

    public String _literal(String[] args) {
        if (args.length != 2) {
            throw new RuntimeException("Need a value for the ${literal;<value>} macro");
        }
        return "${" + args[1] + "}";
    }

    public String _def(String[] args) {
        if (args.length != 2) {
            throw new RuntimeException("Need a value for the ${def;<value>} macro");
        }
        String value = this.properties.getProperty(args[1]);
        if (value == null) {
            return "";
        }
        return value;
    }

    public String _replace(String[] args) {
        if (args.length != 4) {
            this.domain.warning("Invalid nr of arguments to replace " + Arrays.asList(args), new Object[0]);
            return null;
        }
        String[] list = args[1].split("\\s*,\\s*");
        StringBuffer sb = new StringBuffer();
        String del = "";
        for (int i = 0; i < list.length; ++i) {
            String element = list[i].trim();
            if (element.equals("")) continue;
            sb.append(del);
            sb.append(element.replaceAll(args[2], args[3]));
            del = ", ";
        }
        return sb.toString();
    }

    public String _warning(String[] args) {
        for (int i = 1; i < args.length; ++i) {
            this.domain.warning(this.process(args[i]), new Object[0]);
        }
        return "";
    }

    public String _error(String[] args) {
        for (int i = 1; i < args.length; ++i) {
            this.domain.error(this.process(args[i]), new Object[0]);
        }
        return "";
    }

    public String _toclassname(String[] args) {
        Macro.verifyCommand(args, _toclassnameHelp, null, 2, 2);
        Collection<String> paths = Processor.split(args[1]);
        ArrayList<String> names = new ArrayList<String>(paths.size());
        for (String path : paths) {
            String name;
            if (path.endsWith(".class")) {
                name = path.substring(0, path.length() - 6).replace('/', '.');
                names.add(name);
                continue;
            }
            if (path.endsWith(".java")) {
                name = path.substring(0, path.length() - 5).replace('/', '.');
                names.add(name);
                continue;
            }
            this.domain.warning("in toclassname, " + args[1] + " is not a class path because it does not end in .class", new Object[0]);
        }
        return Processor.join(names, ",");
    }

    public String _toclasspath(String[] args) {
        Macro.verifyCommand(args, _toclasspathHelp, null, 2, 3);
        boolean cl = true;
        if (args.length > 2) {
            cl = new Boolean(args[2]);
        }
        Collection<String> names = Processor.split(args[1]);
        ArrayList<String> paths = new ArrayList<String>(names.size());
        for (String name : names) {
            String path = name.replace('.', '/') + (cl ? ".class" : "");
            paths.add(path);
        }
        return Processor.join(paths, ",");
    }

    public String _dir(String[] args) {
        if (args.length < 2) {
            this.domain.warning("Need at least one file name for ${dir;...}", new Object[0]);
            return null;
        }
        String del = "";
        StringBuffer sb = new StringBuffer();
        for (int i = 1; i < args.length; ++i) {
            File f = new File(args[i]).getAbsoluteFile();
            if (!f.exists() || !f.getParentFile().exists()) continue;
            sb.append(del);
            sb.append(f.getParentFile().getAbsolutePath());
            del = ",";
        }
        return sb.toString();
    }

    public String _basename(String[] args) {
        if (args.length < 2) {
            this.domain.warning("Need at least one file name for ${basename;...}", new Object[0]);
            return null;
        }
        String del = "";
        StringBuffer sb = new StringBuffer();
        for (int i = 1; i < args.length; ++i) {
            File f = new File(args[i]).getAbsoluteFile();
            if (!f.exists() || !f.getParentFile().exists()) continue;
            sb.append(del);
            sb.append(f.getName());
            del = ",";
        }
        return sb.toString();
    }

    public String _isfile(String[] args) {
        if (args.length < 2) {
            this.domain.warning("Need at least one file name for ${isfile;...}", new Object[0]);
            return null;
        }
        boolean isfile = true;
        for (int i = 1; i < args.length; ++i) {
            File f = new File(args[i]).getAbsoluteFile();
            isfile &= f.isFile();
        }
        return isfile ? "true" : "false";
    }

    public String _isdir(String[] args) {
        if (args.length < 2) {
            this.domain.warning("Need at least one file name for ${isdir;...}", new Object[0]);
            return null;
        }
        boolean isdir = true;
        for (int i = 1; i < args.length; ++i) {
            File f = new File(args[i]).getAbsoluteFile();
            isdir &= f.isDirectory();
        }
        return isdir ? "true" : "false";
    }

    public String _tstamp(String[] args) {
        String format = "yyyyMMddHHmm";
        long now = System.currentTimeMillis();
        if (args.length > 1) {
            format = args[1];
            if (args.length > 2) {
                now = Long.parseLong(args[2]);
                if (args.length > 3) {
                    this.domain.warning("Too many arguments for tstamp: " + Arrays.toString(args), new Object[0]);
                }
            }
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(new Date(now));
    }

    public String _lsr(String[] args) {
        return this.ls(args, true);
    }

    public String _lsa(String[] args) {
        return this.ls(args, false);
    }

    String ls(String[] args, boolean relative) {
        if (args.length < 2) {
            throw new IllegalArgumentException("the ${ls} macro must at least have a directory as parameter");
        }
        File dir = new File(args[1]);
        if (!dir.isAbsolute()) {
            throw new IllegalArgumentException("the ${ls} macro directory parameter is not absolute: " + dir);
        }
        if (!dir.exists()) {
            throw new IllegalArgumentException("the ${ls} macro directory parameter does not exist: " + dir);
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("the ${ls} macro directory parameter points to a file instead of a directory: " + dir);
        }
        String[] files = dir.list();
        List<String> result = args.length < 3 ? Arrays.asList(files) : new ArrayList<String>();
        for (int i = 2; i < args.length; ++i) {
            String[] parts;
            for (String pattern : parts = args[i].split("\\s*,\\s*")) {
                Instruction instr = Instruction.getPattern(pattern);
                for (int f = 0; f < files.length; ++f) {
                    if (files[f] == null || !instr.matches(files[f])) continue;
                    if (!instr.isNegated()) {
                        if (relative) {
                            result.add(files[f]);
                        } else {
                            result.add(new File(dir, files[f]).getAbsolutePath());
                        }
                    }
                    files[f] = null;
                }
            }
        }
        return Processor.join(result, ",");
    }

    public String _currenttime(String[] args) {
        return Long.toString(System.currentTimeMillis());
    }

    public String _version(String[] args) {
        Macro.verifyCommand(args, _versionHelp, null, 3, 3);
        String mask = args[1];
        Version version = new Version(args[2]);
        StringBuilder sb = new StringBuilder();
        String del = "";
        for (int i = 0; i < mask.length(); ++i) {
            char c = mask.charAt(i);
            String result = null;
            if (c == '~') continue;
            if (i == 3) {
                result = version.getQualifier();
            } else if (Character.isDigit(c)) {
                result = String.valueOf(c);
            } else {
                int x = version.get(i);
                switch (c) {
                    case '+': {
                        ++x;
                        break;
                    }
                    case '-': {
                        --x;
                        break;
                    }
                }
                result = Integer.toString(x);
            }
            if (result == null) continue;
            sb.append(del);
            del = ".";
            sb.append(result);
        }
        return sb.toString();
    }

    public String _system(String[] args) throws Exception {
        Macro.verifyCommand(args, "${system;<command>[;<in>]}, execute a system command", null, 2, 3);
        String command = args[1];
        String input = null;
        if (args.length > 2) {
            input = args[2];
        }
        Process process = Runtime.getRuntime().exec(command, null, this.domain.getBase());
        if (input != null) {
            process.getOutputStream().write(input.getBytes("UTF-8"));
        }
        process.getOutputStream().close();
        String s = Macro.getString(process.getInputStream());
        process.getInputStream().close();
        int exitValue = process.waitFor();
        if (exitValue != 0) {
            this.domain.error("System command " + command + " failed with " + exitValue, new Object[0]);
        }
        return s.trim();
    }

    public String _cat(String[] args) throws IOException {
        Macro.verifyCommand(args, "${cat;<in>}, get the content of a file", null, 2, 2);
        File f = this.domain.getFile(args[1]);
        if (f.isFile()) {
            FileInputStream in = new FileInputStream(f);
            return Macro.getString(in);
        }
        if (f.isDirectory()) {
            return Arrays.toString(f.list());
        }
        try {
            URL url = new URL(args[1]);
            InputStream in = url.openStream();
            return Macro.getString(in);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getString(InputStream in) throws IOException {
        try {
            StringBuilder sb = new StringBuilder();
            BufferedReader rdr = new BufferedReader(new InputStreamReader(in));
            String line = null;
            while ((line = rdr.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
            String string = sb.toString();
            return string;
        }
        finally {
            in.close();
        }
    }

    public static void verifyCommand(String[] args, String help, Pattern[] patterns, int low, int high) {
        String message = "";
        if (args.length > high) {
            message = "too many arguments";
        } else if (args.length < low) {
            message = "too few arguments";
        } else {
            for (int i = 0; patterns != null && i < patterns.length && i < args.length - 1; ++i) {
                if (patterns[i] == null || patterns[i].matcher(args[i + 1]).matches()) continue;
                message = message + String.format("Argument %s (%s) does not match %s\n", i, args[i], patterns[i].pattern());
            }
        }
        if (message.length() != 0) {
            StringBuilder sb = new StringBuilder();
            String del = "${";
            for (String arg : args) {
                sb.append(del);
                sb.append(arg);
                del = ";";
            }
            sb.append("}, is not understood. ");
            sb.append(message);
            throw new IllegalArgumentException(sb.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getFlattenedProperties() {
        this.flattening = true;
        try {
            Properties flattened = new Properties();
            Enumeration<?> e = this.properties.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (key.startsWith("_")) continue;
                if (key.startsWith("-")) {
                    flattened.put(key, this.properties.getProperty(key));
                    continue;
                }
                flattened.put(key, this.process(this.properties.getProperty(key)));
            }
            Properties properties = flattened;
            return properties;
        }
        finally {
            this.flattening = false;
        }
    }

    static class Link {
        Link previous;
        String key;

        public Link(Link previous, String key) {
            this.previous = previous;
            this.key = key;
        }

        public boolean contains(String key) {
            if (this.key.equals(key)) {
                return true;
            }
            if (this.previous == null) {
                return false;
            }
            return this.previous.contains(key);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            String del = "[";
            Link r = this;
            while (r != null) {
                sb.append(del);
                sb.append(r.key);
                del = ",";
                r = r.previous;
            }
            sb.append("]");
            return sb.toString();
        }
    }
}

